/**
 * 
 */
package com.ejie.ab78.adaptadores;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab78.adaptadores.service.ab61WebServiceService;
import com.ejie.ab78.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab78.clientesWS.ab61WebService.BusquedasWS;
import com.ejie.ab78.clientesWS.ab61WebService.DatosInicioOficio;
import com.ejie.ab78.clientesWS.ab61WebService.Exception_Exception;
import com.ejie.ab78.clientesWS.ab61WebService.IdentificadoresPid;
import com.ejie.ab78.clientesWS.ab61WebService.InicioOficioTitularWS;
import com.ejie.ab78.clientesWS.ab61WebService.InicioOficioWS;
import com.ejie.ab78.clientesWS.ab61WebService.Origen;
import com.ejie.ab78.clientesWS.ab61WebService.Usuario;

/**
 *  
 * 
 */
@Service(value = "ab61WebServiceAdaptadorServiceImpl")
public class ab61WebServiceAdaptadorServiceImpl implements ab61WebServiceAdaptadorService {

	public static final Logger logger = LoggerFactory.getLogger(ab61WebServiceAdaptadorServiceImpl.class);

	@Autowired()
	private ab61WebServiceService ab61WebServiceService;

	@Override
	public String generarExcelListados(int idListado, List<BusquedasWS> listaBusquedas, String codAplic)
			throws Ab61Exception {
		ab61WebServiceAdaptadorServiceImpl.logger
				.info("ab61WebServiceAdaptadorServiceImpl.generarExcelListados - Inicio");
		String respuesta = this.ab61WebServiceService.generarExcelListados(idListado, listaBusquedas, codAplic);

		ab61WebServiceAdaptadorServiceImpl.logger
				.debug("ab61WebServiceAdaptadorServiceImpl.generarExcelListados - Return: " + respuesta);
		return respuesta;
	}

	@Override
	public String descargarDocumentoNegocio(Integer idPlantilla, String idEstablecimiento, Origen origen,
			String usuario, Boolean descargarFormatoPdf) throws Ab61Exception {
		return this.ab61WebServiceService.descargarDocumentoNegocio(idPlantilla, idEstablecimiento, origen, usuario,
				descargarFormatoPdf);
	}

	@Override
	public void eliminarDocumentoNegocio(Integer idPlantilla, String identificador) throws Ab61Exception {
		this.ab61WebServiceService.eliminarDocumentoNegocio(idPlantilla, identificador);
	}

	@Override
	public String aportarDocumentoPlatea(Integer idPlantilla, String procedureId, String folderId, Usuario usuario)
			throws Ab61Exception {
		return this.ab61WebServiceService.aportarDocumentoPlatea(idPlantilla, procedureId, folderId, usuario);
	}

	@Override
	public String modificarDocumentoNegocio(Integer idPlantilla, String identificador, String usuario)
			throws Ab61Exception {
		return this.ab61WebServiceService.modificarDocumentoNegocio(idPlantilla, identificador, usuario);
	}

	@Override
	public String generarDocumentoNegocio(Integer idPlantilla, String idEstablecimiento, Origen origen, String usuario)
			throws Ab61Exception {

		return this.ab61WebServiceService.generarDocumentoNegocio(idPlantilla, idEstablecimiento, origen, usuario);

	}

	@Override
	public Boolean actualizarParticipaciones(String folderId, String usuario)
			throws Ab61Exception, Exception_Exception {
		return this.ab61WebServiceService.actualizarParticipaciones(folderId, usuario);
	}

	@Override
	public String actualizarTituloExpediente(String folderId, String tituloExpediente) throws Ab61Exception {
		return this.ab61WebServiceService.actualizarTituloExpediente(folderId, tituloExpediente);
	}

	@Override
	public String insertarParticipacion(String folderId, Integer idTercero, String desCasParticipacion,
			String desEusParticipacion) throws Ab61Exception {
		return this.ab61WebServiceService.insertarParticipacion(folderId, idTercero, desCasParticipacion,
				desEusParticipacion);
	}
}
