package com.ejie.ab78.adaptadores;

import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeFactory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab78.adaptadores.service.Ab79WebServiceService;
import com.ejie.ab78.clientesWS.ab79WebService.Ab79Exception;
import com.ejie.ab78.clientesWS.ab79WebService.Ab79ExceptionGeneral;
import com.ejie.ab78.clientesWS.ab79WebService.InspeccionWS;
import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.expedientes.Expedientes;

/**
 *  
 * 
 */
@Service(value = "ab79WebServiceAdaptadorServiceImpl")
public class Ab79WebServiceAdaptadorServiceImpl implements Ab79WebServiceAdaptadorService {

	public static final Logger logger = LoggerFactory.getLogger(Ab79WebServiceAdaptadorServiceImpl.class);

	@Autowired()
	private Ab79WebServiceService ab79WebServiceService;

	@Override
	public String crearInspeccion(Expedientes expediente, Date fechaLimite, String observaciones, String numDenuncia)
			throws Ab79Exception {
		Ab79WebServiceAdaptadorServiceImpl.logger.info("ab79WebServiceAdaptadorService.crearInspeccion - Inicio");
		try {
			Ab79WebServiceAdaptadorServiceImpl.logger
					.info("ab79WebServiceAdaptadorService.crearInspeccion - folderId: " + expediente.getFolderId());

			InspeccionWS inspeccion = new InspeccionWS();
			if (observaciones != null) {
				inspeccion.setObservacionesActuacionInspeccion(observaciones);
			}
			if (fechaLimite != null) {
				GregorianCalendar calendar = (GregorianCalendar) GregorianCalendar.getInstance();
				calendar.setTime(fechaLimite);
				inspeccion.setFechaLimiteInspeccion(DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar));
			}
			String respuesta = "";
			if (Constantes.TIPO_DENUNCIA_FORMAL.equals(expediente.getProcedimientos().getTipoDenuncia())) {
				respuesta = this.ab79WebServiceService.crearInspeccion(expediente.getFolderId(), inspeccion, null,
						UtilUsuario.getUserConnected(), Constantes.AB79_ORIGEN_DENUNCIAS, null, null);
			} else if (Constantes.TIPO_DENUNCIA_NO_FORMAL.equals(expediente.getProcedimientos().getTipoDenuncia())) {
				respuesta = this.ab79WebServiceService.crearInspeccion(null, inspeccion, null,
						UtilUsuario.getUserConnected(), Constantes.AB79_ORIGEN_DENUNCIAS_NO_FORMALES,
						expediente.getIdExpediente(), numDenuncia);
			}

			Ab79WebServiceAdaptadorServiceImpl.logger
					.debug("ab79WebServiceAdaptadorService.crearInspeccion - Return: " + respuesta + "");
			return respuesta;
		} catch (Exception e) {
			logger.error("Ab79WebServiceAdaptadorService :: Error: ", e);
			throw new Ab79Exception(e.getLocalizedMessage(), new Ab79ExceptionGeneral());
		}
	}

	@Override
	public String eliminarInspeccion(String identificadorInspeccion, String usuario) throws Ab79Exception {
		Ab79WebServiceAdaptadorServiceImpl.logger.info("ab79WebServiceAdaptadorService.eliminarInspeccion - Inicio");
		try {
			String respuesta = this.ab79WebServiceService.eliminarInspeccion(identificadorInspeccion, usuario);

			Ab79WebServiceAdaptadorServiceImpl.logger
					.debug("ab79WebServiceAdaptadorService.eliminarInspeccion - Return: " + respuesta + "");
			return respuesta;
		} catch (Exception e) {
			logger.error("Ab79WebServiceAdaptadorService :: Error: ", e);
			String error = "errorInspeccionNoEliminada";
			if (e instanceof Ab79Exception) {
				Ab79Exception ab79error = (Ab79Exception) e;
				if (ab79error.getFaultInfo() != null) {
					error = ab79error.getFaultInfo().getCodigo()
							.substring(ab79error.getFaultInfo().getCodigo().lastIndexOf(".") + 1);
				}
			}

			throw new Ab79Exception(error, new Ab79ExceptionGeneral());

		}
	}

}
