var PROCEDIMIENTO_PRECARGADO = $("#procedimientoPrecargado").val();

jQuery(function($){
	
	$("#menuTablasMaestras").addClass("active");
	
	var sancionCargada = sessionStorage.getItem("sancionCargada");	
	if (sancionCargada !== null)
	{
		$("#menuFichaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaSancion a").attr("href");
		$("#menuFichaSancion a").attr("href",link+sancionCargada);
		 
		/* Para completar la url del menú Listados */
		var link=$("#menuListados a").attr("href");
		$("#menuListados a").attr("href",link+sancionCargada);
	} else {
		$("#menuFichaSancion").hide();
	}
	
	var propuestaSancionCargada = sessionStorage.getItem("propuestaSancionCargada");	
	if (propuestaSancionCargada !== null)
	{
		$("#menuFichaPropuestaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaPropuestaSancion a").attr("href");
		$("#menuFichaPropuestaSancion a").attr("href",link+propuestaSancionCargada);
	} else {
		$("#menuFichaPropuestaSancion").hide();
	}

	$("#idProcedimiento").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/procedimientos/cargarCombo",
		sourceParam : {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
			value : "idProcedimiento"
		},
		rowStriping: true,
		onLoadSuccess: function(){
			if(PROCEDIMIENTO_PRECARGADO){
				$("#idProcedimiento").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
				$("#idProcedimiento").rup_combo("disable");
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				document.getElementById('tiposFinalizacion_filter_filterButton').click();
			} else {
				document.getElementById('tiposFinalizacion_filter_filterButton').click();
			}
		},
		change: function() {
			$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());								
			document.getElementById('tiposFinalizacion_filter_filterButton').click();
		}
	});	
	
	$("#tiposFinalizacion").rup_datatable({
		
		primaryKey: "idTipoFinalizacion",
		loadOnStartUp: false,
		pagingType: "full_numbers",
		dom: 't <"col-sm-4"l><"col-sm-6"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"tiposFinalizacion_filter_form",
  	  		filterToolbar:"tiposFinalizacion_filter_toolbar",
  	  		collapsableLayerId:"tiposFinalizacion_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	columnDefs: [
    		   {
    		      targets: [1,5],
    		      orderable: false,
    		      visible: false
    		   },
    		   {
    		      targets: [0],
    		      visible: (("es"===$.rup_utils.get("language")) ? true : false)
    		   },
     		   {
    		      targets: [2],
    		      visible: (("eu"===$.rup_utils.get("language")) ? true : false)
    		   }
    	],
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("tiposFinalizacion_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
    	}
	});
	
	var tabla = $('#tiposFinalizacion').DataTable();
	
	$('#tiposFinalizacion tbody').on( 'click', 'tr', function () {
		tabla.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        var datosRow = tabla.rows(['.selected']).data().toArray();
        
        if(datosRow[0].idTipoFinalizacion == TIPO_FINALIZACION_ARCHIVO){
        	$("#btnEditTipoFinalizacion").prop("disabled", true);
        	$("#btnRemoveTipoFinalizacion").prop("disabled", true);
        } else {
        	$("#btnEditTipoFinalizacion").prop("disabled", false);
        	$("#btnRemoveTipoFinalizacion").prop("disabled", false);
        }
    });
	
	$('#tiposFinalizacion tbody').on('dblclick', 'tr', function () {
        var datosRow = $('#tiposFinalizacion').DataTable().rows(['.selected']).data().toArray();
		if($("#tiposFinalizacion_filter_table").val() != "0" && datosRow[0].idTipoFinalizacion != TIPO_FINALIZACION_ARCHIVO){
			$("#btnEditTipoFinalizacion").trigger("click");
		}
	});
	
	$("#tiposFinalizacion_detail_div").rup_dialog({
		autoOpen: false,
		width: 700,
		modal: true,
		position: { my: "center center" },
		type: $.rup.dialog.DIV
	});
	
	$('#btnAddTipoFinalizacion').on( 'click', function () {		
		
		if ($("#tiposFinalizacion_detail_feedback.rup-feedback").length > 0)
		{
			$("#tiposFinalizacion_detail_feedback").rup_feedback("close");
		}
		$("#procedimiento_detail_table").rup_combo("clear");
		$("#tiposFinalizacion_detail_form")[0].reset();
		
		$("#tiposFinalizacion_detail_form").rup_form({
			feedback: $("#tiposFinalizacion_detail_feedback"),
			url: CTX_PATH + "tiposFinalizacion",
			type: "POST",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"procedimiento.idProcedimiento":{
						required: true
					},
					"descripcionCastellano":{
						required: true,
						maxlength: 200
					},
					"descripcionEuskera":{
						required: true,
						maxlength: 200
					}
				}
			},
		    success: function(){
			   $("#tiposFinalizacion_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#tiposFinalizacion_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.tiposFinalizacion.guardarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
			   $("#tiposFinalizacion_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#tiposFinalizacion_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.tiposFinalizacion.guardarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#tiposFinalizacion_detail_form").rup_validate("resetForm");
		inicializaControlCambios("tiposFinalizacion_detail_form");
		
		if(PROCEDIMIENTO_PRECARGADO){
			$("#procedimiento_detail_table").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
			$("#procedimiento_detail_table").rup_combo("disable");
		}
		
		$("#tiposFinalizacion_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.tiposFinalizacion.nuevo);
		$("#tiposFinalizacion_detail_div").rup_dialog("open");
	});
	
	$('#btnEditTipoFinalizacion').on( 'click', function () {	
		
		if ($("#tiposFinalizacion_detail_feedback.rup-feedback").length > 0)
		{
			$("#tiposFinalizacion_detail_feedback").rup_feedback("close");
		}
		$("#tiposFinalizacion_detail_form")[0].reset();
		
		$("#tiposFinalizacion_detail_form").rup_form({
			feedback: $("#tiposFinalizacion_detail_feedback"),
			url: CTX_PATH + "tiposFinalizacion",
			type: "PUT",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"procedimiento.idProcedimiento":{
						required: true
					},
					"descripcionCastellano":{
						required: true,
						maxlength: 200
					},
					"descripcionEuskera":{
						required: true,
						maxlength: 200
					}
				}
			},
		    success: function(){
			   $("#tiposFinalizacion_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#tiposFinalizacion_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.tiposFinalizacion.modificarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
			   $("#tiposFinalizacion_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#tiposFinalizacion_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.tiposFinalizacion.modificarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#tiposFinalizacion_detail_form").rup_validate("resetForm");
		
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			var datosRow = tabla.rows(['.selected']).data().toArray(); 	
			$.ajax({
				type : "GET",
				url : CTX_PATH + "tiposFinalizacion/" + datosRow[0].idTipoFinalizacion,
				dataType : "json",
				async : false,
				success : function(data) {
					cargarDatos(data, "tiposFinalizacion_detail_form");
					if(PROCEDIMIENTO_PRECARGADO){
						$("#procedimiento_detail_table").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
						$("#procedimiento_detail_table").rup_combo("disable");
					} else {
						$("#procedimiento_detail_table").rup_combo("setRupValue", datosRow[0].procedimiento.idProcedimiento);
					}			
					$("#tiposFinalizacion_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.tiposFinalizacion.editar);
					$("#tiposFinalizacion_detail_div").rup_dialog("open");
				}
			});	
		}else{
			$("#tiposFinalizacion_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#tiposFinalizacion_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
		inicializaControlCambios("tiposFinalizacion_detail_form");
	});
	
	$('#btnRemoveTipoFinalizacion').on( 'click', function () {
		
		if ($("#tiposFinalizacion_detail_feedback.rup-feedback").length > 0)
		{
			$("#tiposFinalizacion_detail_feedback").rup_feedback("close");
		}
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			$.rup_messages("msgConfirm", {
				title: $.rup.i18n.app.tabla.botones.eliminar,
				message: $.rup.i18n.app.tablasMaestras.tiposFinalizacion.borrar,
				OKFunction:	function() {
					bloquearInterfaz();
					var datosRow = tabla.rows(['.selected']).data().toArray();
					$.ajax({
						type : "DELETE",
						url : CTX_PATH + "tiposFinalizacion/" + datosRow[0].idTipoFinalizacion,
						dataType : "json",
						async : false,
						success : function() {
							desbloquearInterfaz();
							tabla.ajax.reload();
							$("#tiposFinalizacion_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#tiposFinalizacion_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.tiposFinalizacion.borradoOK, "ok");
						},
						error: function(){
							desbloquearInterfaz();
							$("#infracciones_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#infracciones_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.tiposFinalizacion.borradoError, "error");
						}
					});			
				}
			});		
		}else{
			$("#tiposFinalizacion_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#tiposFinalizacion_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	});
	
	$("#procedimiento_detail_table").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/procedimientos/cargarCombo",
		sourceParam : {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
			value : "idProcedimiento"
		},
		rowStriping: true
	});
	
	$('#tiposFinalizacion_detail_button_save').on( 'click', function () {		
		$("#tiposFinalizacion_detail_form").submit();	
	});
	
	$('#tiposFinalizacion_detail_button_cancel').on( 'click', function () {
		hayCambios();
	});	
});

function cerrarModal()
{
	$('#tiposFinalizacion').DataTable().ajax.reload();			   
	$("#tiposFinalizacion_detail_div").rup_dialog("close");   
}

function hayCambios()
{
	if (controlCambios()) {
		$.rup_messages("msgConfirm", {
			message: $.rup.i18n.app.controlCambios.mensaje,
			title:  $.rup.i18n.app.controlCambios.titulo,
			OKFunction: function () {	
				
				$("#tiposFinalizacion_detail_form").submit();
				
			},
			CANCELFunction: function () {
				cerrarModal();   
			}
		});	
	}	
	else
	{
		cerrarModal();
	}
}