jQuery(function($){
	
	$("#menuTablasMaestras").addClass("active");
	
	var sancionCargada = sessionStorage.getItem("sancionCargada");	
	if (sancionCargada !== null)
	{
		$("#menuFichaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaSancion a").attr("href");
		$("#menuFichaSancion a").attr("href",link+sancionCargada);
		 
		/* Para completar la url del menú Listados */
		var link=$("#menuListados a").attr("href");
		$("#menuListados a").attr("href",link+sancionCargada);
	} else {
		$("#menuFichaSancion").hide();
	}
	
	var propuestaSancionCargada = sessionStorage.getItem("propuestaSancionCargada");	
	if (propuestaSancionCargada !== null)
	{
		$("#menuFichaPropuestaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaPropuestaSancion a").attr("href");
		$("#menuFichaPropuestaSancion a").attr("href",link+propuestaSancionCargada);
	} else {
		$("#menuFichaPropuestaSancion").hide();
	}

	$("#instructores").rup_datatable({
		
		primaryKey: "idInstructor",
		loadOnStartUp: true,
		pagingType: "full_numbers",
		dom: 't <"col-sm-4"l><"col-sm-6"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"instructores_filter_form",
  	  		filterToolbar:"instructores_filter_toolbar",
  	  		collapsableLayerId:"instructores_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	columnDefs: [
    		   {
    		      targets: [0],
    		      orderable: false,
    		      visible: false
    		   },
    		   {
    			   targets: [1],
    			   width: 1000
    		   }
    	],
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("instructores_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
    	}
	});
	
	var tabla = $('#instructores').DataTable();
	
	$('#instructores tbody').on( 'click', 'tr', function () {
		tabla.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });
	
	$('#instructores tbody').on('dblclick', 'tr', function () {
		if($("#instructores_filter_table").val() != "0"){
			$("#btnEditInstructor").trigger("click");
		}
	});
	
	$("#instructores_detail_div").rup_dialog({
		autoOpen: false,
		width: 700,
		modal: true,
		position: { my: "center center" },
		type: $.rup.dialog.DIV
	});
	
	$('#btnAddInstructor').on( 'click', function () {		
		
		if ($("#instructores_detail_feedback.rup-feedback").length > 0)
		{
			$("#instructores_detail_feedback").rup_feedback("close");
		}
		$("#instructores_detail_form")[0].reset();
		
		$("#instructores_detail_form").rup_form({
			feedback: $("#instructores_detail_feedback"),
			url: CTX_PATH + "instructores",
			type: "POST",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"nombreInstructor":{
						required: true,
						maxlength: 100
					}
				}
			},
		    success: function(){
			   $("#instructores_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#instructores_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.instructores.guardarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
			   $("#instructores_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#instructores_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.instructores.guardarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#instructores_detail_form").rup_validate("resetForm");
		inicializaControlCambios("instructores_detail_form");
		
		$("#instructores_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.instructores.nuevo);
		$("#instructores_detail_div").rup_dialog("open");
	});
	
	$('#btnEditInstructor').on( 'click', function () {	
		
		if ($("#instructores_detail_feedback.rup-feedback").length > 0)
		{
			$("#instructores_detail_feedback").rup_feedback("close");
		}
		$("#instructores_detail_form")[0].reset();
		
		$("#instructores_detail_form").rup_form({
			feedback: $("#instructores_detail_feedback"),
			url: CTX_PATH + "instructores",
			type: "PUT",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"nombreInstructor":{
						required: true,
						maxlength: 100
					}
				}
			},
		    success: function(){
			   $("#instructores_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#instructores_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.instructores.modificarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
			   $("#instructores_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#instructores_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.instructores.modificarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#instructores_detail_form").rup_validate("resetForm");
		
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			var datosRow = tabla.rows(['.selected']).data().toArray(); 	
			$.ajax({
				type : "GET",
				url : CTX_PATH + "instructores/" + datosRow[0].idInstructor,
				dataType : "json",
				async : false,
				success : function(data) {
					cargarDatos(data, "instructores_detail_form");			
										
					$("#instructores_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.instructores.editar);
					$("#instructores_detail_div").rup_dialog("open");
				}
			});	
		}else{
			$("#instructores_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#instructores_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
		inicializaControlCambios("instructores_detail_form");
	});
	
	$('#btnRemoveInstructor').on( 'click', function () {
		
		if ($("#instructores_detail_feedback.rup-feedback").length > 0)
		{
			$("#instructores_detail_feedback").rup_feedback("close");
		}
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			$.rup_messages("msgConfirm", {
				title: $.rup.i18n.app.tabla.botones.eliminar,
				message: $.rup.i18n.app.tablasMaestras.instructores.borrar,
				OKFunction:	function() {
					bloquearInterfaz();
					var datosRow = tabla.rows(['.selected']).data().toArray(); 			
					$.ajax({
						type : "DELETE",
						url : CTX_PATH + "instructores/" + datosRow[0].idInstructor,
						dataType : "json",
						async : false,
						success : function() {
							desbloquearInterfaz();
							tabla.ajax.reload();
							$("#instructores_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#instructores_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.instructores.borradoOK, "ok");
						},
						error: function(){
							desbloquearInterfaz();
							$("#instructores_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#instructores_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.instructores.borradoError, "error");
						}
					});			
				}
			});		
		}else{
			$("#instructores_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#instructores_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	});
	
	$('#instructores_detail_button_save').on( 'click', function () {		
		$("#instructores_detail_form").submit();	
	});
	
	$('#instructores_detail_button_cancel').on( 'click', function () {
		hayCambios();
	});	
});

function cerrarModal()
{
	$('#instructores').DataTable().ajax.reload();			   
	$("#instructores_detail_div").rup_dialog("close");   
}

function hayCambios()
{
	if (controlCambios()) {
		$.rup_messages("msgConfirm", {
			message: $.rup.i18n.app.controlCambios.mensaje,
			title:  $.rup.i18n.app.controlCambios.titulo,
			OKFunction: function () {	
				
				$("#instructores_detail_form").submit();
				
			},
			CANCELFunction: function () {
				cerrarModal();   
			}
		});	
	}	
	else
	{
		cerrarModal();
	}
}