var PROCEDIMIENTO_PRECARGADO = $("#procedimientoPrecargado").val();

jQuery(function($){
	
	$("#menuTablasMaestras").addClass("active");
	
	var sancionCargada = sessionStorage.getItem("sancionCargada");	
	if (sancionCargada !== null)
	{
		$("#menuFichaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaSancion a").attr("href");
		$("#menuFichaSancion a").attr("href",link+sancionCargada);
		 
		/* Para completar la url del menú Listados */
		var link=$("#menuListados a").attr("href");
		$("#menuListados a").attr("href",link+sancionCargada);
	} else {
		$("#menuFichaSancion").hide();
	}
	
	var propuestaSancionCargada = sessionStorage.getItem("propuestaSancionCargada");	
	if (propuestaSancionCargada !== null)
	{
		$("#menuFichaPropuestaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaPropuestaSancion a").attr("href");
		$("#menuFichaPropuestaSancion a").attr("href",link+propuestaSancionCargada);
	} else {
		$("#menuFichaPropuestaSancion").hide();
	}
	
	$("#idProcedimiento").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/procedimientos/cargarCombo",
		sourceParam : {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
			value : "idProcedimiento"
		},
		change: function() {
			var source = "/ab59WebAppWar/calificaciones/cargarCombo?procedimiento.idProcedimiento=" + $("#idProcedimiento").val();
			cargarComboCalificacionesFiltro(source);
			
			var source2 = "/ab59WebAppWar/infracciones/cargarCombo?procedimiento.idProcedimiento=" + $("#idProcedimiento").val() + "&Baja=" + ESTADO_NO_BAJA;
			cargarComboInfraccionesFiltro(source2);
			
			$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
			$("#idCalificacion_filter_table").val($("#idCalificacion").val());
			$("#articulo_filter_table").val($("#articulo").val());
									
			document.getElementById('infracciones_filter_filterButton').click();
			
			$("#tablaInfracciones").css("display","block");
	    	$(".botoneraTabla").css("display","block");
	    	$(".bottom").css("display","block");
		},
		rowStriping: true,
		onLoadSuccess: function(){
			if(PROCEDIMIENTO_PRECARGADO){
				$("#idProcedimiento").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
				$("#idProcedimiento").rup_combo("disable");
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				document.getElementById('infracciones_filter_filterButton').click();
				var source = "/ab59WebAppWar/calificaciones/cargarCombo?procedimiento.idProcedimiento=" + $("#idProcedimiento").val();
				cargarComboCalificacionesFiltro(source);
			} else {
				document.getElementById('infracciones_filter_filterButton').click();
			}
		}
	});
	
	if(typeof PROCEDIMIENTO_PRECARGADO === "undefined" || PROCEDIMIENTO_PRECARGADO === "" || PROCEDIMIENTO_PRECARGADO === null){
		$("#idCalificacion").rup_combo("destroy");
		$("#articulo").rup_combo("destroy");
		var listCalificaciones = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listCalificaciones);	
		$("#idCalificacion").rup_combo({
			source: listCalificaciones,	
			blank: "",
			disabled: true,
			rowStriping: true,
			change: function(){
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				$("#idCalificacion_filter_table").val($("#idCalificacion").val());
				$("#articulo_filter_table").val($("#articulo").val());
										
				document.getElementById('infracciones_filter_filterButton').click();
				
				$("#tablaInfracciones").css("display","block");
		    	$(".botoneraTabla").css("display","block");
		    	$(".bottom").css("display","block");
			}
		});
		$("#articulo").rup_combo({
			source: listCalificaciones,	
			blank: "",
			disabled: true,
			rowStriping: true,
			change: function(){
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				$("#idCalificacion_filter_table").val($("#idCalificacion").val());
				$("#articulo_filter_table").val($("#articulo").val());
										
				document.getElementById('infracciones_filter_filterButton').click();
				
				$("#tablaInfracciones").css("display","block");
		    	$(".botoneraTabla").css("display","block");
		    	$(".bottom").css("display","block");
			}
		});
	}
	
	$("#infracciones").rup_datatable({
		
		primaryKey: "idInfraccion",
		loadOnStartUp: false,
		pagingType: "full_numbers",
		dom: 't <"col-sm-4"l><"col-sm-6"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],	
		order: [[ 6, "ASC"]],
		filter:{
  	  		id:"infracciones_filter_form",
  	  		filterToolbar:"infracciones_filter_toolbar",
  	  		collapsableLayerId:"infracciones_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	columnDefs: [
    		   {
    		      targets: [0,8,9],
    		      orderable: false,
    		      visible: false
    		   },
    		   {
      		      targets: [1, 3, 6],
      		      visible: (("es"===$.rup_utils.get("language")) ? true : false)
      		   },
      		   {
       		      targets: [2, 4, 7],
       		      visible: (("eu"===$.rup_utils.get("language")) ? true : false)
       		   },
       		   {
       			   targets: [1, 2],
       			   width: 100
       		   },
       		   {
    			   targets: [3, 4],
    			   width: 100
    		   },
    		   {
       			   targets: [5],
       			   width: 100
       		   },
       		   {
    			   targets: [6, 7],
    			   width: 200
    		   }
    	],
    	initComplete:function() {
    		
    		var spanM = document.createElement("span"); 
    		var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
    		spanM.appendChild(mostrando);  
    		spanM.className = "mostrando";
    		var spanR = document.createElement("span"); 
    		var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
    		spanR.appendChild(registros);
    		spanR.className = "registros";
    		
    		var longitudTabla = document.getElementById("infracciones_length"); 
    		longitudTabla.appendChild(spanM); 
    		longitudTabla.appendChild(spanR);
    	}
	});
	
	var tabla = $('#infracciones').DataTable();
	
	$('#infracciones tbody').on( 'click', 'tr', function () {
		tabla.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });
	
	$('#infracciones tbody').on('dblclick', 'tr', function () {		
		$("#btnEditInfraccion").trigger("click");		
	});
	
	$("#infracciones_detail_div").rup_dialog({
		autoOpen: false,
		width: 700,
		modal: true,
		position: { my: "center center" },
		type: $.rup.dialog.DIV
	});
	
	$('#btnAddInfraccion').on( 'click', function () {
		
		if ($("#infracciones_detail_feedback.rup-feedback").length > 0)
		{
			$("#infracciones_detail_feedback").rup_feedback("close");
		}
		$("#infracciones_detail_form")[0].reset();
		
		$("#infracciones_detail_form").rup_form({
			feedback: $("#infracciones_detail_feedback"),
			url: CTX_PATH + "infracciones",
			type: "POST",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"procedimiento.idProcedimiento":{
						required: true
					},
					"calificaciones.idCalificacion": {
						required: true
					},
					"descripcionCastellano":{
						required: true,
						maxlength: 2000
					},
					"descripcionEuskera":{
						required: true,
						maxlength: 2000
					},
					"articulo":{
						required: true,
						maxlength: 20
					}
				}
			},
		    success: function(){
			   $("#infracciones_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#infracciones_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.infracciones.guardarOk, "ok");
			   
			   cerrarModal();
		    },
		    error: function(){
			   $("#infracciones_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#infracciones_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.infracciones.guardarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#infracciones_detail_form").rup_validate("resetForm");
		inicializaControlCambios("infracciones_detail_form");
		
		$("#procedimiento_detail_table").rup_combo("destroy");
		$("#procedimiento_detail_table").rup_combo({
			blank : "",
			source : "/ab59WebAppWar/procedimientos/cargarCombo",
			sourceParam : {
				label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
				value : "idProcedimiento"
			},
			onLoadSuccess: function(){
				$("#procedimiento_detail_table").rup_combo("clear");
				if(PROCEDIMIENTO_PRECARGADO){
					$("#procedimiento_detail_table").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
					$("#procedimiento_detail_table").rup_combo("disable");
					var source = "/ab59WebAppWar/calificaciones/cargarCombo?procedimiento.idProcedimiento=" + $("#procedimiento_detail_table").val();
					cargarComboCalificacionesModal(source);
				}
			},
			change: function() {
				var source = "/ab59WebAppWar/calificaciones/cargarCombo?procedimiento.idProcedimiento=" + $("#procedimiento_detail_table").val();
				cargarComboCalificacionesModal(source);
			},
			rowStriping: true
		});	
		
		if(typeof PROCEDIMIENTO_PRECARGADO === "undefined" || PROCEDIMIENTO_PRECARGADO === "" || PROCEDIMIENTO_PRECARGADO === null){
			$("#calificacion_detail_table").rup_combo("destroy");
			var listCalificaciones = new Array();				
			//Transformo en JSON la lista
			$.toJSON(listCalificaciones);	
			$("#calificacion_detail_table").rup_combo({
				source: listCalificaciones,	
				blank: "",
				disabled: true,
				rowStriping: true
			});
		}
		
		
		$("#infracciones_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.infracciones.nuevo);
		$("#infracciones_detail_div").rup_dialog("open");
			
	});
	
	$('#btnEditInfraccion').on( 'click', function () {	
		
		if ($("#infracciones_detail_feedback.rup-feedback").length > 0)
		{
			$("#infracciones_detail_feedback").rup_feedback("close");
		}
		$("#infracciones_detail_form")[0].reset();
		
		$("#infracciones_detail_form").rup_form({
			feedback: $("#infracciones_detail_feedback"),
			url: CTX_PATH + "infracciones",
			type: "PUT",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"procedimiento.idProcedimiento":{
						required: true
					},
					"calificaciones.idCalificacion": {
						required: true
					},
					"descripcionCastellano":{
						required: true,
						maxlength: 2000
					},
					"descripcionEuskera":{
						required: true,
						maxlength: 2000
					},
					"articulo":{
						required: true,
						maxlength: 20
					}
				}
			},
		    success: function(){
			   $("#infracciones_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#infracciones_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.infracciones.modificarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
			   $("#infracciones_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#infracciones_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.infracciones.modificarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#infracciones_detail_form").rup_validate("resetForm");
				
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			var datosRow = tabla.rows(['.selected']).data().toArray(); 	
			$.ajax({
				type : "GET",
				url : CTX_PATH + "infracciones/" + datosRow[0].idInfraccion,
				dataType : "json",
				async : false,
				success : function(data) {
					
					cargarDatos(data, "infracciones_detail_form");
															
					$("#infracciones_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.infracciones.editar);
					$("#infracciones_detail_div").rup_dialog("open");
				}
			});	
			
			$("#procedimiento_detail_table").rup_combo("destroy");
			$("#procedimiento_detail_table").rup_combo({
				blank : "",	
				source : "/ab59WebAppWar/procedimientos/cargarCombo",
				sourceParam : {
					label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
					value : "idProcedimiento"
				},
				selected: datosRow[0].procedimiento.idProcedimiento,
				onLoadSuccess: function(){
					if(PROCEDIMIENTO_PRECARGADO){
						$("#procedimiento_detail_table").rup_combo("disable");
					}
					var source = "/ab59WebAppWar/calificaciones/cargarCombo?procedimiento.idProcedimiento=" + $("#procedimiento_detail_table").val();
					cargarComboCalificacionesModal(source, datosRow[0].calificaciones.idCalificacion);
				},
				change: function() {
					var source = "/ab59WebAppWar/calificaciones/cargarCombo?procedimiento.idProcedimiento=" + $("#procedimiento_detail_table").val();
					cargarComboCalificacionesModal(source);
				},
				rowStriping: true
			});
			
		}else{
			$("#infracciones_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#infracciones_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
		inicializaControlCambios("infracciones_detail_form");
	});
	
	$('#btnRemoveInfraccion').on( 'click', function () {
		
		if ($("#infracciones_detail_feedback.rup-feedback").length > 0)
		{
			$("#infracciones_detail_feedback").rup_feedback("close");
		}
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			$.rup_messages("msgConfirm", {
				title: $.rup.i18n.app.tabla.botones.eliminar,
				message: $.rup.i18n.app.tablasMaestras.infracciones.borrar,
				OKFunction:	function() {
					bloquearInterfaz();
					var datosRow = tabla.rows(['.selected']).data().toArray(); 			
					$.ajax({
						type : "DELETE",
						url : CTX_PATH + "infracciones/" + datosRow[0].idInfraccion,
						dataType : "json",
						async : false,
						success : function() {
							desbloquearInterfaz();
							tabla.ajax.reload();
							$("#infracciones_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#infracciones_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.infracciones.borradoOK, "ok");
						},
						error: function(){
							desbloquearInterfaz();
							$("#infracciones_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#infracciones_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.infracciones.borradoError, "error");
						}
					});			
				}
			});		
		}else{
			$("#infracciones_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#infracciones_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	});
	
	$('#infracciones_detail_button_save').on( 'click', function () {		
		$("#infracciones_detail_form").submit();	
	});
	
	$('#infracciones_detail_button_cancel').on( 'click', function () {
		hayCambios();
	});	
	
});

function cargarComboCalificacionesFiltro(source, value){
	if ($("#idProcedimiento").val() != "" && $("#idProcedimiento").val() != null){
		$("#idCalificacion").rup_combo("destroy");
		$("#idCalificacion").rup_combo({
			source: source,
			blank: "",
			selected: value,
			sourceParam: {
				label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
				value : "idCalificacion"
			},
			onLoadSuccess: function() {
				$("#idCalificacion").rup_combo("clear");
			},
			rowStriping: true,
			change : function(){
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				$("#idCalificacion_filter_table").val($("#idCalificacion").val());
				$("#articulo_filter_table").val($("#articulo").val());
										
				document.getElementById('infracciones_filter_filterButton').click();
				
				$("#tablaInfracciones").css("display","block");
		    	$(".botoneraTabla").css("display","block");
		    	$(".bottom").css("display","block");
			}
		});
		
	}else{
		var listCalificaciones = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listCalificaciones);	
		$("#idCalificacion").rup_combo("destroy");
		$("#idCalificacion").rup_combo({
			source: listCalificaciones,	
			blank: "",
			disabled: true,
			rowStriping: true,
			change: function(){
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				$("#idCalificacion_filter_table").val($("#idCalificacion").val());
				$("#articulo_filter_table").val($("#articulo").val());
										
				document.getElementById('infracciones_filter_filterButton').click();
				
				$("#tablaInfracciones").css("display","block");
		    	$(".botoneraTabla").css("display","block");
		    	$(".bottom").css("display","block");
			}
		});
	}
}

function cargarComboCalificacionesModal(source, value){
	if ($("#procedimiento_detail_table").val() != "" && $("#procedimiento_detail_table").val() != null){
		$("#calificacion_detail_table").rup_combo("destroy");
		$("#calificacion_detail_table").rup_combo({
			source: source,
			blank: "",
			selected: value,
			sourceParam: {
				label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
				value : "idCalificacion"
			},
			onLoadSuccess: function(){
				if(typeof value === "undefined"){
					$("#calificacion_detail_table").rup_combo("clear");
				}
			},
			rowStriping: true
		});
		
	}else{
		var listCalificaciones = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listCalificaciones);	
		$("#calificacion_detail_table").rup_combo("destroy");
		$("#calificacion_detail_table").rup_combo({
			source: listCalificaciones,	
			blank: "",
			disabled: true,
			rowStriping: true
		});
	}
}

function cerrarModal()
{
	$("#calificacion_detail_table").rup_combo("clear");
	$("#procedimiento_detail_table").rup_combo("clear");
	$('#infracciones').DataTable().ajax.reload();			   
	$("#infracciones_detail_div").rup_dialog("close");   
}

function hayCambios()
{
	if (controlCambios()) {
		$.rup_messages("msgConfirm", {
			message: $.rup.i18n.app.controlCambios.mensaje,
			title:  $.rup.i18n.app.controlCambios.titulo,
			OKFunction: function () {	
				
				$("#infracciones_detail_form").submit();
				
			},
			CANCELFunction: function () {
				cerrarModal();   
			}
		});	
	}	
	else
	{
		cerrarModal();
	}
}

function cargarComboInfraccionesFiltro(source, value){
	if ($("#idProcedimiento").val() != "" && $("#idProcedimiento").val() != null){
		$("#articulo").rup_combo("destroy");
		$("#articulo").rup_combo({
			source: source,
			blank: "",
			selected: value,
			sourceParam: {
				label : "articulo",
				value : "articulo"
			},
			onLoadSuccess: function() {
				$("#articulo").rup_combo("clear");
			},
			rowStriping: true,
			change : function() {
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				$("#idCalificacion_filter_table").val($("#idCalificacion").val());
				$("#articulo_filter_table").val($("#articulo").val());
										
				document.getElementById('infracciones_filter_filterButton').click();
				
				$("#tablaInfracciones").css("display","block");
		    	$(".botoneraTabla").css("display","block");
		    	$(".bottom").css("display","block");
			}
		});
		
	}else{
		var listInfracciones = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listInfracciones);	
		$("#articulo").rup_combo("destroy");
		$("#articulo").rup_combo({
			source: listInfracciones,	
			blank: "",
			disabled: true,
			rowStriping: true
		});
	}
}