var PROCEDIMIENTO_PRECARGADO = $("#procedimientoPrecargado").val();

jQuery(function($){

	$("#menuTablasMaestras").addClass("active");
	
	var sancionCargada = sessionStorage.getItem("sancionCargada");	
	if (sancionCargada !== null)
	{
		$("#menuFichaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaSancion a").attr("href");
		$("#menuFichaSancion a").attr("href",link+sancionCargada);
		 
		/* Para completar la url del menú Listados */
		var link=$("#menuListados a").attr("href");
		$("#menuListados a").attr("href",link+sancionCargada);
	} else {
		$("#menuFichaSancion").hide();
	}
	
	var propuestaSancionCargada = sessionStorage.getItem("propuestaSancionCargada");	
	if (propuestaSancionCargada !== null)
	{
		$("#menuFichaPropuestaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaPropuestaSancion a").attr("href");
		$("#menuFichaPropuestaSancion a").attr("href",link+propuestaSancionCargada);
	} else {
		$("#menuFichaPropuestaSancion").hide();
	}
	
	$("#idProcedimiento").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/procedimientos/cargarCombo",
		sourceParam : {
			label : "descripcionConCodProcedure",
			value : "idProcedimiento"
		},
		rowStriping: true,
		onLoadSuccess: function(){
			if(PROCEDIMIENTO_PRECARGADO){
				$("#idProcedimiento").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
				$("#idProcedimiento").rup_combo("disable");
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				document.getElementById('estadosProSan_filter_filterButton').click();
			} else {
				document.getElementById('estadosProSan_filter_filterButton').click();
			}
		},
		change: function() {
			$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
			document.getElementById('estadosProSan_filter_filterButton').click();
		},
		width: 250
	});
	
	$("#procedimiento_detail_table").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/procedimientos/cargarCombo",
		sourceParam : {
			label : "descripcionConCodProcedure",
			value : "idProcedimiento"
		},
		rowStriping: true,
		onLoadSuccess: function(){
			if(PROCEDIMIENTO_PRECARGADO){
				$("#procedimiento_detail_table").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
				$("#procedimiento_detail_table").rup_combo("disable");
			}
		},
		width: 250
	});

	$("#estadosProSan").rup_datatable({
		
		primaryKey: "idEstadoProSan",
		loadOnStartUp: true,
		pagingType: "full_numbers",
		dom: 't <"col-sm-4"l><"col-sm-6"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"estadosProSan_filter_form",
  	  		filterToolbar:"estadosProSan_filter_toolbar",
  	  		collapsableLayerId:"estadosProSan_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	columnDefs: [
    		   {
    		      targets: [0, 6],
    		      orderable: false,
    		      visible: false
    		   },
    		   {
    			   targets: [1,3],
 			       visible: (("es"===$.rup_utils.get("language")) ? true : false)
    		   },
    		   {
    			   targets: [2,4],
 			       visible: (("es"===$.rup_utils.get("language")) ? false : true)
    		   },
    		   {
    			   targets: [5],
    			   render: function(data){
    				   if(data == "1"){
    					   return $.rup.i18n.app.msg.si;
    				   } else {
    					   return $.rup.i18n.app.msg.no;
    				   }
    			   }
    		   }
    		   
    	],
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("estadosProSan_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
    	}
	});
	
	var tabla = $('#estadosProSan').DataTable();
	
	$('#estadosProSan tbody').on( 'click', 'tr', function () {
		tabla.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
		var datosRow = tabla.rows(['.selected']).data().toArray();
		
        if(datosRow[0].proteger === 1){
        	$("#btnEditEstadoProSan").prop("disabled", true);
        	$("#btnRemoveEstadoProSan").prop("disabled", true);
        } else {
        	$("#btnEditEstadoProSan").prop("disabled", false);
        	$("#btnRemoveEstadoProSan").prop("disabled", false);
        }
        
    });
	
	$("#estadosProSan_detail_div").rup_dialog({
		autoOpen: false,
		width: 700,
		modal: true,
		position: { my: "center center" },
		type: $.rup.dialog.DIV
	});
	
	$('#btnAddEstadoProSan').on( 'click', function () {		
		
		if ($("#estadosProSan_detail_feedback.rup-feedback").length > 0)
		{
			$("#estadosProSan_detail_feedback").rup_feedback("close");
		}
		
		$("#estadosProSan_detail_form")[0].reset();
		
		$("#estadosProSan_detail_form").rup_form({
			feedback: $("#estadosProSan_detail_feedback"),
			url: CTX_PATH + "estadosProSan",
			type: "POST",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"descripcionCastellano":{required: true, maxlength: 200},
					"descripcionEuskera":{required: true, maxlength: 200},
					"procedimiento.idProcedimiento":{required: true}
				}
			},
		    success: function(){
			   $("#estadosProSanFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#estadosProSanFeedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.estadosProSan.guardarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
			   $("#estadosProSan_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#estadosProSan_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.estadosProSan.guardarError, "error");
		    }
		});
		
		$("#estadosProSan_detail_form").rup_validate("resetForm");
		inicializaControlCambios("estadosProSan_detail_form");
		
		if(!PROCEDIMIENTO_PRECARGADO){
			$("#procedimiento_detail_table").rup_combo("clear");
		} else {
			$("#procedimiento_detail_table").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
		}
		
		$("#estadosProSan_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.estadosProSan.nuevo);
		$("#estadosProSan_detail_div").rup_dialog("open");
	});
	
	$('#btnEditEstadoProSan').on( 'click', function () {	

		if ($("#estadosProSan_detail_feedback.rup-feedback").length > 0)
		{
			$("#estadosProSan_detail_feedback").rup_feedback("close");
		}
		$("#estadosProSan_detail_form")[0].reset();
		
		$("#estadosProSan_detail_form").rup_form({
			feedback: $("#estadosProSan_detail_feedback"),
			url: CTX_PATH + "estadosProSan",
			type: "PUT",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"descripcionCastellano":{required: true, maxlength: 200},
					"descripcionEuskera":{required: true, maxlength: 200},
					"procedimiento.idProcedimiento":{required: true}
				}
			},
		    success: function(){
			   $("#estadosProSanFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#estadosProSanFeedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.estadosProSan.guardarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
			   $("#estadosProSan_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#estadosProSan_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.estadosProSan.guardarError, "error");
		    }
		});
		
		$("#estadosProSan_detail_form").rup_validate("resetForm");
		
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			var datosRow = tabla.rows(['.selected']).data().toArray(); 	
			$.ajax({
				type : "GET",
				url : CTX_PATH + "estadosProSan/" + datosRow[0].idEstadoProSan,
				dataType : "json",
				async : false,
				success : function(data) {
					cargarDatos(data, "estadosProSan_detail_form");			
										
					$("#estadosProSan_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.estadosProSan.editar);
					$("#estadosProSan_detail_div").rup_dialog("open");
				}
			});	
		}else{
			$("#estadosProSanFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#estadosProSanFeedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
		inicializaControlCambios("estadosProSan_detail_form");
	});
	
	$('#btnRemoveEstadoProSan').on( 'click', function () {
		
		if ($("#estadosProSan_detail_feedback.rup-feedback").length > 0)
		{
			$("#estadosProSan_detail_feedback").rup_feedback("close");
		}
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			$.rup_messages("msgConfirm", {
				title: $.rup.i18n.app.tabla.botones.eliminar,
				message: $.rup.i18n.app.tablasMaestras.estadosProSan.borrar,
				OKFunction:	function() {
					bloquearInterfaz();
					var datosRow = tabla.rows(['.selected']).data().toArray(); 			
					$.ajax({
						type : "DELETE",
						url : CTX_PATH + "estadosProSan/" + datosRow[0].idEstadoProSan,
						dataType : "json",
						async : false,
						success : function() {
							desbloquearInterfaz();
							tabla.ajax.reload();
							$("#estadosProSanFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#estadosProSanFeedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.estadosProSan.borradoOK, "ok");
						},
						error: function(){
							desbloquearInterfaz();
							$("#estadosProSanFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#estadosProSanFeedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.estadosProSan.borradoError, "error");
						}
					});			
				}
			});		
		}else{
			$("#estadosProSanFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#estadosProSanFeedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	});
	
	$('#estadosProSan_detail_button_save').on( 'click', function () {
		if($('#porDefecto_detail_table').is(':checked')){
			comprobarPorDefecto($("#procedimiento_detail_table").val());
		} else {
			$("#estadosProSan_detail_form").submit();	
		}				
		
	});
	
	$('#estadosProSan_detail_button_cancel').on( 'click', function () {
		hayCambios();
	});	
});

function cerrarModal()
{
	$('#estadosProSan').DataTable().ajax.reload();			   
	$("#estadosProSan_detail_div").rup_dialog("close");   
}

function hayCambios()
{
	if (controlCambios()) {
		$.rup_messages("msgConfirm", {
			message: $.rup.i18n.app.controlCambios.mensaje,
			title:  $.rup.i18n.app.controlCambios.titulo,
			OKFunction: function () {	
				
				$("#estadosProSan_detail_form").submit();
				
			},
			CANCELFunction: function () {
				cerrarModal();   
			}
		});	
	}	
	else
	{
		cerrarModal();
	}
}

function comprobarPorDefecto(idProcedimiento){
	$.ajax({
		type: "GET",
		async:false,
		url: CTX_PATH + "estadosProSan/comprobarPorDefecto/" + idProcedimiento,
		contentType: "application/json",
		dataType: "json",
		success: function(data){
			if (data > 0){
				$("#estadosProSan_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
				$("#estadosProSan_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.estadosProSan.porDefectoRepetido, "alert");
			} else {
				$("#estadosProSan_detail_form").submit();	
			}
		}
	});
}