var PROCEDIMIENTO_PRECARGADO = $("#procedimientoPrecargado").val();

jQuery(function($){
	
	$("#menuTablasMaestras").addClass("active");
	
	var sancionCargada = sessionStorage.getItem("sancionCargada");	
	if (sancionCargada !== null)
	{
		$("#menuFichaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaSancion a").attr("href");
		$("#menuFichaSancion a").attr("href",link+sancionCargada);
		 
		/* Para completar la url del menú Listados */
		var link=$("#menuListados a").attr("href");
		$("#menuListados a").attr("href",link+sancionCargada);
	} else {
		$("#menuFichaSancion").hide();
	}
	
	var propuestaSancionCargada = sessionStorage.getItem("propuestaSancionCargada");	
	if (propuestaSancionCargada !== null)
	{
		$("#menuFichaPropuestaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaPropuestaSancion a").attr("href");
		$("#menuFichaPropuestaSancion a").attr("href",link+propuestaSancionCargada);
	} else {
		$("#menuFichaPropuestaSancion").hide();
	}
	
	$("#idProcedimiento").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/procedimientos/cargarCombo",
		sourceParam : {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
			value : "idProcedimiento"
		},
		change: function() {
			
			var source = "/ab59WebAppWar/infracciones/cargarCombo?procedimiento.idProcedimiento=" + $("#idProcedimiento").val() + "&Baja=" + ESTADO_NO_BAJA;
			cargarComboInfraccionesFiltro(source);
			
			var source2 = "/ab59WebAppWar/derechos/cargarComboDerechos?procedimiento.idProcedimiento=" + $("#idProcedimiento").val();
			cargarComboDerechoFiltro(source2);
			
			$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
			$("#idInfraccion_filter_table").val($("#idInfraccion").val());
			$("#articulo_filter_table").val($("#articulo").val());
									
			document.getElementById('derechos_filter_filterButton').click();
			
			
			$("#tablaDerechos").css("display","block");
	    	$(".botoneraTabla").css("display","block");
	    	$(".bottom").css("display","block");
		},
		rowStriping: true,
		onLoadSuccess: function(){
			if(PROCEDIMIENTO_PRECARGADO){
				$("#idProcedimiento").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
				$("#idProcedimiento").rup_combo("disable");
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				document.getElementById('derechos_filter_filterButton').click();
				var source = "/ab59WebAppWar/infracciones/cargarCombo?procedimiento.idProcedimiento=" + $("#idProcedimiento").val() + "&Baja=" + ESTADO_NO_BAJA;
				cargarComboInfraccionesFiltro(source);
			} else {
				document.getElementById('derechos_filter_filterButton').click();
			}
		}
	});	
	
	if(typeof PROCEDIMIENTO_PRECARGADO === "undefined" || PROCEDIMIENTO_PRECARGADO === "" || PROCEDIMIENTO_PRECARGADO === null){
		$("#idInfraccion").rup_combo("destroy");
		$("#articulo").rup_combo("destroy");
		var listInfracciones = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listInfracciones);	
		$("#idInfraccion").rup_combo({
			source: listInfracciones,	
			blank: "",
			disabled: true,
			rowStriping: true
		});
		$("#articulo").rup_combo({
			source: listInfracciones,	
			blank: "",
			disabled: true,
			rowStriping: true
		});
	}

	$("#derechos").rup_datatable({
		
		primaryKey: "idDerecho",
		loadOnStartUp: false,
		pagingType: "full_numbers",
		dom: 't <"col-sm-4"l><"col-sm-6"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],	
		order: [[ 3, "ASC"]],
		filter:{
  	  		id:"derechos_filter_form",
  	  		filterToolbar:"derechos_filter_toolbar",
  	  		collapsableLayerId:"derechos_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	columnDefs: [
    		   {
    		      targets: [1,6,8,9,10],
    		      orderable: false,
    		      visible: false
    		   },
    		   {
       		      targets: [0],
       		      visible: (("es"===$.rup_utils.get("language")) ? true : false)
       		   },
       		   {
    		      targets: [2],
    		      visible: (("eu"===$.rup_utils.get("language")) ? true : false)
    		   },
    		   {
      		      targets: [4],
      		      visible: (("es"===$.rup_utils.get("language")) ? true : false)
      		   },
      		   {
       		      targets: [5],
       		      visible: (("eu"===$.rup_utils.get("language")) ? true : false)
       		   },
       		   {
       			   targets: [3, 7],
       			   width: 100
       		   },
    		   {
    			   targets: [7],
    			   render: function(data){
    				   return '<div id="derechos_articuloInfraccionTooltip_" class="derechos_articuloInfraccionTooltip">' + data + '</div>';
    			   }
    		   }
    	],
		drawCallback: function() {
			 var tabla = $('#derechos').DataTable();
			
			$('.derechos_articuloInfraccionTooltip').each(function (index) {
				var toolTipText = (("es"===$.rup_utils.get("language")) ? tabla.row(index).data().articuloInfraccionEs : tabla.row(index).data().articuloInfraccionEu) 
				this.id = this.id + index;
		        $("#"+this.id).rup_tooltip({
		            content: toolTipText,		        	
		            position: {
		                my: 'top left',
		                at: 'bottom right',
		                adjust: {
		                	x: 10,
		                	y: 9
		                }
		            }
		        });
		        $("#"+this.id).mouseover(function(){
		        	var idQtip = $("#"+this.id).parent().attr("data-hasqtip");
		        	setTimeout(function(){ 
		        		$("#qtip-"+idQtip).remove();
		        	}, 90);
		        	
		        });
		    });
		},
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("derechos_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
    	}
	});
	
	var tabla = $('#derechos').DataTable();
	
	$('#derechos tbody').on( 'click', 'tr', function () {
		tabla.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });
	
	$('#derechos tbody').on('dblclick', 'tr', function () {		
		$("#btnEditDerecho").trigger("click");		
	});
	
	$("#derechos_detail_div").rup_dialog({
		autoOpen: false,
		width: 700,
		modal: true,
		position: { my: "center center" },
		type: $.rup.dialog.DIV
	});
	
	$('#btnAddDerecho').on( 'click', function () {
		
		if ($("#derechos_detail_feedback.rup-feedback").length > 0)
		{
			$("#derechos_detail_feedback").rup_feedback("close");
		}
		$("#derechos_detail_form")[0].reset();
		
		$("#derechos_detail_form").rup_form({
			feedback: $("#derechos_detail_feedback"),
			url: CTX_PATH + "derechos",
			type: "POST",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"procedimiento.idProcedimiento":{
						required: true
					},
					"infraccion.idInfraccion":{
						required: true
					},
					"descripcionCastellano":{
						required: true,
						maxlength: 2000
					},
					"descripcionEuskera":{
						required: true,
						maxlength: 2000
					},
					"articulo":{
						required: true,
						maxlength: 20
					}
				}
			},
		    success: function(){
			   $("#derechos_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#derechos_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.derechos.guardarOk, "ok");
			   
			   cerrarModal();
		    },
		    error: function(){
			   $("#derechos_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#derechos_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.derechos.guardarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#derechos_detail_form").rup_validate("resetForm");
		inicializaControlCambios("derechos_detail_form");
		
		$("#procedimiento_detail_table").rup_combo("destroy");
		$("#procedimiento_detail_table").rup_combo({
			blank : "",		
			source : "/ab59WebAppWar/procedimientos/cargarCombo",
			sourceParam : {
				label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
				value : "idProcedimiento"
			},
			onLoadSuccess: function(){
				$("#procedimiento_detail_table").rup_combo("clear");
				if(PROCEDIMIENTO_PRECARGADO){
					$("#procedimiento_detail_table").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
					$("#procedimiento_detail_table").rup_combo("disable");
					var source = "/ab59WebAppWar/infracciones/cargarCombo?procedimiento.idProcedimiento=" + $("#procedimiento_detail_table").val() + "&Baja=" + ESTADO_NO_BAJA;
					cargarComboInfraccionesModal(source);
				}
			},
			change: function() {
				var source = "/ab59WebAppWar/infracciones/cargarCombo?procedimiento.idProcedimiento=" + $("#procedimiento_detail_table").val() + "&Baja=" + ESTADO_NO_BAJA;
				cargarComboInfraccionesModal(source);
			},
			rowStriping: true
		});
		
		if(typeof PROCEDIMIENTO_PRECARGADO === "undefined" || PROCEDIMIENTO_PRECARGADO === "" || PROCEDIMIENTO_PRECARGADO === null){
			$("#infraccion_detail_table").rup_combo("destroy");
			var listInfracciones = new Array();				
			//Transformo en JSON la lista
			$.toJSON(listInfracciones);	
			$("#infraccion_detail_table").rup_combo({
				source: listInfracciones,	
				blank: "",
				disabled: true,
				rowStriping: true
			});
		}
		
		$("#derechos_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.derechos.nuevo);
		$("#derechos_detail_div").rup_dialog("open");
	});
	
	$('#btnEditDerecho').on( 'click', function () {	
		
		if ($("#derechos_detail_feedback.rup-feedback").length > 0)
		{
			$("#derechos_detail_feedback").rup_feedback("close");
		}
		$("#derechos_detail_form")[0].reset();
		
		$("#derechos_detail_form").rup_form({
			feedback: $("#derechos_detail_feedback"),
			url: CTX_PATH + "derechos",
			type: "PUT",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"procedimiento.idProcedimiento":{
						required: true
					},
					"infraccion.idInfraccion":{
						required: true
					},
					"descripcionCastellano":{
						required: true,
						maxlength: 2000
					},
					"descripcionEuskera":{
						required: true,
						maxlength: 2000
					},
					"articulo":{
						required: true,
						maxlength: 20
					}
				}
			},
		    success: function(){
			   $("#derechos_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#derechos_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.derechos.modificarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
			   $("#derechos_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#derechos_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.derechos.modificarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#derechos_detail_form").rup_validate("resetForm");
				
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			var datosRow = tabla.rows(['.selected']).data().toArray(); 
			
			$.ajax({
				type : "GET",
				url : CTX_PATH + "derechos/" + datosRow[0].idDerecho,
				dataType : "json",
				async : false,
				success : function(data) {
					
					cargarDatos(data, "derechos_detail_form");
															
					$("#derechos_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.derechos.editar);
					$("#derechos_detail_div").rup_dialog("open");
				}
			});	
			
			$("#procedimiento_detail_table").rup_combo("destroy");
			$("#procedimiento_detail_table").rup_combo({
				blank : "",		
				source : "/ab59WebAppWar/procedimientos/cargarCombo",
				sourceParam : {
					label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
					value : "idProcedimiento"
				},
				selected: datosRow[0].procedimiento.idProcedimiento,
				onLoadSuccess: function(){
					if(PROCEDIMIENTO_PRECARGADO){
						$("#procedimiento_detail_table").rup_combo("disable");
					}
					var source = "/ab59WebAppWar/infracciones/cargarCombo?procedimiento.idProcedimiento=" + $("#procedimiento_detail_table").val() + "&Baja=" + ESTADO_NO_BAJA;
					cargarComboInfraccionesModal(source, datosRow[0].idsInfracciones.split(","));
				},
				change: function() {
					var source = "/ab59WebAppWar/infracciones/cargarCombo?procedimiento.idProcedimiento=" + $("#procedimiento_detail_table").val() + "&Baja=" + ESTADO_NO_BAJA;
					cargarComboInfraccionesModal(source);
				},
				rowStriping: true
			});
			
		}else{
			$("#derechos_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#derechos_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
		inicializaControlCambios("derechos_detail_form");
	});
	
	$('#btnRemoveDerecho').on( 'click', function () {
		
		if ($("#derechos_detail_feedback.rup-feedback").length > 0)
		{
			$("#derechos_detail_feedback").rup_feedback("close");
		}
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			$.rup_messages("msgConfirm", {
				title: $.rup.i18n.app.tabla.botones.eliminar,
				message: $.rup.i18n.app.tablasMaestras.derechos.borrar,
				OKFunction:	function() {
					bloquearInterfaz();
					var datosRow = tabla.rows(['.selected']).data().toArray(); 			
					$.ajax({
						type : "DELETE",
						url : CTX_PATH + "derechos/" + datosRow[0].idDerecho,
						dataType : "json",
						async : false,
						success : function() {
							desbloquearInterfaz();
							tabla.ajax.reload();
							$("#derechos_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#derechos_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.derechos.borradoOK, "ok");
						},
						error: function(){
							desbloquearInterfaz();
							$("#derechos_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#derechos_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.derechos.borradoError, "error");
						}
					});			
				}
			});		
		}else{
			$("#derechos_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#derechos_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	});
	
	$('#derechos_detail_button_save').on( 'click', function () {		
		$("#derechos_detail_form").submit();	
	});
	
	$('#derechos_detail_button_cancel').on( 'click', function () {
		hayCambios();
	});	
	
});

function cerrarModal()
{
	$("#infraccion_detail_table").rup_combo("clear");
	$('#derechos').DataTable().ajax.reload();			   
	$("#derechos_detail_div").rup_dialog("close");   
}

function cargarComboInfraccionesFiltro(source, value){
	if ($("#idProcedimiento").val() != "" && $("#idProcedimiento").val() != null){
		$("#idInfraccion").rup_combo("destroy");
		$("#idInfraccion").rup_combo({
			source: source,
			blank: "",
			selected: value,
			sourceParam: {
				label : "articulo",
				value : "idInfraccion"
			},
			onLoadSuccess: function() {
				$("#idInfraccion").rup_combo("clear");
			},
			rowStriping: true,
			change : function() {
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				$("#idInfraccion_filter_table").val($("#idInfraccion").val());
				$("#articulo_filter_table").val($("#articulo").val());
										
				document.getElementById('derechos_filter_filterButton').click();
				
				
				$("#tablaDerechos").css("display","block");
		    	$(".botoneraTabla").css("display","block");
		    	$(".bottom").css("display","block");
			}
		});
		
	}else{
		var listInfracciones = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listInfracciones);	
		$("#idInfraccion").rup_combo("destroy");
		$("#idInfraccion").rup_combo({
			source: listInfracciones,	
			blank: "",
			disabled: true,
			rowStriping: true
		});
	}
}

function cargarComboInfraccionesModal(source, value){
	if ($("#procedimiento_detail_table").val() != "" && $("#procedimiento_detail_table").val() != null){
		$("#infraccion_detail_table").rup_combo("destroy");
		$("#infraccion_detail_table").rup_combo({
			source: source,
			multiselect: true,
			submitAsString:true,
			rowStriping: true,
			readAsString: true,
			selected: value,
			sourceParam: {
				label : "articulo",
				value : "idInfraccion"
			},
			onLoadSuccess: function() {
				if(typeof value === "undefined"){
					$("#infraccion_detail_table").rup_combo("clear");
				}
			}
		});
		
	}else{
		var listInfracciones = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listInfracciones);	
		$("#infraccion_detail_table").rup_combo("destroy");
		$("#infraccion_detail_table").rup_combo({
			source: listInfracciones,	
			blank: "",
			disabled: true,
			rowStriping: true
		});
	}
}

function hayCambios()
{
	if (controlCambios()) {
		$.rup_messages("msgConfirm", {
			message: $.rup.i18n.app.controlCambios.mensaje,
			title:  $.rup.i18n.app.controlCambios.titulo,
			OKFunction: function () {	
				
				$("#derechos_detail_form").submit();
				
			},
			CANCELFunction: function () {
				cerrarModal();   
			}
		});	
	}	
	else
	{
		cerrarModal();
	}
}

function cargarComboDerechoFiltro(source, value){
	if ($("#idProcedimiento").val() != "" && $("#idProcedimiento").val() != null){
		$("#articulo").rup_combo("destroy");
		$("#articulo").rup_combo({
			source: source,
			blank: "",
			selected: value,
			sourceParam: {
				label : "articulo",
				value : "articulo"
			},
			onLoadSuccess: function() {
				$("#articulo").rup_combo("clear");
			},
			rowStriping: true,
			change : function() {
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				$("#idInfraccion_filter_table").val($("#idInfraccion").val());
				$("#articulo_filter_table").val($("#articulo").val());
										
				document.getElementById('derechos_filter_filterButton').click();
				
				$("#tablaDerechos").css("display","block");
		    	$(".botoneraTabla").css("display","block");
		    	$(".bottom").css("display","block");
			}
		});
		
	}else{
		var listInfracciones = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listInfracciones);	
		$("#articulo").rup_combo("destroy");
		$("#articulo").rup_combo({
			source: listInfracciones,	
			blank: "",
			disabled: true,
			rowStriping: true
		});
	}
}