var PROCEDIMIENTO_PRECARGADO = $("#procedimientoPrecargado").val();

jQuery(function($){

	$("#menuTablasMaestras").addClass("active");
	
	var sancionCargada = sessionStorage.getItem("sancionCargada");	
	if (sancionCargada !== null)
	{
		$("#menuFichaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaSancion a").attr("href");
		$("#menuFichaSancion a").attr("href",link+sancionCargada);
		 
		/* Para completar la url del menú Listados */
		var link=$("#menuListados a").attr("href");
		$("#menuListados a").attr("href",link+sancionCargada);
	} else {
		$("#menuFichaSancion").hide();
	}
	
	var propuestaSancionCargada = sessionStorage.getItem("propuestaSancionCargada");	
	if (propuestaSancionCargada !== null)
	{
		$("#menuFichaPropuestaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaPropuestaSancion a").attr("href");
		$("#menuFichaPropuestaSancion a").attr("href",link+propuestaSancionCargada);
	} else {
		$("#menuFichaPropuestaSancion").hide();
	}
	
	$("#idProcedimiento").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/procedimientos/cargarCombo",
		sourceParam : {
			label : "descripcionConCodProcedure",
			value : "idProcedimiento"
		},
		rowStriping: true,
		onLoadSuccess: function(){
			if(PROCEDIMIENTO_PRECARGADO){
				$("#idProcedimiento").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
				$("#idProcedimiento").rup_combo("disable");
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				document.getElementById('confIniOfi_filter_filterButton').click();
			} else {
				document.getElementById('confIniOfi_filter_filterButton').click();
			}
		},
		change: function() {
			$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
			document.getElementById('confIniOfi_filter_filterButton').click();
		},
		width: 250
	});
	
	$("#confIniOfi_detail_div").rup_dialog({
		autoOpen: false,
		width: 700,
		modal: true,
		position: { my: "center center" },
		type: $.rup.dialog.DIV
	});
	
	$("#confIniOfi_detail_div").dialog({
		close: function(){limpiarModal();}
	});

	$("#confIniOfi").rup_datatable({
		
		primaryKey: "idConfiguracion",
		loadOnStartUp: true,
		pagingType: "full_numbers",
		dom: 't <"col-sm-4"l><"col-sm-6"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"confIniOfi_filter_form",
  	  		filterToolbar:"confIniOfi_filter_toolbar",
  	  		collapsableLayerId:"confIniOfi_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	columnDefs: [
	    		{
	   		      targets: [1,3],
	   		      orderable: false,
	   		      visible: false,
	   		   },
    		   {
    		      targets: [0],
    		      visible: (("es"===$.rup_utils.get("language")) ? true : false),
    		      className: "text-center"
    		   },
     		   {
    		      targets: [2],
    		      visible: (("eu"===$.rup_utils.get("language")) ? true : false),
    		      className: "text-center"
    		   },
    		   {
     		      targets: [4],
     		      className: "text-center"
     		   },
    		   {
      		      targets: [5],
      		      className: "text-center",
	  		      render: function(data, type, row) {
	  		    	 if(data !== 0){
	  		    		 return data;
	  		    	 }
	  		      }
      		   }
    	],
    	initComplete:function() {
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("confIniOfi_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
    	}
	});
	
	var tabla = $('#confIniOfi').DataTable();
	
	$('#confIniOfi tbody').on( 'click', 'tr', function () {
		tabla.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });
	
	$('#confIniOfi tbody').on('dblclick', 'tr', function () {
		$("#btnEditConfIniOfi").trigger("click");
	});
	
	
	$('#btnAddConfIniOfi').on( 'click', function () {		

		cargarCombosModal(true);
		
		if($("#confIniOfi_detail_feedback.rup-feedback").length > 0)
		{
			$("#confIniOfi_detail_feedback").rup_feedback("close");
		}
		
		$("#confIniOfi_detail_form")[0].reset();

		$("#confIniOfi_detail_form").rup_form({
			feedback: $("#confIniOfi_detail_feedback"),
			url: CTX_PATH + "confIniOfi",
			type: "POST",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"procedimiento.idProcedimiento":{
						required: true
					},
					"firmantes.idFirmante":{
						required: true
					},
					"plazoResolucion": {required: true},
					"tipoPlazoResolucion": {required: true}
				}
			},
		    success: function(){
			   $("#confIniOfi_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#confIniOfi_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.confIniOfi.guardarOk, "ok");
			   cerrarModal();
		    },
		    error: function(resultado){
		    	if(resultado.responseText == 'errorGuardadoProcedRepetido'){
					$("#confIniOfi_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#confIniOfi_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.confIniOfi.errorGuardadoProcedRepetido, "error");
				} else {
					$("#confIniOfi_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#confIniOfi_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.confIniOfi.guardarError, "error");
				}
			   cerrarModal();
		    }
		});
		
		inicializaControlCambios("confIniOfi_detail_form");

		$("#confIniOfi_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.confIniOfi.nuevo);
		$("#confIniOfi_detail_div").rup_dialog("open");
		
		$("#confIniOfi_detail_form").rup_validate("resetForm");
		$("#publicTablonElectronSI").prop("checked", false);
		$("#publicTablonElectronNO").prop("checked", true);
		$("#contenedorValoresAdicionales").hide();  
	});
	
	$('#btnEditConfIniOfi').on( 'click', function () {	
		
		cargarCombosModal(false);
		
		if ($("#confIniOfi_detail_feedback.rup-feedback").length > 0)
		{
			$("#confIniOfi_detail_feedback").rup_feedback("close");
		}
		
		$("#confIniOfi_detail_form")[0].reset();
		
		$("#confIniOfi_detail_form").rup_form({
			feedback: $("#confIniOfi_detail_feedback"),
			url: CTX_PATH + "confIniOfi",
			type: "PUT",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"procedimiento.idProcedimiento":{
						required: true
					},
					"firmantes.idFirmante":{
						required: true
					},
					"plazoResolucion": {required: true},
					"tipoPlazoResolucion": {required: true}
				}
			},
		    success: function(){
			   $("#confIniOfi_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#confIniOfi_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.confIniOfi.modificarOk, "ok");
			   limpiarModal();
			   cerrarModal();
		    },
		    error: function(){
			   $("#confIniOfi_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#confIniOfi_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.confIniOfi.modificarError, "error");
			   cerrarModal();
		    }
		    
		});
		
		$("#confIniOfi_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.confIniOfi.editar);
		$("#confIniOfi_detail_div").rup_dialog("open");
		
		$("#confIniOfi_detail_form").rup_validate("resetForm");
		
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			var datosRow = tabla.rows(['.selected']).data().toArray(); 	
			$.ajax({
				type : "GET",
				url : CTX_PATH + "confIniOfi/" + datosRow[0].idConfiguracion,
				dataType : "json",
				async : false,
				success : function(data) {
					$("#idConfiguracion").val(data.idConfiguracion);
					
					/* Combo */
					$("#comboProcedimientoModal").rup_combo({
						blank : "",
						source : "/ab59WebAppWar/procedimientos/cargarCombo",
						sourceParam : {
							label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
							value : "idProcedimiento"
						},
						onLoadSuccess: function() {
							if(PROCEDIMIENTO_PRECARGADO){
								$("#comboProcedimientoModal").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
								$("#comboProcedimientoModal").rup_combo("disable");
								document.getElementById('confIniOfi_filter_filterButton').click();
							} else {
								$("#comboProcedimientoModal").rup_combo("setRupValue", data.procedimiento.idProcedimiento);	
							}								
						},
						width: 250,
						rowStriping: true		
					});
					
					if (data.publicarTablon === true) {
						
						$("#publicTablonElectronSI").prop("checked", true);
						$("#publicTablonElectronNO").prop("checked", false);
						
						if(data.plazotablon === null || data.plazotablon === 0) {
							$("#plazo").val("");
						} else {
							$("#plazo").val(data.plazotablon);	
						}
						
						if(data.tipoPlazoTablon === null) {
							$("#comboTipoPlazo").rup_combo("setRupValue", "");	
						} else {
							$("#comboTipoPlazo").rup_combo("setRupValue", data.tipoPlazoTablon);	
						}
						
						if(data.tipoRedaccionTablon === null) {
							$("#comboTipoRedaccion").rup_combo("setRupValue", "");	
						} else {
							$("#comboTipoRedaccion").rup_combo("setRupValue", data.tipoRedaccionTablon);	
						}
						
						$("#contenedorValoresAdicionales").show();  
						
					} else {
						$("#publicTablonElectronNO").prop("checked", true);
						$("#publicTablonElectronSI").prop("checked", false);
						$("#contenedorValoresAdicionales").hide();
					}

					$("#plazoResolucion").val(data.plazoResolucion === 0 ? "" : data.plazoResolucion);
					$("#comboTipoPlazoResolucion").rup_combo("setRupValue", data.tipoPlazoResolucion === null ? "" : data.tipoPlazoResolucion);
					$("#fechaAcuerdoInicio").val(data.fechaAcuerdoInicio);
					$("#codigoDepartExpiente").val(data.codigoDepartExpiente);
					
					$("#comboFirmantes").rup_combo({
						blank : "",
						source : "/ab59WebAppWar/firmantes/cargarCombo",
						sourceParam : {
							label : "nombreFirmante",
							value : "idFirmante"
						},
						rowStriping: true,
						onLoadSuccess : function() {
							$("#comboFirmantes").rup_combo("setRupValue", data.firmantes.idFirmante);	
						}
					});

					$("#comboAlcanceResolucion").rup_combo({
							multiselect: true,
							submitAsJSON:true,
							rowStriping: true,
							readAsString: true,
							source : "/ab59WebAppWar/alcanceResolucion/cargarCombo",
							sourceParam : {
								label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
								value : "idAlcanceResolucion"
							},
							onLoadSuccess : function() {
									$("#comboAlcanceResolucion").rup_combo("setRupValue",(data.idsAlcancesResolcuion));	
							}
						});
					
					
				}
			});	
		}else{
			$("#confIniOfi_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#confIniOfi_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
		inicializaControlCambios("confIniOfi_detail_form");
	});
	
	$('#btnRemoveConfIniOfi').on( 'click', function () {
		
		if ($("#confIniOfi_detail_feedback.rup-feedback").length > 0)
		{
			$("#confIniOfi_detail_feedback").rup_feedback("close");
		}
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			$.rup_messages("msgConfirm", {
				title: $.rup.i18n.app.tabla.botones.eliminar,
				message: $.rup.i18n.app.tablasMaestras.confIniOfi.borrar,
				OKFunction:	function() {
					bloquearInterfaz();
					var datosRow = tabla.rows(['.selected']).data().toArray();
					$.ajax({
						type : "DELETE",
						url : CTX_PATH + "confIniOfi/" + datosRow[0].idConfiguracion,
						dataType : "json",
						async : false,
						success : function() {
							desbloquearInterfaz();
							tabla.ajax.reload();
							$("#confIniOfi_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#confIniOfi_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.confIniOfi.borradoOK, "ok");
						},
						error: function(){
							desbloquearInterfaz();
							$("#confIniOfi_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#confIniOfi_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.confIniOfi.borradoError, "error");
						}
					});			
				}
			});		
		}else{
			$("#confIniOfi_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#confIniOfi_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	});
	
	$('#confIniOfi_detail_button_save').on( 'click', function () {		
		$("#confIniOfi_detail_form").submit();	
	});
	
	$('#confIniOfi_detail_button_cancel').on( 'click', function () {
		hayCambios();
	});
	
	 $('input:radio[name="publicarTablon"]').change(function() {
        if ($(this).val() === "true") {
        	$("#contenedorValoresAdicionales").show();
        	$("#publicTablonElectronSI").prop("checked", true);
        } else {
        	$("#contenedorValoresAdicionales").hide();
        	limpiarDivOculto();
        }
	 });
	 
	
})

function cargarCombosModal(desdeAlta) {
	
	if (desdeAlta === true) {
		
		$("#comboFirmantes").rup_combo({
			blank : "",
			source : "/ab59WebAppWar/firmantes/cargarCombo",
			sourceParam : {
				label : "nombreFirmante",
				value : "idFirmante"
			},
			rowStriping: true
		});
		
		$("#comboAlcanceResolucion").rup_combo({
			multiselect: true,
			submitAsJSON:true,
			rowStriping: true,
			readAsString: true,
			source : "/ab59WebAppWar/alcanceResolucion/cargarCombo",
			sourceParam : {
				label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
				value : "idAlcanceResolucion"
			}
		});
		
		/* Combo */
		$("#comboProcedimientoModal").rup_combo({
			blank : "",
			source : "/ab59WebAppWar/procedimientos/cargarCombo",
			sourceParam : {
				label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
				value : "idProcedimiento"
			},
			onLoadSuccess: function() {
				if(PROCEDIMIENTO_PRECARGADO){
					$("#comboProcedimientoModal").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
					$("#comboProcedimientoModal").rup_combo("disable");
					document.getElementById('confIniOfi_filter_filterButton').click();
				}
			},
			width: 250,
			rowStriping: true		
		});
	} 

	var valoresComboTipoPlazo = [
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.DIA, value: $.rup.i18n.app.tablasMaestras.confIniOfi.DIA},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.MES, value: $.rup.i18n.app.tablasMaestras.confIniOfi.MES},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.TRIMESTRE, value: $.rup.i18n.app.tablasMaestras.confIniOfi.TRIMESTRE},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.ANIO, value: $.rup.i18n.app.tablasMaestras.confIniOfi.ANIO},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.DIA_LABORAL, value: $.rup.i18n.app.tablasMaestras.confIniOfi.DIA_LABORAL},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.FECHA_CONCRETA, value: $.rup.i18n.app.tablasMaestras.confIniOfi.FECHA_CONCRETA},
	];
	
	/* Combo */
	$("#comboTipoPlazo").rup_combo({
		blank : "",		
		source : valoresComboTipoPlazo,
		width: 180,
		rowStriping: true
	});
	
	var valoresComboTipoRedaccion = [
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.CORREDACCION, value: $.rup.i18n.app.tablasMaestras.confIniOfi.CORREDACCION},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.BILINGUE, value: $.rup.i18n.app.tablasMaestras.confIniOfi.BILINGUE},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.TRADUCCION, value: $.rup.i18n.app.tablasMaestras.confIniOfi.TRADUCCION},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.TRADUCCION_TUTORIZADA, value: $.rup.i18n.app.tablasMaestras.confIniOfi.TRADUCCION_TUTORIZADA},
	];
	
	/* Combo */
	$("#comboTipoRedaccion").rup_combo({
		blank : "",		
		source : valoresComboTipoRedaccion,
		width: 200,
		rowStriping: true
	});	
	
	var valoresComboTipoPlazoResolucion = [
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.DIA, value: $.rup.i18n.app.tablasMaestras.confIniOfi.DIA},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.MES, value: $.rup.i18n.app.tablasMaestras.confIniOfi.MES},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.TRIMESTRE, value: $.rup.i18n.app.tablasMaestras.confIniOfi.TRIMESTRE},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.ANIO, value: $.rup.i18n.app.tablasMaestras.confIniOfi.ANIO},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.DIA_LABORAL, value: $.rup.i18n.app.tablasMaestras.confIniOfi.DIA_LABORAL},
		{i18nCaption: $.rup.i18n.app.tablasMaestras.confIniOfi.FECHA_CONCRETA, value: $.rup.i18n.app.tablasMaestras.confIniOfi.FECHA_CONCRETA},
	];
	
	/* Combo */
	$("#comboTipoPlazoResolucion").rup_combo({
		blank : "",		
		source : valoresComboTipoPlazoResolucion,
		width: 200,
		rowStriping: true
	});	
	
}

function hayCambios()
{
	if (controlCambios()) {
		$.rup_messages("msgConfirm", {
			message: $.rup.i18n.app.controlCambios.mensaje,
			title:  $.rup.i18n.app.controlCambios.titulo,
			OKFunction: function () {		
				$("#confIniOfi_detail_form").submit();	
			},
			CANCELFunction: function () {
				cerrarModal();   
			}
		});	
	}	
	else
	{
		cerrarModal();
	}
}

function cerrarModal()
{
	$('#confIniOfi').DataTable().ajax.reload();			   
	$("#confIniOfi_detail_div").rup_dialog("close");   
	limpiarModal();
}

function limpiarModal() {
	$("#comboProcedimientoModal").rup_combo("setRupValue", "");
	$("#plazo").val("");
	$("#comboTipoPlazo").rup_combo("setRupValue", "");
	$("#comboTipoRedaccion").rup_combo("setRupValue", "");
	$("#plazoResolucion").val("");
	$("#comboTipoPlazoResolucion").rup_combo("setRupValue", "");
	$("#fechaAcuerdoInicio").val("");
	$("#codigoDepartExpiente").val("");
	$("#comboFirmantes").rup_combo("setRupValue", "");
	$("#comboAlcanceResolucion").rup_combo("setRupValue", "");
}

function limpiarDivOculto() {
	$("#plazo").val("");
	$("#comboTipoPlazo").rup_combo("setRupValue", "");
	$("#comboTipoRedaccion").rup_combo("setRupValue", "");
}

