var PROCEDIMIENTO_PRECARGADO = $("#procedimientoPrecargado").val();

jQuery(function($){
	
	$("#menuTablasMaestras").addClass("active");
	
	var sancionCargada = sessionStorage.getItem("sancionCargada");	
	if (sancionCargada !== null)
	{
		$("#menuFichaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaSancion a").attr("href");
		$("#menuFichaSancion a").attr("href",link+sancionCargada);
		 
		/* Para completar la url del menú Listados */
		var link=$("#menuListados a").attr("href");
		$("#menuListados a").attr("href",link+sancionCargada);
	} else {
		$("#menuFichaSancion").hide();
	}
	
	var propuestaSancionCargada = sessionStorage.getItem("propuestaSancionCargada");	
	if (propuestaSancionCargada !== null)
	{
		$("#menuFichaPropuestaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaPropuestaSancion a").attr("href");
		$("#menuFichaPropuestaSancion a").attr("href",link+propuestaSancionCargada);
	} else {
		$("#menuFichaPropuestaSancion").hide();
	}

	$("#idProcedimiento").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/procedimientos/cargarCombo",
		sourceParam : {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
			value : "idProcedimiento"
		},
		rowStriping: true,
		onLoadSuccess: function(){
			if(PROCEDIMIENTO_PRECARGADO){
				$("#idProcedimiento").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
				$("#idProcedimiento").rup_combo("disable");
				$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
				document.getElementById('calificaciones_filter_filterButton').click();
			} else {
				document.getElementById('calificaciones_filter_filterButton').click();
			}
		},
		change: function(){
			$("#idProcedimiento_filter_table").val($("#idProcedimiento").val());
			
			document.getElementById('calificaciones_filter_filterButton').click();
		}
	});	

	$("#calificaciones").rup_datatable({
		
		primaryKey: "idCalificacion",
		loadOnStartUp: false,
		pagingType: "full_numbers",
		dom: 't <"col-sm-4"l><"col-sm-6"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"calificaciones_filter_form",
  	  		filterToolbar:"calificaciones_filter_toolbar",
  	  		collapsableLayerId:"calificaciones_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	columnDefs: [
    		   {
    		      targets: [1,6],
    		      orderable: false,
    		      visible: false
    		   },
    		   {
       		      targets: [0],
       		      visible: (("es"===$.rup_utils.get("language")) ? true : false),
       		      width: 900
       		   },
    		   {
       		      targets: [2],
       		      visible: (("eu"===$.rup_utils.get("language")) ? true : false),
       		      width: 900
       		   },
    		   {
      		      targets: [3],
      		      visible: (("es"===$.rup_utils.get("language")) ? true : false),
      		      width: 900
      		   },
      		   {
       		      targets: [4],
       		      visible: (("eu"===$.rup_utils.get("language")) ? true : false)
       		   },
    		   {
    			   targets: [7],
    			   render: function(value){
    				   return formatearNumero(value);
				   },
    			   className: "text-center"
    		   }
    	],
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("calificaciones_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
    	}
	});
	
	var tabla = $('#calificaciones').DataTable();
	
	$('#calificaciones tbody').on( 'click', 'tr', function () {
		tabla.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });
	
	$('#calificaciones tbody').on('dblclick', 'tr', function () {
		if($("#calificaciones_filter_table").val() != "0"){
			$("#btnEditCalificacion").trigger("click");
		}
	});
	
	$("#calificaciones_detail_div").rup_dialog({
		autoOpen: false,
		width: 700,
		modal: true,
		position: { my: "center center" },
		type: $.rup.dialog.DIV
	});
	
	$('#btnAddCalificacion').on( 'click', function () {		
		
		if ($("#calificaciones_detail_feedback.rup-feedback").length > 0)
		{
			$("#calificaciones_detail_feedback").rup_feedback("close");
		}
		
		$("#procedimiento_detail_table").rup_combo("clear");
		$("#calificaciones_detail_form")[0].reset();
		
		$("#calificaciones_detail_form").rup_form({
			feedback: $("#calificaciones_detail_feedback"),
			url: CTX_PATH + "calificaciones",
			type: "POST",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"procedimiento.idProcedimiento":{
						required: true
					},
					"descripcionCastellano":{
						required: true,
						maxlength: 200
					},
					"descripcionEuskera":{
						required: true,
						maxlength: 200
					},
					"plazo":{
						required: true,
						maxlength: 2,
						number: true
					},
					"gravedad":{
						required: true,
						maxlength: 1,
						number: true
					},
					"importeMask":{
						required: true
					}
				}
			},
		    success: function(){
			   $("#calificaciones_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#calificaciones_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.calificaciones.guardarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
			   $("#calificaciones_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#calificaciones_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.calificaciones.guardarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#calificaciones_detail_form").rup_validate("resetForm");
		inicializaControlCambios("calificaciones_detail_form");
		
		if(PROCEDIMIENTO_PRECARGADO){
			$("#procedimiento_detail_table").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
			$("#procedimiento_detail_table").rup_combo("disable");
		}
		
		$("#calificaciones_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.calificaciones.nuevo);
		$("#calificaciones_detail_div").rup_dialog("open");
	});
	
	$('#btnEditCalificacion').on( 'click', function () {	
		
		if ($("#calificaciones_detail_feedback.rup-feedback").length > 0)
		{
			$("#calificaciones_detail_feedback").rup_feedback("close");
		}
		$("#calificaciones_detail_form")[0].reset();
		
		$("#calificaciones_detail_form").rup_form({
			feedback: $("#calificaciones_detail_feedback"),
			url: CTX_PATH + "calificaciones",
			type: "PUT",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"procedimiento.idProcedimiento":{
						required: true
					},
					"descripcionCastellano":{
						required: true,
						maxlength: 200
					},
					"descripcionEuskera":{
						required: true,
						maxlength: 200
					},
					"plazo":{
						required: true,
						maxlength: 2,
						number: true
					},
					"gravedad":{
						required: true,
						maxlength: 1,
						number: true
					},
					"importeMask":{
						required: true
					}
				}
			},
		    success: function(){
			   $("#calificaciones_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#calificaciones_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.calificaciones.modificarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
			   $("#calificaciones_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#calificaciones_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.calificaciones.modificarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#calificaciones_detail_form").rup_validate("resetForm");
		
		if(tabla.rows(['.selected']).data().toArray().length > '0'){	
			var datosRow = tabla.rows(['.selected']).data().toArray(); 	
			$.ajax({
				type : "GET",
				url : CTX_PATH + "calificaciones/" + datosRow[0].idCalificacion,
				dataType : "json",
				async : false,
				success : function(data) {
					
					cargarDatos(data, "calificaciones_detail_form");
					if(PROCEDIMIENTO_PRECARGADO){
						$("#procedimiento_detail_table").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
						$("#procedimiento_detail_table").rup_combo("disable");
					} else {
						$("#procedimiento_detail_table").rup_combo("setRupValue", datosRow[0].procedimiento.idProcedimiento);
					}					
					$("#calificaciones_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.tablasMaestras.calificaciones.editar);
					$("#calificaciones_detail_div").rup_dialog("open");
				}
			});	
		}else{
			$("#calificaciones_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#calificaciones_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
		inicializaControlCambios("calificaciones_detail_form");
	});
	
	$("#plazo_detail_table").keypress(function(event) {
		return isNumericKey(event, false, "#plazo_detail_table");
	});
	
	$("#gravedad_detail_table").keypress(function(event) {
		return isNumericKey(event, false, "#gravedad_detail_table");
	});
	
	$("#procedimiento_detail_table").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/procedimientos/cargarCombo",
		sourceParam : {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
			value : "idProcedimiento"
		},
		rowStriping: true
	});
	
	$('#calificaciones_detail_button_save').on( 'click', function () {		
		$("#calificaciones_detail_form").submit();	
	});
	
	$('#calificaciones_detail_button_cancel').on( 'click', function () {
		hayCambios();
	});	
});

function cerrarModal()
{
	$('#calificaciones').DataTable().ajax.reload();			   
	$("#calificaciones_detail_div").rup_dialog("close");   
}

function hayCambios()
{
	if (controlCambios()) {
		$.rup_messages("msgConfirm", {
			message: $.rup.i18n.app.controlCambios.mensaje,
			title:  $.rup.i18n.app.controlCambios.titulo,
			OKFunction: function () {	
				
				$("#calificaciones_detail_form").submit();
				
			},
			CANCELFunction: function () {
				cerrarModal();   
			}
		});	
	}	
	else
	{
		cerrarModal();
	}
}