jQuery(document).ready(function(){

	var  procedureId = $('#codProcedureId').val();
	var  folderId = $('#folderId').val();
	var parametroConfig = $('#parametroConfig').val();
	
	$('#btnGenerarDocumento_plantillas').prop("disabled", true);
	$('#btnEditarDocumento_plantillas').prop("disabled", true);
	$('#btnAportarDocumento_plantillas').prop("disabled", true);
	$('#btnDescargarDocumento_plantillas').prop("disabled", true);
	$('#btnEliminarDocumento_plantillas').prop("disabled", true);
	
	$("#idProcedimiento_filter_table").val($('#idProcedimiento').val());
	$("#plantillas_idExpediente_filter_table").val($('#idExpediente').val());
	$("#plantillas_folderId_filter_table").val(folderId);
	$("#origen_filter_table").val($('#origen').val());
	$("#idExpediente_filter_table").val($("idExpediente").val());
	
	$("#plantillas").rup_datatable({
		
		primaryKey: "idPlantilla",
		loadOnStartUp: true,
		pagingType: "full_numbers",
		dom: 't <"col-sm-3"l><"col-sm-7"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"plantillas_filter_form",
  	  		filterToolbar:"plantillas_filter_toolbar",
  	  		collapsableLayerId:"plantillas_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	columnDefs: [
		   {
		      targets: [0, 4],
		      orderable: false,
		      visible: false
		   },			   
		   {
		      targets: [1],
		      visible: (("es"===$.rup_utils.get("language")) ? true : false)
		   },
			{
		      targets: [2],
		      visible: (("eu"===$.rup_utils.get("language")) ? true : false)
			},
			{
				targets: [3],
				render: function(data, type, row, meta){	
				  if("" != row.ruta && null != row.ruta && 0 != parametroConfig)
				  {
					  data = '<i class="fa fa-file-text" aria-hidden="true"></i>';
				  } else {
					  data = "";
				  }
				  return data;
				},
				width: 3,
				orderable: false
			}
    	],
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("plantillas_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);			  
    	}
	});
	
	$('#plantillas tbody').on( 'click', 'tr', function () {
		$('#plantillas').DataTable().$('tr.selected').removeClass('selected');
	    $(this).addClass('selected');
	    
	    var dataRow = $('#plantillas').DataTable().rows(['.selected']).data().toArray();
 	   	var ruta = dataRow[0].ruta;
 	   	var tarea = dataRow[0].plantilla.tipoPlantilla.taskId;
 	
 	   	switch(parametroConfig) {
	 		  case VALOR_DESCARGAR:
				     $('#btnGenerarDocumento_plantillas').prop("disabled", true);
			         $('#btnEditarDocumento_plantillas').prop("disabled", true);
			         $('#btnAportarDocumento_plantillas').prop("disabled", true);
			         $('#btnDescargarDocumento_plantillas').prop("disabled", false);
			         $('#btnEliminarDocumento_plantillas').prop("disabled", true);
			        
	 		    break;
	 		  case VALOR_TRAMITAR_ONLINE:
			  
				  if( tarea == '' || tarea == null)
			      {
			         $('#btnGenerarDocumento_plantillas').prop("disabled", true);
			         $('#btnEditarDocumento_plantillas').prop("disabled", true);
			         $('#btnAportarDocumento_plantillas').prop("disabled", true);
			         $('#btnEliminarDocumento_plantillas').prop("disabled", true);
			         $('#btnDescargarDocumento_plantillas').prop("disabled", false);
			      }
				  else{
					  $('#btnGenerarDocumento_plantillas').prop("disabled", true);
					  if (ruta != '' && ruta != null){
						  
						  if($("#esExpedienteCerrado").val() === "true"){
							  $('#btnEditarDocumento_plantillas').prop("disabled", true);
							  $('#btnEliminarDocumento_plantillas').prop("disabled", true);
						      $('#btnAportarDocumento_plantillas').prop("disabled", true);
						  }else{
							  $('#btnEditarDocumento_plantillas').prop("disabled", false);
							  $('#btnEliminarDocumento_plantillas').prop("disabled", false);
						      $('#btnAportarDocumento_plantillas').prop("disabled", false);
						  }  
					      $('#btnDescargarDocumento_plantillas').prop("disabled", true);
	 			     }    			        
					  else{
						  if($("#esExpedienteCerrado").val() === "true"){
							  $('#btnGenerarDocumento_plantillas').prop("disabled", true);
						  }else{
							  $('#btnGenerarDocumento_plantillas').prop("disabled", false);
						  }		 
					      $('#btnEditarDocumento_plantillas').prop("disabled", true);
					      $('#btnEliminarDocumento_plantillas').prop("disabled", true);
					      $('#btnAportarDocumento_plantillas').prop("disabled", true);
					      $('#btnDescargarDocumento_plantillas').prop("disabled", true);
				  	}
				  }
				  
	 		    break;
	 		  case VALOR__DESCARGAR_Y_ONLINE:
	 			  
	 			 $('#btnDescargarDocumento_plantillas').prop("disabled", false);
				 if(ruta != '' && ruta != null)
			      {
	    			 $('#btnGenerarDocumento_plantillas').prop("disabled", true);
	    			 
	    			 if($("#esExpedienteCerrado").val() === "true"){
	    				 $('#btnEditarDocumento_plantillas').prop("disabled", true);
				         $('#btnEliminarDocumento_plantillas').prop("disabled", true);
		 			 }else{
		 				 $('#btnEditarDocumento_plantillas').prop("disabled", false);
				         $('#btnEliminarDocumento_plantillas').prop("disabled", false);
		 			 }
			         if (tarea != '' && tarea != null){
			        	 if($("#esExpedienteCerrado").val() === "true"){
			        		 $('#btnAportarDocumento_plantillas').prop("disabled", true);
			        	 }else{
			        		 $('#btnAportarDocumento_plantillas').prop("disabled", false);
			        	 }	        	 
			         }else{
			        	 $('#btnAportarDocumento_plantillas').prop("disabled", true);
			      	}
				  }
				 else {
					 
					 if($("#esExpedienteCerrado").val() === "true"){
						 $('#btnGenerarDocumento_plantillas').prop("disabled", true);
					 }else{
						 $('#btnGenerarDocumento_plantillas').prop("disabled", false);
					 }
			        $('#btnEditarDocumento_plantillas').prop("disabled", true);
			        $('#btnAportarDocumento_plantillas').prop("disabled", true);
			        $('#btnEliminarDocumento_plantillas').prop("disabled", true);
			        
			      }
			    break;
	 		  default:
	 		    // code block
	 		}
	});
	
	$("#btnGenerarDocumento_plantillas").on("click", function () {
		
		if ($("#plantillas_feedback.rup-feedback").length > 0)
		{
			$("#plantillas_feedback").rup_feedback("close");
		}
		
		if($('#plantillas').DataTable().rows(['.selected']).data().toArray().length > '0'){
			var dataRow = $('#plantillas').DataTable().rows(['.selected']).data().toArray();
			var idPlantilla = dataRow[0].plantilla.idPlantilla;
			
			bloquearInterfaz();
			$.ajax({
				url : "/ab59WebAppWar/plantillas/llamarWebService/" + folderId +"/" + idPlantilla,
				contentType: "application/json",
			    type: "GET",
			    success: function (json) 
			    {
			    	desbloquearInterfaz();
		    		var data = JSON.parse(json);
			    	if(data)
			    	{			
			    		$("#plantillas_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			    		$("#plantillas_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.plantillas.documentoGenerado, "ok");
			    		location.href = data;
			    		
			    		$('#plantillas').DataTable().ajax.reload();
			    		
			    		$('#btnGenerarDocumento_plantillas').prop("disabled", true);
			    		$('#btnEditarDocumento_plantillas').prop("disabled", true);
			    		$('#btnAportarDocumento_plantillas').prop("disabled", true);
			    		$('#btnDescargarDocumento_plantillas').prop("disabled", true);
			    		$('#btnEliminarDocumento_plantillas').prop("disabled", true);
			    		
			    	}else{
			    		$.rup_messages("msgAlert",{
			    			title:  $.rup.i18n.app.mensajes.alerta,
			    			message: $.rup.i18n.app.mensajes.avisos
			    			
			    		});
			    		
			    	}
			    	
			    },
			    error : function (respuesta){
					desbloquearInterfaz();
					$("#plantillas_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#plantillas_feedback").rup_feedback("set",respuesta.responseText, "error");
					
				}		
			});
		}
		else{
			desbloquearInterfaz();
			$("#plantillas_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#plantillas_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}

	});
	
	$("#btnEditarDocumento_plantillas").on("click", function () {
	
		if ($("#plantillas_feedback.rup-feedback").length > 0)
		{
			$("#plantillas_feedback").rup_feedback("close");
		}
		
		if($('#plantillas').DataTable().rows(['.selected']).data().toArray().length > '0'){
			var dataRow = $('#plantillas').DataTable().rows(['.selected']).data().toArray();
			var idPlantilla = dataRow[0].plantilla.idPlantilla;
			
			bloquearInterfaz();
			$.ajax({	
				
				url : "/ab59WebAppWar/plantillas/llamarWebService/modificarDocumento/"+ idPlantilla +"/" + folderId , 
				contentType: "application/json",
			    type: "GET",
			    success: function (json) 
			    {
			    	desbloquearInterfaz();
			    	if(json.length>0){
			    		var data = JSON.parse(json);
			    		
			    		$("#plantillas_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			    		$("#plantillas_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.plantillas.documentoModificado, "ok");
			    		
			    		location.href = data;	
			    	}else{
			    		
			    		$("#plantillas_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			    		$("#plantillas_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.plantillas.avisoNoRuta, "error");
			    		$('#plantillas').DataTable().ajax.reload();
			    		
			    		$('#btnGenerarDocumento_plantillas').prop("disabled", true);
			    		$('#btnEditarDocumento_plantillas').prop("disabled", true);
			    		$('#btnAportarDocumento_plantillas').prop("disabled", true);
			    		$('#btnDescargarDocumento_plantillas').prop("disabled", true);
			    		$('#btnEliminarDocumento_plantillas').prop("disabled", true);
			    	}
			    },
			    error: function (respuesta) {
					desbloquearInterfaz();
			    	$("#plantillas_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#plantillas_feedback").rup_feedback("set",respuesta.responseText, "error");
			    }
			});
		}
		else{
			desbloquearInterfaz();
			$("#plantillas_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#plantillas_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
		
	});
				
	$("#btnAportarDocumento_plantillas").on("click", function () {
		
		//bloquear modal hasta que carga los datos de platea y limpiar formulario			
		if ($("#plantillas_feedback.rup-feedback").length > 0)
		{
			$("#plantillas_feedback").rup_feedback("close");
		}
		
		if($('#plantillas').DataTable().rows(['.selected']).data().toArray().length > '0'){
			var dataRow = $('#plantillas').DataTable().rows(['.selected']).data().toArray();
			var idPlantilla = dataRow[0].plantilla.idPlantilla;
			bloquearInterfaz();
			
			$.ajax({
					
					url : "/ab59WebAppWar/plantillas/aportarDocumento/" + idPlantilla +"/" + procedureId +"/" + folderId ,
					contentType: "application/json",
				    type: "GET",
				    dataType: "json",
				    success: function (result){
				 
				    	desbloquearInterfaz();
				    	var xmlDoc = $.parseXML( result );
			    		var $xml = $( xmlDoc );
			    		
			    		var msgResult = ("eu"==$.rup_utils.get("language")) ? $xml.find( "descripcionEuskera" ).text(): $xml.find( "descripcionCastellano" ).text();
				    	$("#plantillas_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			    		$("#plantillas_feedback").rup_feedback("set", msgResult, "ok");
						
						$('#btnGenerarDocumento_plantillas').prop("disabled", true);
				    	$('#btnEditarDocumento_plantillas').prop("disabled", true);
				    	$('#btnAportarDocumento_plantillas').prop("disabled", true);
				    	$('#btnDescargarDocumento_plantillas').prop("disabled", true);
				    	$('#btnEliminarDocumento_plantillas').prop("disabled", true);;
			
			    		$('#plantillas').DataTable().ajax.reload();
						
				    },
					error : function (respuesta){
						desbloquearInterfaz();
						$("#plantillas_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
						$("#plantillas_feedback").rup_feedback("set",respuesta.responseText, "error");
						
					}				    
				});
		}
		else{
			desbloquearInterfaz();
			$("#plantillas_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#plantillas_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
		
	});		
	
	
	$("#btnDescargarDocumento_plantillas").on("click", function () {
		if ($("#plantillas_feedback.rup-feedback").length > 0)
		{
			$("#plantillas_feedback").rup_feedback("close");
		}
		
		if($('#plantillas').DataTable().rows(['.selected']).data().toArray().length > '0'){
			var dataRow = $('#plantillas').DataTable().rows(['.selected']).data().toArray();
			var idPlantilla = dataRow[0].plantilla.idPlantilla;
	
			bloquearInterfaz();
			$.ajax({
				url : "/ab59WebAppWar/plantillas/llamarWebService/descargarDocumento/" + folderId +"/" + idPlantilla,
				contentType: "application/json",
			    type: "GET",
			    success: function (json) 
			    {
			    	
			    	desbloquearInterfaz();
		    		var data = JSON.parse(json);
			    	if(data)
			    	{			
			    		
			    		$("#rutaDocumento").val(data);
						$("#form_Documento").submit();
			    	}else{
			    		$.rup_messages("msgAlert",{
			    			title:  $.rup.i18n.app.mensajes.alerta,
			    			message: $.rup.i18n.app.mensajes.avisos
			    			
			    		});
			    		
			    	}
			    	
			    },
			    error : function (respuesta){
					desbloquearInterfaz();
					$("#plantillas_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#plantillas_feedback").rup_feedback("set",respuesta.responseText, "error");
					
				}		
			});
		}
		else{
			desbloquearInterfaz();
			$("#plantillas_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#plantillas_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}

	});
	
	$("#btnEliminarDocumento_plantillas").on("click", function () {
		if ($("#plantillas_feedback.rup-feedback").length > 0)
		{
			$("#plantillas_feedback").rup_feedback("close");
		}
		
		if($('#plantillas').DataTable().rows(['.selected']).data().toArray().length > '0'){
			var dataRow = $('#plantillas').DataTable().rows(['.selected']).data().toArray();
			var idPlantilla = dataRow[0].plantilla.idPlantilla;
			
			bloquearInterfaz();
			$.ajax({
				url : "/ab59WebAppWar/plantillas/llamarWebService/eliminarDocumento/"+ idPlantilla +"/" + folderId ,
				contentType: "application/json",
			    type: "GET",
			    success: function (result){
			    	desbloquearInterfaz();
			    	$('#btnGenerarDocumento_plantillas').prop("disabled", true);
			    	$('#btnEditarDocumento_plantillas').prop("disabled", true);
			    	$('#btnAportarDocumento_plantillas').prop("disabled", true);
			    	$('#btnDescargarDocumento_plantillas').prop("disabled", true);
			    	$('#btnEliminarDocumento_plantillas').prop("disabled", true);;
		
		    		$('#plantillas').DataTable().ajax.reload();
		    		$("#plantillas_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#plantillas_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.plantillas.documentoEliminado, "ok");
			    },
				error : function (respuesta){
					desbloquearInterfaz();
					$("#plantillas_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#plantillas_feedback").rup_feedback("set",respuesta.responseText, "error");
					
				}				    
			});
		}
		else{
			desbloquearInterfaz();
			$("#plantillas_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#plantillas_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	
	});	
	
});