var PROCEDIMIENTO_PRECARGADO = $("#procedimientoPrecargado").val();

jQuery(document).ready(function(){

	// Feedback
	$("#listados_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
		 
	 //Ocultamos el botón de guardar de la cabecera
	 $("#btnGuardarExpediente").hide();
	 $("#btnGuardarDatosSancion").hide();
	 $("#btnGuardarPagos").hide();
	 $("#btnGuardarControlFechas").hide();
	
	//Marcamos la opción del menú principal "Listados" y habilitamos
	$("#menuListados").addClass("active");
	$("#menuListadosSinIdSancion").addClass("active");
	if ($("#folderId").val() != ""){
		$("#menuFichaSancion").removeClass("disabled");
	} else {
		$("#fixedNav").hide();
		$("#divExpediente").hide();
		$("#divTitulo").hide();
		$("#divProcedimiento").hide();
		$("#menuFichaSancion").addClass("disabled");
	}
	
	var sancionCargada = sessionStorage.getItem("sancionCargada");	
	if (sancionCargada !== null)
	{
		$("#menuFichaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaSancion a").attr("href");
		$("#menuFichaSancion a").attr("href",link+sancionCargada);
		 
		/* Para completar la url del menú Listados */
		var link=$("#menuListados a").attr("href");
		$("#menuListados a").attr("href",link+sancionCargada);
	} else {
		$("#menuFichaSancion").hide();
	}
	
	var propuestaSancionCargada = sessionStorage.getItem("propuestaSancionCargada");	
	if (propuestaSancionCargada !== null)
	{
		$("#menuFichaPropuestaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaPropuestaSancion a").attr("href");
		$("#menuFichaPropuestaSancion a").attr("href",link+propuestaSancionCargada);
	} else {
		$("#menuFichaPropuestaSancion").hide();
	}
	
	/* Combo */
	$("#comboProcedimiento").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/procedimientos/cargarCombo",
		sourceParam : {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEu": "descripcionEs"),
			value : "idProcedimiento"
		},
		select: function() {
			$("#datosBusqueda").html("");
			if($("#comboProcedimiento").val() !== '') {
				cargarComboListados();
			} else {
				$("#comboListado").rup_combo("setRupValue", "");	
				$("#comboListado").rup_combo("disable");
			}
		},
		width: 500,
		rowStriping: true,
		onLoadSuccess : function() {
			if(PROCEDIMIENTO_PRECARGADO){
				$("#comboProcedimiento").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
				$("#comboProcedimiento").rup_combo("disable");
			} else {
				$("#comboProcedimiento").rup_combo("setRupValue",$("#idProcedimiento").val());
			}			
			
			if($("#comboProcedimiento").val() !== '') {
				cargarComboListados();
			} 
		},
		change : function() {
			$("#idProcedimiento").val($("#comboProcedimiento").val());
		}
	});

});

function tratarRespuesta(respuesta){
	//pintar lista de busquedas y parametros de la busqueda
	var jsonResultado = JSON.parse(respuesta);
	var html = "";
	$.each(jsonResultado, function(indexBusqueda, busqueda) {
			html += "<div class=''>"
					    +"<input type='checkbox' class='busquedaschecked' value=" + busqueda.idBusqueda + " onchange='habilitarDesabilitarBoton();'> </input> "
				    + "<b>" + busqueda.nombre + "</b> </br></br>";
			$.each(busqueda.listaParametros, function(indexParametro, parametros) {
				if ("eu"==$.rup_utils.get("language")){
					html +="<div class='row'><div class='col-3'>" 
							+ parametros.textoMostrar 
						+"</div>"
						+"<div class='col-9'>"
							+"<input type='text' id='"+ parametros.idParametro + "' class='"+ busqueda.idBusqueda +""+(parametros.tipoParametro != null && parametros.tipoParametro == 1?' rup_date rupDateListados':'')+"'> </input>"	
						+"</div></div></br>"	
				}else{
					html +="<div class='row'><div class='col-3'>" 
							+ parametros.textoMostrar 
						+"</div>"
						+"<div class='col-9'>"
							+"<input type='text' id='"+ parametros.idParametro + "' class='"+ busqueda.idBusqueda +""+(parametros.tipoParametro != null && parametros.tipoParametro == 1?' rup_date rupDateListados':'')+"'> </input>"	
						+"</div></div></br>"	
				}
			html += "</div>";
		});
	});
	if (null !== respuesta && "" !== respuesta) {
		html += "</br></br> <button type='button' id='btnEjecutar' class='.btn btn-primary ui-button ui-corner-all ui-widget'>" + $.rup.i18n.app.listados.crearListado +"</button>"
	}
	$("#datosBusqueda").html(html);
	
	$("#btnEjecutar").addClass("disabled");
	
	$("#form_listado").rup_form({
		url : "/ab59WebAppWar/listados/llamarWebService/" + $("#idProcedimiento").val(),
		type : "POST",
		contentType : "application/json",
		dataType : 'json',
		success : function(respuesta) {
			desbloquearInterfaz();
			$("#rutaPIF").val(respuesta);
			$("#form_PIF").submit();
		}, 
		error : function (respuesta){
			desbloquearInterfaz();				
				$("#listados_feedback").rup_feedback("set",respuesta.responseText, "error");
			
		}
	});
	
	var fechaActual = new Date();
	
	var dd = String(fechaActual.getDate()).padStart(2, '0');
	var mm = String(fechaActual.getMonth() + 1).padStart(2, '0'); 
	var yyyy = fechaActual.getFullYear();
	
	
	var fechaEsp = dd + "/" + mm + "/" + yyyy;

	$(".rup_date").each(function() {
		$("#"+this.id).rup_date({
			maxDate:  fechaEsp
		});
	});
	
	$("#btnEjecutar").click(function(){
		if ($("#listados_feedback.rup-feedback").length > 0)
		{
			$("#listados_feedback").rup_feedback("close");
		}
		
		var resultado = "";
		
		var error = false;
		
		var parametroVacio = false;
		
		$(".rup_date").each(function() {
			$(".rup_date").each(function() {
				if(!isNaN(obtenerObjetoDate($("#"+this.id).val()))){
					if(obtenerObjetoDate($("#"+this.id).val()) > obtenerObjetoDate(fechaEsp)){
						error = true;
					}
				}
			});
		});
		
		if(error){
				$("#listados_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.fechaMayorActual, "error");
		}else{
			$(".busquedaschecked").each(function () {
				if($(this).is(':checked')){
					var idBusqueda = $(this).val();
					resultado += idBusqueda + "#";
					//recogemos los parametros de esa busqueda
					var parametros = $("."+idBusqueda);
					$.each(parametros, function() {
						if(!$(this).val()){
							parametroVacio = true;
						}
						resultado += $(this).attr("id") + "@" + $(this).val() +",";
					});
					resultado +="&";
				}
			});
			
			if(parametroVacio){
				$("#listados_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.parametroVacio, "error");
			}else{
				//submitimos el resultado
				$("#resultado").val(resultado);
				bloquearInterfaz();
				$("#form_listado").submit();
			}
		}
	});
	
}

function cargarComboListados() {
		var idProcedimientoSelec = $("#comboProcedimiento").val();
		if ("" !== idProcedimientoSelec) {
			$("#comboListado").rup_combo({
				blank : "",
				source : "/ab59WebAppWar/rellispro/cargarCombo?procedimiento.idProcedimiento=" + idProcedimientoSelec,
				sourceParam : {
					label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
					value : "listado.idListado"
				},
				select: function() {
					var idListado = $("#comboListado").val();
					$("#datosBusqueda").html("");
					if ("" !== idListado) {
						$.ajax({	
					        url: "/ab59WebAppWar/busquedas/"+idListado,
					        type: "POST",
					        success: function(respuesta) {
					        	tratarRespuesta(respuesta);
					        },
					        error: function(){

					        }
					     });
					}
				},
				width: 500,
				rowStriping: true,
				onLoadSuccess : function() {
					$("#comboListado").rup_combo("setRupValue", "");
				}
			});	
		}	
}

function obtenerObjetoDate(dateString) {
    var parts = dateString.split('/');
    return new Date(parts[2], parts[1] - 1, parts[0]);
}

function habilitarDesabilitarBoton(){
	
	var algunoSeleccionado = false;
	$(".busquedaschecked").each(function () {
		if($(this).is(':checked')){
			algunoSeleccionado = true;
		}
	});
	
	if(algunoSeleccionado){
		$("#btnEjecutar").removeClass("disabled");
	}else{
		$("#btnEjecutar").addClass("disabled");
	}
}



