$(document).ready(function(){

	//Marcamos la opción del menú principal "Sanciones" y habilitamos
	$("#menuFichaSancion").addClass("active");
	
	$("#relSanProSan_idSancion").val($("#idSancion").val());
	$("#propuestasSancion_idSancionFind").val($("#idSancion").val());
	if($("#codProcedureId").val() == COD_PROCEDURE_SANCIONES_TURISMO){
		$("#idEstadoProSan_filter_table").val(ESTADO_VALIDADA_DIRECCION_TURISMO);
	} else if($("#codProcedureId").val() == COD_PROCEDURE_SANCIONES_COMERCIO){
		$("#idEstadoProSan_filter_table").val(ESTADO_VALIDADA_DIRECCION_COMERCIO);
	}
	
	$(".rup_accordion").rup_accordion({
		collapsible: true,
		heightStyle: "content",
		clearStyle:true
	});
	
	
	$("#accordionExample").rup_accordion ("activate", false);
	$("#accordionParticipaciones").rup_accordion ("activate", false);
	$("#accordionUbicacion").rup_accordion ("activate", false);
	$("#accordionInfracciones").rup_accordion ("activate", false);
	$("#accordionDocumentos").rup_accordion ("activate", false);
	
	if($("#identifiEstableci").val() !== ""){
		$("#btnAccesoCenso").show();
	} else {
		$("#btnAccesoCenso").hide();
	}
	
/* COMBOS de NORA */
	
	$("#idProvincia").rup_combo({
		source: "/ab59WebAppWar/nora/provincias",
		blank: "",
		sourceParam: {
			label: "dsO",
			value: "id"
		},
		change: function() {
			$("#codigoProvincia").val($("#idProvincia").rup_combo("getRupValue"));
			$("#codigoMunicipio").val("");
			var source = "/ab59WebAppWar/nora/municipiosBusqueda?provinciaId=" + $("#idProvincia").val();
			cargarComboMunicipiosFiltro(source);
		},
		width: 250,
		rowStriping: true
	});
	
	$("#codigoMunicipio").prop("disabled", true);
	$("#idMunicipio").rup_combo("destroy");
	var listMunicipios = new Array();				
	//Transformo en JSON la lista
	$.toJSON(listMunicipios);	
	$("#idMunicipio").rup_combo({
		source: listMunicipios,	
		blank: "",
		disabled: true,
		rowStriping: true,
		width: 250
	});
	
	$("#idLocalidad").rup_combo("destroy");
	var listLocalidades = new Array();				
	//Transformo en JSON la lista
	$.toJSON(listLocalidades);	
	$("#idLocalidad").rup_combo({
		source: listLocalidades,	
		blank: "",
		disabled: true,
		rowStriping: true,
		width: 290
	});
	
	$("#propuestasSancion").rup_datatable({
		
		primaryKey: "idPropuestaSancion",
		loadOnStartUp: true,
		pagingType: "full_numbers",
		dom: 't <"col-sm-3"l><"col-sm-6"p><"col-sm-3"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"propuestasSancion_filter_form",
  	  		filterToolbar:"propuestasSancion_filter_toolbar",
  	  		collapsableLayerId:"propuestasSancion_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	order: [ 1, "asc" ],
    	columnDefs: [
    		   {
    		      targets: [0, 7, 8, 9],
    		      orderable: false,
    		      visible: false
    		   },
    		   {
    			   targets: [2],
    			   render: function(data, type, row, meta){
    		            if(type === 'display' && row.expedienteOrigen.procedimiento.aplicacion.urlAplicacion != null){
    		                data = '<a style="color: black; text-decoration: underline" href="' + row.expedienteOrigen.procedimiento.aplicacion.urlAplicacion + row.expedienteOrigen.folderId + '" target="_blanck">' + data + '</a>';
    		            }

    		            return data;
    		         }
    		   },
       		   {
       			   targets: [1],
       			   width: 75,
       		   }
    	],
    	initComplete:function() {
			
			  var spanM = document.createElement("span");
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("propuestasSancion_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);			  
    	}
	});
	
	$('#propuestasSancion tbody').on( 'click', 'tr', function () {
		$('#propuestasSancion').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });
	
	$('#propuestasSancion tbody').on('dblclick', 'tr', function () {
		if($("#propuestasSancion_filter_table").val() != "0"){
			$("#btnVerPropuestasSancion_tablaPropuestaSancion").trigger("click");
		}
	});
	
	$("#registroUno").keyup(function(e) {
		var code = (e.keyCode ? e.keyCode : e.which);
		if(code !== 9 && code !== 16){
			$("#registroUno").val($("#registroUno").val().toUpperCase());
			if($("#registroUno").val().length == 1){
				$("#registroDos").focus();
			}
		}
	});
	
	$("#registroDos").keyup(function(e) {
		var code = (e.keyCode ? e.keyCode : e.which);
		if(code !== 9 && code !== 16){
			$("#registroDos").val($("#registroDos").val().toUpperCase());
			if($("#registroDos").val().length == 2){
				$("#registroTres").focus();
			}
		}
	});
	
	$("#registroTres").focusout(function() {
		if($("#registroTres").val() !== ""){
			$("#registroTres").val(pad($("#registroTres").val(), 5));
		}
	});
	
	$( "#btnBuscar" ).click(function() {
		document.getElementById('propuestasSancion_filter_filterButton').click();
		
		$("#tablaPropuestasSancion").css("display","block");
    	$(".botoneraTabla").css("display","block");
    	$(".bottom").css("display","block");

	});
	
	if ($("#nombreTitular_filter_table").val() !== "")
	{
		$("#btnBuscar").trigger("click");
	}
	
	$("#btnLimpiar").click(function(){
		$("#tablaPropuestasSancion").css("display","none");
		limpiar("#propuestasSancion_filter_form");
		$("#idProvincia").rup_combo("clear");
		if($("#codProcedureId").val() == COD_PROCEDURE_SANCIONES_TURISMO){
			$("#idEstadoProSan_filter_table").val(ESTADO_VALIDADA_DIRECCION_TURISMO);
		} else if($("#codProcedureId").val() == COD_PROCEDURE_SANCIONES_COMERCIO){
			$("#idEstadoProSan_filter_table").val(ESTADO_VALIDADA_DIRECCION_COMERCIO);
		}
				 
	});
	
	$("#relSanProSan").rup_datatable({
		
		primaryKey: "idRelSanProSan",
		loadOnStartUp: true,
		pagingType: "full_numbers",
		dom: 't <"col-sm-3"l><"col-sm-7"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"relSanProSan_filter_form",
  	  		filterToolbar:"relSanProSan_filter_toolbar",
  	  		collapsableLayerId:"relSanProSan_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	order: [ 1, "asc" ],
    	columnDefs: [
    		   {
    		      targets: [0, 7, 8, 9],
    		      orderable: false,
    		      visible: false
    		   },
    		   {
    			   targets: [1],
      		       width: 75
        		},
    		   {
    			   targets: [2],
    			   render: function(data, type, row, meta){
    		            if(type === 'display' && row.propuestaSancion.expedienteOrigen.procedimiento.aplicacion.urlAplicacion!= null){
    		                data = '<a style="color: black; text-decoration: underline" href="' + row.propuestaSancion.expedienteOrigen.procedimiento.aplicacion.urlAplicacion + row.propuestaSancion.expedienteOrigen.folderId + '" target="_blanck">' + data + '</a>';
    		            }

    		            return data;
    		         }
    		   }
    	],
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("relSanProSan_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);			  
    	}
	});
	
	$('#relSanProSan tbody').on( 'click', 'tr', function () {
		$('#relSanProSan').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });
	
	$('#relSanProSan tbody').on('dblclick', 'tr', function () {
		if($("#relSanProSan_filter_table").val() != "0"){
			$("#btnVerPropuestasSancion_relSanProSan").trigger("click");
		}
	});
	
	$("#btnAddPropuestaSancion").click(function(){
		
		if ($("#propuestasSancionFeedback.rup-feedback").length > 0)
		{
			$("#propuestasSancionFeedback").rup_feedback("close");
		}
		if ($("#relSanProSanFeedback.rup-feedback").length > 0)
		{
			$("#relSanProSanFeedback").rup_feedback("close");
		}
		
		if($('#propuestasSancion').DataTable().rows(['.selected']).data().toArray().length > '0'){
			var datosRow = $('#propuestasSancion').DataTable().rows(['.selected']).data().toArray(); 	
			
			$.ajax({
				type : "POST",
				url : CTX_PATH + "relsanprosan/comprobarEstablecimientoPropuesta/" + $("#relSanProSan_idSancion").val() + "/" + datosRow[0].idPropuestaSancion,
				dataType : "json",
				async : false,
				success : function(data) {
					
					if (data==true){
						agregarPropuestaSan(1);
					}else{
						$.rup_messages("msgConfirm", {
							message: $.rup.i18n.app.propuestasSancion.validarUbicacion.mensaje,
							title:  $.rup.i18n.app.propuestasSancion.validarUbicacion.titulo,
							OKFunction: function () {	
								agregarPropuestaSan(1);
							},
							CANCELFunction: function () {
								agregarPropuestaSan(0);
							}
						});
						
						$( ".ui-dialog-buttonset button:nth-child(1)" ).text($.rup.i18n.app.msg.si);
						$( ".ui-dialog-buttonset button:nth-child(2)" ).text($.rup.i18n.app.msg.no);
						
					}
					
				
				}
			});
		}
		else
		{
			$("#relSanProSanFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#relSanProSanFeedback").rup_feedback("set", $.rup.i18n.app.feedback.error.lineaNoSeleccionadaPropuestasSancion, "error");
		}
	});
	
	
	
	
	$("#btnRemovePropuestaSancion").click(function(){
		if ($("#propuestasSancionFeedback.rup-feedback").length > 0)
		{
			$("#propuestasSancionFeedback").rup_feedback("close");
		}		
		if ($("#relSanProSanFeedback.rup-feedback").length > 0)
		{
			$("#relSanProSanFeedback").rup_feedback("close");
		}
		
		if($('#relSanProSan').DataTable().rows(['.selected']).data().toArray().length > '0'){
			var datosRow = $('#relSanProSan').DataTable().rows(['.selected']).data().toArray(); 	
			
			$.ajax({
				type : "DELETE",
				url : CTX_PATH + "relsanprosan/eliminar/" + $("#relSanProSan_idSancion").val() + "/" + datosRow[0].idRelSanProSan + "/" + datosRow[0].propuestaSancion.idPropuestaSancion,
				dataType : "json",
				async : false,
				success : function(data) {	
					$('#propuestasSancion').DataTable().ajax.reload();
					$('#relSanProSan').DataTable().ajax.reload();
				}
			});
		}
		else
		{
			$("#relSanProSanFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#relSanProSanFeedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	});
	
	$("#estado_detail_table").rup_combo({
		blank: "",
		source: "/ab59WebAppWar/estadosProSan/cargarCombo?procedimiento.idProcedimiento=" + $("#idProcedimiento").val(),	
		sourceParam: {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
			value : "idEstadoProSan"
		},
		width : 225,
		rowStriping: true
	});
	
	$("#infracciones").rup_datatable({
		
		primaryKey: "idRelArtInfProSan",
		loadOnStartUp: false,
		pagingType: "full_numbers",
		dom: 't <"col-sm-3"l><"col-sm-7"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"infracciones_filter_form",
  	  		filterToolbar:"infracciones_filter_toolbar",
  	  		collapsableLayerId:"infracciones_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	order: [ 1, "asc" ],
    	columnDefs: [
    		{
  		      targets: [0, 8, 9, 10, 11],
  		      orderable: false,
  		      visible: false
  		   },
  		   {
    		      targets: [2],
    		      visible: (("es"===$.rup_utils.get("language")) ? true : false),
    		      width: 100
    		   },
    		   {
     		      targets: [3],
     		      visible: (("eu"===$.rup_utils.get("language")) ? true : false),
    		      width: 100
     		   },
  		   {
  			   targets: [1],
  			   render: function(data){
  				   if(data === null){
  					   data = '';
  				   }
  				   return '<div id="propuesta_articuloInfraccionTooltip_" class="propuesta_articuloInfraccionTooltip">' + data + '</div>';
  			   }
  		   },
  		   {
  			   targets: [7],
  			   render: function(data){
  				   if(data === null){
  					   data = '';
  				   }
  				   return '<div id="propuesta_articuloDerechoTooltip_" class="propuesta_articuloDerechoTooltip">' + data.replace(/#/g, "<br/>") + '</div>';
  			   }
  		   }    		   
    	],
		drawCallback: function() {
			 var tabla = $('#infracciones').DataTable();
			
			$('.propuesta_articuloInfraccionTooltip').each(function (index) {
				if (tabla.row(index) && tabla.row(index).data()){
					
				
					var toolTipText = (("es"===$.rup_utils.get("language")) ? tabla.row(index).data().infraccion.descripcionCastellano : tabla.row(index).data().infraccion.descripcionEuskera) 
					this.id = this.id + index;
			        $("#"+this.id).rup_tooltip({
			            content: toolTipText,		        	
			            position: {
			                my: 'top left',
			                at: 'bottom right',
			                adjust: {
			                	x: 10,
			                	y: 9
			                }
			            }
			        });
			        $("#"+this.id).mouseover(function(){
			        	var idQtip = $("#"+this.id).parent().attr("data-hasqtip");
			        	setTimeout(function(){ 
			        		$("#qtip-"+idQtip).remove();
			        	}, 90);
			        	
			        });
				}
		    });
			
			$('.propuesta_articuloDerechoTooltip').each(function (index) {
				var toolTipText = "- " +  (("es"===$.rup_utils.get("language")) ? tabla.row(index).data().descripcionDerechosInfCas.replace(/#/g, "<br/>- ") : tabla.row(index).data().descripcionDerechosInfEus.replace(/#/g, "<br/>- ")) 
				this.id = this.id + index;
		        $("#"+this.id).rup_tooltip({
		            content: toolTipText,		        	
		            position: {
		                my: 'top left',
		                at: 'bottom right',
		                adjust: {
		                	x: 10,
		                	y: 9
		                }
		            }
		        });
		        $("#"+this.id).mouseover(function(){
		        	var idQtip = $("#"+this.id).parent().attr("data-hasqtip");
		        	setTimeout(function(){ 
		        		$("#qtip-"+idQtip).remove();
		        	}, 90);
		        	
		        });
		    });
		},
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("infracciones_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
			  
    	}
	});
	
	$("#documentos").rup_datatable({
		
		primaryKey: "idDocumento",
		loadOnStartUp: false,
		pagingType: "full_numbers",
		dom: 't <"col-sm-3"l><"col-sm-7"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"documentos_filter_form",
  	  		filterToolbar:"documentos_filter_toolbar",
  	  		collapsableLayerId:"documentos_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	order: [ 1, "asc" ],
    	columnDefs: [
			   {
			      targets: [0, 1, 2, 3],
			      orderable: false,
			      visible: false
			   },	
	           {
	        		targets: [4],
	        		render: function (cellvalue, options, rowObject){
	        			var urlDescargarRelActDoc;
	        			if (cellvalue !== null && cellvalue !== "") {
	        				if (rowObject.oidDokusi !== null && rowObject.oidDokusi !== "") {
	        					urlDescargarRelActDoc = CTX_PATH + "docprosan/descargarDocumentoDokusi/" + rowObject.oidDokusi + "/" + cellvalue;
	        				} else {
	        					urlDescargarRelActDoc = CTX_PATH + "docprosan/descargarDocumentoPid/" + rowObject.oidDokusi + "/" + cellvalue;;
	        				}
	        				
	        				return "<a href='" + urlDescargarRelActDoc + "'><u>" + cellvalue + "</u></a>";
	        			} else {
	        				return "";
	        			}
	        		}
	           },		   
			   {
			      targets: [5],
			      visible: (("es"===$.rup_utils.get("language")) ? true : false)
			   },
   				{
			      targets: [6],
			      visible: (("eu"===$.rup_utils.get("language")) ? true : false)
   				},   				
				{
					targets: [7],
					render: function(data) {
						if(data === APORTADO_EXPEDIENTE_SI){
							return $.rup.i18n.app.propuestasSancion.documentos.aportadoExpedienteSi;
						} else if(data === APORTADO_EXPEDIENTE_NO){
							return $.rup.i18n.app.propuestasSancion.documentos.aportadoExpedienteNo;
						} else if(data === APORTADO_EXPEDIENTE_NO_SUBIR){
							return $.rup.i18n.app.propuestasSancion.documentos.aportadoExpedienteNoSubir;
						}
					}
				}
    	],
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("documentos_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
			  
    	}
	});

	$('#documentos tbody').on( 'click', 'tr', function () {
		$('#documentos').DataTable().$('tr.selected').removeClass('selected');
	    $(this).addClass('selected');
	    if($('#documentos').DataTable().rows(['.selected']).data().toArray()[0].plantilla.idPlantilla == 0){
	    	$("#btnAportarDocumento").prop("disabled", true);
	    } else {
	    	$("#btnAportarDocumento").prop("disabled", false);
	    }
	});
	
$("#relExpTer").rup_datatable({
		
		primaryKey: "idRelExpTer",
		loadOnStartUp: false,
		pagingType: "full_numbers",
		dom: 't',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"relExpTer_filter_form",
  	  		filterToolbar:"relExpTer_filter_toolbar",
  	  		collapsableLayerId:"relExpTer_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	order: [ 1, "asc" ],
    	columnDefs: [
		   {
		      targets: [0],
		      orderable: false,
		      visible: false
	      },
	      {
	    	  targets: [1],
	    	  visible: "es"==$.rup_utils.get("language") ? true: false,
			  width: 75
	      },
	      {
	    	  targets: [2],
	    	  visible: "eu"==$.rup_utils.get("language") ? true: false,
			  width: 75
	      }
    	]
	});
	
	$('#relExpTer tbody').on( 'click', 'tr', function () {
		$('#relExpTer').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });
	
	//Botón aportar documento a Tramitagune
	$("#btnAportarDocumento").click(function(){
		if ($("#documentos_feedback.rup-feedback").length > 0)
		{
			$("#documentos_feedback").rup_feedback("close");
		}
		
		if($('#documentos').DataTable().rows(['.selected']).data().toArray().length > '0'){
			bloquearInterfaz();
			var urlAportarDocumento;

			var datosRow = $('#documentos').DataTable().rows(['.selected']).data().toArray();
			if(typeof datosRow[0].oidDokusi !== "undefined" && datosRow[0].oidDokusi !== "" && datosRow[0].oidDokusi !== null) {
				urlAportarDocumento = CTX_PATH + "docprosan/aportarDocumentoDokusi/" + datosRow[0].idDocumento + "/" + datosRow[0].oidDokusi + "/" + datosRow[0].plantilla.idPlantilla + "/" + $("#relSanProSan_idSancion").val();
			} else {
				urlAportarDocumento = CTX_PATH + "docprosan/aportarDocumentoPid/" + datosRow[0].idDocumento + "/" + datosRow[0].oidPID + "/" + datosRow[0].plantilla.idPlantilla + "/" + $("#relSanProSan_idSancion").val();
			}
			
			$.ajax({
				type: "GET",
				url: urlAportarDocumento,
				contentType: "application/json",
				dataType: "json",
				success: function(data){
					
					desbloquearInterfaz();
					if (data != "ok")
					{
						$("#documentos_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
						$("#documentos_feedback").rup_feedback("set", data, "error");
					}
					else
					{
						$("#documentos_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
						$("#documentos_feedback").rup_feedback("set", $.rup.i18n.app.mensajes.documentoTramitado, "ok");
						$("#documentos").DataTable().ajax.reload();
					}
				},
				error: function(data){
					
					desbloquearInterfaz();
					$("#documentos_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
					$("#documentos_feedback").rup_feedback("set", data.responseText, "error");
				}
			});
		} else{
			$("#documentos_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#documentos_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	});
		
	$('#btnVerPropuestasSancion_tablaPropuestaSancion').on( 'click', function () {	
				
		if ($("#propuestasSancionFeedback.rup-feedback").length > 0)
		{
			$("#propuestasSancionFeedback").rup_feedback("close");
		}
		$("#propuestasSancion_detail_form")[0].reset();
		
		$("#propuestasSancion_detail_form").rup_form({
			feedback: $("#propuestasSancionFeedback"),
			url: CTX_PATH + "propuestassancion",
			type: "PUT",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"notas":{
						maxlength: 1000
					}
				}
			},
		    success: function(){
			   $("#propuestasSancionFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#propuestasSancionFeedback").rup_feedback("set", $.rup.i18n.app.propuestasSancion.modificarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
			   $("#propuestasSancionFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#propuestasSancionFeedback").rup_feedback("set", $.rup.i18n.app.propuestasSancion.modificarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#propuestasSancion_detail_form").rup_validate("resetForm");
		
		if($('#propuestasSancion').DataTable().rows(['.selected']).data().toArray().length > '0'){	
			var datosRow = $('#propuestasSancion').DataTable().rows(['.selected']).data().toArray();
			
			if(null !== datosRow[0].expedienteOrigen.idExpediente && '' !== datosRow[0].expedienteOrigen.idExpediente){
			
				$.ajax({
					type : "GET",
					url : CTX_PATH + "propuestassancion/" + datosRow[0].idPropuestaSancion,
					dataType : "json",
					async : false,
					success : function(data) {			
						
						cargarDatos(data, "propuestasSancion_detail_form");
						
						$("#establecimiento_detail_table").val(data.expedienteOrigen.datosDirecciones.establecimiento);
						$("#identificadorEstablecimientoUno_detail_table").val(data.expedienteOrigen.datosDirecciones.identificadorEstablecimientoUno);
						$("#identificadorEstablecimientoDos_detail_table").val(data.expedienteOrigen.datosDirecciones.identificadorEstablecimientoDos);
						$("#identificadorEstablecimientoTres_detail_table").val(data.expedienteOrigen.datosDirecciones.identificadorEstablecimientoTres);
						$("#descripcionProvincia_detail_table").val(data.expedienteOrigen.datosDirecciones.descripcionProvincia);
						$("#descripcionMunicipio_detail_table").val(data.expedienteOrigen.datosDirecciones.descripcionMunicipio);
						$("#descripcionLocalidad_detail_table").val(data.expedienteOrigen.datosDirecciones.descripcionLocalidad);
						$("#calle_detail_table").val(data.expedienteOrigen.datosDirecciones.direccion);
						$("#numero_detail_table").val(data.expedienteOrigen.datosDirecciones.numero);
						$("#escalera_detail_table").val(data.expedienteOrigen.datosDirecciones.escalera);
						$("#piso_detail_table").val(data.expedienteOrigen.datosDirecciones.piso);
						$("#letra_detail_table").val(data.expedienteOrigen.datosDirecciones.letra);
						$("#codigoPostal_detail_table").val(data.expedienteOrigen.datosDirecciones.codigoPostal);
						
						$("#numExpedienteOrigen_detail_table").val(data.expedienteOrigen.folderNumber);
						$("#tituloExpedienteOrigen_detail_table").val(data.expedienteOrigen.titulo);
						
						$("#idExpediente_filter_table").val(data.expedienteOrigen.idExpediente);	
						$("#idTercero_filter_table").val("");				
						$('#relExpTer').DataTable().ajax.reload();
						
						$("#idPropuestaSancion_filter_table").val(data.idPropuestaSancion);					
						$('#infracciones').DataTable().ajax.reload();
							
						$("#documentos_idPropuestaSancion_filter_table").val(data.idPropuestaSancion);					
						$('#documentos').DataTable().ajax.reload();
						
						$("#estado_detail_table").rup_combo("enable");
						$("#notas_detail_table").prop("disabled", false);
						
						$(".botoneraTabla").hide();
						
						$("#notasResponsable_detail_table").val(data.notasRespOfi);
						
						$("#propuestasSancion_detail_button_save").show();
						
						abrirModal();
					}
				});
			} else {
				$.ajax({
					type : "GET",
					url : CTX_PATH + "propuestassancion/sinExpediente/" + datosRow[0].idPropuestaSancion,
					dataType : "json",
					async : false,
					success : function(data) {
						cargarDatos(data, "propuestasSancion_detail_form");
						
						$("#establecimiento_detail_table").val(data.datosDirecciones.establecimiento);
						$("#identificadorEstablecimientoUno_detail_table").val(data.datosDirecciones.identificadorEstablecimientoUno);
						$("#identificadorEstablecimientoDos_detail_table").val(data.datosDirecciones.identificadorEstablecimientoDos);
						$("#identificadorEstablecimientoTres_detail_table").val(data.datosDirecciones.identificadorEstablecimientoTres);
						$("#descripcionProvincia_detail_table").val(data.datosDirecciones.descripcionProvincia);
						$("#descripcionMunicipio_detail_table").val(data.datosDirecciones.descripcionMunicipio);
						$("#descripcionLocalidad_detail_table").val(data.datosDirecciones.descripcionLocalidad);
						$("#calle_detail_table").val(data.datosDirecciones.direccion);
						$("#numero_detail_table").val(data.datosDirecciones.numero);
						$("#escalera_detail_table").val(data.datosDirecciones.escalera);
						$("#piso_detail_table").val(data.datosDirecciones.piso);
						$("#letra_detail_table").val(data.datosDirecciones.letra);
						$("#codigoPostal_detail_table").val(data.datosDirecciones.codigoPostal);
						
						$("#numExpedienteOrigen_detail_table").val("");
						$("#tituloExpedienteOrigen_detail_table").val("");
						
						$("#idTercero_filter_table").val(data.idTercero);
						$("#idExpediente_filter_table").val("");
						$('#relExpTer').DataTable().ajax.reload();
						
						$("#idPropuestaSancion_filter_table").val(data.idPropuestaSancion);					
						$('#infracciones').DataTable().ajax.reload();
						
						$("#documentos_idPropuestaSancion_filter_table").val(data.idPropuestaSancion);					
						$('#documentos').DataTable().ajax.reload();
						
						$("#estado_detail_table").rup_combo("enable");
						$("#notas_detail_table").prop("disabled", false);
						
						$(".botoneraTabla").hide();
						
						$("#notasResponsable_detail_table").val(data.notasRespOfi);
						
						$("#propuestasSancion_detail_button_save").show();
						
						abrirModal();
					}
				});	
			}
		}else{
			$("#propuestasSancionFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#propuestasSancionFeedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
		inicializaControlCambios("propuestasSancion_detail_form");
	});
	
	$('#btnVerPropuestasSancion_relSanProSan').on( 'click', function () {	
		
		var datosRow = $('#relSanProSan').DataTable().rows(['.selected']).data().toArray();
		//ACA le pasaremos el isSancion a inspecionar 
		window.location = "/ab59WebAppWar/fichapropuestasancion/maint/"+datosRow[0].propuestaSancion.idPropuestaSancion;
		
		inicializaControlCambios("propuestasSancion_detail_form");
		
	});
	
	$('#propuestasSancion_detail_button_save').on( 'click', function () {		
		$("#propuestasSancion_detail_form").submit();	
	});
	
	$('#propuestasSancion_detail_button_cancel').on( 'click', function () {
		hayCambios();
	});
	
	$.unblockUI();
});

function buscarComboProvincia(){
	$("#idProvincia").rup_combo("setRupValue", pad($("#codigoProvincia").val(), 2));
}

function buscarComboMunicipio(){
	$("#idMunicipio").rup_combo("setRupValue", pad($("#codigoMunicipio").val(), 3));
}

function cerrarModal()
{
	$('#propuestasSancion').DataTable().ajax.reload();			   
	$("#propuestasSancion_detail_div").rup_dialog("destroy");
}

function hayCambios()
{
	if (controlCambios()) {
		$.rup_messages("msgConfirm", {
			message: $.rup.i18n.app.controlCambios.mensaje,
			title:  $.rup.i18n.app.controlCambios.titulo,
			OKFunction: function () {	
				
				$("#propuestasSancion_detail_form").submit();
				
			},
			CANCELFunction: function () {
				cerrarModal();   
			}
		});	
	}	
	else
	{
		cerrarModal();
	}
}

function abrirModal()
{
	$("#propuestasSancion_detail_div").rup_dialog({
		autoOpen: true,
		width: 1100,
		modal: true,
		position: { my: "center center" },
		type: $.rup.dialog.DIV,
		title: $.rup.i18n.app.propuestasSancion.editar,
		open:function(){
			$("#notas_detail_table").focus();
			$("#accordionParticipaciones").rup_accordion ("activate", false);
			$("#accordionUbicacion").rup_accordion ("activate", false);
			$("#accordionInfracciones").rup_accordion ("activate", false);
			$("#accordionDocumentos").rup_accordion ("activate", false);
		}
	});
}

function agregarPropuestaSan(tratarUbicacion){
	
	
	if ($("#propuestasSancionFeedback.rup-feedback").length > 0)
	{
		$("#propuestasSancionFeedback").rup_feedback("close");
	}
	if ($("#relSanProSanFeedback.rup-feedback").length > 0)
	{
		$("#relSanProSanFeedback").rup_feedback("close");
	}
	
	if($('#propuestasSancion').DataTable().rows(['.selected']).data().toArray().length > '0'){
		var datosRow = $('#propuestasSancion').DataTable().rows(['.selected']).data().toArray(); 	
		
		$.ajax({
			type : "POST",
			url : CTX_PATH + "relsanprosan/guardar/" + $("#relSanProSan_idSancion").val() + "/" + datosRow[0].idPropuestaSancion + "/" + tratarUbicacion,
			dataType : "json",
			async : false,
			success : function(data) {	
				$('#propuestasSancion').DataTable().ajax.reload();
				$('#relSanProSan').DataTable().ajax.reload();
			}
		});
	}
	else
	{
		$("#propuestasSancionFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
		$("#propuestasSancionFeedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
	}
}

function cargarComboMunicipiosFiltro(source, value) {
	if($("#idProvincia").val() != "" && $("#idProvincia").val() != null) {
		$("#codigoMunicipio").prop("disabled", false);
		$("#idMunicipio").rup_combo({	
			blank: "",
			source: source,	
			selected: value,
			sourceParam: {
				label: "dsO",
				value: "id"
			},
			change: function() {
				$("#codigoMunicipio").val($("#idMunicipio").rup_combo("getRupValue"));
				var source = "/ab59WebAppWar/nora/localidadesBusqueda?provinciaId=" + $("#idProvincia").val() + "&municipioId=" + $("#idMunicipio").val();
				cargarComboLocalidadesFiltro(source);
			},
			width: 250,
			onLoadSuccess: function() {
				$("#idMunicipio").rup_combo("clear");
			},
			rowStriping: true
		});
	} else {
		$("#codigoMunicipio").prop("disabled", true);
		$("#idMunicipio").rup_combo("destroy");
		var listMunicipios = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listMunicipios);	
		$("#idMunicipio").rup_combo({
			source: listMunicipios,	
			blank: "",
			disabled: true,
			rowStriping: true,
			width: 250
		});
	}
}

function cargarComboLocalidadesFiltro(source, value) {
	if($("#idMunicipio").val() != "" && $("#idMunicipio").val() != null) {
		$("#idLocalidad").rup_combo({
			blank: "",
			source: source,
			selected: value,
			sourceParam: {
				label: "dsO",
				value: "id"
			},
			width: 290,
			onLoadSuccess: function() {
				$("#idLocalidad").rup_combo("clear");
			},
			rowStriping: true
		});
	} else {
		$("#idLocalidad").rup_combo("destroy");
		var listLocalidades = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listLocalidades);	
		$("#idLocalidad").rup_combo({
			source: listLocalidades,	
			blank: "",
			disabled: true,
			rowStriping: true,
			width: 290
		});
	}
}