$(document).ready(function(){

	//Marcamos la opción del menú principal "Sanciones" y habilitamos
	$("#menuFichaSancion").addClass("active");
	
	inicializaControlCambios("pagosForm");

	desbloquearInterfaz();
	
	//Configuración de campos fecha
	$(".campoFecha").each(function(){
		$("#"+this.id).rup_date();
	});
	
	/**
	 * Si el valor de la variable es true, se mostrara el mensaje
	 */
	if($("#mostraMensajeExpedienteSancionadorValidoParaPago").val() == 'true'){
		$("#mensajeExpedienteListoPago_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true});
    	$("#mensajeExpedienteListoPago_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.pagos.mostraMensajeExpedienteSancionadorValidoParaPago, "alert");
	}
	
	
	if($("#identifiEstableci").val() !== ""){
		$("#btnAccesoCenso").show();
	} else {
		$("#btnAccesoCenso").hide();
	}
	
	var tipoPago = [
		{
            i18nCaption:  $.rup.i18n.app.fichaSancion.pagos.tipoPago.previoResolucion,
            value: PREVIO_RESOLUCION
        }, {
            i18nCaption: $.rup.i18n.app.fichaSancion.pagos.tipoPago.trasResolucion,
            value: TRAS_RESOLUCION
        }
    ];
	
	$("#tipoPago").rup_combo({
		source: tipoPago,
		blank: "",
		width: 250
	});	
	
	var comboSiNo = [
		{
            i18nCaption:  $.rup.i18n.app.generico.si,
            value: COMBO_SI
        }, {
            i18nCaption: $.rup.i18n.app.generico.no,
            value: COMBO_NO
        }
    ];
	$("#reconocimientoVoluntario").rup_combo({
		source: comboSiNo,
		blank: "",
		width: 250
	});
	
	$("#pagoVoluntario").rup_combo({
		source: comboSiNo,
		blank: "",
		width: 250
	});
	
	
	//Asignamos tanto el idSancion como el idPagoSan
	$("#pagos_idSancion").val($("#idSancion").val());
	$("#pagosForm").rup_form({
		feedback: $("#pagosForm_feedback"),
		url: CTX_PATH + "pagos",
		type: "PUT",
		contentType: "application/json",
		dataType:"json",
		validate:{ 
			liveCheckingErrors : false,
			showFieldErrorAsDefault : true,
			showErrorsInFeedback : false,
			showFieldErrorsInFeedback : true,
			rules:{
				"observacionesCastellano":{
					maxlength: 2000
				},
				"observacionesEuskera": {
					maxlength: 2000
				}
			}
		},
	    success: function(data){
	    	cargarDatosPago();
	    	
	    	  /**
		    	* Para mostrar el mensaje de si esta prest para la carta de pago
			    */
			   $.ajax({
					type: "GET",
					url: CTX_PATH + "sanciones/validarExpedienteSancionadorListoParaElPago/" + $("#idSancion").val(),
					contentType: "application/json",
					dataType: "json",
					success: function(data){
						desbloquearInterfaz();
						if(data !== null && data){
							$("#mensajeExpedienteListoPago_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true});
					    	$("#mensajeExpedienteListoPago_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.pagos.mostraMensajeExpedienteSancionadorValidoParaPago, "alert");
						}				
					},
					error: function(data){
						desbloquearInterfaz();
					}
				});
	    	
	    	$("#pagosForm_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true, delay:3000 });
	    	$("#pagosForm_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.pagos.modificarOk, "ok");
	    	desbloquearInterfaz();
	    },
	    error: function(){
	    	$("#pagosForm_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true, delay:3000 });
	    	$("#pagosForm_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.pagos.modificarError, "error");
	    	desbloquearInterfaz();
	    }
	});
	
	//Sumitar el formulario.
	$("#btnGuardarPagos").click(function(){			
		bloquearInterfaz();
		$("#pagosForm").submit();
		
		ab59a_isChanged = false;
		desbloquearInterfaz();
	});	
	
	//cargamos el expediente para el filtro de la tabla
	$("#expediente_filterForm").val($("#idExpediente").val());
	$("#tablaLiquidaciones").rup_datatable({
		primaryKey: "idLiquidacionPago",
		loadOnStartUp: true,
		pagingType: "full_numbers",
		dom: 't <"col-sm-3"l><"col-sm-7"p><"col-sm-2"i>',
		pageLength : 5,
		lengthMenu: [5, 10, 25],
		filter:{
  	  		id:"tablaLiquidaciones_filter_form",
  	  		filterToolbar:"tablaLiquidaciones_filter_toolbar",
  	  		collapsableLayerId:"tablaLiquidaciones_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 0
    	},
    	order: [[ 3, "DESC"]],
    	columnDefs: [
	    		{
	   		      targets: [0, 1],
	   		      orderable: false,
	   		      visible: false
	   		   },
	   		   {
    		      targets: [2],
    		      className: "text-left",
    		      render: function(data, type, row, meta){    
    		    	  var retorno = "";
    		    	  if(data != null && data == 1){
    		    		  retorno = $.rup.i18n.app.fichaSancion.pagos.tipoPago.previoResolucion;
    		    	  }else if(data != null && data == 2){
    		    		  retorno = $.rup.i18n.app.fichaSancion.pagos.tipoPago.trasResolucion;
    		    	  }
    		    	  return retorno;
    		      }
    		   },
    		   {
    		      targets: [3, 4, 5, 6, 7, 8],
    		      className: "text-center"
    		   }
    	],
    	initComplete:function() {	  
    		var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("tablaLiquidaciones_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
    	}
	});
	
	$('#tablaLiquidaciones tbody').on( 'click', 'tr', function () {
		$('#tablaLiquidaciones').DataTable().$('tr.selected').removeClass('selected');
	    $(this).addClass('selected');
	});
	
	
	
	$('#btnVerLiquidacion').on( 'click', function () {		
		if($('#tablaLiquidaciones').DataTable().rows(['.selected']).data().toArray().length > '0'){			
			var datosRow = $('#tablaLiquidaciones').DataTable().rows(['.selected']).data().toArray();
			
			var linkVerDocumento = document.createElement('a');
			linkVerDocumento.href = "/ab61WebAppWar/moduloContableCobros/verLiquidacion/"+datosRow[0].idLiquidacionPago;
			linkVerDocumento.target = "_blank";
			linkVerDocumento.click();
		}else{
			$("#tablaLiquidaciones_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true, delay:3000 });
			$("#tablaLiquidaciones_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}	
	});
	
	$('#btnVerCartaPago').on( 'click', function () {	
		if($('#tablaLiquidaciones').DataTable().rows(['.selected']).data().toArray().length > '0'){	
			var datosRow = $('#tablaLiquidaciones').DataTable().rows(['.selected']).data().toArray();
			
			$("#p12iOidsPago").val(datosRow[0].codigoPago);
			document.getElementById('p12FormOids').submit();
		}else{
			$("#tablaLiquidaciones_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true, delay:3000 });
			$("#tablaLiquidaciones_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	});
	
	//Para cargar los datos del pago
	cargarDatosPago();
});

function cargarDatosPago(){
	
	//Cargamos los datos del pago
	$.ajax({
		url: CTX_PATH + "pagos/maint/datos/" + $("#idSancion").val(),
		type: "GET",
		contentType: "application/json",
		dataType:"json",
		async: false,
		success: function(data){
			cargarDatos(data, "pagosForm");
		}
	});
	
}
