$(document).ready(function(){

	//Marcamos la opción del menú principal "Sanciones" y habilitamos
	$("#menuFichaSancion").addClass("active");
	$("#menuFichaSancion").removeClass("disabled");
	$("#menuFichaPropuestaSancion").hide();
	
	sessionStorage.removeItem("propuestaSancionCargada");
	
	var idSancion = $("#idSancion").val();
	 
	/* Al entrar desde tramitagune hay que guardar la Sanción en sesión */
	var sancionCargada = sessionStorage.getItem("sancionCargada");	
	if (sancionCargada == null)
	{
		sessionStorage.setItem("sancionCargada", idSancion);
	}
	
	var selector = '.ui-tabs-nav li a';

	$("#tabsFichaSancion").rup_tabs({
		tabs : [
			{i18nCaption:$.rup.i18n.app.tabs.propuestaSancion, url:"/ab59WebAppWar/propuestassancion/maint/"+idSancion},
			{i18nCaption:$.rup.i18n.app.tabs.expediente, url:"/ab59WebAppWar/expedientes/maint/"+idSancion},
			{i18nCaption:$.rup.i18n.app.tabs.datosSancion, url:"/ab59WebAppWar/sanciones/maint/"+idSancion},
			{i18nCaption:$.rup.i18n.app.tabs.controlFechas, url:"/ab59WebAppWar/controlfechas/maint/"+idSancion},
			{i18nCaption:$.rup.i18n.app.tabs.pagos, url:"/ab59WebAppWar/pagos/maint/"+idSancion}
		],
		select: function(event, tab){
			bloquearInterfaz();
			var pestania = $("#tabsFichaSancion").tabs('option', 'active');		
			var nombre = document.getElementsByClassName("ui-tabs-anchor")[pestania].innerHTML;
			if (controlCambios()) {	
				$.rup_messages("msgConfirm", {
					message: jQuery.jgrid.format(jQuery.rup.i18nParse(jQuery.rup.i18n.app, 'tabs.controlDeCambios'), nombre),
					title:  $.rup.i18n.app.tabs.controlDeCambiosTitulo,
					OKFunction: function () {	
						switch(pestania){
							case 1:
								$("#expedienteForm").submit();
								break;
							case 2:
								$("#datosSancionForm").submit();
								break;
							case 4:
								$("#pagosForm").submit();
								break;
						}
						ab59a_isChanged = false;
					},
					CANCELFunction: function () {
						ab59a_isChanged=false;
						switch(pestania){
							case 1:
								$("#ui-id-2").load("/ab59WebAppWar/expedientes/maint/"+idSancion);
								inicializaControlCambios("expedienteForm");
								break;
							case 2:
								$("#ui-id-3").load("/ab59WebAppWar/sanciones/maint/"+idSancion);
								inicializaControlCambios("datosSancionForm");
								break;
							case 4:
								$("#ui-id-5").load("/ab59WebAppWar/pagos/maint/"+idSancion);
								inicializaControlCambios("pagosForm");
								break;
						}
					}
				});	
			}
			
			
		},
		cache:false
	});
	$("#btnGuardarExpediente").hide();
	$("#btnGuardarDatosSancion").hide();
	$("#btnGuardarPagos").hide();
	$("#btnGuardarControlFechas").hide();
	$("#btnAccesoCenso").hide();
	
	$(selector).on('click', function(){
		   var tab = this.id;
		   
		   switch (tab){
		   
		   case "#" + $.rup.i18n.app.tabs.propuestaSancion :		
			   $("#btnGuardarExpediente").hide();
			   $("#btnGuardarDatosSancion").hide();
			   $("#btnGuardarPagos").hide();
			   $("#btnGuardarControlFechas").hide();
			   break;
			   
		   case "#" + $.rup.i18n.app.tabs.expediente :
			   $("#btnGuardarExpediente").show();
			   $("#btnGuardarDatosSancion").hide();
			   $("#btnGuardarPagos").hide();
			   $("#btnGuardarControlFechas").hide();
			   break;
			   
		   case "#" + $.rup.i18n.app.tabs.datosSancion :
			   $("#btnGuardarExpediente").hide();
			   $("#btnGuardarDatosSancion").show();
			   $("#btnGuardarPagos").hide();
			   $("#btnGuardarControlFechas").hide();
			   break;
			   
		   case "#" + $.rup.i18n.app.tabs.controlFechas :
			   $("#btnGuardarExpediente").hide();
			   $("#btnGuardarDatosSancion").hide();
			   $("#btnGuardarPagos").hide();
			   $("#btnGuardarControlFechas").show();
			   break;	   
			   
		   case "#" + $.rup.i18n.app.tabs.pagos :
			   $("#btnGuardarExpediente").hide();
			   $("#btnGuardarDatosSancion").hide();
			   $("#btnGuardarPagos").show();
			   $("#btnGuardarControlFechas").hide();
			   break;
		   }
		});
	
	$( function () {
        
		if ($("#propuestasAsociadas").val() > 0 && ($("#irAExpediente").val() === "true" || sessionStorage.getItem("irAExpediente") === "true")) {
        	$("#tabsFichaSancion").rup_tabs("selectTab",{
        		idTab: "tabsFichaSancion",
        		position: 1,
        	});
		    $("#btnGuardarExpediente").show();
		    $("#btnGuardarDatosSancion").hide();
		    $("#btnGuardarPagos").hide();
		    $("#btnGuardarControlFechas").hide();
        }
        	$("#irAExpediente").val(false);
        	sessionStorage.removeItem("irAExpediente")
    });	
});
