var valueComboMunicipio = "";
var valueComboLocalidad = "";

jQuery(function($) {

	var urlab61 = $('#urlab61').val();
	var ab61_folderID = $('#ab61_folderID').val();
	
	//Marcamos la opción del menú principal "Sanciones" y habilitamos
	$("#menuFichaSancion").addClass("active");
	
	inicializaControlCambios("expedienteForm");
		
	/**
	 * Si el valor de la variable es true, se mostrara el mensaje
	 */
	if($("#mostraMensajeExpedienteSancionadorValidoParaPago").val() == 'true'){
		$("#mensajeExpedienteListoPago_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true});
    	$("#mensajeExpedienteListoPago_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.pagos.mostraMensajeExpedienteSancionadorValidoParaPago, "alert");
	}
	
	$(".rup_accordion").rup_accordion({
		collapsible: true,
		heightStyle: "content",
		clearStyle:true
	});
	
	$("#accordionExample").rup_accordion ("activate", false);
	$("#divUbicacion").rup_accordion ("activate", false);
	
	if($("#parteInculpadaSinDatosAviso").val() === "true"){
		$("#id_capa").rup_feedback({ gotoTop : false, block : false, closeLink : true });
		$("#id_capa").rup_feedback("set", $.rup.i18n.app.mensajes.parteInculpadaSinDatosAviso, "alert");
	}
	
	
	$.ajax({
		type: "GET",
		url: CTX_PATH + "sanciones/findExpedientesPartesInculpadas/" + $("#idExpediente").val(),
		contentType: "application/json",
		dataType: 'json',
		async:false,
		success: function(data){
			desbloquearInterfaz();
			if(typeof data !== "undefined" && data !== null && data !== ""){
				var listaExpedientes = "<ul id='listaExpedientes'>" + $.rup.i18n.app.mensajes.expedientesParteInculpada;
				for (var i = 0; i < data.length; i++) {
					listaExpedientes += "<li><b><a href='/ab59WebAppWar/fichasancion/maint/" + data[i].idSancion + "' target='_blank'>" + data[i].expediente.folderNumber + ":</a></b> " + data[i].expediente.titulo + " (" + data[i].expediente.fechaExpediente + ")</li>"
				}
				listaExpedientes += "</ul>"
				$("#feedbackPartesInculpadas").rup_feedback({ gotoTop : false, block : false, closeLink : true });
				$("#feedbackPartesInculpadas").rup_feedback("set",listaExpedientes, "alert");
			}			
		},
		error: function(){
			$("#feedbackPartesInculpadas").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#feedbackPartesInculpadas").rup_feedback("set", $.rup.i18n.app.feedback.error.errorGenerico, "error");
		}
	});
	
	$("#listaExpedientes li a").click(function() {
		sessionStorage.setItem("irAExpediente", true);
	});
	
	// Creamos el área de mensajes para la ficha de expedientes en general
	$("#expedienteForm_feedback").rup_feedback({
		closeLink : true,
		block : false,
		gotoTop : false
	});
	
	if ("true" != $("#flagSearchFolder").val()) {
		$("#expedienteForm_feedback").rup_feedback("set",$.rup.i18n.app.mensajes.error.searchFolder_error,"error");
	}else{
		$("#accordionExample").rup_accordion("activate", 0);
	}
	
	if($("#numeroRegistroUbicacion").val() !== ""){
		$("#identifiEstableci").val($("#numeroRegistroUbicacion").val());
		$("#btnAccesoCenso").show();
	} else {
		$("#identifiEstableci").val("");
		$("#btnAccesoCenso").hide();
	}
	
	$(".comboDinamico").each(function(){
		var id = $(this).attr("id");
		var selectValue = $(this).prev(":hidden").val();
		$("#" + id).rup_combo({
			source: "/ab59WebAppWar/subtipotercero/cargarCombo",
			blank: "-1",
			sourceParam: {
				label: ("es"===$.rup_utils.get("language")) ? "descripcionCastellano" : "descripcionEuskera",
				value: "idSubtipoTercero"
			},
			width: 260,
			rowStriping: true,
			onLoadSuccess: function() {
				$("#" + id).rup_combo("setRupValue", selectValue);
			}
		});
	});
	// DIRECCIÓN POSTAL
	$(".divDireccionPostal").each(function() {
		var idDivDireccionPostal = $(this).attr("id");
		var identificador = idDivDireccionPostal.split("_")[1];
		$("#btnDireccionPostal_"+identificador).css("margin-top", "12em");
		
		if($("#otroPais_"+identificador).is(':checked')){
			var selectValuePais = $("#idPaisDireccionPostal_"+identificador).prev(":hidden").val();
			$("#idPaisDireccionPostal_"+identificador).rup_combo({
				source: "/ab59WebAppWar/nora/paises",
				blank: "",
				sourceParam: {
					label: "dsO",
					value: "id"
				},
				selected: selectValuePais,
				onLoadSuccess : function() {
					$("#idPaisDireccionPostal_"+identificador).rup_combo("disable");
				},
				width: 250
			});
		} else {
			$("#idProvinciaDireccionPostal_"+identificador).rup_combo({
				source: "/ab59WebAppWar/nora/provincias",
				blank: "",
				sourceParam: {
					label: "dsO",
					value: "id"
				},
				onLoadSuccess : function() {
					$("#idProvinciaDireccionPostal_"+identificador).rup_combo("setRupValue", pad($("#codigoProvinciaDireccionPostal_"+identificador).val(),2));
					$("#idProvinciaDireccionPostal_"+identificador).rup_combo("disable");
				},
				width: 250
			});		
			
			$("#idMunicipioDireccionPostal_"+identificador).rup_combo({
				source: "/ab59WebAppWar/nora/municipios",
				parent: ["idProvinciaDireccionPostal_"+identificador],
				blank: "",
				sourceParam: {
					label: "dsO",
					value: "id"
				},
				onLoadSuccess : function() {
					$("#idMunicipioDireccionPostal_"+identificador).rup_combo("setRupValue", pad($("#codigoMunicipioDireccionPostal_"+identificador).val(),3));
					$("#codigoMunicipioDireccionPostal_"+identificador).val($("#idMunicipioDireccionPostal_"+identificador).rup_combo("getRupValue"));
					$("#idMunicipioDireccionPostal_"+identificador).rup_combo("disable");
					
				},
				width: 250
			});
			
			var selectValueLocalidad = $("#idLocalidadDireccionPostal_"+identificador).prev(":hidden").val();
			$("#idLocalidadDireccionPostal_"+identificador).rup_combo({
				source: "/ab59WebAppWar/nora/localidades",
				parent: ["idProvinciaDireccionPostal_"+identificador, "idMunicipioDireccionPostal_"+identificador],
				blank: "",
				sourceParam: {
					label: "dsO",
					value: "id"
				},
				selected: selectValueLocalidad,
				onLoadSuccess : function() {
					$("#idLocalidadDireccionPostal_"+identificador).rup_combo("disable");
				},
				width: 290
			});
		}
		
	});
	
	$('#relExpDir_detail_button_save').on( 'click', function () {
		$("#relExpDir_detail_form").submit();	
	});
	
	$('#relExpDir_detail_button_cancel').on( 'click', function () {
		hayCambios();
	});

	$("#relExpDir").rup_datatable({
			
			primaryKey: "idRelExpDir",
			loadOnStartUp: true,
			pagingType: "full_numbers",
			dom: 't <"col-sm-3"l><"col-sm-6"p><"col-sm-3"i>',
			pageLength : 10,
			lengthMenu: [10, 25, 50],
			filter:{
	  	  		id:"relExpDir_filter_form",
	  	  		filterToolbar:"relExpDir_filter_toolbar",
	  	  		collapsableLayerId:"relExpDir_filter_fieldset"
	     	},
	     	colReorder: {
				fixedColumnsLeft: 1
	    	},
	    	order: [ 3, "asc" ],
	    	columnDefs: [
	    		   {
	    		      targets: [0,1,2],
	    		      orderable: false,
	    		      visible: false
	    		   }	    		  
	    	],
	    	
	    	initComplete:function() {
				
				  var spanM = document.createElement("span");
				  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
				  spanM.appendChild(mostrando);  
				  spanM.className = "mostrando";
				  var spanR = document.createElement("span"); 
				  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
				  spanR.appendChild(registros);
				  spanR.className = "registros";
				  
				  var longitudTabla = document.getElementById("relExpDir_length"); 
				  longitudTabla.appendChild(spanM); 
				  longitudTabla.appendChild(spanR);			  
	    	}
		});
	
	
	$('#relExpDir tbody').on( 'click', 'tr', function () {
		$('#relExpDir').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });
	
	$('#relExpDir tbody').on('dblclick', 'tr', function () {
		if($("#relExpDir_filter_table").val() != "0"){
			$("#btnVerUbicacionActividad").trigger("click");
		}
	});
	
	$('#relExpDir tbody').on('click', 'tr', function () {
		
		var datosRow = $('#relExpDir').DataTable().rows(['.selected']).data().toArray();
		var identificadorEstablecimiento = datosRow[0].datosDirecciones.identificadorEstablecimiento;
		if (identificadorEstablecimiento!=null && identificadorEstablecimiento != ""){
			$("#btnAccesoCenso").show();
		} else {
			$("#btnAccesoCenso").hide();
		}
			
		
	});
	
	$('#btnAccesoCenso').on( 'click', function () {	
		
		if($('#relExpDir').DataTable().rows(['.selected']).data().toArray().length > '0'){
			var datosRow = $('#relExpDir').DataTable().rows(['.selected']).data().toArray();
			var identificadorEstablecimiento = datosRow[0].datosDirecciones.identificadorEstablecimiento;
			if (identificadorEstablecimiento!=null && identificadorEstablecimiento != ""){
				var urlAb63 = $("#urlab63").val() + "establecimientos/maint/" + identificadorEstablecimiento;
				window.open(urlAb63, "_blank");
			}else{
				$("#relExpDir_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
				$("#relExpDir_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
			}
			
		}else{
			$("#relExpDir_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#relExpDir_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
		
	});
	
	$('#btnVerUbicacionActividad').on( 'click', function () {
		
		if ($("#expedienteForm_feedback.rup-feedback").length > 0)
		{
			$("#expedienteForm_feedback").rup_feedback("close");
		}
		if ($("#relExpDir_feedback.rup-feedback").length > 0)
		{
			$("#relExpDir_feedback").rup_feedback("close");
		}
		if ($("#relExpDir_detail_feedback.rup-feedback").length > 0)
		{
			$("#relExpDir_detail_feedback").rup_feedback("close");
		}		
		
		$("#relExpDir_detail_form").rup_form({
			feedback: $("#relExpDir_feedback"),
			url: CTX_PATH + "datosDirecciones",
			type: "PUT",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"datosDirecciones.establecimiento":{
						maxlength: 260
					},
					"datosDireciones.direccion":{
						maxlength: 100
					},
					"datosDireciones.numero":{
						maxlength: 60
					},
					"datosDireciones.escalera":{
						maxlength: 5
					},
					"datosDireciones.piso":{
						maxlength: 20
					},
					"datosDireciones.letra":{
						maxlength: 20
					},
					"datosDireciones.codigoPostal":{
						maxlength: 20
					},
					"datosDirecciones.provincia.id":{
						required: true
					},
					"datosDirecciones.municipio.id":{
						required: true
					},
					"datosDirecciones.identificadorEstablecimientoUno":{
						maxlength: 1
					},
					"datosDirecciones.identificadorEstablecimientoDos":{
						maxlength: 2
					},
					"datosDirecciones.identificadorEstablecimientoTres":{
						maxlength: 5,
						number: true
					}
				}
			},
		    success: function(){
		    	
			   $("#relExpDir_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#relExpDir_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.ubicacionSanciones.modificarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
		    	
			   $("#relExpDir_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#relExpDir_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.ubicacionSanciones.modificarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#relExpDir_detail_form")[0].reset();
		
		if($('#relExpDir').DataTable().rows(['.selected']).data().toArray().length > '0'){
			
			var datosRow = $('#relExpDir').DataTable().rows(['.selected']).data().toArray();
			$("#idExpediente_detail_table").val( datosRow[0].idExpediente);			
			$("#idDireccionExp_detail_table").val( datosRow[0].idRelExpDir);
			$("#idRelExpDir_detail_table").val( datosRow[0].idRelExpDir);			
			$("#idDireccion_detail_table").val( datosRow[0].datosDirecciones.idDireccion);
			$("#idEstablecimiento_detail_table").val(datosRow[0].datosDirecciones.establecimiento);
			$("#identificadorEstablecimiento_detail_table").val(datosRow[0].datosDirecciones.identificadorEstablecimiento);
			$("#idProvinciaExpedienteUbicacion").val(datosRow[0].datosDirecciones.provincia.id);
			$("#idMunicipioExpedienteUbicacion").val(datosRow[0].datosDirecciones.municipio.id);
			$("#idLocalidadExpedienteHidden").val(datosRow[0].datosDirecciones.localidad.id);			
			$("#direccion_detail_table").val(datosRow[0].datosDirecciones.direccion);
			$("#portal_detail_table").val(datosRow[0].datosDirecciones.numero);
			$("#idEscalera_detail_table").val(datosRow[0].datosDirecciones.escalera);
			$("#idPiso_detail_table").val(datosRow[0].datosDirecciones.piso);
			$("#idLetra_detail_table").val(datosRow[0].datosDirecciones.letra);
			$("#idCodigoPostal_detail_table").val(datosRow[0].datosDirecciones.codigoPostal);
			$("#idIdentificadorEstablecimientoUno_detail_table").val(datosRow[0].datosDirecciones.identificadorEstablecimientoUno);
			$("#idIdentificadorEstablecimientoDos_detail_table").val(datosRow[0].datosDirecciones.identificadorEstablecimientoDos);
			$("#idIdentificadorEstablecimientoTres_detail_table").val(datosRow[0].datosDirecciones.identificadorEstablecimientoTres);
			
			abrirModal();
			
			/* COMBOS de NORA */
			$("#idProvinciaExpediente_detail_table").rup_combo({
				source: "/ab59WebAppWar/nora/provincias",
				blank: "0",
				sourceParam: {
					label: "dsO",
					value: "id"
				},
				onLoadSuccess : function() {
					var idProvinciaHidden = pad($("#idProvinciaExpedienteUbicacion").val(),2);
					$("#idProvinciaExpediente_detail_table").rup_combo("setRupValue", idProvinciaHidden);
					$("#idProvinciaExpedienteUbicacion").val(($("#idProvinciaExpediente_detail_table").rup_combo("getRupValue") == "0") ? "" : $("#idProvinciaExpediente_detail_table").rup_combo("getRupValue"));
					var source = "/ab59WebAppWar/nora/municipiosBusqueda?provinciaId=" + $("#idProvinciaExpediente_detail_table").val();
					cargarComboMunicipiosFiltro(source, datosRow[0].datosDirecciones.municipio.id, datosRow[0].datosDirecciones.localidad.id);
				},
				select : function() {
					$("#idProvinciaExpedienteUbicacion").val(($("#idProvinciaExpediente_detail_table").rup_combo("getRupValue") == "0") ? "" : $("#idProvinciaExpediente_detail_table").rup_combo("getRupValue"));
					
				},
				change: function() {
					$("#idProvinciaExpedienteUbicacion").val(($("#idProvinciaExpediente_detail_table").rup_combo("getRupValue") == "0") ? "" : $("#idProvinciaExpediente_detail_table").rup_combo("getRupValue"));
					$("#idMunicipioExpediente_detail_table").rup_combo("setRupValue", "");
					$("#idMunicipioExpedienteUbicacion").val("");
					$("#idLocalidadExpediente_detail_table").rup_combo("setRupValue", "");
					$("#idLocalidadExpedienteHidden").val("");
					var source = "/ab59WebAppWar/nora/municipiosBusqueda?provinciaId=" + $("#idProvinciaExpediente_detail_table").val();
					if(valueComboMunicipio !== "" && valueComboLocalidad !== ""){
						cargarComboMunicipiosFiltro(source, valueComboMunicipio, valueComboLocalidad);
					} else if(valueComboMunicipio !== ""){
						cargarComboMunicipiosFiltro(source, valueComboMunicipio);
					} else {
						cargarComboMunicipiosFiltro(source);
					}										
				},
				open: function(){
					$("#idProvinciaExpediente-menu").width(
						$("#idProvinciaExpediente-button").width()
					);
				},
				rowStriping: true,
				width: 280
			});			
			
		}else{
				$("#relExpDir_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
				$("#relExpDir_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
			
		}
	});
	
	
	$("#btnAddUbicacionActividad").click(function(){
		
		if ($("#expedienteForm_feedback.rup-feedback").length > 0)
		{
			$("#expedienteForm_feedback").rup_feedback("close");
		}
		if ($("#relExpDir_feedback.rup-feedback").length > 0)
		{
			$("#relExpDir_feedback").rup_feedback("close");
		}
		if ($("#relExpDir_detail_feedback.rup-feedback").length > 0)
		{
			$("#relExpDir_detail_feedback").rup_feedback("close");
		}		
		
		$("#relExpDir_detail_form")[0].reset();
		
		$("#relExpDir_detail_form").rup_form({
			feedback: $("#relExpDir_feedback"),
			url: CTX_PATH + "datosDirecciones",
			type: "PUT",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"datosDirecciones.establecimiento":{
						maxlength: 260
					},
					"datosDireciones.direccion":{
						maxlength: 100
					},
					"datosDireciones.numero":{
						maxlength: 60
					},
					"datosDirecciones.escalera":{
						maxlength: 5
					},
					"datosDireciones.piso":{
						maxlength: 20
					},
					"datosDireciones.letra":{
						maxlength: 20
					},
					"datosDireciones.codigoPostal":{
						maxlength: 20
					},
					"datosDirecciones.provincia.id":{
						required: true
					},
					"datosDirecciones.municipio.id":{
						required: true
					}
					
				}
			},
		    success: function(){
		    	
			   $("#relExpDir_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#relExpDir_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.ubicacionSanciones.modificarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
		    	
			   $("#relExpDir_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#relExpDir_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.ubicacionSanciones.modificarError, "error");
			   cerrarModal();
		    }
		});
		
			$("#relExpDir_detail_form").rup_validate("resetForm");
			
			abrirModal();
			
			/* COMBOS de NORA */
			$("#idProvinciaExpediente_detail_table").rup_combo({
				source: "/ab59WebAppWar/nora/provincias",
				blank: "",
				sourceParam: {
					label: "dsO",
					value: "id"
				},
				onLoadSuccess : function() {
					$("#idProvinciaExpediente_detail_table").rup_combo("select", 0);
					$("#idProvinciaExpedienteUbicacion").val(($("#idProvinciaExpediente_detail_table").rup_combo("getRupValue") == "0") ? "" : $("#idProvinciaExpediente_detail_table").rup_combo("getRupValue"));
					var source = "/ab59WebAppWar/nora/municipiosBusqueda?provinciaId=" + $("#idProvinciaExpediente_detail_table").val();
					cargarComboMunicipiosFiltro(source);
					
				},
				select : function() {
					$("#idProvinciaExpedienteUbicacion").val(($("#idProvinciaExpediente_detail_table").rup_combo("getRupValue") == "0") ? "" : $("#idProvinciaExpediente_detail_table").rup_combo("getRupValue"));
					
				},
				change: function() {
					$("#idProvinciaExpedienteUbicacion").val(($("#idProvinciaExpediente_detail_table").rup_combo("getRupValue") == "0") ? "" : $("#idProvinciaExpediente_detail_table").rup_combo("getRupValue"));
					$("#idMunicipioExpediente_detail_table").rup_combo("setRupValue", "");
					$("#idMunicipioExpedienteUbicacion").val("");
					$("#idLocalidadExpediente_detail_table").rup_combo("setRupValue", "");
					$("#idLocalidadExpedienteHidden").val("");
					var source = "/ab59WebAppWar/nora/municipiosBusqueda?provinciaId=" + $("#idProvinciaExpediente_detail_table").val();
					if(valueComboMunicipio !== "" && valueComboLocalidad !== ""){
						cargarComboMunicipiosFiltro(source, valueComboMunicipio, valueComboLocalidad);
					} else if(valueComboMunicipio !== ""){
						cargarComboMunicipiosFiltro(source, valueComboMunicipio);
					} else {
						cargarComboMunicipiosFiltro(source);
					}
					
				},
				open: function(){
					$("#idProvinciaExpediente-menu").width(
						$("#idProvinciaExpediente-button").width()
					);
				},
				rowStriping: true,
				width: 280
			});
			
			$("#idMunicipioExpediente_detail_table").rup_combo("destroy");
			var listMunicipios = new Array();				
			//Transformo en JSON la lista
			$.toJSON(listMunicipios);	
			$("#idMunicipioExpediente_detail_table").rup_combo({
				source: listMunicipios,	
				blank: "",
				disabled: true,
				rowStriping: true,
				width: 280
			});
			
			$("#idLocalidadExpediente_detail_table").rup_combo("destroy");
			var listLocalidades = new Array();				
			//Transformo en JSON la lista
			$.toJSON(listLocalidades);	
			$("#idLocalidadExpediente_detail_table").rup_combo({
				source: listLocalidades,	
				blank: "",
				disabled: true,
				rowStriping: true,
				width: 290
			});
		
	});
	
	
	$("#btnRemoveUbicacionActividad").click(function(){
		if ($("#expedienteForm_feedback.rup-feedback").length > 0)
		{
			$("#expedienteForm_feedback").rup_feedback("close");
		}	
		
		if ($("#relExpDir_feedback.rup-feedback").length > 0)
		{
			$("#relExpDir_feedback").rup_feedback("close");
		}	
		
		
		if($('#relExpDir').DataTable().rows(['.selected']).data().toArray().length > '0'){
			var datosRow = $('#relExpDir').DataTable().rows(['.selected']).data().toArray(); 	
			
			$.ajax({
				type : "DELETE",
				url : CTX_PATH + "relexpdir/eliminar/" + datosRow[0].idRelExpDir + "/" + datosRow[0].datosDirecciones.idDireccion,
				dataType : "json",
				async : false,
				success : function(data) {	
					$('#relExpDir').DataTable().ajax.reload();
					$("#relExpDir_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#relExpDir_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.ubicacionSanciones.borradoOK, "ok");
				},
				error: function(){
					$("#relExpDir_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#relExpDir_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.ubicacionSanciones.borradoError, "error");
				}
			});
		}
		else
		{
			$("#relExpDir_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#relExpDir_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	});
	
	
	$(".botonParticipante").click(function() {		
		var tipo = "";
		var tipoAux = $(this).prop('id');
		// Split string by whitespace character
		var splitString = tipoAux.split("-");
		//hidden para saber si recargar la pagina al cerrar las modales de la ab61 o no
		$("#recargarPagina").val(0);
		if (tipoAux.substring(0, 7) == "TITULAR") {
			tipo = "TITULAR";
			$("#recargarPagina").val(0);
		} else {
			if (tipoAux.substring(0, 13) == "REPRESENTANTE") {
				tipo = "REPRESENTANTE";
				$("#recargarPagina").val(0);
			} else {
				if (tipoAux.substring(0, 6) == "RLEGAL") {
					tipo = "REPRESENTANTELEGAL";
					$("#recargarPagina").val(1);
				}else if(tipoAux.substring(0, 16) == "PERSONASCONTACTO"){
						tipo = "PERSONASCONTACTO";
						$("#recargarPagina").val(1);
				
				}else{
					if (tipoAux.substring(0, 4) == "OTRO") {
						tipo = "OTRO";
						$("#recargarPagina").val(1);
					}
				}
			}
		}
		var url="";
		var idTercero = $(this).val();
		if(splitString.length == 1){
			splitString.push("0");
			url = urlab61 + "datosterceros/"+$('#idExpediente').val()+ "/" + idTercero + "/" + ab61_folderID + "/" +tipo+"/"+splitString[1];
		}else{
			url = urlab61 + "datosterceros/"+$('#idExpediente').val()+"/"+ idTercero + "/" + ab61_folderID + "/" + splitString[0]+"/"+splitString[1];
		}
		
		$('#modalFrame').attr('src', url);
	});
	
	//bloquear modal hasta que carga los datos de platea y limpiar formulario
	$('#myModal').on('show.bs.modal', function () {
		 bloquearInterfaz();
	});
	
	//desbloquear interfaz cuando termina de cargarse el iframe
	$('#modalFrame').load(function(){
		//limpiar el iframe
		$(".close").on("click",function(){	
			if (1 != $("#recargarPagina").val()) {
				bloquearInterfaz();
				desbloquearInterfaz();
				var frame = document.getElementById("modalFrame");		 
				var frameDoc = frame.contentDocument || frame.contentWindow.document;
				frameDoc.removeChild(frameDoc.documentElement);
			}else{
				bloquearInterfaz();
				accederMenu('relexpter');
			}
		});
		desbloquearInterfaz();
	});
	
	$("#expedienteForm").rup_form({
		feedback: $("#expedienteForm_feedback"),
		url: CTX_PATH + "expedientes/" + $("#idSancion").val(),
		type: "PUT",
		contentType: "application/json",
		dataType:"json",
		validate:{ 
			liveCheckingErrors : false,
			showFieldErrorAsDefault : true,
			showErrorsInFeedback : false,
			showFieldErrorsInFeedback : true,
			rules:{
				"establecimiento":{
					maxlength: 260
				},
				"numeroRegistroUbicacion":{
					maxlength: 20
				},
				"direccion":{
					maxlength: 100
				},
				"numero":{
					maxlength: 60
				},
				"escalera":{
					maxlength: 5
				},
				"piso":{
					maxlength: 20
				},
				"letra":{
					maxlength: 20
				},
				"codigoPostal":{
					maxlength: 20
				}
			}
		},
	    success: function(){
	    	if($("#numeroRegistroUbicacion").val() !== ""){
	    		$("#identifiEstableci").val($("#numeroRegistroUbicacion").val());
	    		$("#btnAccesoCenso").show();
	    	} else {
	    		$("#identifiEstableci").val("");
	    		$("#btnAccesoCenso").hide();
	    	}
		   $("#expedienteForm_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
		   $("#expedienteForm_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.expedientes.modificarOk, "ok");
		   
		   /**
		    * Para mostrar el mensaje de si esta prest para la carta de pago
		    */
		   $.ajax({
				type: "GET",
				url: CTX_PATH + "sanciones/validarExpedienteSancionadorListoParaElPago/" + $("#idSancion").val(),
				contentType: "application/json",
				dataType: "json",
				success: function(data){
					
					desbloquearInterfaz();
					if(data !== null && data){
						$("#mensajeExpedienteListoPago_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true});
				    	$("#mensajeExpedienteListoPago_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.pagos.mostraMensajeExpedienteSancionadorValidoParaPago, "alert");
					}				
				},
				error: function(data){
					desbloquearInterfaz();
				}
			});
		   
		   desbloquearInterfaz();
	    },
	    error: function(){
		   $("#expedienteForm_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
		   $("#expedienteForm_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.expedientes.modificarError, "error");
		   desbloquearInterfaz();
	    }
	});
	
	//Sumitar el formulario.
	$("#btnGuardarExpediente").click(function(){			
		bloquearInterfaz();
		$("#expedienteForm").submit();
		
		ab59a_isChanged = false;
		desbloquearInterfaz();
	});	
	
	//Botón buscar establecimiento (lupa modal ubicaciones)
	$("#btnBuscarEstablecimiento").click(function() {
		montarIdentificadorEstablecimiento();
		if($("#identifiEstableci").val() !== "" && $("#identifiEstableci").val().length === 8){
			$.ajax({
				type: "GET",
				url: CTX_PATH + "datosDirecciones/buscarEstablecimiento/" + $("#identifiEstableci").val(),
				contentType: "application/json",
				dataType: "json",
				success: function(data){
					desbloquearInterfaz();
					if(data !== null){
						
						if ($("#relExpDir_detail_feedback.rup-feedback").length > 0)
						{
							$("#relExpDir_detail_feedback").rup_feedback("close");
						}
						$("#idProvinciaExpediente_detail_table").rup_combo("clear");
						$("#idMunicipioExpediente_detail_table").rup_combo("clear");
						$("#idLocalidadExpediente_detail_table").rup_combo("clear");
						if(data.municipio.id !== null){
							valueComboMunicipio = data.municipio.id;
						}
						if(data.localidad.id !== null){
							valueComboLocalidad = data.localidad.id;
						}
						if(data.provincia.id !== null){
							
							$("#idProvinciaExpedienteUbicacion").val(pad(data.provincia.id, 2));
							$("#idProvinciaExpediente_detail_table").rup_combo("setRupValue", pad(data.provincia.id, 2));
						}
						$("#idEstablecimiento_detail_table").val(data.establecimiento);
						$("#direccion_detail_table").val(data.direccion);
						$("#portal_detail_table").val(data.numero);
						$("#idEscalera_detail_table").val(data.escalera);
						$("#idPiso_detail_table").val(data.piso);
						$("#idLetra_detail_table").val(data.letra);
						$("#idCodigoPostal_detail_table").val(data.codigoPostal);
						valueComboMunicipio = "";
						valueComboLocalidad = "";
					} else {
						$("#relExpDir_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
						$("#relExpDir_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.ubicacionSanciones.buscarEstablecimientoVacio, "alert");
					}					
				},
				error: function(data){
					desbloquearInterfaz();
					$("#relExpDir_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
					$("#relExpDir_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.ubicacionSanciones.buscarEstablecimientoError, "error");
				}
			});
		} else {
			$("#relExpDir_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
		    $("#relExpDir_detail_feedback").rup_feedback("set", $.rup.i18n.app.tablasMaestras.ubicacionSanciones.numeroRegistroVacio, "alert");
		}
	});
	
	$("#idIdentificadorEstablecimientoUno_detail_table").keyup(function(e) {
		var code = (e.keyCode ? e.keyCode : e.which);
		if(code !== 9 && code !== 16){
			$("#idIdentificadorEstablecimientoUno_detail_table").val($("#idIdentificadorEstablecimientoUno_detail_table").val().toUpperCase());
			if($("#idIdentificadorEstablecimientoUno_detail_table").val().length == 1){
				$("#idIdentificadorEstablecimientoDos_detail_table").focus();
			}
		}
	});
	
	$("#idIdentificadorEstablecimientoDos_detail_table").keyup(function(e) {
		var code = (e.keyCode ? e.keyCode : e.which);
		if(code !== 9 && code !== 16){
			$("#idIdentificadorEstablecimientoDos_detail_table").val($("#idIdentificadorEstablecimientoDos_detail_table").val().toUpperCase());
			if($("#idIdentificadorEstablecimientoDos_detail_table").val().length == 2){
				$("#idIdentificadorEstablecimientoTres_detail_table").focus();
			}
		}
	});
	
	$("#idIdentificadorEstablecimientoTres_detail_table").focusout(function() {
		if($("#idIdentificadorEstablecimientoTres_detail_table").val() !== ""){
			$("#idIdentificadorEstablecimientoTres_detail_table").val(pad($("#idIdentificadorEstablecimientoTres_detail_table").val(), 5));
		}
	});
	
	desbloquearInterfaz();
	
	
	$.ajax({
		type: "GET",
		url: CTX_PATH + "propuestassancion/findPropuestasPendientesMismoTitularBySancion/" + $("#idSancion").val(),
		contentType: "application/json",
		dataType: 'json',
		success: function(data){
			if(typeof data !== "undefined" && data !== null && data !== ""){
				
				var listaPropuestasSanciones = "<ul id='listaPropuestasSanciones'>" + $.rup.i18n.app.propuestasSancion.existenPropuestasParaMismoAfectado +": ";
				for (var i = 0; i < data.length; i++) {
					listaPropuestasSanciones += "<li><b>"+ data[i].identificadorProSan +":</b> " + data[i].expedienteOrigen.folderNumber + ". " + data[i].expedienteOrigen.titulo + ". "+data[i].estadoProSan.descripcionDecorator+". </li>"
				}
				listaPropuestasSanciones += "</ul>"
				$("#id_capa_Propuestas_Sancion").rup_feedback({ gotoTop : false, block : false, closeLink : true });
				$("#id_capa_Propuestas_Sancion").rup_feedback("set",listaPropuestasSanciones, "alert");
			}
		},
		error: function(){
			desbloquearInterfaz();
			$("#id_capa_Propuestas_Sancion").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#id_capa_Propuestas_Sancion").rup_feedback("set", $.rup.i18n.app.feedback.error.errorGenerico, "error");
		}
	});
});

function montarIdentificadorEstablecimiento()
{
	$("#numeroRegistroUbicacion").val($("#idIdentificadorEstablecimientoUno_detail_table").val()+$("#idIdentificadorEstablecimientoDos_detail_table").val()+$("#idIdentificadorEstablecimientoTres_detail_table").val());
	$("#identifiEstableci").val($("#idIdentificadorEstablecimientoUno_detail_table").val()+$("#idIdentificadorEstablecimientoDos_detail_table").val()+$("#idIdentificadorEstablecimientoTres_detail_table").val());
}

function abrirModal()
{
	$("#relExpDir_detail_div").rup_dialog({
		autoOpen: true,
		width: 1100,
		modal: true,
		position: { my: "center center" },
		type: $.rup.dialog.DIV,
		title: $.rup.i18n.app.fichaSancion.expedientes.editarUbicacion,
		close:function(){
		$("#relExpDir_detail_div").rup_dialog("destroy");
		}
	});
}


function cerrarModal()
{
	$('#relExpDir').DataTable().ajax.reload();			   
	//$("#relExpDir_detail_div").rup_dialog("close"); 
	$("#relExpDir_detail_div").rup_dialog("destroy");
	$("#idProvinciaExpedienteUbicacion").val("");
	$("#idMunicipioExpedienteUbicacion").val("");
	$("#idLocalidadExpedienteHidden").val("");
	$("#idLocalidadExpediente_detail_table").rup_combo("clear");
	$("#idMunicipioExpediente_detail_table").rup_combo("clear");
	$("#idProvinciaExpediente_detail_table").rup_combo("clear");
	
}

function hayCambios()
{
	if (controlCambios()) {
		$.rup_messages("msgConfirm", {
			message: $.rup.i18n.app.controlCambios.mensaje,
			title:  $.rup.i18n.app.controlCambios.titulo,
			OKFunction: function () {	
				
				$("#relExpDir_detail_form").submit();
				
			},
			CANCELFunction: function () {
				cerrarModal();   
			}
		});	
	}	
	else
	{
		cerrarModal();
	}
}

function fncCollapseDireccionPostal(identificador)
{
	if ($("#panelDireccionPostal_"+identificador).hasClass("activo"))
	{
		$("#btnDireccionPostal_"+identificador).removeClass("ui-accordion-header-active");
		$("#btnDireccionPostal_"+identificador).addClass("ui-accordion-header-collapsed ui-corner-all ui-state-default");
		$("#panelDireccionPostal_"+identificador).removeClass("activo");
		$("#panelDireccionPostal_"+identificador).addClass("noActivo");
		
	}
	else
	{
		$("#btnDireccionPostal_"+identificador).removeClass("ui-accordion-header-collapsed ui-corner-all ui-state-default");
		$("#btnDireccionPostal_"+identificador).addClass("ui-accordion-header-active");
		$("#panelDireccionPostal_"+identificador).removeClass("noActivo");
		$("#panelDireccionPostal_"+identificador).addClass("activo");
	}
}

function buscarComboProvinciaUbicacion(){
	$("#idProvinciaExpediente_detail_table").rup_combo("setRupValue", pad($("#idProvinciaExpedienteUbicacion").val(), 2));
}

function buscarComboMunicipioUbicacion(){
	$("#idMunicipioExpediente_detail_table").rup_combo("setRupValue", pad($("#idMunicipioExpedienteUbicacion").val(), 3));
}

function cargarComboMunicipiosFiltro(source, valueMunicipio, valueLocalidad) {
	if($("#idProvinciaExpediente_detail_table").val() != "" && $("#idProvinciaExpediente_detail_table").val() != null) {
		$("#idMunicipioExpedienteUbicacion").prop("disabled", false);
		$("#idMunicipioExpediente_detail_table").rup_combo({
			blank: "0",
			source: source,
			selected: pad(valueMunicipio, 3),
			sourceParam: {
				label: "dsO",
				value: "id"
			},
			onLoadSuccess : function() {
				$("#idMunicipioExpedienteUbicacion").val(($("#idMunicipioExpediente_detail_table").rup_combo("getRupValue") == "0") ? "" : $("#idMunicipioExpediente_detail_table").rup_combo("getRupValue"));		
				var source = "/ab59WebAppWar/nora/localidadesBusqueda?provinciaId=" + $("#idProvinciaExpediente_detail_table").val() + "&municipioId=" + $("#idMunicipioExpediente_detail_table").val();
				cargarComboLocalidadesFiltro(source, valueLocalidad);
			},
			select : function() {
				$("#idMunicipioExpedienteUbicacion").val(($("#idMunicipioExpediente_detail_table").rup_combo("getRupValue") == "0") ? "" : $("#idMunicipioExpediente_detail_table").rup_combo("getRupValue"));
			},
			change: function() {
				$("#idMunicipioExpedienteUbicacion").val(($("#idMunicipioExpediente_detail_table").rup_combo("getRupValue") == "0") ? "" : $("#idMunicipioExpediente_detail_table").rup_combo("getRupValue"));
				$("#idLocalidadExpediente_detail_table").rup_combo("setRupValue", "");
				$("#idLocalidadExpedienteHidden").val("");
				var source = "/ab59WebAppWar/nora/localidadesBusqueda?provinciaId=" + $("#idProvinciaExpediente_detail_table").val() + "&municipioId=" + $("#idMunicipioExpediente_detail_table").val();
				cargarComboLocalidadesFiltro(source);			
			},
			open: function(){
				$("#idMunicipioExpediente-menu").width(
					$("#idMunicipioExpediente-button").width()
				);
			},
			rowStriping: true,
			width: 280
		});
	} else {
		$("#idMunicipioExpedienteUbicacion").prop("disabled", true);
		$("#idMunicipioExpediente_detail_table").rup_combo("destroy");
		var listMunicipios = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listMunicipios);	
		$("#idMunicipioExpediente_detail_table").rup_combo({
			source: listMunicipios,	
			blank: "",
			disabled: true,
			rowStriping: true,
			width: 280
		});
	}
}

function cargarComboLocalidadesFiltro(source, value) {
	if($("#idMunicipioExpediente_detail_table").val() != "" && $("#idMunicipioExpediente_detail_table").val() != null) {
		$("#idLocalidadExpediente_detail_table").rup_combo({
			blank: "0",
			source: source,
			selected: pad(value, 14),
			sourceParam: {
				label: "dsO",
				value: "id"
			},
			onLoadSuccess : function() {
				var idLocalidadHidden = $("#idLocalidadExpediente_detail_table").val();
				$("#idLocalidadExpedienteHidden").val(idLocalidadHidden);
			},
			select : function() {
				var idLocalidadHidden = $("#idLocalidadExpediente_detail_table").val();
				$("#idLocalidadExpedienteHidden").val(idLocalidadHidden);
			
			},
			open: function(){
				$("#idLocalidadExpediente-menu").width(
					$("#idLocalidadExpediente-button").width()
				);
			},
			rowStriping: true,
			width: 290
		});
	} else {
		$("#idLocalidadExpediente_detail_table").rup_combo("destroy");
		var listLocalidades = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listLocalidades);	
		$("#idLocalidadExpediente_detail_table").rup_combo({
			source: listLocalidades,	
			blank: "",
			disabled: true,
			rowStriping: true,
			width: 290
		});
	}
}