$(document).ready(function(){
	
	//Marcamos la opción del menú principal "Sanciones" y habilitamos
	$("#menuFichaSancion").addClass("active");
		
	inicializaControlCambios("datosSancionForm");
	
	$(".rup_accordion").rup_accordion({
		collapsible: true,
		heightStyle: "content",
		clearStyle:true
	});
	
	$("#accordionExample").rup_accordion ("activate", false);
	
	/**
	 * Si el valor de la variable es true, se mostrara el mensaje
	 */
	if($("#mostraMensajeExpedienteSancionadorValidoParaPago").val() == 'true'){
		$("#mensajeExpedienteListoPago_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true});
    	$("#mensajeExpedienteListoPago_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.pagos.mostraMensajeExpedienteSancionadorValidoParaPago, "alert");
	}
	
	//Configuración de campos fecha
	$(".campoFecha").each(function(){
		$("#"+this.id).rup_date();
	});
	
	if($("#identifiEstableci").val() !== ""){
		$("#btnAccesoCenso").show();
	} else {
		$("#btnAccesoCenso").hide();
	}
		
	$.ajax({
		url: CTX_PATH + "sanciones/maint/datos/" + $("#idSancion").val(),
		type: "GET",
		contentType: "application/json",
		dataType:"json",
		success: function(data){
			cargarDatos(data, "datosSancionForm");
		}
	});
		
	$("#instructorCombo").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/instructores/cargarCombo?idInstructor=" + $("#idInstructor").val() + "&Baja=" + ESTADO_NO_BAJA,
		sourceParam : {
			label : "nombreInstructor",
			value : "idInstructor"
		},
		onLoadSuccess : function() {
			var idInstructorLoad = $("#idInstructor").val();
			if (" " !== idInstructorLoad) {
				$("#instructorCombo").rup_combo("setRupValue", idInstructorLoad);
			}
		},
		select: function(){			
			var idInstructorChange = $("#instructorCombo").val();
			$("#idInstructor").val(idInstructorChange);
		},
		rowStriping: true
	});

	$("#tipoFinalizacionCombo").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/tiposFinalizacion/cargarCombo",
		sourceParam : {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
			value : "idTipoFinalizacion"
		},
		onLoadSuccess : function() {
			var idTipoFinalizacionLoad = $("#idTipoFinalizacion").val();
			if (" " !== idTipoFinalizacionLoad) {
				$("#tipoFinalizacionCombo").rup_combo("setRupValue", idTipoFinalizacionLoad);
			}
		},
		select: function(){
			var idTipoFinalizacionChange = $("#tipoFinalizacionCombo").val();
			$("#idTipoFinalizacion").val(idTipoFinalizacionChange);
		},
		rowStriping: true
	});

	
	$("#relArtInfSan").rup_datatable({
		
		primaryKey: "idRelArtInfSan",
		loadOnStartUp: true,
		pagingType: "full_numbers",
		dom: 't <"col-sm-3"l><"col-sm-7"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"relArtInfSan_filter_form",
  	  		filterToolbar:"relArtInfSan_filter_toolbar",
  	  		collapsableLayerId:"relArtInfSan_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	columnDefs: [
    		   {
    		      targets: [0, 3, 11, 12, 13, 14],
    		      orderable: false,
    		      visible: false
    		   },
    		   {
      		      targets: [1],
      		      visible: (("es"===$.rup_utils.get("language")) ? true : false)
      		   },
      		   {
       		      targets: [2],
       		      visible: (("eu"===$.rup_utils.get("language")) ? true : false)
       		   },
    		   {
    			   targets: [9, 10],
    			   width: 150,
    			   render: function(value){
    				   return formatearNumero(value);
				   },
				   className: "text-right"
    		   },
    		   {
    			   targets: [4],
    			   render: function(data){
    				   if(data === null){
    					   data = '';
    				   }
    				   return '<div id="datosSancion_articuloInfraccionTooltip_" class="datosSancion_articuloInfraccionTooltip">' + data + '</div>';
    			   }
    		   },
    		   {
    			   targets: [7],
    			   render: function(data){
    				   if(data === null){
    					   data = '';
    				   }
    				   
    				   return '<div id="datosSancion_articuloDerechoTooltip_" class="datosSancion_articuloDerechoTooltip">' + data.replace(/#/g, "<br/>") + '</div>';
    			   }
    		   }
    	],
		drawCallback: function() {
			 var tabla = $('#relArtInfSan').DataTable();
			
			$('.datosSancion_articuloInfraccionTooltip').each(function (index) {
				
				var toolTipText = (("es"===$.rup_utils.get("language")) ? tabla.row(index).data().infraccion.descripcionCastellano : tabla.row(index).data().infraccion.descripcionEuskera) 
				this.id = this.id + index;
		        $("#"+this.id).rup_tooltip({
		            content: toolTipText,		        	
		            position: {
		                my: 'top left',
		                at: 'bottom right',
		                adjust: {
		                	x: 10,
		                	y: 9
		                }
		            }
		        });
		        $("#"+this.id).mouseover(function(){
		        	var idQtip = $("#"+this.id).parent().attr("data-hasqtip");
		        	setTimeout(function(){ 
		        		$("#qtip-"+idQtip).remove();
		        	}, 90);
		        	
		        });
		    });
			
			$('.datosSancion_articuloDerechoTooltip').each(function (index) {
				var toolTipText = "- " +  (("es"===$.rup_utils.get("language")) ? tabla.row(index).data().descripcionDerechosInfCas.replace(/#/g, "<br/>- ") : tabla.row(index).data().descripcionDerechosInfEus.replace(/#/g, "<br/>- ")) 
				this.id = this.id + index;
		        $("#"+this.id).rup_tooltip({
		            content: toolTipText,		        	
		            position: {
		                my: 'top left',
		                at: 'bottom right',
		                adjust: {
		                	x: 10,
		                	y: 9
		                }
		            }
		        });
		        $("#"+this.id).mouseover(function(){
		        	var idQtip = $("#"+this.id).parent().attr("data-hasqtip");
		        	setTimeout(function(){ 
		        		$("#qtip-"+idQtip).remove();
		        	}, 90);
		        	
		        });
		    });
		},
    	footerCallback: function ( row, data, start, end, display ) {
    		
            var api = this.api(), data;
  
            var intVal = function ( i ) {
            	
                return typeof i === 'string' ?
                		i.replace(/[\$.]/g, '').replace(',', '.')*1:
                    typeof i === 'number' ?
                        i : 0;
            };
  
            $( api.column( 0 ).footer() ).empty();
            $( api.column( 1 ).footer() ).empty();
            $( api.column( 2 ).footer() ).empty();
            $( api.column( 3 ).footer() ).empty();
            $( api.column( 4 ).footer() ).empty();
            $( api.column( 5 ).footer() ).empty();
            $( api.column( 6 ).footer() ).empty();
            $( api.column( 7 ).footer() ).empty();
            $( api.column( 8 ).footer() ).text($.rup.i18n.app.fichaSancion.datosSancion.infracciones.total);
            $( api.column( 9 ).footer() ).empty();
            $( api.column( 10 ).footer() ).empty();
            $( api.column( 11 ).footer() ).empty();
            $( api.column( 12 ).footer() ).empty();
            $( api.column( 13 ).footer() ).empty();
            $( api.column( 14 ).footer() ).empty();
            
            var totalSancion;
            var totalResolucion
            $.ajax({
				type : "GET",
				url : CTX_PATH + "relartinfsan/totales/" + $("#idSancion").val(),
				dataType : "json",
				async : false,
				success : function(data) {
					
					totalSancion = data.totalSancion;
					totalResolucion = data.totalResolucion;
				}
			});
            
            /* Importe sanción */
            // Total over this page            	
            var pageTotalSancion = api
                .column( 9, { page: 'current'} )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
              
            // Update footer            
            $( api.column( 9 ).footer() ).html(
            		formatearNumero(totalSancion) +' € ('+ formatearNumero(pageTotalSancion.toString().replace('.', ',')) +' €)'
            );
            
            /* Importe Resolución*/  
            // Total over this page
            var pageTotalResolucion = api
                .column( 10, { page: 'current'} )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );            
  
            // Update footer
            $( api.column( 10 ).footer() ).html(
            		formatearNumero(totalResolucion) + ' € ('+ formatearNumero(pageTotalResolucion.toString().replace('.', ',')) +' €)'
            );
        },
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("relArtInfSan_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
			  
			  $("#relArtInfSan tfoot").appendTo("#relArtInfSan");
			  $("#relArtInfSan tfoot").show();
    	}
	});
	
	$('#relArtInfSan tbody').on( 'click', 'tr', function () {
		$('#relArtInfSan').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });
	
	$('#relArtInfSan tbody').on('dblclick', 'tr', function () {		
		$("#btnEditInfracciones").trigger("click");		
	});
	
	$("#relArtInfSan_detail_div").dialog({
		autoOpen: false,
		width: 750,
		modal: true,
		position: { my: "center center" },
		type: $.rup.dialog.DIV
	});
	
	
	$('#btnAddInfracciones').on( 'click', function () {
		
		$("#infraccion_detail_table").rup_combo("destroy");
		$("#infraccion_detail_table").rup_combo({
			blank : "",		
			source : "/ab59WebAppWar/infracciones/cargarCombo?procedimiento.idProcedimiento=" + $("#idProcedimiento").val() + "&Baja=" + ESTADO_NO_BAJA,
			sourceParam : {
				label : "articulo",
				value : "idInfraccion"
			},
			select: function() {
				buscarDescricionInfraccion($("#infraccion_detail_table").val());
			},
			change: function() {				
				buscarCalificacion($("#infraccion_detail_table").val());
				var source = "/ab59WebAppWar/derechos/cargarCombo?infraccion.idInfraccion=" + $("#infraccion_detail_table").val() + "&Baja=" + ESTADO_NO_BAJA;
				cargarComboDerechos(source);
			},
			rowStriping: true,
			onLoadSuccess: function() {
				$("#infraccion_detail_table").rup_combo("clear");
			}
		});
		
		$("#derechos_detail_table").rup_combo("destroy");
		var listDerechos = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listDerechos);	
		$("#derechos_detail_table").rup_combo({
			source: listDerechos,	
			blank: "",
			disabled: true,
			rowStriping: true
		});

		$("#descripcionInfraccion_detail_table").val("");
		$("#descripcionDerechos_detail_table").val("");
				
		if ($("#relArtInfSan_detail_feedback.rup-feedback").length > 0)
		{
			$("#relArtInfSan_detail_feedback").rup_feedback("close");
		}
		$("#relArtInfSan_detail_form")[0].reset();
		
		$("#relArtInfSan_detail_form").rup_form({
			feedback: $("#relArtInfSan_detail_feedback"),
			url: CTX_PATH + "relartinfsan",
			type: "POST",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"infraccion.idInfraccion":{
						required: true
					},
					"listArticulosDerechosInf": {
						required: true
					},
					"descripcionHecho":{
						maxlength: 500
					},
					"importeSancionArtMask":{						
						validarNumerodecimal: [11]
					}
				}
			},
		    success: function(){
			   $("#relArtInfSan_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#relArtInfSan_detail_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.datosSancion.infracciones.guardarOk, "ok");
			   
			   cerrarModal();
		    },
		    error: function(){
			   $("#relArtInfSan_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#relArtInfSan_detail_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.datosSancion.infracciones.guardarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#relArtInfSan_detail_form").rup_validate("resetForm");
		$("#idSancion_detail_table").val($("#idSancion").val());
		inicializaControlCambios("relArtInfSan_detail_form");
		$("#fechaHecho_detail_table").rup_date();
		calcularMayorFechaHecho();
		$("#relArtInfSan_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.fichaSancion.datosSancion.infracciones.nuevo);
		$("#relArtInfSan_detail_div").rup_dialog("open");
	});
	
	$('#btnEditInfracciones').on( 'click', function () {	
				
		if ($("#relArtInfSan_detail_feedback.rup-feedback").length > 0)
		{
			$("#relArtInfSan_detail_feedback").rup_feedback("close");
		}
		$("#relArtInfSan_detail_form")[0].reset();
		
		$("#relArtInfSan_detail_form").rup_form({
			feedback: $("#relArtInfSan_detail_feedback"),
			url: CTX_PATH + "relartinfsan",
			type: "PUT",
			contentType: "application/json",
			dataType:"json",
			validate:{ 
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : false,
				showFieldErrorsInFeedback : true,
				rules:{
					"infraccion.idInfraccion":{
						required: true
					},
					"listArticulosDerechosInf": {
						required: true
					},
					"descripcionHecho":{
						maxlength: 500
					},
					"importeSancionArtMask":{						
						validarNumerodecimal: [11]
					},
					"importeResolucionArtMask":{						
						validarNumerodecimal: [11]
					}
				}
			},
		    success: function(){
			   $("#relArtInfSan_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#relArtInfSan_detail_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.datosSancion.infracciones.modificarOk, "ok");
			   cerrarModal();
		    },
		    error: function(){
			   $("#relArtInfSan_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			   $("#relArtInfSan_detail_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.datosSancion.infracciones.modificarError, "error");
			   cerrarModal();
		    }
		});
		
		$("#relArtInfSan_detail_form").rup_validate("resetForm");
		
		if($('#relArtInfSan').DataTable().rows(['.selected']).data().toArray().length > '0'){	
			var datosRow = $('#relArtInfSan').DataTable().rows(['.selected']).data().toArray();
						
			$.ajax({
				type : "GET",
				url : CTX_PATH + "relartinfsan/" + datosRow[0].idRelArtInfSan,
				dataType : "json",
				async : false,
				success : function(data) {
					
					cargarDatos(data, "relArtInfSan_detail_form");
										
					$("#calificacion_detail_table").val(("eu"==$.rup_utils.get("language")) ? data.infraccion.calificaciones.descripcionEuskera : data.infraccion.calificaciones.descripcionCastellano);
					$("#importeSancionArtMask_detail_table").val(formatearNumero(data.infraccion.calificaciones.importe));
					formatearNumeroObjeto(document.getElementById("importeSancionArtMask_detail_table"));
					calcularImporteResolucion();
															
					$("#relArtInfSan_detail_div").rup_dialog("setOption", "title", $.rup.i18n.app.fichaSancion.datosSancion.infracciones.editar);
					$("#relArtInfSan_detail_div").rup_dialog("open");
				}
			});
						
			$("#infraccion_detail_table").rup_combo("destroy");
			$("#infraccion_detail_table").rup_combo({
				blank : "",		
				source : "/ab59WebAppWar/infracciones/cargarCombo?idInfraccion=" + datosRow[0].infraccion.idInfraccion + "&Baja=" + ESTADO_NO_BAJA,
				sourceParam : {
					label : "articulo",
					value : "idInfraccion"
				},
				selected: datosRow[0].infraccion.idInfraccion,
				disabled: true,
				onLoadSuccess: function(){
					buscarDescricionInfraccion($("#infraccion_detail_table").val());
					var source = "/ab59WebAppWar/derechos/cargarCombo?infraccion.idInfraccion=" + $("#infraccion_detail_table").val() + "&listaIdsDerechos=" + $("#articulosDerechosInf_detail_table").val() + "&Baja=" + ESTADO_NO_BAJA;
					cargarComboDerechos(source, $("#articulosDerechosInf_detail_table").val().split("#"));
				},
				rowStriping: true
			});
			
			
			
		}else{
			$("#relArtInfSan_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#relArtInfSan_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
		
		inicializaControlCambios("relArtInfSan_detail_form");
	});

	$('#btnRemoveInfracciones').on( 'click', function () {
		
		if ($("#relArtInfSan_detail_feedback.rup-feedback").length > 0)
		{
			$("#relArtInfSan_detail_feedback").rup_feedback("close");
		}
		if($('#relArtInfSan').DataTable().rows(['.selected']).data().toArray().length > '0'){	
			$.rup_messages("msgConfirm", {
				title: $.rup.i18n.app.tabla.botones.eliminar,
				message: $.rup.i18n.app.fichaSancion.datosSancion.infracciones.borrar,
				OKFunction:	function() {
					bloquearInterfaz();
					var datosRow = $('#relArtInfSan').DataTable().rows(['.selected']).data().toArray(); 			
					$.ajax({
						type : "DELETE",
						url : CTX_PATH + "relartinfsan/" + datosRow[0].idRelArtInfSan,
						data: $("#idSancion").val(),
						contentType: "application/json",
						dataType : "json",
						async : false,
						success : function() {
							desbloquearInterfaz();
							$('#relArtInfSan').DataTable().ajax.reload();
							$("#relArtInfSan_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#relArtInfSan_detail_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.datosSancion.infracciones.borradoOK, "ok");
						},
						error: function(){
							desbloquearInterfaz();
							$("#relArtInfSan_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
							$("#relArtInfSan_detail_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.datosSancion.infracciones.borradoError, "error");
						}
					});			
				}
			});		
		}else{
			$("#relArtInfSan_detail_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#relArtInfSan_detail_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	});
		
	$('#relArtInfSan_detail_button_save').on( 'click', function () {
		
		if ( $("#derechos_detail_table").val()!= null ){
			$("#articulosDerechosInf_detail_table").val($("#derechos_detail_table").val().toString().replace(/,/g, "#"));
		}else{
			$("#articulosDerechosInf_detail_table").val(null);
		}
		
		$("#relArtInfSan_detail_form").submit();	
	});
	
	$('#relArtInfSan_detail_button_cancel').on( 'click', function () {
		hayCambios();
		ab59a_isChanged=false;
	});	
	
	$("#datosSancion_idSancion").val($("#idSancion").val());
	
	$("#datosSancionForm").rup_form({
		feedback: $("#datosSancionForm_feedback"),
		url: CTX_PATH + "sanciones",
		type: "PUT",
		contentType: "application/json",
		dataType:"json",
		validate:{ 
			liveCheckingErrors : false,
			showFieldErrorAsDefault : true,
			showErrorsInFeedback : false,
			showFieldErrorsInFeedback : true,
			rules:{
				"instructorCombo":{
					required: true
				},
				"observacionesCastellano":{
					maxlength: 2000
				},
				"observacionesEuskera": {
					maxlength: 2000
				}
			}
		},
	    success: function(){
	    	
	    	/**
		    * Para mostrar el mensaje de si esta prest para la carta de pago
		    */
		   $.ajax({
				type: "GET",
				url: CTX_PATH + "sanciones/validarExpedienteSancionadorListoParaElPago/" + $("#idSancion").val(),
				contentType: "application/json",
				dataType: "json",
				success: function(data){
					
					desbloquearInterfaz();
					if(data !== null && data){
						$("#mensajeExpedienteListoPago_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true});
				    	$("#mensajeExpedienteListoPago_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.pagos.mostraMensajeExpedienteSancionadorValidoParaPago, "alert");
					}				
				},
				error: function(data){
					desbloquearInterfaz();
				}
			});
	    	
		   $("#datosSancionForm_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
		   $("#datosSancionForm_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.datosSancion.modificarOk, "ok");
		   desbloquearInterfaz();
	    },
	    error: function(){
		   $("#datosSancionForm_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
		   $("#datosSancionForm_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.datosSancion.modificarError, "error");
		   desbloquearInterfaz();
	    }
	});
	
	//Sumitar el formulario.
	$("#btnGuardarDatosSancion").click(function(){			
		bloquearInterfaz();
		$("#datosSancionForm").submit();
		
		ab59a_isChanged = false;
		desbloquearInterfaz();
	});	
	
	$('body').on('change', "#derechos_detail_table", function(event, data){
		buscarDescricionDerechos($("#derechos_detail_table").val());
	});
	
	desbloquearInterfaz();
});

function cerrarModal()
{
	$("#infraccion_detail_table").rup_combo("clear");
	$('#relArtInfSan').DataTable().ajax.reload();			   
	$("#relArtInfSan_detail_div").rup_dialog("close");   
	ab59a_isChanged = false;
}

function hayCambios()
{
	if (controlCambios()) {
		$.rup_messages("msgConfirm", {
			message: $.rup.i18n.app.controlCambios.mensaje,
			title:  $.rup.i18n.app.controlCambios.titulo,
			OKFunction: function () {	
				
				$("#relArtInfSan_detail_form").submit();
				
			},
			CANCELFunction: function () {
				cerrarModal();   
			}
		});	
	}	
	else
	{
		cerrarModal();
	}
}

function calcularFechaPrescripcion()
{
	if ($("#fechaHecho_detail_table").val() != ""){
		
		var fechaPrescripcion = new Date($("#fechaHecho_detail_table").datepicker("getDate").setFullYear($("#fechaHecho_detail_table").datepicker("getDate").getFullYear() + parseInt($("#plazo").val())));
		
		//Modificamos el formato de las '/' por el '-' para que llegue al controlador
		var fechaHechoStr = $("#fechaHecho_detail_table").val().replaceAll("/","-");
		var fechaPrescripcionStr = formatearDateAStr(fechaPrescripcion, $.rup_utils.get("language")).replaceAll("/","-");
		
		$.ajax({
			type : "GET",
			url : CTX_PATH + "intervalos/calcularFechaConIntervalo/" + fechaHechoStr+"/"+fechaPrescripcionStr,
			dataType : "json",
			async : false,
			success : function(data) {
				$("#fechaPrescripcion_detail_table").val(data);
			}
		});
	}else{
		$("#fechaPrescripcion_detail_table").val("");
	}
}

function buscarCalificacion(infraccion)
{
	if (infraccion != ""){
		$.ajax({
			type : "GET",
			url : CTX_PATH + "calificaciones/infracciones/" + infraccion,
			dataType : "json",
			async : false,
			success : function(data) {
				$("#calificacion_detail_table").val(("eu"==$.rup_utils.get("language")) ? data.descripcionEuskera : data.descripcionCastellano);
				$("#plazo").val(data.plazo);
				$("#importeSancionArtMask_detail_table").val(formatearNumero(data.importe));
				formatearNumeroObjeto(document.getElementById("importeSancionArtMask_detail_table"));
				calcularImporteResolucion();
				calcularFechaPrescripcion();
			}
		});
	}
}

function buscarDescricionInfraccion(infraccion)
{
	if (infraccion != ""){
		$.ajax({
			type : "GET",
			url : CTX_PATH + "infracciones/" + infraccion,
			dataType : "json",
			async : false,
			success : function(data) {
				$("#descripcionInfraccion_detail_table").val(("eu"==$.rup_utils.get("language")) ? "- " + data.descripcionEuskera : "- " + data.descripcionCastellano);
			}
		});
	} else {
		$("#descripcionInfraccion_detail_table").val("");
	}
}

function buscarDescricionDerechos(derechos)
{
	if (derechos != "" && derechos != null){
		$.ajax({
			type : "GET",
			url : CTX_PATH + "derechos/descripciones/" + derechos,
			dataType : "json",
			async : false,
			success : function(data) {
				var descripcionDerecho = "";
				for (var i = 0; i < data.length; i++) {
					descripcionDerecho += ("eu"==$.rup_utils.get("language")) ? "- " + data[i].descripcionEuskera + "\r\n" : "- " + data[i].descripcionCastellano + "\r\n";
				}
				$("#descripcionDerechos_detail_table").val(descripcionDerecho);
			}
		});
	} else {
		$("#descripcionDerechos_detail_table").val("");
	}
}

function cargarComboDerechos(source, value){

	if ($("#infraccion_detail_table").val() != "" && $("#infraccion_detail_table").val() != null){
		$("#derechos_detail_table").rup_combo("destroy");
		$("#derechos_detail_table").rup_combo({
			source: source,
			multiselect: true,
			selected: value,
			sourceParam: {
				label: "articulo",
				value: "idDerecho"
			},
			rowStriping: true,
			onLoadSuccess: function() {
				buscarDescricionDerechos($("#derechos_detail_table").val());
			}
		});
		
	}else{
		var listDerechos = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listDerechos);	
		$("#derechos_detail_table").rup_combo("destroy");
		$("#derechos_detail_table").rup_combo({
			source: listDerechos,	
			blank: "",
			disabled: true,
			rowStriping: true
		});
		$("#calificacion_detail_table").val("");
	}
}

function calcularMayorFechaHecho(){
	
	var mayorFechaHecho = "";
	for (var i = 0; i < $("#relArtInfSan").DataTable().rows()[0].length; i++) {
		if($("#relArtInfSan").DataTable().rows().data()[i].fechaHecho !== null){
			if(i === 0){
				mayorFechaHecho = $("#relArtInfSan").DataTable().rows().data()[i].fechaHecho;
			} else {
				if(strToDate($("#relArtInfSan").DataTable().rows().data()[i].fechaHecho) > strToDate(mayorFechaHecho)){
					mayorFechaHecho = $("#relArtInfSan").DataTable().rows().data()[i].fechaHecho;
				}
			}
		}
	}
	
	$("#fechaHecho_detail_table").val(mayorFechaHecho);
}

function calcularImporteResolucion(){
	
	if($("#importeSancionArtMask_detail_table").val() != null && $("#importeSancionArtMask_detail_table").val() != ""){
		
		var importeSancionFormateado = eliminarFormatoNumero($("#importeSancionArtMask_detail_table").val());
		importeSancionFormateado = importeSancionFormateado.replaceAll(".", ",");

		$.ajax({
			type : "GET",
			url : CTX_PATH + "relartinfsan/calcularImporteResolucion/" + $("#idSancion").val()+"/"+importeSancionFormateado,
			dataType : "json",
			contentType: "application/json",
			async : false,
			success : function(data) {
				if(data != null && data.importeResolucionArt != null){					
					
					$("#importeResolucionArtMask_detail_table").val(data.importeResolucionArt);
					formatearNumeroObjeto(document.getElementById("importeResolucionArtMask_detail_table"));
				}
			}
		});
	}else{
		$("#importeResolucionArtMask_detail_table").val("");
		$("#importeResolucionArt_detail_table").val("");
	}
}