$(document).ready(function(){

	//Marcamos la opción del menú principal "Sanciones" y habilitamos
	$("#menuFichaSancion").addClass("active");
	
	$("#controlFechasPropSancion_idSancion").val($("#idSancion").val());
	
	inicializaControlCambios("controlFechasForm");
	
	/**
	 * Si el valor de la variable es true, se mostrara el mensaje
	 */
	if($("#mostraMensajeExpedienteSancionadorValidoParaPago").val() == 'true'){
		$("#mensajeExpedienteListoPago_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true});
    	$("#mensajeExpedienteListoPago_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.pagos.mostraMensajeExpedienteSancionadorValidoParaPago, "alert");
	}
	
	//Configuración de campos fecha
	$(".campoFecha").each(function(){
		$("#"+this.id).rup_date();
	});
	
	//Modal historial fechas.
	$("#historialFechasModal").rup_dialog({
		autoOpen: false,
		width: 700,
		modal: true,
		position: { my: "center center" },
		title: $.rup.i18n.app.fichaSancion.controlFechas.historial,
		type: $.rup.dialog.DIV
	});
	
	$.ajax({
		url: CTX_PATH + "controlfechas/maint/datos/" + $("#idSancion").val(),
		type: "GET",
		contentType: "application/json",
		dataType:"json",
		success: function(data){
			cargarDatos(data, "controlFechasForm");
		}, error: function() {
			$("#controlFechasPropSancionFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#controlFechasPropSancionFeedback").rup_feedback("set",$.rup.i18n.app.feedback.error.errorGenerico, "error");
		}
	});
	
	if($("#identifiEstableci").val() !== ""){
		$("#btnAccesoCenso").show();
	} else {
		$("#btnAccesoCenso").hide();
	}
	
	$("#controlFechasPropSancion").rup_datatable({
		
		primaryKey: "idPropuestaSancion",
		loadOnStartUp: true,
		pagingType: "full_numbers",
		dom: 't <"col-sm-3"l><"col-sm-7"p><"col-sm-2"i>',
		pageLength : 3,
		lengthMenu: [3, 6, 9],
		filter:{
  	  		id:"controlFechasPropSancion_filter_form",
  	  		filterToolbar:"controlFechasPropSancion_filter_toolbar",
  	  		collapsableLayerId:"controlFechasPropSancion_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},    	
    	columnDefs: [
 		   {
 		      targets: [7],
 		      orderable: false,
 		      visible: false
 		   }
 		],
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("controlFechasPropSancion_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
    	}
	});
	
	var tabla = $('#controlFechasPropSancion').DataTable();
	
	$('#controlFechasPropSancion tbody').on( 'click', 'tr', function () {
		$('#controlFechasPropSancion').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });
	
	$("#controlFechasForm").rup_form({
		feedback: $("#controlFechasForm_feedback"),
		url: CTX_PATH + "controlfechas",
		type: "PUT",
		contentType: "application/json",
		dataType:"json",
		validate:{ 
			liveCheckingErrors : false,
			showFieldErrorAsDefault : true,
			showErrorsInFeedback : false,
			showFieldErrorsInFeedback : true
		},
	    success: function(){
	       
	       /**
	    	* Para mostrar el mensaje de si esta prest para la carta de pago
		    */
		   $.ajax({
				type: "GET",
				url: CTX_PATH + "sanciones/validarExpedienteSancionadorListoParaElPago/" + $("#idSancion").val(),
				contentType: "application/json",
				dataType: "json",
				success: function(data){
					
					desbloquearInterfaz();
					if(data !== null && data){
						$("#mensajeExpedienteListoPago_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true});
				    	$("#mensajeExpedienteListoPago_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.pagos.mostraMensajeExpedienteSancionadorValidoParaPago, "alert");
					}				
				},
				error: function(data){
					desbloquearInterfaz();
				}
			});
	    	
		   $("#controlFechasForm_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
		   $("#controlFechasForm_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.controlFechas.modificarOk, "ok");		   
		   desbloquearInterfaz();
	    },
	    error: function(){
		   $("#controlFechasForm_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
		   $("#controlFechasForm_feedback").rup_feedback("set", $.rup.i18n.app.fichaSancion.controlFechas.modificarError, "error");
		   desbloquearInterfaz();
	    }
	});
	
	//Sumitar el formulario.
	$("#btnGuardarControlFechas").click(function(){			
		bloquearInterfaz();
		$("#controlFechasForm").submit();
		
		ab59a_isChanged = false;
		desbloquearInterfaz();
	});

	desbloquearInterfaz();
	
	//Botón historial fechas
	$("#btnHistorialFechas").click(function() {
		if(tabla.rows(['.selected']).data().toArray().length > '0'){
			cargarHistorialFechas(tabla.rows(['.selected']).data().toArray()[0].propuestaSancion.idPropuestaSancion);
			$("#historialFechasModal").rup_dialog("open");
		} else {
			$("#controlFechasPropSancionFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#controlFechasPropSancionFeedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "alert");
		}
	});
	
	//Botón cancelar historial fechas
	$("#historialFechasCancelar").click(function() {
		$("#historialFechasModal").rup_dialog("close");
	});
	
});

function cargarHistorialFechas(idPropuestaSancion){
	$("#historialFechas_idPropuestaSancion").val(idPropuestaSancion);
	
	if(!$.fn.DataTable.isDataTable('#historialFechas')){
		$("#historialFechas").rup_datatable({
			primaryKey: "idRelProSanFec",
			loadOnStartUp: true,
			pagingType: "full_numbers",
			dom: 't',
			filter: {
				id: "historialFechas_filter_form",
				filterToolbar: "historialFechas_filter_toolbar",
				collapsableLayerId: "historialFechas_filter_fieldset"
			},
			colReorder: {
				fixedColumnsLeft: 1
			},
			columnDefs: [
				{
					targets: [0],
					orderable: false,
					visible: false
				},
				{
					targets: [1],
    			   className: "text-center"
				},
				{
					targets: [1,2],
					orderable: false
				},
    		    {
       			    targets: [2],
    			    render: function(data){
    			    	switch (data) {
						case FECHA_PROPUESTA_OT:
							return $.rup.i18n.app.fichaSancion.controlFechas.fechaPropuestaOT;
							
						case FECHA_VALIDACION_DIRECCION:
							return $.rup.i18n.app.fichaSancion.controlFechas.fechaValidacionDireccion;
							
						case FECHA_RECHAZO:
							return $.rup.i18n.app.fichaSancion.controlFechas.fechaRechazo;
							
						case FECHA_REQUERIMIENTO_SUBSANACION:
							return $.rup.i18n.app.fichaSancion.controlFechas.fechaRequerimientoSubsanacion;

						default:
							return "";
						}
    			    }
    		    }
			],
	    	order: [ 1, "desc" ]
		});
	}else{
		$("#historialFechas").DataTable().ajax.reload();
	}
}

//Cuando se modifica el campo fechaRecursoPotestativoReposicion
function cambiosRecursoPotestativo(){
	
	if ($("#fechaRecursoPotestativoReposicion").val() != null && $("#fechaRecursoPotestativoReposicion").val() != ""){
		$("#fechaResolucionRecursoPotestativoReposicion").val(null);
		$("#recursoContenciosoAdministrativo").val(null);
		$("#resolucionContenciosoAdministrativo").val(null);
		$("#sancionFirme").val(null);
	}
}

//Cuando se modifica el campo fechaResolucionRecursoPotestativoReposicion
function cambiosResolucionRecursoPotestativo(){
	
	if ($("#fechaResolucionRecursoPotestativoReposicion").val() != null && $("#fechaResolucionRecursoPotestativoReposicion").val() != ""){			
		
		$("#recursoContenciosoAdministrativo").val(null);
		$("#resolucionContenciosoAdministrativo").val(null);
		$("#sancionFirme").val(sumaMesesFecha($("#fechaResolucionRecursoPotestativoReposicion").val(), 2));
	}
}

//Cuando se modifica el campo fechaRecursoPotestativoReposicion
function cambiosRecursoContencioso(){
	
	if ($("#recursoContenciosoAdministrativo").val() != null && $("#recursoContenciosoAdministrativo").val() != ""){
		$("#resolucionContenciosoAdministrativo").val(null);
		$("#sancionFirme").val(null);
	}
}

//Cuando se modifica el campo fechaResolucionRecursoPotestativoReposicion
function cambiosResolucionRecursoContencioso(){
	
	if ($("#resolucionContenciosoAdministrativo").val() != null && $("#resolucionContenciosoAdministrativo").val() != ""){			
		
		$("#sancionFirme").val($("#resolucionContenciosoAdministrativo").val());
	}
}