var PROCEDIMIENTO_PRECARGADO = $("#procedimientoPrecargado").val();

$(document).ready(function(){
	
	var urlab61 = $('#urlab61').val();
	var ab61_folderID = $('#ab61_folderID').val();
	
	$("#btnActualizar").click(function(){
		location.reload();
	});
	
	if($("#tieneExpSancionador").val() === "true"){
		$("#cabeceraPropuestaSancionExpedienteSancionador").removeAttr("hidden");
		$("#btnCrearExpedienteSancionador").attr("hidden", "true");
	} else {
		$("#cabeceraPropuestaSancionExpedienteSancionador").attr("hidden", "true");
		if($("#idEstadoProSan").val() == ESTADO_VALIDADA_DIRECCION_TURISMO || $("#idEstadoProSan").val() == ESTADO_VALIDADA_DIRECCION_COMERCIO){
			$("#btnCrearExpedienteSancionador").removeAttr("hidden");
		}else {
			$("#btnCrearExpedienteSancionador").attr("hidden", "true");
		}
	}
	
	if(sessionStorage.getItem("crearExpedienteInicioOficioOk") === "true"){
		$("#propuestasSancion_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true, delay:3000 });
		$("#propuestasSancion_feedback").rup_feedback("set", $.rup.i18n.app.expedienteInicioOficio.creadoOk, "ok");
	}
	
	if(sessionStorage.getItem("propuestaGuardarOk") === "true"){
		sessionStorage.removeItem("propuestaGuardarOk");
		$("#propuestasSancion_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
		$("#propuestasSancion_feedback").rup_feedback("set", $.rup.i18n.app.propuestasSancion.modificarOk, "ok");
	}
	
	$(".rup_accordion").rup_accordion({
		collapsible: true,
		heightStyle: "content",
		clearStyle:true,
		active: false
	});
	
	$(".expandH1_6").hide();
	$(".expandH1_2").hide();

	$(".comboDinamico").each(function(){
		var id = $(this).attr("id");
		var selectValue = $(this).prev(":hidden").val();
		$("#" + id).rup_combo({
			source: "/ab59WebAppWar/subtipotercero/cargarCombo",
			blank: "",
			sourceParam: {
				label: ("es"===$.rup_utils.get("language")) ? "descripcionCastellano" : "descripcionEuskera",
				value: "idSubtipoTercero"
			},
			width: 260,
			rowStriping: true,
			onLoadSuccess: function() {
				if(selectValue !== ""){
					$("#" + id).rup_combo("setRupValue", selectValue);
				} else {
					$("#" + id).rup_combo("clear");
				}
				
				$("#" + id).rup_combo("disable");
			}
		});
	});
	
	$(".comboDinamicoModal").each(function(){
		var id = $(this).attr("id");
		var selectValue = $(this).prev(":hidden").val();
		$("#" + id).rup_combo({
			source: "/ab59WebAppWar/subtipotercero/cargarCombo",
			blank: "",
			sourceParam: {
				label: ("es"===$.rup_utils.get("language")) ? "descripcionCastellano" : "descripcionEuskera",
				value: "idSubtipoTercero"
			},
			width: 220,
			rowStriping: true,
			onLoadSuccess: function() {
				if(selectValue !== ""){
					$("#" + id).rup_combo("setRupValue", selectValue);
				} else {
					$("#" + id).rup_combo("clear");
				}

				$("#" + id).rup_combo("disable");
			}
		});
	});
	
	$("#nuevaModalExpedienteInicioOficio").rup_dialog({
		autoOpen: false,
		width: 1200,
		modal: true,
		position:{ my: "center center" },
		type: $.rup.dialog.DIV,
		open: function() {
			var provincia = $("#idProvincia_detail_table").val();
			if(provincia.length === 1){
				provincia = "0" + provincia;
			}
			var numeroRegistro = cargarNumeroRegistro();
			var nombreTitular = $("#nombreTitular").val();
			
			$("#nuevaModalExpedienteInicioOficioTitulo").val('(' + provincia + ') [' + numeroRegistro + '] ' + nombreTitular);

			$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback("hide");
			
			$("#contenedorInteresados").html("");
			$("#datosCrearExpedienteInicioOficio").val("");
			
			if(PROCEDIMIENTO_PRECARGADO){
				consultarDatosInteresado();				
			}
			
		},
		close: function() {
			$("#contenedorInteresados").html("");
			$("#datosCrearExpedienteInicioOficio").val("");
			$("#nuevaModalExpedienteInicioOficioComboProcedimiento").rup_combo("clear");
			
			$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback("hide");
		}
	});
	
	
	
	
	
	
	$("#infracciones").rup_datatable({
		
		primaryKey: "idRelArtInfProSan",
		loadOnStartUp: false,
		pagingType: "full_numbers",
		dom: 't <"col-sm-3"l><"col-sm-7"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"infracciones_filter_form",
  	  		filterToolbar:"infracciones_filter_toolbar",
  	  		collapsableLayerId:"infracciones_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	order: [ 1, "asc" ],
    	columnDefs: [
    		   {
    		      targets: [0, 8, 9, 10, 11],
    		      orderable: false,
    		      visible: false
    		   },
    		   {
      		      targets: [2],
      		      visible: (("es"===$.rup_utils.get("language")) ? true : false),
      		      width: 100
      		   },
      		   {
       		      targets: [3],
       		      visible: (("eu"===$.rup_utils.get("language")) ? true : false),
      		      width: 100
       		   },
    		   {
       			   targets: [1],
    			   render: function(data){
    				   if(data === null){
    					   data = '';
    				   }
    				   return '<div id="busqPropuestas_articuloInfraccionTooltip_" class="busqPropuestas_articuloInfraccionTooltip">' + data + '</div>';
    			   }
    		   },
    		   {
    			   targets: [7],
    			   render: function(data){
    				   if(data === null){
    					   data = '';
    				   }
    				   return '<div id="busqPropuestas_articuloDerechoTooltip_" class="busqPropuestas_articuloDerechoTooltip">' + data.replace(/#/g, "<br/>") + '</div>';
    			   }
    		   }
    	],
		drawCallback: function() {
			 var tabla = $('#infracciones').DataTable();
			
			$('.busqPropuestas_articuloInfraccionTooltip').each(function (index) {				
				var toolTipText = (("es"===$.rup_utils.get("language")) ? tabla.row(index).data().infraccion.descripcionCastellano : tabla.row(index).data().infraccion.descripcionEuskera) 
				this.id = this.id + index;
		        $("#"+this.id).rup_tooltip({
		            content: toolTipText,		        	
		            position: {
		                my: 'top left',
		                at: 'bottom right',
		                adjust: {
		                	x: 10,
		                	y: 9
		                }
		            }
		        });
		        $("#"+this.id).mouseover(function(){
		        	var idQtip = $("#"+this.id).parent().attr("data-hasqtip");
		        	setTimeout(function(){ 
		        		$("#qtip-"+idQtip).remove();
		        	}, 90);
		        	
		        });
		    });
			
			$('.busqPropuestas_articuloDerechoTooltip').each(function (index) {
				var toolTipText = "- " +  (("es"===$.rup_utils.get("language")) ? tabla.row(index).data().descripcionDerechosInfCas.replace(/#/g, "<br/>- ") : tabla.row(index).data().descripcionDerechosInfEus.replace(/#/g, "<br/>- ")) 
				this.id = this.id + index;
		        $("#"+this.id).rup_tooltip({
		            content: toolTipText,		        	
		            position: {
		                my: 'top left',
		                at: 'bottom right',
		                adjust: {
		                	x: 10,
		                	y: 9
		                }
		            }
		        });
		        $("#"+this.id).mouseover(function(){
		        	var idQtip = $("#"+this.id).parent().attr("data-hasqtip");
		        	setTimeout(function(){ 
		        		$("#qtip-"+idQtip).remove();
		        	}, 90);
		        	
		        });
		    });
		},
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("infracciones_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
			  
    	}
	});
	
	$("#documentos").rup_datatable({
		
		primaryKey: "idDocumento",
		loadOnStartUp: false,
		pagingType: "full_numbers",
		dom: 't <"col-sm-3"l><"col-sm-7"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"documentos_filter_form",
  	  		filterToolbar:"documentos_filter_toolbar",
  	  		collapsableLayerId:"documentos_filter_fieldset"
     	},
    	colReorder: {
			fixedColumnsLeft: 1
    	},
    	order: [ 1, "asc" ],
    	columnDefs: [
			   {
			      targets: [0, 1, 2, 3],
			      orderable: false,
			      visible: false
			   },
	           {
	        		targets: [4],
	        		render: function (cellvalue, options, rowObject){
	        			var urlDescargarRelActDoc;
	        			if (cellvalue !== null && cellvalue !== "") {
	        				if (rowObject.oidDokusi !== null && rowObject.oidDokusi !== "") {
	        					urlDescargarRelActDoc = CTX_PATH + "docprosan/descargarDocumentoDokusi/" + rowObject.oidDokusi + "/" + cellvalue;
	        				} else {
	        					urlDescargarRelActDoc = CTX_PATH + "docprosan/descargarDocumentoPid/" + rowObject.oidDokusi + "/" + cellvalue;;
	        				}
	        				
	        				return "<a href='" + urlDescargarRelActDoc + "'><u>" + cellvalue + "</u></a>";
	        			} else {
	        				return "";
	        			}
	        		}
	           },			   
			   {
			      targets: [5],
			      visible: (("es"===$.rup_utils.get("language")) ? true : false)
			   },
   				{
			      targets: [6],
			      visible: (("eu"===$.rup_utils.get("language")) ? true : false)
   				},   				
				{
					targets: [7],
					render: function(data) {
						if(data === APORTADO_EXPEDIENTE_SI){
							return $.rup.i18n.app.propuestasSancion.documentos.aportadoExpedienteSi;
						} else if(data === APORTADO_EXPEDIENTE_NO){
							return $.rup.i18n.app.propuestasSancion.documentos.aportadoExpedienteNo;
						} else if(data === APORTADO_EXPEDIENTE_NO_SUBIR){
							return $.rup.i18n.app.propuestasSancion.documentos.aportadoExpedienteNoSubir;
						}
					}
				},
				{
				targets:[0, 1, 2, 3, 4, 5, 6, 7],
				orderable: false
				}
    	],
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("documentos_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
			  
    	}
	});
	
	$('#documentos tbody').on( 'click', 'tr', function () {
		$('#documentos').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        if($('#documentos').DataTable().rows(['.selected']).data().toArray()[0].plantilla.idPlantilla == 0 || $("#esExpedienteCerrado").val() === "true"){
	    	$("#btnAportarDocumento").prop("disabled", true);
	    } else {
	    	$("#btnAportarDocumento").prop("disabled", false);
	    }
    });
	
	//Botón aportar documento a Tramitagune
	$("#btnAportarDocumento").click(function(){
		if ($("#documentos_feedback.rup-feedback").length > 0)
		{
			$("#documentos_feedback").rup_feedback("close");
		}
		
		if($('#documentos').DataTable().rows(['.selected']).data().toArray().length > '0'){
			bloquearInterfaz();
			
			var datosRow = $('#documentos').DataTable().rows(['.selected']).data().toArray();
			
			$.ajax({
				type: "GET",
				url: CTX_PATH + "docprosan/aportarDocumento/" + datosRow[0].idDocumento + "/" + datosRow[0].oidPID + "/" + datosRow[0].plantilla.idPlantilla + "/" + $("#relSanProSan_idSancion").val(),
				contentType: "application/json",
				dataType: "json",
				success: function(data){
					
					desbloquearInterfaz();
					if (data != "ok")
					{
						$("#documentos_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
						$("#documentos_feedback").rup_feedback("set", data, "error");
					}
					else
					{
						$("#documentos_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
						$("#documentos_feedback").rup_feedback("set", $.rup.i18n.app.mensajes.documentoTramitado, "ok");
						$("#documentos").DataTable().ajax.reload();
					}
				},
				error: function(data){
					
					desbloquearInterfaz();
					$("#documentos_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
					$("#documentos_feedback").rup_feedback("set", data.responseText, "error");
				}
			});
			
		} else{
			$("#documentos_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#documentos_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
		}
	});
	
	$("#propuestasSancion_detail_form").rup_form({
		feedback: $("#propuestasSancion_feedback"),
		url: CTX_PATH + "propuestassancion",
		type: "PUT",
		contentType: "application/json",
		dataType:"json",
		validate:{ 
			liveCheckingErrors : false,
			showFieldErrorAsDefault : true,
			showErrorsInFeedback : false,
			showFieldErrorsInFeedback : true,
			rules:{
				"notas":{ required : {
					depends: function(){
						if($("#estado_detail_table").val() == ESTADO_REQUERIMIENTO_SUBSANACION){
							return true;
						} else{
							return false;
						}
					}
				}, maxlength : 1000 }
			}
		},
	    success: function(){
	    	
	    	sessionStorage.setItem("propuestaGuardarOk", true);
		    location.reload();
	    },
	    error: function(){
		   $("#propuestasSancion_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
		   $("#propuestasSancion_feedback").rup_feedback("set", $.rup.i18n.app.propuestasSancion.modificarError, "error");
	    }
	});
	
	$("#propuestasSancion_detail_form").rup_validate("resetForm");	
		
	if(null !== $("#idExpedienteOrigen").val() && '' !== $("#idExpedienteOrigen").val()){			
		$.ajax({
			type : "GET",
			url : CTX_PATH + "propuestassancion/" + $("#idPropuestaSancion").val(),
			dataType : "json",
			success : function(data) {
				cargarDatos(data, "propuestasSancion_detail_form");
				
				$("#establecimiento_detail_table").val(data.expedienteOrigen.datosDirecciones.establecimiento);
				$("#identificadorEstablecimientoUno_detail_table").val(data.expedienteOrigen.datosDirecciones.identificadorEstablecimientoUno);
				$("#identificadorEstablecimientoDos_detail_table").val(data.expedienteOrigen.datosDirecciones.identificadorEstablecimientoDos);
				$("#identificadorEstablecimientoTres_detail_table").val(data.expedienteOrigen.datosDirecciones.identificadorEstablecimientoTres);
				$("#idProvincia_detail_table").val(data.expedienteOrigen.datosDirecciones.idProvincia);
				$("#descripcionProvincia_detail_table").val(data.expedienteOrigen.datosDirecciones.descripcionProvincia);
				$("#descripcionMunicipio_detail_table").val(data.expedienteOrigen.datosDirecciones.descripcionMunicipio);
				$("#descripcionLocalidad_detail_table").val(data.expedienteOrigen.datosDirecciones.descripcionLocalidad);
				$("#calle_detail_table").val(data.expedienteOrigen.datosDirecciones.direccion);
				$("#numero_detail_table").val(data.expedienteOrigen.datosDirecciones.numero);
				$("#escalera_detail_table").val(data.expedienteOrigen.datosDirecciones.escalera);
				$("#piso_detail_table").val(data.expedienteOrigen.datosDirecciones.piso);
				$("#letra_detail_table").val(data.expedienteOrigen.datosDirecciones.letra);
				$("#codigoPostal_detail_table").val(data.expedienteOrigen.datosDirecciones.codigoPostal);
				
				$("#numExpedienteOrigen_detail_table").val(data.expedienteOrigen.folderNumber);
				$("#tituloExpedienteOrigen_detail_table").val(data.expedienteOrigen.titulo);
				
				$("#idExpediente_filter_table").val(data.expedienteOrigen.idExpediente);
				$("#idTercero_filter_table").val("");
				
				$("#idPropuestaSancion_filter_table").val(data.idPropuestaSancion);					
				$('#infracciones').DataTable().ajax.reload();
				
				$("#documentos_idPropuestaSancion_filter_table").val(data.idPropuestaSancion);					
				$('#documentos').DataTable().ajax.reload();
				
				$(".botoneraTabla").hide();
				
				$("#notasResponsable_detail_table").val(data.notasRespOfi);
				
				$("#estado_detail_table").rup_combo({
					blank: "",
					source : "/ab59WebAppWar/estadosProSan/cargarCombo?idDireccion=" + data.expedienteOrigen.procedimiento.direcciones.idDireccion,
					sourceParam : {
						label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
						value : "idEstadoProSan"
					},
					onLoadSuccess: function(){
						$("#estado_detail_table").rup_combo("clear");
						$("#estado_detail_table").rup_combo("setRupValue", data.estado);
						
						if (data.asociadoSancion > 0 || $("#esPerfilConsulta").val() === "true")
						{
							$("#estado_detail_table").rup_combo("disable");
							$("#notas_detail_table").prop("disabled", true);
						}
						else {
							$("#estado_detail_table").rup_combo("enable");
							$("#notas_detail_table").prop("disabled", false);
						}
						
						if($("#estado_detail_table").val() == ESTADO_REQUERIMIENTO_SUBSANACION){
							$("#notas_detail_table_label").addClass("required");
						} else{
							$("#notas_detail_table_label").removeClass("required");
						}
					},
					select: function(){
						if($("#estado_detail_table").val() == ESTADO_REQUERIMIENTO_SUBSANACION){
							$("#notas_detail_table_label").addClass("required");
						} else{
							$("#notas_detail_table_label").removeClass("required");
						}
					},
					width : 225,
					rowStriping: true
				});
			}
		});	
	} else {
		$.ajax({
			type : "GET",
			url : CTX_PATH + "propuestassancion/sinExpediente/" + $("#idPropuestaSancion").val(),
			dataType : "json",
			success : function(data) {
				cargarDatos(data, "propuestasSancion_detail_form");
				
				$("#establecimiento_detail_table").val(data.datosDirecciones.establecimiento);
				$("#identificadorEstablecimientoUno_detail_table").val(data.datosDirecciones.identificadorEstablecimientoUno);
				$("#identificadorEstablecimientoDos_detail_table").val(data.datosDirecciones.identificadorEstablecimientoDos);
				$("#identificadorEstablecimientoTres_detail_table").val(data.datosDirecciones.identificadorEstablecimientoTres);
				$("#idProvincia_detail_table").val(data.expedienteOrigen.datosDirecciones.idProvincia);
				$("#descripcionProvincia_detail_table").val(data.datosDirecciones.descripcionProvincia);
				$("#descripcionMunicipio_detail_table").val(data.datosDirecciones.descripcionMunicipio);
				$("#descripcionLocalidad_detail_table").val(data.datosDirecciones.descripcionLocalidad);
				$("#calle_detail_table").val(data.datosDirecciones.direccion);
				$("#numero_detail_table").val(data.datosDirecciones.numero);
				$("#escalera_detail_table").val(data.datosDirecciones.escalera);
				$("#piso_detail_table").val(data.datosDirecciones.piso);
				$("#letra_detail_table").val(data.datosDirecciones.letra);
				$("#codigoPostal_detail_table").val(data.datosDirecciones.codigoPostal);
				
				$("#numExpedienteOrigen_detail_table").val("");
				$("#tituloExpedienteOrigen_detail_table").val("");
				
				$("#idTercero_filter_table").val(data.idTercero);
				$("#idExpediente_filter_table").val("");
				
				$("#idPropuestaSancion_filter_table").val(data.idPropuestaSancion);					
				$('#infracciones').DataTable().ajax.reload();
				
				$("#documentos_idPropuestaSancion_filter_table").val(data.idPropuestaSancion);					
				$('#documentos').DataTable().ajax.reload();
				
				$(".botoneraTabla").hide();
				
				$("#notasResponsable_detail_table").val(data.notasRespOfi);
				
				$("#estado_detail_table").rup_combo({
					blank: "",
					source : "/ab59WebAppWar/estadosProSan/cargarCombo",
					sourceParam : {
						label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
						value : "idEstadoProSan"
					},
					onLoadSuccess: function(){
						$("#estado_detail_table").rup_combo("clear");
						
						if (data.asociadoSancion > 0 || $("#esPerfilConsulta").val() === "true")
						{
							$("#estado_detail_table").rup_combo("disable");
							$("#notas_detail_table").prop("disabled", true);
						}
						else {
							$("#estado_detail_table").rup_combo("enable");
							$("#notas_detail_table").prop("disabled", false);
						}
					},
					width : 225,
					rowStriping: true
				});
			}
		});	
	}
	
	$('#btnGuardarPropuesta').on( 'click', function () {		
		$("#propuestasSancion_detail_form").submit();	
	});
	
	//Abrir ventana modal para crear expediente de inicio de oficio
	$("#btnCrearExpedienteSancionador").click(function(){
		$("#nuevaModalExpedienteInicioOficio").rup_dialog("open");
		$("#nuevaModalExpedienteInicioOficio").rup_dialog("setOption", "title", $.rup.i18n.app.propuestasSancion.crearExpIniOfi);
	});
	
	//Cerrar modal expediente inicio oficio
	$("#nuevaModalExpedienteInicioOficioCancelar").click(function(){
		$("#nuevaModalExpedienteInicioOficio").rup_dialog("close");
	});
	
	$(".botonParticipante").click(function() {		
		var tipo = "";
		var tipoAux = $(this).prop('id');
		// Split string by whitespace character
		var splitString = tipoAux.split("-");
		//hidden para saber si recargar la pagina al cerrar las modales de la ab61 o no
		$("#recargarPagina").val(0);
		if (tipoAux.substring(0, 7) == "TITULAR") {
			tipo = "TITULAR";
			$("#recargarPagina").val(0);
		} else {
			if (tipoAux.substring(0, 13) == "REPRESENTANTE") {
				tipo = "REPRESENTANTE";
				$("#recargarPagina").val(0);
			} else {
				if (tipoAux.substring(0, 6) == "RLEGAL") {
					tipo = "REPRESENTANTELEGAL";
					$("#recargarPagina").val(1);
				}else if(tipoAux.substring(0, 16) == "PERSONASCONTACTO"){
						tipo = "PERSONASCONTACTO";
						$("#recargarPagina").val(1);
				
				}else{
					if (tipoAux.substring(0, 4) == "OTRO") {
						tipo = "OTRO";
						$("#recargarPagina").val(1);
					}
				}
			}
		}
		var url="";
		var idTercero = $(this).val();
		if(splitString.length == 1){
			splitString.push("0");
			url = urlab61 + "datosterceros/"+$('#idExpedienteOrigen').val()+ "/" + idTercero + "/" + ab61_folderID + "/" +tipo+"/"+splitString[1];
		}else{
			url = urlab61 + "datosterceros/"+$('#idExpedienteOrigen').val()+"/"+ idTercero + "/" + ab61_folderID + "/" + splitString[0]+"/"+splitString[1];
		}
		
		$('#modalFrame').attr('src', url);
	});
	
	//bloquear modal hasta que carga los datos de platea y limpiar formulario
	$('#myModal').on('show.bs.modal', function () {
		 bloquearInterfaz();
	});
	
	//desbloquear interfaz cuando termina de cargarse el iframe
	$('#modalFrame').load(function(){
		//limpiar el iframe
		$(".close").on("click",function(){	
			if (1 != $("#recargarPagina").val()) {
				bloquearInterfaz();
				desbloquearInterfaz();
				var frame = document.getElementById("modalFrame");		 
				var frameDoc = frame.contentDocument || frame.contentWindow.document;
				frameDoc.removeChild(frameDoc.documentElement);
			}else{
				bloquearInterfaz();
				accederMenu('propuestasSancion');
			}
		});
		desbloquearInterfaz();
	});

	$("#nuevaModalExpedienteInicioOficioGuardar").click(function(){
		
		if($("#nuevaModalExpedienteInicioOficioComboProcedimiento").val() == "") {
			
			$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback("set", $.rup.i18n.app.modalCrearExpedienteInicioOficio.seleccionarProcedimiento, "alert");
		}else{
				
			var algunoRolParteInculpadaSeleccionado = false;
			var datosTitularRepresentante = [];
			var msgError = "";
			$(".rolTitularModalEnviar").each(function() {
				
				if($("#"+this.id).rup_combo("getRupValue") == PARTE_INCULPADA){
					algunoRolParteInculpadaSeleccionado = true;
				}		
			});
			
			if(!algunoRolParteInculpadaSeleccionado) {	
				desbloquearInterfaz();
				$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
				$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback("set", $.rup.i18n.app.expedienteInicioOficio.parteInculpadaObligatoria, "alert");
			}else{
				
				$.each(JSON.parse($("#datosCrearExpedienteInicioOficio").val()), function(indexBusqueda, busqueda) {
				
					if($("#"+indexBusqueda).rup_combo("getRupValue") != ""){	
						/**
						 * Dependiendo de si existe un representante, o no exista y tenga cuenta con consentimiento o bien no exista representante y no tengamos cuenta con consentimiento
						 * se haran unas validaciones contra unos u otros campos
						 */
						if(busqueda.datosRepresentante != null && busqueda.datosRepresentante.numeroIdentificacion != null){
							
							/**
							 * Para este caso, se validara que el representante tenga el canal seleccionado asi como el radio del pais y los datos de la comunicacion postal si esta estuviera seleccionado
							 * 
							 * Como en este caso no se puede modificar el contenido, no hacemnos nada mas.
							 */
							if(!$("#radioCanalElectronicoRepresentante_"+indexBusqueda).prop("checked") && !$("#radioCanalPostalRepresentante_"+indexBusqueda).prop("checked")){
								msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorCanalComunicacionSinInformar;
							}else if ($("#radioCanalElectronicoRepresentante_"+indexBusqueda).prop("checked") && $("#emailRepresentante_"+indexBusqueda).val() == ""){
								msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorDatosCanalComunicacionSinInformar;
							}else if ($("#radioCanalPostalRepresentante_"+indexBusqueda).prop("checked")){
								
								if(!$("#radioEspaniaRepresentante_"+indexBusqueda).prop("checked") && !$("#radioOtroPaisRepresentante_"+indexBusqueda).prop("checked")){
									msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorDatosSinInformar;
								}else if ($("#radioEspaniaRepresentante_"+indexBusqueda).prop("checked") && ($("#provinciaRepresentante_"+indexBusqueda).val() == "" || $("#municipioRepresentante_"+indexBusqueda).val() == ""     || $("#direccionRepresentante_"+indexBusqueda).val() == ""     || $("#portalRepresentante_"+indexBusqueda).val() == ""        || $("#codPostalRepresentante_"+indexBusqueda).val() == "")){
									msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorDatosCanalComunicacionSinInformar;
								}else if ($("#radioOtroPaisRepresentante_"+indexBusqueda).prop("checked") && ($("#otroPaisRepresentante_"+indexBusqueda).val() == "" || $("#otraDireccionRepresentante_"+indexBusqueda).val() == "")){
									msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorDatosCanalComunicacionSinInformar;
								}	
							}
							
							if($("#nombreApellidosTitular_"+indexBusqueda).val().trim() == ""){
								msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorNombreApellidosSinInformar;
							}else{
								var nombreApellidos = $("#nombreApellidosTitular_"+indexBusqueda).val().split("-");
								if(nombreApellidos.length == 0 || nombreApellidos.length == 1 || ( nombreApellidos[1] != null && nombreApellidos[1].trim() == "")){
									msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorNombreApellidosSinInformar;
								}	
							}
						}else if((busqueda.datosRepresentante == null || busqueda.datosRepresentante.numeroIdentificacion == null) && busqueda.datosInteresado.tieneCuentaConConsentimiento){
							
							/**
							 * Para este caso, se validara que el titular tenga el canal seleccionado asi como el radio del pais y los datos de la comunicacion postal si esta estuviera seleccionado
							 * 
							 * Como en este caso no se puede modificar el contenido, no hacemnos nada mas.
							 */
							if(!$("#radioCanalElectronico_"+indexBusqueda).prop("checked") && !$("#radioCanalPostal_"+indexBusqueda).prop("checked")){
								msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorCanalComunicacionSinInformar;
							}else if ($("#radioCanalElectronico_"+indexBusqueda).prop("checked") && $("#canalComunicacionTitularEmail_"+indexBusqueda).val() == ""){
								msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorDatosCanalComunicacionSinInformar;
							}else if ($("#radioCanalPostal_"+indexBusqueda).prop("checked")){
								
								if(!$("#radioEspaniaTitular_"+indexBusqueda).prop("checked") && !$("#radioOtroPaisTitular_"+indexBusqueda).prop("checked")){
									msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorDatosSinInformar;
								}else if ($("#radioEspaniaTitular_"+indexBusqueda).prop("checked") && ($("#provinciaTitular_"+indexBusqueda).val() == "" || $("#municipioTitular_"+indexBusqueda).val() == "" || $("#direccionTitular_"+indexBusqueda).val() == "" || $("#portalTitular_"+indexBusqueda).val() == "" 	    || $("#codPostalTitular_"+indexBusqueda).val() == "")){
									msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorDatosCanalComunicacionSinInformar;
								}else if ($("#radioOtroPaisTitular_"+indexBusqueda).prop("checked") && ($("#otroPaisTitular_"+indexBusqueda).val() == "" || $("#otraDireccionTitular_"+indexBusqueda).val() == "")){
									msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorDatosCanalComunicacionSinInformar;
								}	
							}
							
							if($("#nombreApellidosTitular_"+indexBusqueda).val().trim() == ""){
								msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorNombreApellidosSinInformar;
							}else{
								var nombreApellidos = $("#nombreApellidosTitular_"+indexBusqueda).val().split("-");
								if(nombreApellidos.length == 0 || nombreApellidos.length == 1 || ( nombreApellidos[1] != null && nombreApellidos[1].trim() == "")){
									msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorNombreApellidosSinInformar;
								}	
							}
						}else if((busqueda.datosRepresentante == null || busqueda.datosRepresentante.numeroIdentificacion == null) && !busqueda.datosInteresado.tieneCuentaConConsentimiento){
							
							/**
							 * Para este caso, se validara que el titular tenga el canal seleccionado asi como el radio del pais y los datos de la comunicacion postal si esta estuviera seleccionado
							 * 
							 */
							if(!$("#radioCanalElectronicoEditable_"+indexBusqueda).prop("checked") && !$("#radioCanalPostalEditable_"+indexBusqueda).prop("checked")){
								msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorCanalComunicacionSinInformar;
							}else if ($("#radioCanalElectronicoEditable_"+indexBusqueda).prop("checked") && $("#canalComunicacionTitularEmailEditable_"+indexBusqueda).val() == ""){
								msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorDatosCanalComunicacionSinInformar;
							}else if ($("#radioCanalPostalEditable_"+indexBusqueda).prop("checked")){
								
								if(!$("#radioEspaniaEditable_"+indexBusqueda).prop("checked") && !$("#radioOtroPaisEditable_"+indexBusqueda).prop("checked")){
									msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorDatosSinInformar;
								}else if ($("#radioEspaniaEditable_"+indexBusqueda).prop("checked") && ($("#provinciaHiddenTitularEditable_"+indexBusqueda).val() == "" || $("#municipioHiddenTitularEditable_"+indexBusqueda).val() == "" || $("#direccionTitularEditable_"+indexBusqueda).val() == "" 	 || $("#portalTitularEditable_"+indexBusqueda).val() == "" || $("#codPostalTitularEditable_"+indexBusqueda).val() == "")){
									msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorDatosCanalComunicacionSinInformar;
								}else if ($("#radioOtroPaisEditable_"+indexBusqueda).prop("checked") && ($("#otroPaisHiddenTitularEditable_"+indexBusqueda).val() == "" || $("#otraDireccionTitularEditable_"+indexBusqueda).val() == "")){
									msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorDatosCanalComunicacionSinInformar;
								}	
							}
							
							if($("#nombreApellidosTitular_"+indexBusqueda).val().trim() == ""){
								msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorNombreApellidosSinInformar;
							}else{
								var nombreApellidos = $("#nombreApellidosTitular_"+indexBusqueda).val().split("-");
								if(nombreApellidos.length == 0 || nombreApellidos.length == 1 || ( nombreApellidos[1] != null && nombreApellidos[1].trim() == "")){
									msgError = $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorNombreApellidosSinInformar;
								}	
							}
	
							/**
							 * Si no se ha encontrado ningun error, completaremos / modificaremos los datos almacenados por los nuevos y los añadiremos al array de datos a enviar
							 */
							if(msgError == ""){
								/**
								 * Asignamos los datos de comunicacion ELECTRONICA
								 */
								if($("#radioCanalElectronicoEditable_"+indexBusqueda).prop("checked")){
									busqueda.datosInteresado.canalNotificacion = "ELECTRONICA";
									
									if(document.getElementById("canalComunicacionTitularEmailEditable_"+indexBusqueda)){				
										busqueda.datosInteresado.correo = $("#canalComunicacionTitularEmailEditable_"+indexBusqueda).val();
									}
									if(document.getElementById("canalComunicacionTitularTelefonoEditable_"+indexBusqueda)){				
										busqueda.datosInteresado.telefono = $("#canalComunicacionTitularTelefonoEditable_"+indexBusqueda).val();
									}
									busqueda.datosInteresado.codPais = "";
									busqueda.datosInteresado.pais = "";
									busqueda.datosInteresado.codProvincia = "";
									busqueda.datosInteresado.provincia = "";
									busqueda.datosInteresado.codMunicipio = "";
									busqueda.datosInteresado.municipio = "";
									busqueda.datosInteresado.codLocalidad = "";
									busqueda.datosInteresado.localidad = "";
									busqueda.datosInteresado.direccion = "";
									busqueda.datosInteresado.portal = "";
									busqueda.datosInteresado.escalera = "";
									busqueda.datosInteresado.piso = "";
									busqueda.datosInteresado.letra = "";
									busqueda.datosInteresado.cp = "";
								}else if($("#radioCanalPostalEditable_"+indexBusqueda).prop("checked")){
									busqueda.datosInteresado.canalNotificacion = "CORREO_POSTAL";
									
									/**
									 * Asignamos por si las moscas tanto el correo como el telefono
									 */
									if(document.getElementById("canalComunicacionTitularEmailEditable_"+indexBusqueda)){				
										busqueda.datosInteresado.correo = $("#canalComunicacionTitularEmailEditable_"+indexBusqueda).val();
									}
									if(document.getElementById("canalComunicacionTitularTelefonoEditable_"+indexBusqueda)){				
										busqueda.datosInteresado.telefono = $("#canalComunicacionTitularTelefonoEditable_"+indexBusqueda).val();
									}
									
									/**
									 * Asiganmos los datos de correo postal
									 */
									if($("#radioEspaniaEditable_"+indexBusqueda).prop("checked")){
										
										busqueda.datosInteresado.codPais = "108";
										busqueda.datosInteresado.pais = "";
										
										if(document.getElementById("provinciaHiddenTitularEditable_"+indexBusqueda)){
											busqueda.datosInteresado.codProvincia = document.getElementById("provinciaHiddenTitularEditable_"+indexBusqueda).value;
											if(document.getElementById("provinciaHiddenTitularEditable_"+indexBusqueda).value != ""){
												busqueda.datosInteresado.provincia = $("#provinciaTitularEditable_"+indexBusqueda).rup_combo("label").toUpperCase();
											}
										}else{
											busqueda.datosInteresado.codProvincia = "";
											busqueda.datosInteresado.provincia = "";
										}
										if(document.getElementById("municipioHiddenTitularEditable_"+indexBusqueda)){
											busqueda.datosInteresado.codMunicipio = document.getElementById("municipioHiddenTitularEditable_"+indexBusqueda).value;
											if(document.getElementById("municipioHiddenTitularEditable_"+indexBusqueda).value != ""){
												busqueda.datosInteresado.municipio = $("#municipioTitularEditable_"+indexBusqueda).rup_combo("label").toUpperCase();
											}
										}else{
											busqueda.datosInteresado.codMunicipio = "";
											busqueda.datosInteresado.municipio = "";
										}
										if(document.getElementById("localidadHiddenTitularEditable_"+indexBusqueda)){
											busqueda.datosInteresado.codLocalidad = document.getElementById("localidadHiddenTitularEditable_"+indexBusqueda).value;
											if(document.getElementById("localidadHiddenTitularEditable_"+indexBusqueda).value != ""){
												busqueda.datosInteresado.localidad = $("#localidadTitularEditable_"+indexBusqueda).rup_combo("label").toUpperCase();
											}
										}else{
											busqueda.datosInteresado.codLocalidad = "";
											busqueda.datosInteresado.localidad = "";
										}
										if(document.getElementById("direccionTitularEditable_"+indexBusqueda)){				
											busqueda.datosInteresado.direccion = $("#direccionTitularEditable_"+indexBusqueda).val();
										}else{
											busqueda.datosInteresado.direccion = "";
										}
										if(document.getElementById("portalTitularEditable_"+indexBusqueda)){				
											busqueda.datosInteresado.portal = $("#portalTitularEditable_"+indexBusqueda).val();
										}else{
											busqueda.datosInteresado.portal = "";
										}
										if(document.getElementById("escaleraTitularEditable_"+indexBusqueda)){				
											busqueda.datosInteresado.escalera = $("#escaleraTitularEditable_"+indexBusqueda).val();
										}else{
											busqueda.datosInteresado.escalera = "";
										}
										if(document.getElementById("pisoTitularEditable_"+indexBusqueda)){				
											busqueda.datosInteresado.piso = $("#pisoTitularEditable_"+indexBusqueda).val();
										}else{
											busqueda.datosInteresado.piso = "";
										}
										if(document.getElementById("letraTitularEditable_"+indexBusqueda)){				
											busqueda.datosInteresado.letra = $("#letraTitularEditable_"+indexBusqueda).val();
										}else{
											busqueda.datosInteresado.letra = "";
										}
										if(document.getElementById("codPostalTitularEditable_"+indexBusqueda)){				
											busqueda.datosInteresado.cp = $("#codPostalTitularEditable_"+indexBusqueda).val();
										}else{
											busqueda.datosInteresado.cp = "";
										}	
									}else if($("#radioOtroPaisEditable_"+indexBusqueda).prop("checked")){
										
										busqueda.datosInteresado.codMunicipio = "";
										busqueda.datosInteresado.municipio = "";
										busqueda.datosInteresado.codProvincia = "";
										busqueda.datosInteresado.codLocalidad = "";
										
										if(document.getElementById("otroPaisHiddenTitularEditable_"+indexBusqueda)){
											busqueda.datosInteresado.codPais = document.getElementById("otroPaisHiddenTitularEditable_"+indexBusqueda).value;
											if(document.getElementById("otroPaisHiddenTitularEditable_"+indexBusqueda).value != ""){
												busqueda.datosInteresado.pais = $("#otroPaisTitularEditable_"+indexBusqueda).rup_combo("label").toUpperCase();
											}
										}else{
											busqueda.datosInteresado.codPais = "";
											busqueda.datosInteresado.pais = "";
										}
										if(document.getElementById("otraProvinciaTitularEditable_"+indexBusqueda) && document.getElementById("otraProvinciaTitularEditable_"+indexBusqueda).value != ""){
											busqueda.datosInteresado.provincia = $("#otraProvinciaTitularEditable_"+indexBusqueda).val().toUpperCase();
										}else{
											busqueda.datosInteresado.provincia = "";
										}
										if(document.getElementById("otraLocalidadTitularEditable_"+indexBusqueda) && document.getElementById("otraLocalidadTitularEditable_"+indexBusqueda).value != ""){
											busqueda.datosInteresado.localidad = $("#otraLocalidadTitularEditable_"+indexBusqueda).val().toUpperCase();	
										}else{
											busqueda.datosInteresado.localidad = "";
										}
										if(document.getElementById("otraDireccionTitularEditable_"+indexBusqueda)){				
											busqueda.datosInteresado.direccion = $("#otraDireccionTitularEditable_"+indexBusqueda).val();
										}else{
											busqueda.datosInteresado.direccion = "";
										}
										if(document.getElementById("otroCodPostalTitularEditable_"+indexBusqueda)){				
											busqueda.datosInteresado.cp = $("#otroCodPostalTitularEditable_"+indexBusqueda).val();
										}else{
											busqueda.datosInteresado.cp = "";
										}
										
										busqueda.datosInteresado.portal = "";
										busqueda.datosInteresado.escalera = "";
										busqueda.datosInteresado.letra = "";
										busqueda.datosInteresado.piso = "";
									}
								}			
							}	
						}
					
						/**
						 * Si nos hemos encontrado con algun error, rompemos el for y mostramos los errores
						 */
						if(msgError != ""){
							 return false;
						}
									
						//Se obtiene el idSubTipoParticipacion sea cual sea la parte del if
						busqueda.datosInteresado.idSubTipoParticipacionEnviar = $("#"+indexBusqueda).rup_combo("getRupValue");
						
						datosTitularRepresentante.push(busqueda);
					}
				});	
				
				if(msgError != ""){
					
					desbloquearInterfaz();
					$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback("set", msgError, "alert");
				}else{
					
					var datosLlamada = {
							"tituloExpediente": $("#nuevaModalExpedienteInicioOficioTitulo").val(),
							"datosTitularRepresentante": datosTitularRepresentante
					}
					
					bloquearInterfaz();		
					$.ajax({
						url: "/ab59WebAppWar/propuestasSancion/generarExpedienteInicioOficioDatosInteresado/"+ $("#idPropuestaSancion").val() + "/" +$("#nuevaModalExpedienteInicioOficioComboProcedimiento").val(),
						type: "POST",
						contentType: "application/json",
						dataType: "json",
						data: JSON.stringify(datosLlamada),
						success: function(data){
							desbloquearInterfaz();
							
							if(data != "ok"){
								$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
								$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback("set", data, "error");
							} else {
								sessionStorage.setItem("crearExpedienteInicioOficioOk", true);
								location.reload();
							}
						},
						error: function(){
							desbloquearInterfaz();
							$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
							$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback("set", $.rup.i18n.app.expedienteInicioOficio.creadoError, "error");
						}
					});	
				}
			}
		}		
	});
	
	
	$("#nuevaModalExpedienteInicioOficioComboProcedimiento").rup_combo({
		blank: "",
		source : "/ab59WebAppWar/procedimientos/cargarComboInicioOficio",
		sourceParam : {
			label : "descripcionConCodProcedure",
			value : "idProcedimiento"
		},
		width : 350,
		select: function(){
			$("#contenedorInteresados").html("");
			$("#datosCrearExpedienteInicioOficio").val("");
			consultarDatosInteresado();
		},
		onLoadSuccess : function() {
			if(PROCEDIMIENTO_PRECARGADO){
				$("#nuevaModalExpedienteInicioOficioComboProcedimiento").rup_combo("setRupValue", PROCEDIMIENTO_PRECARGADO);
				$("#nuevaModalExpedienteInicioOficioComboProcedimiento").rup_combo("disable");
			} else {
				$("#nuevaModalExpedienteInicioOficioComboProcedimiento").rup_combo("clear");
			}			
			
		}
	});	
	
	$.ajax({
		type: "GET",
		url: CTX_PATH + "propuestassancion/findPropuestasPendientesMismoTitular/" + $("#idPropuestaSancion").val(),
		contentType: "application/json",
		dataType: 'json',
		success: function(data){
			if(typeof data !== "undefined" && data !== null && data !== ""){
				
				var listaPropuestasSanciones = "<ul id='listaPropuestasSanciones'>" + $.rup.i18n.app.propuestasSancion.existenPropuestasParaMismoAfectado +": ";
				for (var i = 0; i < data.length; i++) {
					listaPropuestasSanciones += "<li><b>"+ data[i].identificadorProSan +":</b> " + data[i].expedienteOrigen.folderNumber + ". " + data[i].expedienteOrigen.titulo + ". "+data[i].estadoProSan.descripcionDecorator+". </li>"
				}
				listaPropuestasSanciones += "</ul>"
				$("#propuestasSancion_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
				$("#propuestasSancion_feedback").rup_feedback("set",listaPropuestasSanciones, "alert");
			}
		},
		error: function(){
			desbloquearInterfaz();
			$("#propuestasSancion_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
			$("#propuestasSancion_feedback").rup_feedback("set", $.rup.i18n.app.feedback.error.errorGenerico, "error");
		}
	});
	
	
	if($("#esExpedienteCerrado").val() === "true"){
		setTimeout(function() { 
			bloquearSancion();
	    }, 500);
	} else {
		setTimeout(function() { 
			desbloquearSancion();
	    }, 500);
	}
});

function cargarNumeroRegistro() {
	
	var nRegistro = "";
	
	if($("#identificadorEstablecimientoUno_detail_table").val() !== "" && $("#identificadorEstablecimientoDos_detail_table").val() !== "" && $("#identificadorEstablecimientoTres_detail_table").val() !== ""){
		nRegistro = $("#identificadorEstablecimientoUno_detail_table").val() + $("#identificadorEstablecimientoDos_detail_table").val() + $("#identificadorEstablecimientoTres_detail_table").val();
	}
	
	return nRegistro;
	
}

function crearInteresadosExpedienteInicioOficio(){
	if($("#datosCrearExpedienteInicioOficio").val() != ""){

		var htmlDatosInteresado = "";
		$.each(JSON.parse($("#datosCrearExpedienteInicioOficio").val()), function(indexBusqueda, busqueda) {
			
			//Creamos el acordeon
			htmlDatosInteresado += '<div id="acordeonTerceros_'+indexBusqueda+'" class="rup_accordion accordion-overflow-hidden cuantosDatosInteresado">'//Apertura del acordeon principal
									+'<h1 class="expandH1_'+indexBusqueda+'" id="expandH1_'+indexBusqueda+'"><a><span> '+($("#listaTipoParticipacion").val().split(",")[indexBusqueda] != '*'?$("#listaTipoParticipacion").val().split(",")[indexBusqueda]:'')+' </span></a>&nbsp;<i class="fa fa-edit iconoDerecha" aria-hidden="true"></i></h1>'
									+'<div class="form-group accordion_height_auto">'//Apertura del contenido del acordeon principal
										+'<fieldset id="fieldsetInteresado_'+indexBusqueda+'" class="rup-table-filter-fieldset">'//Apertura del fieldset
											+'<legend class="legendExpInicioOficio">'+ $.rup.i18n.app.modalCrearExpedienteInicioOficio.datosDelTitular +'</legend>'
											+'<div class="panel panel-default">'//Apertura del panel
												+'<div class="panel-body">';//Apertura del panel body
												
												if(busqueda.datosRepresentante != null && busqueda.datosRepresentante.numeroIdentificacion != null){			
													htmlDatosInteresado += '<div class="row">';
														htmlDatosInteresado += '<div class="col-xs-9 form-group"><label for="nombreApellidosTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.nombreApellidos+'</label><br><input type="text" id="nombreApellidosTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.numeroIdentificacion!=null?busqueda.datosInteresado.numeroIdentificacion+' - ':'')+''+(busqueda.datosInteresado.nombre!=null?busqueda.datosInteresado.nombre:'')+' '+(busqueda.datosInteresado.apellido1!=null?busqueda.datosInteresado.apellido1:'')+' '+(busqueda.datosInteresado.apellido2!=null?busqueda.datosInteresado.apellido2:'')+'" /></div>';
														htmlDatosInteresado += '<div class="col-xs-3 form-group"><label for="rolParticipanteTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.rolParticipanteExpediente+'</label><br><input type="text" id="'+indexBusqueda+'" class="rolTitularModalEnviar form-control"/></div>';
													htmlDatosInteresado +='</div>';
													
													htmlDatosInteresado +='<div class="row">&nbsp;</div>'; 
													htmlDatosInteresado +='<fieldset id="fieldsetRepresentante_'+indexBusqueda+'" class="rup-table-filter-fieldset">';//Apertura del fieldset
														htmlDatosInteresado +='<legend class="legendExpInicioOficio">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.datosDelRepresentante+'</legend>';
														htmlDatosInteresado +='<div class="panel panel-default">';//Apertura del panel
															htmlDatosInteresado +='<div class="panel-body">'; //Apertura del panel body
															
																htmlDatosInteresado +='<div class="row">';
																	htmlDatosInteresado +='<div class="col-xs-9 form-group"><label for="nombreApellidosRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.nombreApellidos+'</label><br><input type="text" id="nombreApellidosRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.numeroIdentificacion!=null?busqueda.datosRepresentante.numeroIdentificacion+' - ':'')+''+(busqueda.datosRepresentante.nombre!=null?busqueda.datosRepresentante.nombre:'')+' '+(busqueda.datosRepresentante.apellido1!=null?busqueda.datosRepresentante.apellido1:'')+' '+(busqueda.datosRepresentante.apellido2!=null?busqueda.datosRepresentante.apellido2:'')+'" /></div>';
																	if(busqueda.datosRepresentante.descIdioma != null && busqueda.datosRepresentante.descIdioma == "ES"){											
																		htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="idiomaRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idioma+'</label><br><input type="text" id="idiomaRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idiomaCastellano+'" /></div>';
																	}else if(busqueda.datosRepresentante.descIdioma != null && busqueda.datosRepresentante.descIdioma == "EU"){	
																		htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="idiomaRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idioma+'</label><br><input type="text" id="idiomaRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idiomaEuskera+'" /></div>';
																	}else if(busqueda.datosRepresentante.descIdioma != null && busqueda.datosRepresentante.descIdioma == "BI"){	
																		htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="idiomaRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idioma+'</label><br><input type="text" id="idiomaRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idiomaBilingue+'" /></div>';
																	}else if(busqueda.datosRepresentante.descIdioma != null && busqueda.datosRepresentante.descIdioma == "NA"){	
																		htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="idiomaRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idioma+'</label><br><input type="text" id="idiomaRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idiomaNa+'" /></div>';
																	}
																htmlDatosInteresado +='</div>';
																
																htmlDatosInteresado +='<div class="row">';
																	htmlDatosInteresado += '<div class="col-xs-3 form-group">';
																		htmlDatosInteresado += '<label>'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.tipoCanalComunicacion+'</label><br />';
																			if(busqueda.datosRepresentante.canalNotificacion!= null && busqueda.datosRepresentante.canalNotificacion == 'ELECTRONICA'){
																				htmlDatosInteresado +='<input id="radioCanalElectronicoRepresentante_'+indexBusqueda+'" type="radio" class="radioCanalRepresentante" name="canalComunicacionRepresentante_'+indexBusqueda+'" checked disabled/>';
																				htmlDatosInteresado +='<label for="radioCanalElectronicoRepresentante_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalElectronica+'</label>&nbsp;&nbsp;';
																				htmlDatosInteresado +='<input id="radioCanalPostalRepresentante_'+indexBusqueda+'" type="radio" class="radioCanalRepresentante" name="canalComunicacionRepresentante_'+indexBusqueda+'" disabled/>';
																				htmlDatosInteresado +='<label for="radioCanalPostalRepresentante_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalPostal+'</label>';
																			}else if(busqueda.datosRepresentante.canalNotificacion!= null && busqueda.datosRepresentante.canalNotificacion == 'CORREO_POSTAL'){
																				htmlDatosInteresado +='<input id="radioCanalElectronicoRepresentante_'+indexBusqueda+'" type="radio" class="radioCanalRepresentante" name="canalComunicacionRepresentante_'+indexBusqueda+'" disabled/>';
																				htmlDatosInteresado +='<label for="radioCanalElectronicoRepresentante_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalElectronica+'</label>&nbsp;&nbsp;';
																				htmlDatosInteresado +='<input id="radioCanalPostalRepresentante_'+indexBusqueda+'" type="radio" class="radioCanalRepresentante" name="canalComunicacionRepresentante_'+indexBusqueda+'" checked disabled/>';
																				htmlDatosInteresado +='<label for="radioCanalPostalRepresentante_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalPostal+'</label>';
																			}else {
																				htmlDatosInteresado +='<input id="radioCanalElectronicoRepresentante_'+indexBusqueda+'" type="radio" class="radioCanalRepresentante" name="canalComunicacionRepresentante_'+indexBusqueda+'" disabled/>';
																				htmlDatosInteresado +='<label for="radioCanalElectronicoRepresentante_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalElectronica+'</label>&nbsp;&nbsp;';
																				htmlDatosInteresado +='<input id="radioCanalPostalRepresentante_'+indexBusqueda+'" type="radio" class="radioCanalRepresentante" name="canalComunicacionRepresentante_'+indexBusqueda+'" disabled/>';
																				htmlDatosInteresado +='<label for="radioCanalPostalRepresentante_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalPostal+'</label>';
																			}
																		htmlDatosInteresado +='</div>';
																		
																		//Para indicar si es requerido el email dependiendo del canal
																		if(busqueda.datosRepresentante.canalNotificacion!= null && busqueda.datosRepresentante.canalNotificacion == 'ELECTRONICA'){
																			htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="emailRepresentante_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.email+'</label><br><input type="text" id="emailRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.correo!=null?busqueda.datosRepresentante.correo:'')+'" /></div>';
																		}else{
																			htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="emailRepresentante_'+indexBusqueda+'" >'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.email+'</label><br><input type="text" id="emailRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.correo!=null?busqueda.datosRepresentante.correo:'')+'" /></div>';
																		}
																		htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="telefonoRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.telefono+'</label><br><input type="text" id="telefonoRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.telefono!=null?busqueda.datosRepresentante.telefono:'')+'" /></div>';
																htmlDatosInteresado +='</div>';
																
																//Validamos si tiene un tipo de comunicacion de CORREO POSTAL para mostrar el acordeon correspondiente
																if(busqueda.datosRepresentante.canalNotificacion!= null && busqueda.datosRepresentante.canalNotificacion == 'CORREO_POSTAL'){
																	htmlDatosInteresado += '<div id="acordeonDomicilioRepresentante_'+indexBusqueda+'" class="rup_accordion">';			
																		htmlDatosInteresado +='<h1 class="divDomicilioRepresentante_'+indexBusqueda+'"><a>'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.datosDelDomicilio+'</a></h1>';
																		htmlDatosInteresado +='<div class="form-group accordion_height_auto divDomicilioRepresentante">';
																			
																			htmlDatosInteresado += '<div class="row">';	
																				htmlDatosInteresado += '<div class="col-xs-3 form-group">';
																					if(busqueda.datosRepresentante.codPais!= null && (busqueda.datosRepresentante.codPais == 0 || busqueda.datosRepresentante.codPais == 108)){
																						htmlDatosInteresado +='<input id="radioEspaniaRepresentante_'+indexBusqueda+'" type="radio" class="radioPaisRepresentante" name="paisRepresentante_'+indexBusqueda+'" checked disabled/>';
																						htmlDatosInteresado +='<label for="radioEspaniaRepresentante_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.espania+'</label>&nbsp;&nbsp;';
																						htmlDatosInteresado +='<input id="radioOtroPaisRepresentante_'+indexBusqueda+'" type="radio" class="radioPaisRepresentante" name="paisRepresentante_'+indexBusqueda+'" disabled/>';
																						htmlDatosInteresado +='<label for="radioOtroPaisRepresentante_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.otroPais+'</label>';
																					}else if(busqueda.datosRepresentante.codPais!= null && busqueda.datosRepresentante.codPais != 0 && busqueda.datosRepresentante.codPais != 108){
																						htmlDatosInteresado +='<input id="radioEspaniaRepresentante_'+indexBusqueda+'" type="radio" class="radioPaisRepresentante" name="paisRepresentante_'+indexBusqueda+'" disabled/>';
																						htmlDatosInteresado +='<label for="radioEspaniaRepresentante_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.espania+'</label>&nbsp;&nbsp;';
																						htmlDatosInteresado +='<input id="radioOtroPaisRepresentante_'+indexBusqueda+'" type="radio" class="radioPaisRepresentante" name="paisRepresentante_'+indexBusqueda+'" checked disabled/>';
																						htmlDatosInteresado +='<label for="radioOtroPaisRepresentante_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.otroPais+'</label>';
																					}else {
																						htmlDatosInteresado +='<input id="radioEspaniaRepresentante_'+indexBusqueda+'" type="radio" class="radioPaisRepresentante" name="paisRepresentante_'+indexBusqueda+'" disabled/>';
																						htmlDatosInteresado +='<label for="radioEspaniaRepresentante_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.espania+'</label>&nbsp;&nbsp;';
																						htmlDatosInteresado +='<input id="radioOtroPaisRepresentante_'+indexBusqueda+'" type="radio" class="radioPaisRepresentante" name="paisRepresentante_'+indexBusqueda+'" disabled/>';
																						htmlDatosInteresado +='<label for="radioOtroPaisRepresentante_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.otroPais+'</label>';
																					}
																				htmlDatosInteresado +='</div>';
																			htmlDatosInteresado +='</div>';
																		
																			if(busqueda.datosRepresentante.codPais!= null && busqueda.datosRepresentante.codPais != 0 && busqueda.datosRepresentante.codPais != 108){	
																			
																				htmlDatosInteresado +='<div class="row">'
																					htmlDatosInteresado +='<div class="col-xs-4 form-group">'
																						htmlDatosInteresado +='<label for="otroPaisRepresentante_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.pais+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="otroPaisRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.pais != null?busqueda.datosRepresentante.pais:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																					htmlDatosInteresado +='<div class="col-xs-4 form-group">';
																						htmlDatosInteresado +='<label for="otraProvinciaRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.provincia+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="otraProvinciaRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.provincia!=null?busqueda.datosRepresentante.provincia:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																					htmlDatosInteresado +='<div class="col-xs-4 form-group">';
																						htmlDatosInteresado +='<label for="otraLocalidadRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.ciudad+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="otraLocalidadRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.localidad!=null?busqueda.datosRepresentante.localidad:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																				htmlDatosInteresado +='</div>';
																				htmlDatosInteresado +='<div class="row">';
																					htmlDatosInteresado +='<div class="col-xs-5 form-group">';
																						htmlDatosInteresado +='<label for="otraDireccionRepresentante_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.direccion+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="otraDireccionRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.direccion!=null?busqueda.datosRepresentante.direccion:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																					htmlDatosInteresado +='<div class="col-xs-2 form-group">';
																						htmlDatosInteresado +='<label for="otroCodPostalRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.cp+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="otroCodPostalRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.cp!=null?busqueda.datosRepresentante.cp:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																				htmlDatosInteresado +='</div>';
																			}
																			
																			if(busqueda.datosRepresentante.codPais!= null && (busqueda.datosRepresentante.codPais == 0 || busqueda.datosRepresentante.codPais == 108)){
																				htmlDatosInteresado +='<div class="row">';
																					htmlDatosInteresado +='<div class="col-xs-4 form-group">';
																						htmlDatosInteresado +='<label for="provinciaRepresentante_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.provincia+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="provinciaRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.provincia != null?busqueda.datosRepresentante.provincia:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																					htmlDatosInteresado +='<div class="col-xs-4 form-group">';
																						htmlDatosInteresado +='<label for="municipioRepresentante_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.municipio+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="municipioRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.municipio!=null?busqueda.datosRepresentante.municipio:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																					htmlDatosInteresado +='<div class="col-xs-4 form-group">';
																						htmlDatosInteresado +='<label for="localidadRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.localidad+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="localidadRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.localidad!=null?busqueda.datosRepresentante.localidad:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																				htmlDatosInteresado +='</div>';
																				htmlDatosInteresado +='<div class="row">';
																					htmlDatosInteresado +='<div class="col-xs-5 form-group">';
																						htmlDatosInteresado +='<label for="direccionRepresentante_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.direccion+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="direccionRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.direccion!=null?busqueda.datosRepresentante.direccion:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																					htmlDatosInteresado +='<div class="col-xs-1 form-group">';
																						htmlDatosInteresado +='<label for="portalRepresentante_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.numero+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="portalRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.portal!=null?busqueda.datosRepresentante.portal:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																					htmlDatosInteresado +='<div class="col-xs-1 form-group">';
																						htmlDatosInteresado +='<label for="escaleraRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.escalera+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="escaleraRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.escalera!=null?busqueda.datosRepresentante.escalera:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																					htmlDatosInteresado +='<div class="col-xs-1 form-group">';
																						htmlDatosInteresado +='<label for="pisoRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.piso+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="pisoRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.piso!=null?busqueda.datosRepresentante.piso:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																					htmlDatosInteresado +='<div class="col-xs-1 form-group">';
																						htmlDatosInteresado +='<label for="letraRepresentante_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.letra+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="letraRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.letra!=null?busqueda.datosRepresentante.letra:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																					htmlDatosInteresado +='<div class="col-xs-2 form-group">';
																						htmlDatosInteresado +='<label for="codPostalRepresentante_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.cp+'</label><br>';
																						htmlDatosInteresado +='<input type="text" id="codPostalRepresentante_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosRepresentante.cp!=null?busqueda.datosRepresentante.cp:'')+'"/>';
																					htmlDatosInteresado +='</div>';
																				htmlDatosInteresado +='</div>';
																			}
																		htmlDatosInteresado +='</div>';
																	htmlDatosInteresado +='</div>';
																}
															htmlDatosInteresado +='</div>';//Cierre del panel body
														htmlDatosInteresado +='</div>';//Cierre del panel
													htmlDatosInteresado +='</fieldset>';//Cierre del fieldset	
												}else if((busqueda.datosRepresentante == null || busqueda.datosRepresentante.numeroIdentificacion == null) && busqueda.datosInteresado.tieneCuentaConConsentimiento){
													htmlDatosInteresado += '<div class="row">';
														htmlDatosInteresado += '<div class="col-xs-9 form-group"><label for="nombreApellidosTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.nombreApellidos+'</label><br><input type="text" id="nombreApellidosTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.numeroIdentificacion!=null?busqueda.datosInteresado.numeroIdentificacion+' - ':'')+''+(busqueda.datosInteresado.nombre!=null?busqueda.datosInteresado.nombre:'')+' '+(busqueda.datosInteresado.apellido1!=null?busqueda.datosInteresado.apellido1:'')+' '+(busqueda.datosInteresado.apellido2!=null?busqueda.datosInteresado.apellido2:'')+'" /></div>';
														htmlDatosInteresado += '<div class="col-xs-3 form-group"><label for="rolParticipanteTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.rolParticipanteExpediente+'</label><br><input type="text" id="'+indexBusqueda+'" class="rolTitularModalEnviar form-control"/></div>';
													htmlDatosInteresado +='</div>';
													htmlDatosInteresado += '<div class="row">';
														htmlDatosInteresado += '<div class="col-xs-3 form-group">';
															htmlDatosInteresado += '<label>'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.tipoCanalComunicacion+'</label><br />';
															if(busqueda.datosInteresado.canalNotificacion!= null && busqueda.datosInteresado.canalNotificacion == 'ELECTRONICA'){
																htmlDatosInteresado +='<input id="radioCanalElectronico_'+indexBusqueda+'" type="radio" class="radioCanal" name="canalComunicacion_'+indexBusqueda+'" checked disabled/>';
																htmlDatosInteresado +='<label for="radioCanalElectronico_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalElectronica+'</label>&nbsp;&nbsp;';
																htmlDatosInteresado +='<input id="radioCanalPostal_'+indexBusqueda+'" type="radio" class="radioCanal" name="canalComunicacion_'+indexBusqueda+'" disabled/>';
																htmlDatosInteresado +='<label for="radioCanalPostal_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalPostal+'</label>';
															}else if(busqueda.datosInteresado.canalNotificacion!= null && busqueda.datosInteresado.canalNotificacion == 'CORREO_POSTAL'){
																htmlDatosInteresado +='<input id="radioCanalElectronico_'+indexBusqueda+'" type="radio" class="radioCanal" name="canalComunicacion_'+indexBusqueda+'" disabled/>';
																htmlDatosInteresado +='<label for="radioCanalElectronico_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalElectronica+'</label>&nbsp;&nbsp;';
																htmlDatosInteresado +='<input id="radioCanalPostal_'+indexBusqueda+'" type="radio" class="radioCanal" name="canalComunicacion_'+indexBusqueda+'" checked disabled/>';
																htmlDatosInteresado +='<label for="radioCanalPostal_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalPostal+'</label>';
															}else {
																htmlDatosInteresado +='<input id="radioCanalElectronico_'+indexBusqueda+'" type="radio" class="radioCanal" name="canalComunicacion_'+indexBusqueda+'" disabled/>';
																htmlDatosInteresado +='<label for="radioCanalElectronico_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalElectronica+'</label>&nbsp;&nbsp;';
																htmlDatosInteresado +='<input id="radioCanalPostal_'+indexBusqueda+'" type="radio" class="radioCanal" name="canalComunicacion_'+indexBusqueda+'" disabled/>';
																htmlDatosInteresado +='<label for="radioCanalPostal_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalPostal+'</label>';
															}
														htmlDatosInteresado +='</div>';
														
														//Para indicar si es requerido el email o no dependiendo del canal
														if(busqueda.datosInteresado.canalNotificacion!= null && busqueda.datosInteresado.canalNotificacion == 'ELECTRONICA'){
															htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="canalComunicacionTitularEmail_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.email+'</label><br><input type="text" id="canalComunicacionTitularEmail_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.correo != null ?busqueda.datosInteresado.correo:'')+'" /></div>';
														}else {
															htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="canalComunicacionTitularEmail_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.email+'</label><br><input type="text" id="canalComunicacionTitularEmail_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.correo != null ?busqueda.datosInteresado.correo:'')+'" /></div>';
														}
														htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="canalComunicacionTitularTelefono_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.telefono+'</label><br><input type="text" id="canalComunicacionTitularTelefono_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.telefono != null ?busqueda.datosInteresado.telefono:'')+'" /></div>';
														if(busqueda.datosInteresado.descIdioma != null && busqueda.datosInteresado.descIdioma == "ES"){											
															htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="idiomaTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idioma+'</label><br><input type="text" id="idiomaTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idiomaCastellano+'" /></div>';
														}else if(busqueda.datosInteresado.descIdioma != null && busqueda.datosInteresado.descIdioma == "EU"){	
															htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="idiomaTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idioma+'</label><br><input type="text" id="idiomaTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idiomaEuskera+'" /></div>';
														}else if(busqueda.datosInteresado.descIdioma != null && busqueda.datosInteresado.descIdioma == "BI"){	
															htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="idiomaTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idioma+'</label><br><input type="text" id="idiomaTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idiomaBilingue+'" /></div>';
														}else if(busqueda.datosInteresado.descIdioma != null && busqueda.datosInteresado.descIdioma == "NA"){	
															htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="idiomaTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idioma+'</label><br><input type="text" id="idiomaTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idiomaNa+'" /></div>';
														}		
													htmlDatosInteresado +='</div>';
													if(busqueda.datosInteresado.canalNotificacion!= null && busqueda.datosInteresado.canalNotificacion == 'CORREO_POSTAL'){
														htmlDatosInteresado += '<div id="acordeonDomicilioTitular_'+indexBusqueda+'" class="rup_accordion">';			
															htmlDatosInteresado += '<h1 class="divDomicilioTitular_'+indexBusqueda+'"><a>'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.datosDelDomicilio+'</a></h1>';
															htmlDatosInteresado += '<div class="form-group accordion_height_auto divDomicilioTitular">';	
																	
															htmlDatosInteresado += '<div class="row">';	
																htmlDatosInteresado += '<div class="col-xs-3 form-group">';
																	if(busqueda.datosInteresado.codPais!= null && (busqueda.datosInteresado.codPais == 0 || busqueda.datosInteresado.codPais == 108)){
																		htmlDatosInteresado +='<input id="radioEspaniaTitular_'+indexBusqueda+'" type="radio" class="radioPaisTitular" name="paisTitular_'+indexBusqueda+'" checked disabled/>';
																		htmlDatosInteresado +='<label for="radioEspaniaTitular_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.espania+'</label>&nbsp;&nbsp;';
																		htmlDatosInteresado +='<input id="radioOtroPaisTitular_'+indexBusqueda+'" type="radio" class="radioPaisTitular" name="paisTitular_'+indexBusqueda+'" disabled/>';
																		htmlDatosInteresado +='<label for="radioOtroPaisTitular_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.otroPais+'</label>';
																	}else if(busqueda.datosInteresado.codPais!= null && busqueda.datosInteresado.codPais != 0 && busqueda.datosInteresado.codPais != 108){
																		htmlDatosInteresado +='<input id="radioEspaniaTitular_'+indexBusqueda+'" type="radio" class="radioPaisTitular" name="paisTitular_'+indexBusqueda+'" disabled/>';
																		htmlDatosInteresado +='<label for="radioEspaniaTitular_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.espania+'</label>&nbsp;&nbsp;';
																		htmlDatosInteresado +='<input id="radioOtroPaisTitular_'+indexBusqueda+'" type="radio" class="radioPaisTitular" name="paisTitular_'+indexBusqueda+'" checked disabled/>';
																		htmlDatosInteresado +='<label for="radioOtroPaisTitular_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.otroPais+'</label>';
																	}else{
																		htmlDatosInteresado +='<input id="radioEspaniaTitular_'+indexBusqueda+'" type="radio" class="radioPaisTitular" name="paisTitular_'+indexBusqueda+'" disabled/>';
																		htmlDatosInteresado +='<label for="radioEspaniaTitular_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.espania+'</label>&nbsp;&nbsp;';
																		htmlDatosInteresado +='<input id="radioOtroPaisTitular_'+indexBusqueda+'" type="radio" class="radioPaisTitular" name="paisTitular_'+indexBusqueda+'" disabled/>';
																		htmlDatosInteresado +='<label for="radioOtroPaisTitular_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.otroPais+'</label>';
																	}
																htmlDatosInteresado +='</div>';
															htmlDatosInteresado +='</div>';
															
															if(busqueda.datosInteresado.codPais!= null && busqueda.datosInteresado.codPais != 0 && busqueda.datosInteresado.codPais != 108){	
																htmlDatosInteresado += '<div class="row">';
																	htmlDatosInteresado += '<div class="col-xs-4 form-group">';
																		htmlDatosInteresado += '<label for="otroPaisTitular_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.pais+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="otroPaisTitular_'+indexBusqueda+'" readonly="readonly" value="'+(busqueda.datosInteresado.pais!=null?busqueda.datosInteresado.pais:'')+'" />';
																	htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '<div class="col-xs-4 form-group">';
																		htmlDatosInteresado += '<label for="otraProvinciaTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.provincia+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="otraProvinciaTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.provincia!=null?busqueda.datosInteresado.provincia:'')+'" />';
																	htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '<div class="col-xs-4 form-group">';
																		htmlDatosInteresado += '<label for="otraLocalidadTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.ciudad+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="otraLocalidadTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.localidad!=null?busqueda.datosInteresado.localidad:'')+'" />';
																	htmlDatosInteresado += '</div>';
																htmlDatosInteresado += '</div>';
																htmlDatosInteresado += '<div class="row">';
																	htmlDatosInteresado += '<div class="col-xs-5 form-group">';
																		htmlDatosInteresado += '<label for="otraDireccionTitular_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.direccion+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="otraDireccionTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.direccion!=null?busqueda.datosInteresado.direccion:'')+'" />';
																	htmlDatosInteresado += '</div>';	
																	htmlDatosInteresado += '<div class="col-xs-2 form-group">';
																		htmlDatosInteresado += '<label for="otroCodPostalTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.cp+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="otroCodPostalTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.cp!=null?busqueda.datosInteresado.cp:'')+'"/>';
																	htmlDatosInteresado += '</div>';
																htmlDatosInteresado += '</div>';
															}
															
															if(busqueda.datosInteresado.codPais!= null && (busqueda.datosInteresado.codPais == 0 || busqueda.datosInteresado.codPais == 108)){
																htmlDatosInteresado += '<div class="row">';
																	htmlDatosInteresado += '<div class="col-xs-4 form-group">';
																		htmlDatosInteresado += '<label for="provinciaTitular_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.provincia+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="provinciaTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.provincia != null?busqueda.datosInteresado.provincia:'')+'"/>';
																	htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '<div class="col-xs-4 form-group">';
																		htmlDatosInteresado += '<label for="municipioTitular_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.municipio+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="municipioTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.municipio!=null?busqueda.datosInteresado.municipio:'')+'"/>';
																	htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '<div class="col-xs-4 form-group">';
																		htmlDatosInteresado += '<label for="localidadTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.localidad+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="localidadTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.localidad!=null?busqueda.datosInteresado.localidad:'')+'"/>';
																	htmlDatosInteresado += '</div>';
																htmlDatosInteresado += '</div>';
																htmlDatosInteresado += '<div class="row">';
																	htmlDatosInteresado += '<div class="col-xs-5 form-group">';
																		htmlDatosInteresado += '<label for="direccionTitular_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.direccion+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="direccionTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.direccion!=null?busqueda.datosInteresado.direccion:'')+'"/>';
																	htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '<div class="col-xs-1 form-group">';
																		htmlDatosInteresado += '<label for="portalTitular_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.numero+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="portalTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.portal!=null?busqueda.datosInteresado.portal:'')+'"/>';
																	htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '<div class="col-xs-1 form-group">';
																		htmlDatosInteresado += '<label for="escaleraTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.escalera+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="escaleraTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.escalera!=null?busqueda.datosInteresado.escalera:'')+'"/>';
																	htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '<div class="col-xs-1 form-group">';
																		htmlDatosInteresado += '<label for="pisoTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.piso+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="pisoTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.piso!=null?busqueda.datosInteresado.piso:'')+'"/>';
																	htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '<div class="col-xs-1 form-group">';
																		htmlDatosInteresado += '<label for="letraTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.letra+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="letraTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.letra!=null?busqueda.datosInteresado.letra:'')+'"/>';
																	htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '<div class="col-xs-2 form-group">';
																		htmlDatosInteresado += '<label for="codPostalTitular_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.cp+'</label><br>';
																		htmlDatosInteresado += '<input type="text" id="codPostalTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.cp!=null?busqueda.datosInteresado.cp:'')+'"/>';
																	htmlDatosInteresado += '</div>';
																htmlDatosInteresado += '</div>';
															}
															htmlDatosInteresado += '</div>';
														htmlDatosInteresado += '</div>';
													}
												}else if((busqueda.datosRepresentante == null || busqueda.datosRepresentante.numeroIdentificacion == null) && !busqueda.datosInteresado.tieneCuentaConConsentimiento){
													htmlDatosInteresado += '<div class="row">';
														htmlDatosInteresado += '<div class="col-xs-9 form-group"><label for="nombreApellidosTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.nombreApellidos+'</label><br><input type="text" id="nombreApellidosTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+(busqueda.datosInteresado.numeroIdentificacion!=null?busqueda.datosInteresado.numeroIdentificacion+' - ':'')+''+(busqueda.datosInteresado.nombre!=null?busqueda.datosInteresado.nombre:'')+' '+(busqueda.datosInteresado.apellido1!=null?busqueda.datosInteresado.apellido1:'')+' '+(busqueda.datosInteresado.apellido2!=null?busqueda.datosInteresado.apellido2:'')+'" /></div>';
														htmlDatosInteresado += '<div class="col-xs-3 form-group"><label for="rolParticipanteTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.rolParticipanteExpediente+'</label><br><input type="text" id="'+indexBusqueda+'" class="rolTitularModalEnviar form-control"/></div>';
													htmlDatosInteresado +='</div>';
													htmlDatosInteresado += '<div class="row">';
														htmlDatosInteresado += '<div class="col-xs-3 form-group">';
															htmlDatosInteresado += '<label>'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.tipoCanalComunicacion+'</label><br />';
															if(busqueda.datosInteresado.canalNotificacion!= null && busqueda.datosInteresado.canalNotificacion == 'ELECTRONICA'){
																htmlDatosInteresado +='<input id="radioCanalElectronicoEditable_'+indexBusqueda+'" type="radio" class="radioCanalEditable" name="canalComunicacionEditable_'+indexBusqueda+'" checked/>';
																htmlDatosInteresado +='<label for="radioCanalElectronicoEditable_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalElectronica+'</label>&nbsp;&nbsp;';
																htmlDatosInteresado +='<input id="radioCanalPostalEditable_'+indexBusqueda+'" type="radio" class="radioCanalEditable" name="canalComunicacionEditable_'+indexBusqueda+'"/>';
																htmlDatosInteresado +='<label for="radioCanalPostalEditable_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalPostal+'</label>';
															}else if(busqueda.datosInteresado.canalNotificacion!= null && busqueda.datosInteresado.canalNotificacion == 'CORREO_POSTAL'){
																htmlDatosInteresado +='<input id="radioCanalElectronicoEditable_'+indexBusqueda+'" type="radio" class="radioCanalEditable" name="canalComunicacionEditable_'+indexBusqueda+'"/>';
																htmlDatosInteresado +='<label for="radioCanalElectronicoEditable_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalElectronica+'</label>&nbsp;&nbsp;';
																htmlDatosInteresado +='<input id="radioCanalPostalEditable_'+indexBusqueda+'" type="radio" class="radioCanalEditable" name="canalComunicacionEditable_'+indexBusqueda+'" checked/>';
																htmlDatosInteresado +='<label for="radioCanalPostalEditable_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalPostal+'</label>';
															}else {
																htmlDatosInteresado +='<input id="radioCanalElectronicoEditable_'+indexBusqueda+'" type="radio" class="radioCanalEditable" name="canalComunicacionEditable_'+indexBusqueda+'"/>';
																htmlDatosInteresado +='<label for="radioCanalElectronicoEditable_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalElectronica+'</label>&nbsp;&nbsp;';
																htmlDatosInteresado +='<input id="radioCanalPostalEditable_'+indexBusqueda+'" type="radio" class="radioCanalEditable" name="canalComunicacionEditable_'+indexBusqueda+'" />';
																htmlDatosInteresado +='<label for="radioCanalPostalEditable_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.canalPostal+'</label>';
															}
														htmlDatosInteresado +='</div>';
														
														//Para indicar si es requerido el email o no dependiendo del canal
														if(busqueda.datosInteresado.canalNotificacion!= null && busqueda.datosInteresado.canalNotificacion == 'ELECTRONICA'){
															htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="canalComunicacionTitularEmailEditable_'+indexBusqueda+'" id="labelCanalComunicacionTitularEmailEditable_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.email+'</label><br><input type="text" id="canalComunicacionTitularEmailEditable_'+indexBusqueda+'" class="form-control" maxlength="50" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.correo != null ?busqueda.datosInteresado.correo:'')+'" /></div>';
														}else{
															htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="canalComunicacionTitularEmailEditable_'+indexBusqueda+'" id="labelCanalComunicacionTitularEmailEditable_'+indexBusqueda+'" >'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.email+'</label><br><input type="text" id="canalComunicacionTitularEmailEditable_'+indexBusqueda+'" class="form-control" maxlength="50" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.correo != null ?busqueda.datosInteresado.correo:'')+'" /></div>';
														}
														htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="canalComunicacionTitularTelefonoEditable_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.telefono+'</label><br><input type="text" id="canalComunicacionTitularTelefonoEditable_'+indexBusqueda+'" class="form-control" maxlength="9" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.telefono != null ?busqueda.datosInteresado.telefono:'')+'" /></div>';
														if(busqueda.datosInteresado.descIdioma != null && busqueda.datosInteresado.descIdioma == "ES"){											
															htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="idiomaTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idioma+'</label><br><input type="text" id="idiomaTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idiomaCastellano+'" /></div>';
														}else if(busqueda.datosInteresado.descIdioma != null && busqueda.datosInteresado.descIdioma == "EU"){	
															htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="idiomaTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idioma+'</label><br><input type="text" id="idiomaTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idiomaEuskera+'" /></div>';
														}else if(busqueda.datosInteresado.descIdioma != null && busqueda.datosInteresado.descIdioma == "BI"){	
															htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="idiomaTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idioma+'</label><br><input type="text" id="idiomaTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idiomaBilingue+'" /></div>';
														}else if(busqueda.datosInteresado.descIdioma != null && busqueda.datosInteresado.descIdioma == "NA"){	
															htmlDatosInteresado +='<div class="col-xs-3 form-group"><label for="idiomaTitular_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idioma+'</label><br><input type="text" id="idiomaTitular_'+indexBusqueda+'" class="form-control" readonly="readonly" value="'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.idiomaNa+'" /></div>';
														}		
													htmlDatosInteresado +='</div>';

														htmlDatosInteresado += '<div id="acordeonDomicilioTitular_'+indexBusqueda+'" class="rup_accordion">';			
															htmlDatosInteresado += '<h1 class="divDomicilioTitular_'+indexBusqueda+'"><a>'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.datosDelDomicilio+'</a></h1>';
																htmlDatosInteresado += '<div class="form-group accordion_height_auto divDomicilioTitularEditable" id="divDomicilioTitularEditable_'+indexBusqueda+'">';	
																	
																htmlDatosInteresado += '<div class="row">';	
																	htmlDatosInteresado += '<div class="col-xs-3 form-group">';
																		if(busqueda.datosInteresado.codPais!= null && (busqueda.datosInteresado.codPais == 0 || busqueda.datosInteresado.codPais == 108)){
																			htmlDatosInteresado +='<input id="radioEspaniaEditable_'+indexBusqueda+'" type="radio" class="radioPaisEditable" name="paisEditable_'+indexBusqueda+'" checked/>';
																			htmlDatosInteresado +='<label for="radioEspaniaEditable_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.espania+'</label>&nbsp;&nbsp;';
																			htmlDatosInteresado +='<input id="radioOtroPaisEditable_'+indexBusqueda+'" type="radio" class="radioPaisEditable" name="paisEditable_'+indexBusqueda+'"/>';
																			htmlDatosInteresado +='<label for="radioOtroPaisEditable_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.otroPais+'</label>';
																		}else if(busqueda.datosInteresado.codPais!= null && busqueda.datosInteresado.codPais != 0 && busqueda.datosInteresado.codPais != 108){
																			htmlDatosInteresado +='<input id="radioEspaniaEditable_'+indexBusqueda+'" type="radio" class="radioPaisEditable" name="paisEditable_'+indexBusqueda+'"/>';
																			htmlDatosInteresado +='<label for="radioEspaniaEditable_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.espania+'</label>&nbsp;&nbsp;';
																			htmlDatosInteresado +='<input id="radioOtroPaisEditable_'+indexBusqueda+'" type="radio" class="radioPaisEditable" name="paisEditable_'+indexBusqueda+'" checked/>';
																			htmlDatosInteresado +='<label for="radioOtroPaisEditable_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.otroPais+'</label>';
																		}else{
																			htmlDatosInteresado +='<input id="radioEspaniaEditable_'+indexBusqueda+'" type="radio" class="radioPaisEditable" name="paisEditable_'+indexBusqueda+'"/>';
																			htmlDatosInteresado +='<label for="radioEspaniaEditable_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.espania+'</label>&nbsp;&nbsp;';
																			htmlDatosInteresado +='<input id="radioOtroPaisEditable_'+indexBusqueda+'" type="radio" class="radioPaisEditable" name="paisEditable_'+indexBusqueda+'"/>';
																			htmlDatosInteresado +='<label for="radioOtroPaisEditable_'+indexBusqueda+'" class="">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.otroPais+'</label>';
																		}
																	htmlDatosInteresado +='</div>';
																htmlDatosInteresado +='</div>';
																htmlDatosInteresado += '<div id="divOtroPaisTitularEditable_'+indexBusqueda+'">';
																	htmlDatosInteresado += '<div class="row">';
																		htmlDatosInteresado += '<div class="col-xs-4 form-group">';
																			htmlDatosInteresado += '<label for="otroPaisTitularEditable_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.pais+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="otroPaisTitularEditable_'+indexBusqueda+'" name="idPaisUbicacion" class="form-control" />';
																			htmlDatosInteresado += '<input type="hidden" id="otroPaisHiddenTitularEditable_'+indexBusqueda+'" value="'+(busqueda.datosInteresado.codPais!=null?busqueda.datosInteresado.codPais:'')+'" />';
																		htmlDatosInteresado += '</div>';
																		htmlDatosInteresado += '<div class="col-xs-4 form-group">';
																			htmlDatosInteresado += '<label for="otraProvinciaTitularEditable_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.provincia+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="otraProvinciaTitularEditable_'+indexBusqueda+'" class="form-control" maxlength="100" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.provincia!=null?busqueda.datosInteresado.provincia:'')+'" />';
																		htmlDatosInteresado += '</div>';
																		htmlDatosInteresado += '<div class="col-xs-4 form-group">';
																			htmlDatosInteresado += '<label for="otraLocalidadTitularEditable_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.ciudad+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="otraLocalidadTitularEditable_'+indexBusqueda+'" class="form-control" maxlength="100" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.localidad!=null?busqueda.datosInteresado.localidad:'')+'" />';
																		htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '<div class="row">';
																		htmlDatosInteresado += '<div class="col-xs-5 form-group">';
																			htmlDatosInteresado += '<label for="otraDireccionTitularEditable_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.direccion+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="otraDireccionTitularEditable_'+indexBusqueda+'" class="form-control" maxlength="100" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.direccion!=null?busqueda.datosInteresado.direccion:'')+'" />';
																		htmlDatosInteresado += '</div>';	
																		htmlDatosInteresado += '<div class="col-xs-2 form-group">';
																			htmlDatosInteresado += '<label for="otroCodPostalTitularEditable_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.cp+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="otroCodPostalTitularEditable_'+indexBusqueda+'" class="form-control" maxlength="5" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.cp!=null?busqueda.datosInteresado.cp:'')+'"/>';
																		htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '</div>';
																htmlDatosInteresado += '</div>';
																
																htmlDatosInteresado += '<div id="divPaisEspaniaTitularEditable_'+indexBusqueda+'">';				
																	htmlDatosInteresado += '<div class="row">';
																		htmlDatosInteresado += '<div class="col-xs-4 form-group">';
																			htmlDatosInteresado += '<label for="provinciaTitularEditable_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.provincia+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="provinciaTitularEditable_'+indexBusqueda+'" name="idProvinciaDireccionPostal" class="form-control" />';
																			htmlDatosInteresado += '<input type="hidden" id="provinciaHiddenTitularEditable_'+indexBusqueda+'" value="'+(busqueda.datosInteresado.codProvincia!=null?busqueda.datosInteresado.codProvincia:'')+'" />';
																		htmlDatosInteresado += '</div>';
																		htmlDatosInteresado += '<div class="col-xs-4 form-group">';
																			htmlDatosInteresado += '<label for="municipioTitularEditable_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.municipio+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="municipioTitularEditable_'+indexBusqueda+'" name="idMunicipioDireccionPostal" class="form-control" />';
																			htmlDatosInteresado += '<input type="hidden" id="municipioHiddenTitularEditable_'+indexBusqueda+'" value="'+(busqueda.datosInteresado.codMunicipio!=null?busqueda.datosInteresado.codMunicipio:'')+'" />';
																		htmlDatosInteresado += '</div>';
																		htmlDatosInteresado += '<div class="col-xs-4 form-group">';
																			htmlDatosInteresado += '<label for="localidadTitularEditable_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.localidad+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="localidadTitularEditable_'+indexBusqueda+'" class="form-control" />';
																			htmlDatosInteresado += '<input type="hidden" id="localidadHiddenTitularEditable_'+indexBusqueda+'" value="'+(busqueda.datosInteresado.codLocalidad!=null?busqueda.datosInteresado.codLocalidad:'')+'" />';
																		htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '<div class="row">';
																		htmlDatosInteresado += '<div class="col-xs-5 form-group">';
																			htmlDatosInteresado += '<label for="direccionTitularEditable_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.direccion+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="direccionTitularEditable_'+indexBusqueda+'" class="form-control" maxlength="64" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.direccion!=null?busqueda.datosInteresado.direccion:'')+'"/>';
																		htmlDatosInteresado += '</div>';
																		htmlDatosInteresado += '<div class="col-xs-1 form-group">';
																			htmlDatosInteresado += '<label for="portalTitularEditable_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.numero+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="portalTitularEditable_'+indexBusqueda+'" class="form-control" maxlength="6" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.portal!=null?busqueda.datosInteresado.portal:'')+'"/>';
																		htmlDatosInteresado += '</div>';
																		htmlDatosInteresado += '<div class="col-xs-1 form-group">';
																			htmlDatosInteresado += '<label for="escaleraTitularEditable_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.escalera+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="escaleraTitularEditable_'+indexBusqueda+'" class="form-control" maxlength="4" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.escalera!=null?busqueda.datosInteresado.escalera:'')+'"/>';
																		htmlDatosInteresado += '</div>';
																		htmlDatosInteresado += '<div class="col-xs-1 form-group">';
																			htmlDatosInteresado += '<label for="pisoTitularEditable_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.piso+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="pisoTitularEditable_'+indexBusqueda+'" class="form-control" maxlength="4" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.piso!=null?busqueda.datosInteresado.piso:'')+'"/>';
																		htmlDatosInteresado += '</div>';
																		htmlDatosInteresado += '<div class="col-xs-1 form-group">';
																			htmlDatosInteresado += '<label for="letraTitularEditable_'+indexBusqueda+'">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.letra+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="letraTitularEditable_'+indexBusqueda+'" class="form-control" maxlength="4" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.letra!=null?busqueda.datosInteresado.letra:'')+'"/>';
																		htmlDatosInteresado += '</div>';
																		htmlDatosInteresado += '<div class="col-xs-2 form-group">';
																			htmlDatosInteresado += '<label for="codPostalTitularEditable_'+indexBusqueda+'" class="required">'+$.rup.i18n.app.modalCrearExpedienteInicioOficio.cp+'</label><br>';
																			htmlDatosInteresado += '<input type="text" id="codPostalTitularEditable_'+indexBusqueda+'" class="form-control" maxlength="5" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" value="'+(busqueda.datosInteresado.cp!=null?busqueda.datosInteresado.cp:'')+'"/>';
																		htmlDatosInteresado += '</div>';
																	htmlDatosInteresado += '</div>';
																htmlDatosInteresado += '</div>';
																
															htmlDatosInteresado += '</div>';
														htmlDatosInteresado += '</div>';

												}

												htmlDatosInteresado +='</div>'//Cierre del panel body
											+'</div>'//Cierre del panel
										+'</fieldset>'//Cierre del fieldset
									+'</div>'//Cierre del contenido del acordeon principal
		htmlDatosInteresado += '</div>'//Cierre del acordeon principal
		});
		
		//Asignamos el HTML al div contenedor
		$("#contenedorInteresados").html(htmlDatosInteresado);
		
		//Lanzamos el rup_acordeon para que cargue y muestre los acordeones
		$(".rup_accordion").rup_accordion({
			collapsible: true,
			heightStyle: "content",
			clearStyle:true,
			active: false
		});
		
		$(".divDomicilioTitularEditable").each(function() {
			var idDomicilio = $(this).attr("id");
			var identificador = idDomicilio.split("_")[1];
			
			$("#otroPaisTitularEditable_"+identificador).rup_combo({
				source: "/ab59WebAppWar/nora/paises",
				blank: "",
				sourceParam: {
					label: "dsO",
					value: "id"
				},
				onLoadSuccess : function() {
					if($("#otroPaisHiddenTitularEditable_"+identificador).val() != null && $("#otroPaisHiddenTitularEditable_"+identificador).val() != "" && $("#otroPaisHiddenTitularEditable_"+identificador).val() != "0" && $("#otroPaisHiddenTitularEditable_"+identificador).val() != "108"){
						var idPais = $("#otroPaisHiddenTitularEditable_"+identificador).val();
						$("#otroPaisTitularEditable_"+identificador).rup_combo("setRupValue", idPais);
					}	
				},
				select : function() {
					var idPais = $("#otroPaisTitularEditable_"+identificador).val();
					$("#otroPaisHiddenTitularEditable_"+identificador).val(idPais);
				},
				width: 250
			});
			
			$("#provinciaTitularEditable_"+identificador).rup_combo({
				source: "/ab59WebAppWar/nora/provincias",
				blank: "",
				sourceParam: {
					label: "dsO",
					value: "id"
				},
				onLoadSuccess : function() {
					if($("#provinciaHiddenTitularEditable_"+identificador).val() != null && $("#provinciaHiddenTitularEditable_"+identificador).val() != ""){
						var idProvincia = pad($("#provinciaHiddenTitularEditable_"+identificador).val(),2);
						$("#provinciaTitularEditable_"+identificador).rup_combo("setRupValue", idProvincia);
					}	
				},
				select : function() {
					var idProvincia = $("#provinciaTitularEditable_"+identificador).val();
					$("#provinciaHiddenTitularEditable_"+identificador).val(idProvincia);
					
					$("#municipioTitularEditable_"+identificador).rup_combo("clear");
					$("#municipioHiddenTitularEditable_"+identificador).val("");
				},
				width: 250
			});
			
			$("#municipioTitularEditable_"+identificador).rup_combo({
				source: "/ab59WebAppWar/nora/municipios",
				parent: ["provinciaTitularEditable_"+identificador],
				blank: "",
				sourceParam: {
					label: "dsO",
					value: "id"
				},
				onLoadSuccess : function() {
					if($("#municipioHiddenTitularEditable_"+identificador).val() != null && $("#municipioHiddenTitularEditable_"+identificador).val() != ""){
						var idMunicipio = pad($("#municipioHiddenTitularEditable_"+identificador).val(),3);
						$("#municipioTitularEditable_"+identificador).rup_combo("setRupValue", idMunicipio);
					}else{
						$("#municipioTitularEditable_"+identificador).rup_combo("clear");
						$("#municipioHiddenTitularEditable_"+identificador).val("");
					}
				},
				select : function() {
					var idMunicipio = $("#municipioTitularEditable_"+identificador).val();
					$("#municipioHiddenTitularEditable_"+identificador).val(idMunicipio);
					
					$("#localidadTitularEditable_"+identificador).rup_combo("clear");
					$("#localidadHiddenTitularEditable_"+identificador).val("");
				},
				width: 250
			});
			
			$("#localidadTitularEditable_"+identificador).rup_combo({
				source: "/ab59WebAppWar/nora/localidades",
				parent: ["provinciaTitularEditable_"+identificador, "municipioTitularEditable_"+identificador],
				blank: "",
				sourceParam: {
					label: "dsO",
					value: "id"
				},
				onLoadSuccess : function() {
					if($("#localidadHiddenTitularEditable_"+identificador).val() != null && $("#localidadHiddenTitularEditable_"+identificador).val() != ""){
						var idLocalidad = $("#localidadHiddenTitularEditable_"+identificador).val();
						$("#localidadTitularEditable_"+identificador).rup_combo("setRupValue", idLocalidad);
					}else{
						$("#localidadTitularEditable_"+identificador).rup_combo("clear");
						$("#localidadHiddenTitularEditable_"+identificador).val("");
					}	
				},
				select : function() {
					var idLocalidad = $("#localidadTitularEditable_"+identificador).val();
					$("#localidadHiddenTitularEditable_"+identificador).val(idLocalidad);
				},
				width: 290
			});
		});
		
		$(".radioPaisEditable").each(function() {
			
			var id = $(this).attr("id");
			var identificador = id.split("_")[1];
			
			if($("#radioEspaniaEditable_"+identificador).prop("checked")){	
				$("#otroPaisHiddenTitularEditable_"+identificador).val("");
				$("#otraProvinciaTitularEditable_"+identificador).val("");
				$("#otraLocalidadTitularEditable_"+identificador).val("");
				$("#otraDireccionTitularEditable_"+identificador).val("");
				$("#otroCodPostalTitularEditable_"+identificador).val("");
				
				$("#divOtroPaisTitularEditable_"+identificador).hide();
				$("#divPaisEspaniaTitularEditable_"+identificador).show();
			}else if($("#radioOtroPaisEditable_"+identificador).prop("checked")){
				$("#provinciaTitularEditable_"+identificador).rup_combo("clear");
				$("#municipioTitularEditable_"+identificador).rup_combo("clear");
				$("#localidadTitularEditable_"+identificador).rup_combo("clear");
				$("#provinciaHiddenTitularEditable_"+identificador).val("");
				$("#municipioHiddenTitularEditable_"+identificador).val("");
				$("#localidadHiddenTitularEditable_"+identificador).val("");	
				$("#direccionTitularEditable_"+identificador).val("");
				$("#portalTitularEditable_"+identificador).val("");
				$("#escaleraTitularEditable_"+identificador).val("");
				$("#pisoTitularEditable_"+identificador).val("");
				$("#letraTitularEditable_"+identificador).val("");
				$("#codPostalTitularEditable_"+identificador).val("");
				
				$("#divOtroPaisTitularEditable_"+identificador).show();
				$("#divPaisEspaniaTitularEditable_"+identificador).hide();
			}else{
				$("#divOtroPaisTitularEditable_"+identificador).hide();
				$("#divPaisEspaniaTitularEditable_"+identificador).hide();
			}
		});
		
		$(".radioPaisEditable").click(function() {
			
			var id = $(this).attr("id");
			var identificador = id.split("_")[1];
			
			if($("#radioEspaniaEditable_"+identificador).prop("checked")){
				$("#otroPaisTitularEditable_"+identificador).rup_combo("clear");
				$("#otroPaisHiddenTitularEditable_"+identificador).val("");
				$("#otraProvinciaTitularEditable_"+identificador).val("");
				$("#otraLocalidadTitularEditable_"+identificador).val("");
				$("#otraDireccionTitularEditable_"+identificador).val("");
				$("#otroCodPostalTitularEditable_"+identificador).val("");
				
				$("#divOtroPaisTitularEditable_"+identificador).hide();
				$("#divPaisEspaniaTitularEditable_"+identificador).show();
			}else if($("#radioOtroPaisEditable_"+identificador).prop("checked")){
				$("#provinciaTitularEditable_"+identificador).rup_combo("clear");
				$("#municipioTitularEditable_"+identificador).rup_combo("clear");
				$("#localidadTitularEditable_"+identificador).rup_combo("clear");
				$("#provinciaHiddenTitularEditable_"+identificador).val("");
				$("#municipioHiddenTitularEditable_"+identificador).val("");
				$("#localidadHiddenTitularEditable_"+identificador).val("");	
				$("#direccionTitularEditable_"+identificador).val("");
				$("#portalTitularEditable_"+identificador).val("");
				$("#escaleraTitularEditable_"+identificador).val("");
				$("#pisoTitularEditable_"+identificador).val("");
				$("#letraTitularEditable_"+identificador).val("");
				$("#codPostalTitularEditable_"+identificador).val("");
				
				$("#divOtroPaisTitularEditable_"+identificador).show();
				$("#divPaisEspaniaTitularEditable_"+identificador).hide();
			}
		});
		
		$(".radioCanalEditable").each(function() {
			var id = $(this).attr("id");
			var identificador = id.split("_")[1];
			
			if(!$("#radioCanalPostalEditable_"+identificador).prop("checked") && !$("#radioCanalElectronicoEditable_"+identificador).prop("checked")){
				$("#radioEspaniaEditable_"+identificador).prop("checked", "");
				$("#radioOtroPaisEditable_"+identificador).prop("checked", "");
				$("#divOtroPaisTitularEditable_"+identificador).hide();
				$("#divPaisEspaniaTitularEditable_"+identificador).hide();
				
				$("#acordeonDomicilioTitular_"+identificador).hide();
			}else if(!$("#radioCanalPostalEditable_"+identificador).prop("checked")){
				$("#acordeonDomicilioTitular_"+identificador).hide();
				$("#labelCanalComunicacionTitularEmailEditable_"+identificador).addClass("required");
			}
		});
		
		/**
		 * Cuando se seleccione el canal de comunicacion editable
		 */
		$(".radioCanalEditable").click(function() {
			
			var id = $(this).attr("id");
			var identificador = id.split("_")[1];
			
			if($("#radioCanalPostalEditable_"+identificador).prop("checked")){
				$("#acordeonDomicilioTitular_"+identificador).show();
				
				$("#radioEspaniaEditable_"+identificador).prop("checked", "");
				$("#radioOtroPaisEditable_"+identificador).prop("checked", "");
				$("#divOtroPaisTitularEditable_"+identificador).hide();
				$("#divPaisEspaniaTitularEditable_"+identificador).hide();
				
				$("#provinciaTitularEditable_"+identificador).rup_combo("clear");
				$("#municipioTitularEditable_"+identificador).rup_combo("clear");
				$("#localidadTitularEditable_"+identificador).rup_combo("clear");
				$("#provinciaHiddenTitularEditable_"+identificador).val("");
				$("#municipioHiddenTitularEditable_"+identificador).val("");
				$("#localidadHiddenTitularEditable_"+identificador).val("");	
				$("#direccionTitularEditable_"+identificador).val("");
				$("#portalTitularEditable_"+identificador).val("");
				$("#escaleraTitularEditable_"+identificador).val("");
				$("#pisoTitularEditable_"+identificador).val("");
				$("#letraTitularEditable_"+identificador).val("");
				$("#codPostalTitularEditable_"+identificador).val("");
				
				$("#otroPaisTitularEditable_"+identificador).rup_combo("clear");
				$("#otroPaisHiddenTitularEditable_"+identificador).val("");
				$("#otraProvinciaTitularEditable_"+identificador).val("");
				$("#otraLocalidadTitularEditable_"+identificador).val("");
				$("#otraDireccionTitularEditable_"+identificador).val("");
				$("#otroCodPostalTitularEditable_"+identificador).val("");
				
				$("#labelCanalComunicacionTitularEmailEditable_"+identificador).removeClass("required");
			}else if($("#radioCanalElectronicoEditable_"+identificador).prop("checked")){
				$("#acordeonDomicilioTitular_"+identificador).hide();
				
				$("#radioEspaniaEditable_"+identificador).prop("checked", "");
				$("#radioOtroPaisEditable_"+identificador).prop("checked", "");
				$("#divOtroPaisTitularEditable_"+identificador).hide();
				$("#divPaisEspaniaTitularEditable_"+identificador).hide();
				
				$("#provinciaTitularEditable_"+identificador).rup_combo("clear");
				$("#municipioTitularEditable_"+identificador).rup_combo("clear");
				$("#localidadTitularEditable_"+identificador).rup_combo("clear");
				$("#provinciaHiddenTitularEditable_"+identificador).val("");
				$("#municipioHiddenTitularEditable_"+identificador).val("");
				$("#localidadHiddenTitularEditable_"+identificador).val("");	
				$("#direccionTitularEditable_"+identificador).val("");
				$("#portalTitularEditable_"+identificador).val("");
				$("#escaleraTitularEditable_"+identificador).val("");
				$("#pisoTitularEditable_"+identificador).val("");
				$("#letraTitularEditable_"+identificador).val("");
				$("#codPostalTitularEditable_"+identificador).val("");
				
				$("#otroPaisTitularEditable_"+identificador).rup_combo("clear");
				$("#otroPaisHiddenTitularEditable_"+identificador).val("");
				$("#otraProvinciaTitularEditable_"+identificador).val("");
				$("#otraLocalidadTitularEditable_"+identificador).val("");
				$("#otraDireccionTitularEditable_"+identificador).val("");
				$("#otroCodPostalTitularEditable_"+identificador).val("");
				
				$("#labelCanalComunicacionTitularEmailEditable_"+identificador).addClass("required");
			}
		});
	}
	
	$(".rolTitularModalEnviar").each(function(){
		var id = $(this).attr("id");
		$("#" + id).rup_combo({
			source: "/ab59WebAppWar/subtipotercero/cargarCombo",
			blank: "",
			sourceParam: {
				label: ("es"===$.rup_utils.get("language")) ? "descripcionCastellano" : "descripcionEuskera",
				value: "idSubtipoTercero"
			},
			width: 260,
			rowStriping: true
		});
	});	
}

function consultarDatosInteresado(){
	bloquearInterfaz();
	setTimeout(function(){ 
		$.ajax({
			url: "/ab59WebAppWar/propuestasSancion/consultaDatosInteresado/"+$("#nuevaModalExpedienteInicioOficioComboProcedimiento").val(), 
			type: "POST",
			contentType: "application/json",
			dataType: "json",
			data: $("#listaIdTercerosTitular").val(),
			async: false,
			success: function(data){

				$("#datosCrearExpedienteInicioOficio").val(JSON.stringify(data));
				crearInteresadosExpedienteInicioOficio();
				
				desbloquearInterfaz();
			},
			error: function(){
				desbloquearInterfaz();
				$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
				$("#nuevaModalExpedienteInicioOficioFeedback").rup_feedback("set", $.rup.i18n.app.modalCrearExpedienteInicioOficio.errorObteniendoDatos, "error");
			}
		});	
	}, 90);
}