$(document).ready(function(){
	//Marcamos la opción del menú principal "Sanciones"
	$("#menuConsultaListados").addClass("active");
	$("#menuFichaPropuestaSancion").hide();
	
	sessionStorage.removeItem("propuestaSancionCargada");
	
	$(".rup_accordion").rup_accordion({
		active: true,
		collapsible: true,
		autoHeight: false
	});
	$("#acordeonBusqueda").rup_accordion("activate", 0);
	
	var sancionCargada = sessionStorage.getItem("sancionCargada");	
	if (sancionCargada !== null)
	{
		$("#menuFichaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Inspección */
		var link=$("#menuFichaSancion a").attr("href");
		$("#menuFichaSancion a").attr("href",link+sancionCargada);
		 
		/* Para completar la url del menú Listados */
		 var link=$("#menuListados a").attr("href");
		 $("#menuListados a").attr("href",link+sancionCargada);
	}
	
	//Filtro tipo empresa
	$("#tipoEmpresaFiltro").click(function() {
		$("#rowEmpresa").removeAttr("hidden");
		$("#rowTercero").attr("hidden", "true");
		$("#dniTitular").val("");
		$("#nombreTitular").val("");
		$("#apellido1Titular").val("");
		$("#apellido2Titular").val("");
	});
	
	//Filtro tipo tercero
	$("#tipoTerceroFiltro").click(function() {
		$("#rowEmpresa").attr("hidden", "true");
		$("#rowTercero").removeAttr("hidden");
		$("#cifEmpresa").val("");
		$("#nombreEmpresa").val("");
	});
	
	//Mantener los criterios de búsqueda (filtro) anteriores
	var filtro = JSON.parse(sessionStorage.getItem("busquedaSancion"));
	if(filtro !== null && sessionStorage.getItem("desdeBusqueda") === 'true'){
		$("#numExpediente").val(filtro["expediente.folderNumber"]);
		$("#tituloExpediente").val(filtro["expediente.titulo"]);
		if(filtro.tipoEmpTer === "1"){
			$("#tipoEmpresaFiltro").prop("checked", true);
			$("#rowEmpresa").removeAttr("hidden");
			$("#rowTercero").attr("hidden", "true");
			$("#cifEmpresa").attr("name", "expediente.datosTerceros.documento");
			$("#nombreEmpresa").attr("name", "expediente.datosTerceros.nombre");
			$("#cifEmpresa").val(filtro["expediente.datosTerceros.documento"]);
			$("#nombreEmpresa").val(filtro["expediente.datosTerceros.nombre"]);
		} else if(filtro.tipoEmpTer === "2") {
			$("#tipoTerceroFiltro").prop("checked", true);
			$("#rowEmpresa").attr("hidden", "true");
			$("#rowTercero").removeAttr("hidden");
			$("#dniTitular").attr("name", "expediente.datosTerceros.documento");
			$("#nombreTitular").attr("name", "expediente.datosTerceros.nombre");
			$("#dniTitular").val(filtro["datosTerceros.documento"]);
			$("#nombreTitular").val(filtro["datosTerceros.nombre"]);
			$("#apellido1Titular").val(filtro["expediente.datosTerceros.apellido1"]);
			$("#apellido2Titular").val(filtro["expediente.datosTerceros.apellido2"]);
		}
				
		$("#calle").val(filtro["expediente.datosDirecciones.direccion"]);
		$("#numero").val(filtro["expediente.datosDirecciones.numero"]);
		$("#escalera").val(filtro["expediente.datosDirecciones.escalera"]);
		$("#piso").val(filtro["expediente.datosDirecciones.piso"]);
		$("#letra").val(filtro["expediente.datosDirecciones.letra"]);
		$("#codigoPostal").val(filtro["expediente.datosDirecciones.codigoPostal"]);
		
		$("#importeSancionDesde").val(filtro.importeSancionDesde);
		$("#importeSancionHasta").val(filtro.importeSancionHasta);
		$("#fechaAcuseAcuerdoIncoacionDesde").val(filtro.fechaAcuseAcuerdoIncoacionDesde);
		$("#fechaAcuseAcuerdoIncoacionHasta").val(filtro.fechaAcuseAcuerdoIncoacionHasta);
		$("#fechaSancionFirmeDesde").val(filtro.fechaSancionFirmeDesde);
		$("#fechaSancionFirmeHasta").val(filtro.fechaSancionFirmeHasta);
		
		if (filtro.pendientesIngreso === "1"){
			$("#pendientesIngreso").prop("checked", true);
		}else{
			$("#pendientesIngreso").prop("checked", false);
		}
		if (filtro.cerradas === "1"){
			$("#cerradas").prop("checked", true);
		}else{
			$("#cerradas").prop("checked", false);
		}

		if(filtro.expedientesSinPropuesta === 1){
    		$("#expedientesSinPropuesta").attr("checked", true);
		} 
		
		if (filtro.expedientesCerrados === 1) {
			$('#expedientesCerrados').attr("checked", true);
		}
		  
	  $("#numExpediente_filter_table").val($("#numExpediente").val());
		$("#tituloExpediente_filter_table").val($("#tituloExpediente").val());

		if($('#tipoEmpresaFiltro').is(':checked')){
			$("#nombreTitular_filter_table").val($("#nombreEmpresa").val());
			$("#dniTitular_filter_table").val($("#cifEmpresa").val());
		} else if ($('#tipoTerceroFiltro').is(':checked')) {
			$("#nombreTitular_filter_table").val($("#nombreTitular").val());
			$("#apellido1Titular_filter_table").val($("#apellido1Titular").val());
			$("#apellido2Titular_filter_table").val($("#apellido2Titular").val());
			$("#dniTitular_filter_table").val($("#dniTitular").val());
		}
		
		$("#idProvincia_filter_table").val(filtro["expediente.datosDirecciones.provincia.id"]);
		$("#idMunicipio_filter_table").val(filtro["expediente.datosDirecciones.municipio.id"]);
		$("#idLocalidad_filter_table").val(filtro["expediente.datosDirecciones.localidad.id"]);
		$("#calle_filter_table").val($("#calle").val());
		$("#numero_filter_table").val($("#numero").val());
		$("#escalera_filter_table").val($("#escalera").val());
		$("#piso_filter_table").val($("#piso").val());
		$("#letra_filter_table").val($("#letra").val());
		$("#codigoPostal_filter_table").val($("#codigoPostal").val());

		$("#importeSancionDesde_filter_table").val($("#importeSancionDesde").val());
		$("#importeSancionHasta_filter_table").val($("#importeSancionHasta").val());
		$("#fechaAcuseAcuerdoIncoacionDesde_filter_table").val($("#fechaAcuseAcuerdoIncoacionDesde").val());
		$("#fechaAcuseAcuerdoIncoacionHasta_filter_table").val($("#fechaAcuseAcuerdoIncoacionHasta").val());
		$("#fechaSancionFirmeDesde_filter_table").val($("#fechaSancionFirmeDesde").val());
		$("#fechaSancionFirmeHasta_filter_table").val($("#fechaSancionFirmeHasta").val());

		$("#idDireccion_filter_table").val(filtro["expediente.procedimiento.direcciones.idDireccion"]);
		$("#idTipoFinalizacion_filter_table").val(filtro["tipoFinalizacion.idTipoFinalizacion"]);	
		if($("#expedientesCerrados").is(":checked")){
			$("#expedientesCerrados_filter_table").val(1);
		}else{
			$("#expedientesCerrados_filter_table").val(0);
		}
		if($("#expedientesSinPropuesta").is(":checked")){
			$("#expedientesSinPropuesta_filter_table").val(1);
		}else{
			$("#expedientesSinPropuesta_filter_table").val(0);
		}
	}	
	
	//Checks mostrar expedientes
	$("#expedientesSinPropuesta").click(function() {
		if($("#expedientesSinPropuesta").is(":checked")){
			$("#expedientesSinPropuesta_filter_table").val(1);
		}else{
			$("#expedientesSinPropuesta_filter_table").val(0);
		}
	});
	
	$("#expedientesCerrados").click(function() {
		if($("#expedientesCerrados").is(":checked")){
			$("#expedientesCerrados_filter_table").val(1);
		}else{
			$("#expedientesCerrados_filter_table").val(0);
		}
	});
		
	
	/* COMBOS de NORA */
	
	$("#idProvincia").rup_combo({
		source: "/ab59WebAppWar/nora/provincias",
		blank: "0",
		sourceParam: {
			label: "dsO",
			value: "id"
		},
		change: function() {
			$("#codigoProvincia").val(($("#idProvincia").rup_combo("getRupValue") == "0") ? "" : $("#idProvincia").rup_combo("getRupValue"));
			$("#codigoMunicipio").val("");
			var source = "/ab59WebAppWar/nora/municipiosBusqueda?provinciaId=" + $("#idProvincia").val();
			cargarComboMunicipiosFiltro(source);
		},
		width: 250,
		onLoadSuccess: function() {
			if (JSON.parse(sessionStorage.getItem("busquedaSancion")) != null)
			{
				$("#idProvincia").rup_combo("setRupValue", JSON.parse(sessionStorage.getItem("busquedaSancion"))["expediente.datosDirecciones.provincia.id"]);
				$("#codigoProvincia").val(($("#idProvincia").rup_combo("getRupValue") == "0") ? "" : $("#idProvincia").rup_combo("getRupValue"));				
				$("#codigoMunicipio").val("");
				var source = "/ab59WebAppWar/nora/municipiosBusqueda?provinciaId=" + $("#idProvincia").val();
				cargarComboMunicipiosFiltro(source, JSON.parse(sessionStorage.getItem("busquedaSancion"))["expediente.datosDirecciones.municipio.id"]);
			}
		},
		rowStriping: true
	});

	$("#codigoMunicipio").prop("disabled", true);
	$("#idMunicipio").rup_combo("destroy");
	var listMunicipios = new Array();				
	//Transformo en JSON la lista
	$.toJSON(listMunicipios);	
	$("#idMunicipio").rup_combo({
		source: listMunicipios,	
		blank: "",
		disabled: true,
		rowStriping: true,
		width: 250
	});
	
	$("#idLocalidad").rup_combo("destroy");
	var listLocalidades = new Array();				
	//Transformo en JSON la lista
	$.toJSON(listLocalidades);	
	$("#idLocalidad").rup_combo({
		source: listLocalidades,	
		blank: "",
		disabled: true,
		rowStriping: true,
		width: 290
	});
	
	$("#idDireccion").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/direcciones/cargarCombo",
		sourceParam : {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
			value : "idDireccion"
		},
		change: function() {
			var source = "/ab59WebAppWar/tiposFinalizacion/cargarCombo?idDireccion=" + $("#idDireccion").val();
			cargarComboTiposFinalizacionFiltro(source);
		},
		onLoadSuccess: function() {
			if (JSON.parse(sessionStorage.getItem("busquedaSancion")) != null)
			{
				$("#idDireccion").rup_combo("setRupValue", JSON.parse(sessionStorage.getItem("busquedaSancion"))["expediente.procedimiento.direcciones.idDireccion"]);
				var source = "/ab59WebAppWar/tiposFinalizacion/cargarCombo?idDireccion=" + $("#idDireccion").val();
				cargarComboTiposFinalizacionFiltro(source, JSON.parse(sessionStorage.getItem("busquedaSancion"))["tipoFinalizacion.idTipoFinalizacion"]);
			}
			else{
				if(DIRECCION_PRECARGADA) {
					$("#idDireccion").rup_combo("setRupValue", DIRECCION_PRECARGADA);
					$("#idDireccion").rup_combo("disable");
					var source = "/ab59WebAppWar/tiposFinalizacion/cargarCombo?idDireccion=" + $("#idDireccion").val();
					cargarComboTiposFinalizacionFiltro(source);
				} else {
					$("#idDireccion").rup_combo("setRupValue", ID_TURISMO_DIRECCION);
					var source = "/ab59WebAppWar/tiposFinalizacion/cargarCombo?idDireccion=" + $("#idDireccion").val();
					cargarComboTiposFinalizacionFiltro(source);
				}
			}
		},
		rowStriping: true
	});
		
	$("#sanciones").rup_datatable({
		primaryKey: "idSancion",
		loadOnStartUp: true,
		pagingType: "full_numbers",
		dom: 't <"col-sm-3"l><"col-sm-7"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"sanciones_filter_form",
  	  		filterToolbar:"sanciones_filter_toolbar",
  	  		collapsableLayerId:"sanciones_filter_fieldset"
     	},
     	stateSave: true,
		stateSaveCallback: function(settings,data) {
			localStorage.setItem( 'DataTables_' + settings.sInstance, JSON.stringify(data) );
		},
		stateLoadCallback: function(settings) {
			if(sessionStorage.getItem("desdeBusqueda") === 'true'){
				return JSON.parse( localStorage.getItem( 'DataTables_' + settings.sInstance ) );
			} else {
				return '';
			}
		},
    	colReorder: false,
    	order: [ 1, "asc" ],
    	columnDefs: [
    		   {
    		      targets: [0],
    		      orderable: false,
    		      visible: false
    		   },
    		   {
    			   targets: [3],
    			   render: function(value){
    				   return formatearNumero(value);
				   },
    			   className: "text-center"
    		   },
    		   {
    			   targets: [4],
    			   className: "text-center"
    		   }
    	],
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("sanciones_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
			  
			  if((sessionStorage.getItem("desdeBusqueda") !== 'true')){
				  $("#tablaBusquedaSanciones").css("display","none");
			  } else {
			  	  sessionStorage.setItem("desdeBusqueda", "false");
			  	  $("#acordeonBusqueda").rup_accordion("activate", false);
				  $("#tablaBusquedaSanciones").css("display","block");
				  $(".botoneraTabla").css("display","block");
				  $(".bottom").css("display","block");

			  }
			  
    	}

	});

	$('#sanciones tbody').on( 'click', 'tr', function () {
		$('#sanciones').DataTable().$('tr.selected').removeClass('selected');
	    $(this).addClass('selected');
	});
	
	$('#sanciones tbody').on('dblclick', 'tr', function () {
		if($("#sanciones").val() != "0"){
			$("#btnVerSancion").trigger("click");
		}
	});
	
	$("#btnBuscar").click(function() {	
		irABusqueda();
	});
	
	$("#btnLimpiar").click(function(){		
		$("#tablaBusquedaSanciones").css("display","none");
		$("#dniTitular_filter_table").val("");
		$("#nombreTitular_filter_table").val("");
		$("#apellido1Titular_filter_table").val("");
		$("#apellido2Titular_filter_table").val("");
		$("#tipoEmpresaFiltro").prop("checked", false);
		$("#tipoTerceroFiltro").prop("checked", false);
		$("#rowEmpresa").attr("hidden", "true");
		$("#rowTercero").attr("hidden", "true");
		$("#idTipoFinalizacion").rup_combo("clear");
		$("#idDireccion").rup_combo("clear");
		limpiar("#formBusquedaSanciones");	 
		sessionStorage.removeItem("busquedaSancion");
		sessionStorage.setItem("desdeBusqueda", false);
	});
	
	//Exportar a Excel
	$("#btnExportarExcel").click(function(){
		var orderColumnIndex = $('#sanciones').DataTable().order()[0];
		var sord = $('#sanciones').DataTable().order()[1];
		var sidx = $('#sanciones').DataTable().settings().init().columns[orderColumnIndex].sidx; 
		var form=document.getElementById("sanciones_filter_form");
		form.method = "POST";
		form.action = "/ab59WebAppWar/sanciones/exportarExcel/"+sidx+"/"+sord;
		form.submit();
	});
		
	$( "#btnVerSancion" ).click(function() {
		
		if($('#sanciones').DataTable().rows('.selected').data().length === 1){			
			/*para recogerlo*/
			var datosRow = $('#sanciones').DataTable().rows(['.selected']).data().toArray();
			
			sessionStorage.setItem("sancionCargada", datosRow[0].idSancion);
			sessionStorage.setItem("irAExpediente", true);
			sessionStorage.setItem("desdeBusqueda", true); 
			//ACA le pasaremos el isSancion a inspecionar 
			window.location = "/ab59WebAppWar/fichasancion/maint/"+datosRow[0].idSancion;
		}
		else{
			if($('#sanciones').DataTable().rows('.selected').data().length > '1'){	
				$("#sanciones_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
				$("#sanciones_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.muchaslineasSeleccionada, "error");
			}else{
				$("#sanciones_feedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
				$("#sanciones_feedback").rup_feedback("set",$.rup.i18n.app.feedback.error.lineaNoSeleccionada, "error");
			}
		}
	});
	
});

function buscarComboProvincia(){
	$("#idProvincia").rup_combo("setRupValue", pad($("#codigoProvincia").val(), 2));
}

function buscarComboMunicipio(){
	$("#idMunicipio").rup_combo("setRupValue", pad($("#codigoMunicipio").val(), 3));
}

function cargarComboTiposFinalizacionFiltro(source, value){
	$("#idTipoFinalizacion").rup_combo("destroy");
	$("#idTipoFinalizacion").rup_combo({
		blank: "",
		source: source,
		selected: value,
		sourceParam: {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
			value : "idTipoFinalizacion"
		},
		onLoadSuccess: function() {
			if (JSON.parse(sessionStorage.getItem("busquedaSancion")) == null
					|| JSON.parse(sessionStorage.getItem("busquedaSancion"))["tipoFinalizacion.idTipoFinalizacion"] === ""){
				$("#idTipoFinalizacion").rup_combo("select", -1);
				$("#idTipoFinalizacion").rup_combo("clear");
			}
		},
		rowStriping: true
	});
}

function cargarComboMunicipiosFiltro(source, value) {
	if($("#idProvincia").val() != "" && $("#idProvincia").val() != null && $("#idProvincia").val() != "0") {
		$("#codigoMunicipio").prop("disabled", false);
		$("#idMunicipio").rup_combo({	
			blank: "0",
			source: source,	
			selected: value,
			sourceParam: {
				label: "dsO",
				value: "id"
			},
			change: function() {
				$("#codigoMunicipio").val(($("#idMunicipio").rup_combo("getRupValue") == "0") ? "" : $("#idMunicipio").rup_combo("getRupValue"));
				var source = "/ab59WebAppWar/nora/localidadesBusqueda?provinciaId=" + $("#idProvincia").val() + "&municipioId=" + $("#idMunicipio").val();
				cargarComboLocalidadesFiltro(source);
			},
			width: 250,
			onLoadSuccess: function() {
				if (JSON.parse(sessionStorage.getItem("busquedaSancion")) != null
						&& JSON.parse(sessionStorage.getItem("busquedaSancion"))["expediente.datosDirecciones.municipio.id"] != "")
				{
					$("#idMunicipio").rup_combo("setRupValue", JSON.parse(sessionStorage.getItem("busquedaSancion"))["expediente.datosDirecciones.municipio.id"]);
					$("#codigoMunicipio").val(($("#idMunicipio").rup_combo("getRupValue") == "0") ? "" : $("#idMunicipio").rup_combo("getRupValue"));
					var source = "/ab59WebAppWar/nora/localidadesBusqueda?provinciaId=" + $("#idProvincia").val() + "&municipioId=" + $("#idMunicipio").val();
					cargarComboLocalidadesFiltro(source, JSON.parse(sessionStorage.getItem("busquedaSancion"))["expediente.datosDirecciones.localidad.id"]);
				} else {
					$("#idMunicipio").rup_combo("clear");
				}
			},
			rowStriping: true
		});
	} else {
		$("#codigoMunicipio").prop("disabled", true);
		$("#idMunicipio").rup_combo("destroy");
		var listMunicipios = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listMunicipios);	
		$("#idMunicipio").rup_combo({
			source: listMunicipios,	
			blank: "",
			disabled: true,
			rowStriping: true,
			width: 250
		});
	}
}

function cargarComboLocalidadesFiltro(source, value) {
	if($("#idMunicipio").val() != "" && $("#idMunicipio").val() != null) {
		$("#idLocalidad").rup_combo({
			blank: "0",
			source: source,
			selected: value,
			sourceParam: {
				label: "dsO",
				value: "id"
			},
			width: 290,
			onLoadSuccess: function() {
				if (JSON.parse(sessionStorage.getItem("busquedaSancion")) != null
						&& JSON.parse(sessionStorage.getItem("busquedaSancion"))["expediente.datosDirecciones.localidad.id"] != "")
				{
					$("#idLocalidad").rup_combo("setRupValue", JSON.parse(sessionStorage.getItem("busquedaSancion"))["expediente.datosDirecciones.localidad.id"]);
				} else {
					$("#idLocalidad").rup_combo("clear");
				}
			},
			rowStriping: true
		});
	} else {
		$("#idLocalidad").rup_combo("destroy");
		var listLocalidades = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listLocalidades);	
		$("#idLocalidad").rup_combo({
			source: listLocalidades,	
			blank: "",
			disabled: true,
			rowStriping: true,
			width: 290
		});
	}
}

function irABusqueda() {

	$("#numExpediente_filter_table").val($("#numExpediente").val());
	$("#tituloExpediente_filter_table").val($("#tituloExpediente").val());

	if($('#tipoEmpresaFiltro').is(':checked')){
		$("#nombreTitular_filter_table").val($("#nombreEmpresa").val());
		$("#dniTitular_filter_table").val($("#cifEmpresa").val());
	} else if ($('#tipoTerceroFiltro').is(':checked')) {
		$("#nombreTitular_filter_table").val($("#nombreTitular").val());
		$("#apellido1Titular_filter_table").val($("#apellido1Titular").val());
		$("#apellido2Titular_filter_table").val($("#apellido2Titular").val());
		$("#dniTitular_filter_table").val($("#dniTitular").val());
	}
	
	$("#idProvincia_filter_table").val(($("#idProvincia").val() == "0") ? null : $("#idProvincia").val());
	$("#idMunicipio_filter_table").val(($("#idMunicipio").val() == "0") ? null : $("#idMunicipio").val());
	$("#idLocalidad_filter_table").val(($("#idLocalidad").val() == "0") ? null : $("#idLocalidad").val());
	$("#calle_filter_table").val($("#calle").val());
	$("#numero_filter_table").val($("#numero").val());
	$("#escalera_filter_table").val($("#escalera").val());
	$("#piso_filter_table").val($("#piso").val());
	$("#letra_filter_table").val($("#letra").val());
	$("#codigoPostal_filter_table").val($("#codigoPostal").val());

	$("#importeSancionDesde_filter_table").val($("#importeSancionDesde").val());
	$("#importeSancionHasta_filter_table").val($("#importeSancionHasta").val());
	$("#fechaAcuseAcuerdoIncoacionDesde_filter_table").val($("#fechaAcuseAcuerdoIncoacionDesde").val());
	$("#fechaAcuseAcuerdoIncoacionHasta_filter_table").val($("#fechaAcuseAcuerdoIncoacionHasta").val());
	$("#fechaSancionFirmeDesde_filter_table").val($("#fechaSancionFirmeDesde").val());
	$("#fechaSancionFirmeHasta_filter_table").val($("#fechaSancionFirmeHasta").val());
	
	$("#idTipoFinalizacion_filter_table").val($("#idTipoFinalizacion").val());	
	$("#idDireccion_filter_table").val($("#idDireccion").val());
	
	document.getElementById('sanciones_filter_filterButton').click();

	$("#tablaBusquedaSanciones").css("display","block");
	$(".botoneraTabla").css("display","block");
	$(".bottom").css("display","block");

	var busqueda = {};
	
	$.each($("#sanciones_filter_form").serializeArray(), function() {
		busqueda[this.name] = this.value;
	});

	if($('#tipoEmpresaFiltro').is(':checked')){
		busqueda['tipoEmpTer'] = $('#tipoEmpresaFiltro').val();
	} else if ($('#tipoTerceroFiltro').is(':checked')) {
		busqueda['tipoEmpTer'] = $('#tipoTerceroFiltro').val();
	}

	
	if($("#expedientesSinPropuesta").is(":checked")){
		busqueda['expedientesSinPropuesta'] = 1;
	}
	
	if ($('#expedientesCerrados').is(':checked')) {
		busqueda['expedientesCerrados'] = 1;
	}
	
	sessionStorage.setItem("busquedaSancion", JSON.stringify(busqueda));
	
	$("#acordeonBusqueda").rup_accordion("activate", false);
}