$(document).ready(function(){
	//Marcamos la opción del menú principal "Sanciones"
	$("#menuConsultaListados").addClass("active");
	$("#menuFichaSancion").hide();
	sessionStorage.removeItem("sancionCargada");

	$(".rup_accordion").rup_accordion({
		active: true,
		collapsible: true,
		autoHeight: false
	});
	$("#acordeonBusqueda").rup_accordion("activate", 0);
	
	var propuestaSancionCargada = sessionStorage.getItem("propuestaSancionCargada");	
	if (propuestaSancionCargada !== null)
	{
		$("#menuFichaPropuestaSancion").removeClass("disabled");
		/* Para completar la url del menú Ficha Sanción */
		 var link=$("#menuFichaPropuestaSancion a").attr("href");
		 $("#menuFichaPropuestaSancion a").attr("href",link+propuestaSancionCargada);
	}
	
	$("#idCalificacion").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/calificaciones/cargarCombo",
		sourceParam : {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
			value : "idCalificacion"
		},
		onLoadSuccess: function() {
			if (JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion")) != null)
			{
				$("#idCalificacion").rup_combo("setRupValue", JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion"))["calificacionFind.idCalificacion"]);
			}
		},
		rowStriping: true
	});
	
	$("#idInfraccionFind").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/infracciones/cargarCombo",
		sourceParam : {
			label : "articulo",
			value : "idInfraccion"
		},
		onLoadSuccess: function() {
			if (JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion")) != null)
			{
				$("#idInfraccionFind").rup_combo("setRupValue", JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion")).idInfraccionFind);
			}
		},
		rowStriping: true
	});
	
	$("#idDireccion").rup_combo({
		blank : "",
		source : "/ab59WebAppWar/direcciones/cargarCombo",
		sourceParam : {
			label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
			value : "idDireccion"
		},
		change: function() {
			var source = "/ab59WebAppWar/estadosProSan/cargarCombo?idDireccion=" + $("#idDireccion").val();
			cargarComboEstadosFiltro(source);
		},
		onLoadSuccess: function() {
			if (JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion")) != null)
			{
				$("#idDireccion").rup_combo("setRupValue", JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion"))["expedienteOrigen.procedimiento.direcciones.idDireccion"]);
				var source = "/ab59WebAppWar/estadosProSan/cargarCombo?idDireccion=" + $("#idDireccion").val();
				cargarComboEstadosFiltro(source, JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion")).estado);
			}
			else{
				if(typeof DIRECCION_PRECARGADA !== "undefined" && DIRECCION_PRECARGADA !== null && DIRECCION_PRECARGADA !== "") {
					$("#idDireccion").rup_combo("setRupValue", DIRECCION_PRECARGADA);
					$("#idDireccion").rup_combo("disable");
					var source = "/ab59WebAppWar/estadosProSan/cargarCombo?idDireccion=" + $("#idDireccion").val();
					cargarComboEstadosFiltro(source);
				} else {
					$("#idDireccion").rup_combo("setRupValue", ID_TURISMO_DIRECCION);
					var source = "/ab59WebAppWar/estadosProSan/cargarCombo?idDireccion=" + $("#idDireccion").val();
					cargarComboEstadosFiltro(source);
				}
			}
		},
		rowStriping: true
	});
	
	if(typeof DIRECCION_PRECARGADA === "undefined" || DIRECCION_PRECARGADA === null || DIRECCION_PRECARGADA === "") {
		$("#estado").rup_combo("destroy");
		var listEstadosProSan = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listEstadosProSan);	
		$("#estado").rup_combo({
			source: listEstadosProSan,	
			blank: "",
			disabled: true,
			rowStriping: true,
			onLoadSuccess: function() {
				if (JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion")) != null)
				{
					$("#estado").rup_combo("setRupValue", JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion")).estado);
				}
			},
		});
	}
	
	//Mantener los criterios de búsqueda (filtro) anteriores
	var filtro = JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion"));
	if(filtro !== null && sessionStorage.getItem("desdeBusquedaPropuesta") === 'true'){
		$("#identificadorProSan").val(filtro.identificadorProSan);
		$("#identificadorInspeccion").val(filtro.identificadorInspeccion);
		$("#numExpedienteOrigen").val(filtro["expedienteOrigen.folderNumber"]);
		$("#tituloExpedienteOrigen").val(filtro["expedienteOrigen.titulo"]);
		$("#fechaCreacion").val(filtro.fechaRegistro);
		$("#fechaHecho").val(filtro.fechaHechoFind);
		
		$("#identificadorProSan_filter_table").val(filtro.identificadorProSan);
		$("#identificadorInspeccion_filter_table").val(filtro.identificadorInspeccion);
		$("#numExpedienteOrigen_filter_table").val(filtro["expedienteOrigen.folderNumber"]);
		$("#tituloExpedienteOrigen_filter_table").val(filtro["expedienteOrigen.titulo"]);

		$("#fechaCreacion_filter_table").val(filtro.fechaRegistro);
		$("#fechaHecho_filter_table").val(filtro.fechaHechoFind);		
		
		$("#idCalificacion_filter_table").val(filtro["calificacionFind.idCalificacion"]);
		$("#idInfraccionFind_filter_table").val(filtro.idInfraccionFind);
		$("#estado_filter_table").val(filtro.estado);
		$("#idDireccion_filter_table").val(filtro["expedienteOrigen.procedimiento.direcciones.idDireccion"]);
	}
	
	$("#propuestasSancion").rup_datatable({
		
		primaryKey: "idPropuestaSancion",
		loadOnStartUp: true,
		pagingType: "full_numbers",
		dom: 't <"col-sm-4"l><"col-sm-6"p><"col-sm-2"i>',
		pageLength : 10,
		lengthMenu: [10, 25, 50],
		filter:{
  	  		id:"propuestasSancion_filter_form",
  	  		filterToolbar:"propuestasSancion_filter_toolbar",
  	  		collapsableLayerId:"propuestasSancion_filter_fieldset"
     	},
     	stateSave: true,
		stateSaveCallback: function(settings,data) {
			localStorage.setItem( 'DataTables_' + settings.sInstance, JSON.stringify(data) );
		},
		stateLoadCallback: function(settings) {
			if(sessionStorage.getItem("desdeBusquedaPropuesta") === 'true'){
				return JSON.parse( localStorage.getItem( 'DataTables_' + settings.sInstance ) );
			} else {
				return '';
			}
		},
    	colReorder: false,
    	order: [ 1, "asc" ],
    	columnDefs: [
    		   {
    		      targets: [0, 8, 9],
    		      orderable: false,
    		      visible: false
    		   },
    		   {
    			   targets: [1],
      		       width: 75
        	   },
    		   {
    			   targets: [2],
    			   render: function(data, type, row, meta){    				   
    		            if(type === 'display' && row.expedienteOrigen.procedimiento.aplicacion.urlAplicacion != null){
    		                data = '<a style="color: black; text-decoration: underline" href="' + row.expedienteOrigen.procedimiento.aplicacion.urlAplicacion + row.expedienteOrigen.folderId + '" target="_blanck">' + data + '</a>';
    		            }

    		            return data;
    		         }
    		   },
    		   {
    			   targets: [10],
    			   render: function(data, type, row, meta){    				   
    		            if(type === 'display' && row.expedienteSancionador.procedimiento.aplicacion.urlAplicacion != null){
    		                data = '<a style="color: black; text-decoration: underline" href="' + row.expedienteSancionador.procedimiento.aplicacion.urlAplicacion + row.expedienteSancionador.folderId + '" target="_blanck">' + data + '</a>';
    		            }

    		            return data;
    		         }
    		   }
    	],
    	initComplete:function() {
			
			  var spanM = document.createElement("span"); 
			  var mostrando = document.createTextNode($.rup.i18n.app.paginador.mostrando); 
			  spanM.appendChild(mostrando);  
			  spanM.className = "mostrando";
			  var spanR = document.createElement("span"); 
			  var registros = document.createTextNode($.rup.i18n.app.paginador.registros); 
			  spanR.appendChild(registros);
			  spanR.className = "registros";
			  
			  var longitudTabla = document.getElementById("propuestasSancion_length"); 
			  longitudTabla.appendChild(spanM); 
			  longitudTabla.appendChild(spanR);
			  
			  if((sessionStorage.getItem("desdeBusquedaPropuesta") !== 'true')){
				  $("#tablaBusquedaPropuestasSancion").css("display","none");
			  } else {
				  sessionStorage.setItem("desdeBusquedaPropuesta", "false");
					
					$("#tablaBusquedaPropuestasSancion").css("display","block");
					$(".botoneraTabla").css("display","block");
					$(".bottom").css("display","block");

			  }
    	}
	});
	
	$('#propuestasSancion tbody').on( 'click', 'tr', function () {
		$('#propuestasSancion').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });
	
	$('#propuestasSancion tbody').on('dblclick', 'tr', function () {
		if($("#propuestasSancion_filter_table").val() != "0"){
			$("#btnVerPropuestasSancion").trigger("click");
		}
	});
		
	$( "#btnBuscar" ).click(function() {
		$("#numExpedienteOrigen_filter_table").val($("#numExpedienteOrigen").val());
		$("#tituloExpedienteOrigen_filter_table").val($("#tituloExpedienteOrigen").val());

		$("#fechaCreacion_filter_table").val($("#fechaCreacion").val());
		$("#fechaHecho_filter_table").val($("#fechaHecho").val());		
		
		$("#idCalificacion_filter_table").val($("#idCalificacion").val());
		$("#idInfraccionFind_filter_table").val($("#idInfraccionFind").val());
		$("#estado_filter_table").val($("#estado").val());
		$("#idDireccion_filter_table").val($("#idDireccion").val());
		$("#identificadorProSan_filter_table").val($("#identificadorProSan").val());
		$("#identificadorInspeccion_filter_table").val($("#identificadorInspeccion").val());
				
		
		
		$("#tablaBusquedaPropuestasSancion").css("display","block");
    	$(".botoneraTabla").css("display","block");
    	$(".bottom").css("display","block");

    	var busqueda = {};
    	
    	$.each($("#propuestasSancion_filter_form").serializeArray(), function() {
    		busqueda[this.name] = this.value;
    	});
    	
    	sessionStorage.setItem("busquedaPropuestaSancion", JSON.stringify(busqueda));
    	
    	$("#acordeonBusqueda").rup_accordion("activate", false);
    	
    	document.getElementById('propuestasSancion_filter_filterButton').click();
	});
	
	$("#btnLimpiar").click(function(){		
		$("#tablaBusquedaPropuestasSancion").css("display","none");
		sessionStorage.removeItem("busquedaPropuestaSancion");
		sessionStorage.setItem("desdeBusquedaPropuesta", false);	
		limpiar("#formBusquedaPropuestasSancion");	 
	});
	
	//Exportar a Excel
	$("#btnExportarExcel").click(function(){
		var orderColumnIndex = $('#propuestasSancion').DataTable().order()[0];
		var sord = $('#propuestasSancion').DataTable().order()[1];
		var sidx = $('#propuestasSancion').DataTable().settings().init().columns[orderColumnIndex].sidx; 
		var form=document.getElementById("propuestasSancion_filter_form");
		form.method = "POST";
		form.action = "/ab59WebAppWar/propuestassancion/exportarExcel/"+sidx+"/"+sord;
		form.submit();
	});
			
	$("#propuestasSancion_detail_div").rup_dialog({
		autoOpen: false,
		width: 1100,
		modal: true,
		position: { my: "center center" },
		type: $.rup.dialog.DIV,
		open:function(){
			$("#notas_detail_table").focus();
			$("#accordionParticipaciones").rup_accordion ("activate", false);
			$("#accordionUbicacion").rup_accordion ("activate", false);
			$("#accordionInfracciones").rup_accordion ("activate", false);
			$("#accordionDocumentos").rup_accordion ("activate", false);
		}
	});
	
	$('#btnVerPropuestasSancion').on( 'click', function () {
		var datosRow = $('#propuestasSancion').DataTable().rows(['.selected']).data().toArray();
		sessionStorage.setItem("propuestaSancionCargada", datosRow[0].idPropuestaSancion);
		sessionStorage.setItem("desdeBusquedaPropuesta", true); 
		//ACA le pasaremos el isSancion a inspecionar 
		window.location = "/ab59WebAppWar/fichapropuestasancion/maint/"+datosRow[0].idPropuestaSancion;
		
		inicializaControlCambios("propuestasSancion_detail_form");
	});
	
	$('#propuestasSancion_detail_button_save').on( 'click', function () {		
		$("#propuestasSancion_detail_form").submit();	
	});
	
	$('#propuestasSancion_detail_button_cancel').on( 'click', function () {
		hayCambios();
	});

	
	if(filtro !== null && sessionStorage.getItem("desdeBusquedaPropuesta") === 'true'){
		
		$("#acordeonBusqueda").rup_accordion("activate", false);
		
		setTimeout(function() { 
			$("#btnBuscar").click();
	    }, 500);
	}
	
	if($("#esExpedienteCerrado").val() === "true"){
		setTimeout(function() { 
			bloquearSancion();
	    }, 500);
	} else {
		setTimeout(function() { 
			desbloquearSancion();
	    }, 500);
	}
});

function cerrarModal()
{
	$('#propuestasSancion').DataTable().ajax.reload();			   
	$("#propuestasSancion_detail_div").rup_dialog("close");   
}

function hayCambios()
{
	if (controlCambios()) {
		$.rup_messages("msgConfirm", {
			message: $.rup.i18n.app.controlCambios.mensaje,
			title:  $.rup.i18n.app.controlCambios.titulo,
			OKFunction: function () {	
				
				$("#propuestasSancion_detail_form").submit();
				
			},
			CANCELFunction: function () {
				cerrarModal();   
			}
		});	
	}	
	else
	{
		cerrarModal();
	}
}

function cargarComboEstadosFiltro(source, value){
	if ($("#idDireccion").val() != "" && $("#idDireccion").val() != null){
		$("#estado").rup_combo("destroy");
		$("#estado").rup_combo({
			blank: "",
			source: source,
			selected: value,
			sourceParam: {
				label : (("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
				value : "idEstadoProSan"
			},
			onLoadSuccess: function() {	
				if ((JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion")) !== null &&
						(JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion")).estado == null ||
							JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion")).estado == ""))
								|| JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion")) === null){
					$.ajax({
						type: "GET",
						url: CTX_PATH + "estadosProSan/findPorDefecto/" + $("#idDireccion").val(),
						contentType: "application/json",
						dataType: "json",
						async:false,
						success: function(data){
							desbloquearInterfaz();
							if (typeof data !== "undefined" && data !== null && data !== "")
							{
								$("#estado").rup_combo("setRupValue", data.idEstadoProSan);
							}
							else
							{
								$("#estado").rup_combo("clear");
							}
						}
					});
					
				} else {
					$("#estado").rup_combo("setRupValue", JSON.parse(sessionStorage.getItem("busquedaPropuestaSancion")).estado);
				} 	
			},
			rowStriping: true
		});
		
	}else{
		var listEstados = new Array();				
		//Transformo en JSON la lista
		$.toJSON(listEstados);	
		$("#estado").rup_combo("destroy");
		$("#estado").rup_combo({
			source: listEstados,	
			blank: "",
			disabled: true,
			rowStriping: true
		});
	}
}