package com.ejie.ab59.serviciosWeb;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.ejie.ab59.exceptions.Ab59Exception;
import com.ejie.ab59.model.servicioWeb.PropuestaSancionIdentificadoresWS;
import com.ejie.ab59.model.servicioWeb.PropuestaSancionWS;
import com.ejie.ab59.service.serviciosWeb.ServiciosWebService;


@WebService(serviceName = "ab59WebService", portName = "ab59WebServicePort", targetNamespace = "http://com.ejie.ab59.serviciosWeb")
@SOAPBinding(parameterStyle = ParameterStyle.WRAPPED)
public class WebServiceImpl extends SpringBeanAutowiringSupport {
	
	private static final Logger logger = LoggerFactory.getLogger(WebServiceImpl.class);
	
	@Autowired
	ServiciosWebService serviciosWebService;
	
	@WebMethod
	public PropuestaSancionIdentificadoresWS crearPropuestaSancion(@WebParam(name = "propuestaSancionWS") PropuestaSancionWS objetoPropuestaSancion, @WebParam(name = "usuario") String usuario, @WebParam(name = "idOrigenPropuestaSancion") Integer idOrigenPropuestaSancion, @WebParam(name = "idTercero") Integer idTercero, @WebParam(name = "idDireccion") Integer idDireccion) throws Ab59Exception{
		
		WebServiceImpl.logger.info("[crearPropuestaSancion] : ***************************************");
		WebServiceImpl.logger.info("[crearPropuestaSancion] : Parametros de entrada Webservice AB59");
		WebServiceImpl.logger.info("[crearPropuestaSancion] : ***************************************");
		
		if(objetoPropuestaSancion.getIdentificadorInspeccion() != null){
			WebServiceImpl.logger.info("[crearPropuestaSancion] : identificadorInspeccion - " + objetoPropuestaSancion.getIdentificadorInspeccion());
		}
				
		WebServiceImpl.logger.info("");
		
		if(objetoPropuestaSancion.getArticulosInfringidosWS() != null){
			for (int i = 0; i < objetoPropuestaSancion.getArticulosInfringidosWS().size(); i++){
				WebServiceImpl.logger.info("[crearPropuestaSancion] : ArticulosInfringidos ", (i + 1), ":");
				
				if(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getIdTipoInfraccion() != null){
					WebServiceImpl.logger.info("[crearPropuestaSancion] : 	idTipoInfraccion - " + objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getIdTipoInfraccion());
				}
				if(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getNotasArticulo() != null){
					WebServiceImpl.logger.info("[crearPropuestaSancion] : 	notasArticulo - " + objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getNotasArticulo());
				}
				if(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getFechaHecho() != null){
					WebServiceImpl.logger.info("[crearPropuestaSancion] : fechaHecho - " + objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getFechaHecho());
				}
				if(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDescripcionHecho() != null){
					WebServiceImpl.logger.info("[crearPropuestaSancion] : descripcionHecho - " + objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDescripcionHecho());
				}
				
				if(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDerechosInfringidosWS() != null){
					for (int z = 0; z < objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDerechosInfringidosWS().size(); z++){
						WebServiceImpl.logger.info("[crearPropuestaSancion] : DerechosInfringidos ", (z + 1), ":");
						
						if(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDerechosInfringidosWS().get(z) != null){
							WebServiceImpl.logger.info("[crearPropuestaSancion] : 	idDerechoInfringido - " + objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDerechosInfringidosWS().get(z).getIdDerechoInfringido());
						}						
					}
					
					WebServiceImpl.logger.info("");			
				}
			}
			
			WebServiceImpl.logger.info("");			
		}
		
		if(objetoPropuestaSancion.getDocumentosWS() != null){
			for (int i = 0; i < objetoPropuestaSancion.getDocumentosWS().size(); i++){
				WebServiceImpl.logger.info("[crearPropuestaSancion] : documentos ", (i + 1), ":");
				
				if(objetoPropuestaSancion.getDocumentosWS().get(i).getOidPID() != null){
					WebServiceImpl.logger.info("[crearPropuestaSancion] : 	Oid_PID - " + objetoPropuestaSancion.getDocumentosWS().get(i).getOidPID());
				}
				if(objetoPropuestaSancion.getDocumentosWS().get(i).getTipoDocumento() != null){
					WebServiceImpl.logger.info("[crearPropuestaSancion] : 	tipoDocumento - " + objetoPropuestaSancion.getDocumentosWS().get(i).getTipoDocumento());
				}
				if (objetoPropuestaSancion.getDocumentosWS().get(i).getNombreDocumento() != null){
					WebServiceImpl.logger.info("[crearPropuestaSancion] : 	nombreDocumento - " + objetoPropuestaSancion.getDocumentosWS().get(i).getNombreDocumento());
				}
				if (objetoPropuestaSancion.getDocumentosWS().get(i).getOidDokusi() != null){
					WebServiceImpl.logger.info("[crearPropuestaSancion] : 	Oid_Dokusi - " + objetoPropuestaSancion.getDocumentosWS().get(i).getOidDokusi());
				}
			}
			
			WebServiceImpl.logger.info("");			
		}
		
		if(objetoPropuestaSancion.getFolderId() != null){
			WebServiceImpl.logger.info("[crearPropuestaSancion] : folderId - " + objetoPropuestaSancion.getFolderId());
		}
		if(objetoPropuestaSancion.getIdTipoActividad() != null){
			WebServiceImpl.logger.info("[crearPropuestaSancion] : idTipoActividad - " + objetoPropuestaSancion.getIdTipoActividad());
		}
		if(objetoPropuestaSancion.getNotasResponsableOficina() != null){
			WebServiceImpl.logger.info("[crearPropuestaSancion] : notasResponsableOficina - " + objetoPropuestaSancion.getNotasResponsableOficina());
		}
		
		if(usuario != null){
			WebServiceImpl.logger.info("[crearPropuestaSancion] : Usuario - ", usuario);
		}
		
		if(idOrigenPropuestaSancion != null){
			WebServiceImpl.logger.info("[crearPropuestaSancion] : idOrigenPropuestaSancion - ", idOrigenPropuestaSancion);
		}		
		
		return serviciosWebService.crearPropuestaSancion(objetoPropuestaSancion, usuario, idOrigenPropuestaSancion, idTercero, idDireccion);		
	}	
	
	@WebMethod
	public String modificarPropuestaSancion(@WebParam(name = "propuestaSancionWS") PropuestaSancionWS objetoPropuestaSancion, @WebParam(name = "usuario") String usuario, @WebParam(name = "idTercero") Integer idTercero, @WebParam(name = "idDireccion") Integer idDireccion) throws Ab59Exception{
		
		WebServiceImpl.logger.info("[modificarPropuestaSancion] : ***************************************");
		WebServiceImpl.logger.info("[modificarPropuestaSancion] : Parametros de entrada Webservice AB59");
		WebServiceImpl.logger.info("[modificarPropuestaSancion] : ***************************************");
		
		if(objetoPropuestaSancion.getIdPropuestaSancion() != null){
			WebServiceImpl.logger.info("[modificarPropuestaSancion] : idPropuestaSancion - " + objetoPropuestaSancion.getIdPropuestaSancion());
		}
				
		WebServiceImpl.logger.info("");
		
		if(objetoPropuestaSancion.getArticulosInfringidosWS() != null){
			for (int i = 0; i < objetoPropuestaSancion.getArticulosInfringidosWS().size(); i++){
				WebServiceImpl.logger.info("[modificarPropuestaSancion] : ArticulosInfringidos ", (i + 1), ":");
				
				if(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getIdTipoInfraccion() != null){
					WebServiceImpl.logger.info("[modificarPropuestaSancion] : 	idTipoInfraccion - " + objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getIdTipoInfraccion());
				}
				if(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getNotasArticulo() != null){
					WebServiceImpl.logger.info("[modificarPropuestaSancion] : 	notasArticulo - " + objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getNotasArticulo());
				}
				if(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getFechaHecho() != null){
					WebServiceImpl.logger.info("[modificarPropuestaSancion] : fechaHecho - " + objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getFechaHecho());
				}
				if(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDescripcionHecho() != null){
					WebServiceImpl.logger.info("[modificarPropuestaSancion] : descripcionHecho - " + objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDescripcionHecho());
				}
				
				if(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDerechosInfringidosWS() != null){
					for (int z = 0; z < objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDerechosInfringidosWS().size(); z++){
						WebServiceImpl.logger.info("[modificarPropuestaSancion] : DerechosInfringidos ", (z + 1), ":");
						
						if(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDerechosInfringidosWS().get(z) != null){
							WebServiceImpl.logger.info("[modificarPropuestaSancion] : 	idDerechoInfringido - " + objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDerechosInfringidosWS().get(z).getIdDerechoInfringido());
						}						
					}
					
					WebServiceImpl.logger.info("");			
				}
			}
			
			WebServiceImpl.logger.info("");			
		}
		
		if(objetoPropuestaSancion.getDocumentosWS() != null){
			for (int i = 0; i < objetoPropuestaSancion.getDocumentosWS().size(); i++){
				WebServiceImpl.logger.info("[modificarPropuestaSancion] : documentos ", (i + 1), ":");
				
				if(objetoPropuestaSancion.getDocumentosWS().get(i).getOidPID() != null){
					WebServiceImpl.logger.info("[modificarPropuestaSancion] : 	Oid_PID - " + objetoPropuestaSancion.getDocumentosWS().get(i).getOidPID());
				}
				if(objetoPropuestaSancion.getDocumentosWS().get(i).getTipoDocumento() != null){
					WebServiceImpl.logger.info("[modificarPropuestaSancion] : 	tipoDocumento - " + objetoPropuestaSancion.getDocumentosWS().get(i).getTipoDocumento());
				}
				if (objetoPropuestaSancion.getDocumentosWS().get(i).getNombreDocumento() != null){
					WebServiceImpl.logger.info("[crearPropuestaSancion] : 	nombreDocumento - " + objetoPropuestaSancion.getDocumentosWS().get(i).getNombreDocumento());
				}
				if (objetoPropuestaSancion.getDocumentosWS().get(i).getOidDokusi() != null){
					WebServiceImpl.logger.info("[crearPropuestaSancion] : 	Oid_Dokusi - " + objetoPropuestaSancion.getDocumentosWS().get(i).getOidDokusi());
				}
			}
			
			WebServiceImpl.logger.info("");			
		}
		
		if(objetoPropuestaSancion.getNotasResponsableOficina() != null){
			WebServiceImpl.logger.info("[modificarPropuestaSancion] : notasResponsableOficina - " + objetoPropuestaSancion.getNotasResponsableOficina());
		}
		
		if(usuario != null){
			WebServiceImpl.logger.info("[modificarPropuestaSancion] : Usuario - ", usuario);
		}
		
		return serviciosWebService.modificarPropuestaSancion(objetoPropuestaSancion, usuario, idTercero, idDireccion);		
	}
	
	@WebMethod
	public String eliminarPropuestaSancion(@WebParam(name = "idPropuestaSancion") Integer idPropuestaSancion, @WebParam(name = "usuario") String usuario) throws Ab59Exception{
		
		WebServiceImpl.logger.info("[eliminarPropuestaSancion] : ***************************************");
		WebServiceImpl.logger.info("[eliminarPropuestaSancion] : Parametros de entrada Webservice AB59");
		WebServiceImpl.logger.info("[eliminarPropuestaSancion] : ***************************************");
		
		if(idPropuestaSancion != null){
			WebServiceImpl.logger.info("[eliminarPropuestaSancion] : idPropuestaSancion - " + idPropuestaSancion);
		}
				
		WebServiceImpl.logger.info("");
				
		if(usuario != null){
			WebServiceImpl.logger.info("[eliminarPropuestaSancion] : Usuario - ", usuario);
		}
		
		return serviciosWebService.eliminarPropuestaSancion(idPropuestaSancion, usuario);		
	}
}
