package com.ejie.ab59.control.verExpediente;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.service.sanciones.FichaSancionService;
import com.ejie.ab59.service.sanciones.SancionesService;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/verexpediente")

public class VerExpedienteController {

	private static final Logger logger = LoggerFactory.getLogger(VerExpedienteController.class);

	@Autowired
	private SancionesService sancionesService;

	@Autowired
	private FichaSancionService fichaSancionService;

	/**
	 * Metodo de presentacion de las Tabs.
	 * 
	 * @param model
	 *            Model
	 * @param idSancion
	 *            Integer
	 * @return String
	 */
	@RequestMapping(value = "/{folderId}", method = RequestMethod.GET)
	public String getFormEdit(HttpServletRequest httpRequest, Model model, @PathVariable String folderId) {

		VerExpedienteController.logger.info("[GET - View] : Ver Expediente - Tabs de datos basicos de sanción");

		Expedientes expediente = new Expedientes();
		expediente.setFolderId(folderId);

		Sanciones sancion = new Sanciones();
		sancion.setExpediente(expediente);

		sancion = this.sancionesService.findByFolderId(sancion);
		if (sancion != null) {
			Sanciones sancionAux = this.sancionesService.obtenerCabeceraSancion(sancion.getIdSancion());
			return this.fichaSancionService.fichaSancionView(httpRequest, sancionAux, model, true);
		} else {
			return "folderError";
		}
	}
}
