package com.ejie.ab59.control.tablasMaestras;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.comun.SeguridadAplicacion;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.tablasMaestras.TiposFinalizacion;
import com.ejie.ab59.service.procedimientos.ProcedimientosService;
import com.ejie.ab59.service.tablasMaestras.TiposFinalizacionService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/tiposFinalizacion")

public class TiposFinalizacionController {

	private static final Logger logger = LoggerFactory.getLogger(TiposFinalizacionController.class);

	@Autowired
	private TiposFinalizacionService tiposFinalizacionService;
	@Autowired
	private ProcedimientosService procedimientosService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idTipoFinalizacion
	 *            Long
	 * @return TiposFinalizacion Objeto correspondiente al identificador
	 *         indicado.
	 */
	@RequestMapping(value = "/{idTipoFinalizacion}", method = RequestMethod.GET)
	public @ResponseBody TiposFinalizacion get(@PathVariable Long idTipoFinalizacion) {
		TiposFinalizacion tipoFinalizacion = new TiposFinalizacion();
		tipoFinalizacion.setIdTipoFinalizacion(idTipoFinalizacion);
		tipoFinalizacion = this.tiposFinalizacionService.find(tipoFinalizacion);
		TiposFinalizacionController.logger.info("[GET - findBy_PK] : Obtener Tipos de Finalización por PK");
		return tipoFinalizacion;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterTiposFinalizacion
	 *            TiposFinalizacion Objeto que contiene los parametros de
	 *            filtrado utilizados en la busqueda.
	 * @return List<TiposFinalizacion> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TiposFinalizacion> getAll(@ModelAttribute TiposFinalizacion filterTiposFinalizacion) {
		TiposFinalizacionController.logger.info("[GET - find_ALL] : Obtener Tipos de Finalización por filtro");
		return this.tiposFinalizacionService.findAll(filterTiposFinalizacion, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param tipoFinalizacion
	 *            TiposFinalizacion Bean que contiene la informacion a
	 *            modificar.
	 * @return TiposFinalizacion Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody TiposFinalizacion edit(@RequestBody TiposFinalizacion tipoFinalizacion,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Calendar cal = Calendar.getInstance();
		tipoFinalizacion.setFechaUltmodificacion(cal.getTime());
		tipoFinalizacion.setUsuarioUltmodificacion(usuario.getUsuario());

		TiposFinalizacion tipoFinalizacionAux = this.tiposFinalizacionService.update(tipoFinalizacion);
		TiposFinalizacionController.logger.info("[PUT] : Tipo de Finalización actualizado correctamente");
		return tipoFinalizacionAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param tipoFinalizacion
	 *            TiposFinalizacion Bean que contiene la informacion con la que
	 *            se va a crear el nuevo registro.
	 * @return TiposFinalizacion Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TiposFinalizacion add(@RequestBody TiposFinalizacion tipoFinalizacion,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Calendar cal = Calendar.getInstance();
		tipoFinalizacion.setFechaRegistro(cal.getTime());
		tipoFinalizacion.setUsuarioRegistro(usuario.getUsuario());
		tipoFinalizacion.setBaja(Constantes.ESTADO_NO_BAJA);

		TiposFinalizacion tipoFinalizacionAux = this.tiposFinalizacionService.add(tipoFinalizacion);
		TiposFinalizacionController.logger.info("[POST] : Tipo de Finalización insertado correctamente");
		return tipoFinalizacionAux;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		TiposFinalizacionController.logger.info("[GET - View] : tipos de finalización");
		String idDireccion = SeguridadAplicacion.precargarDireccion();
		Procedimientos procedimiento = null;
		String idProcedimiento = "";

		if (!"".contentEquals(idDireccion)) {
			procedimiento = this.procedimientosService.obtenerProcedimientos(Integer.parseInt(idDireccion));
		}

		if (procedimiento != null) {
			idProcedimiento = String.valueOf(procedimiento.getIdProcedimiento());
		}

		model.addAttribute("procedimientoPrecargado", idProcedimiento);
		return "tiposFinalizacion";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterTiposFinalizacion
	 *            TiposFinalizacion Bean que contiene los parametros de filtrado
	 *            a emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<TiposFinalizacion> Dto que contiene el resultado
	 *         del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<TiposFinalizacion> filter(
			@RequestJsonBody(param = "filter") TiposFinalizacion filterTiposFinalizacion,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TiposFinalizacionController.logger.info("[POST - filter] : Obtener Tipos de Finalización");
		filterTiposFinalizacion.setBaja(Constantes.ESTADO_NO_BAJA);
		return this.tiposFinalizacionService.filter(filterTiposFinalizacion, tableRequestDto);
	}

	/**
	 *
	 * @param filterTiposFinalizacion
	 *            TiposFinalizacion Objeto que contiene los parametros de
	 *            filtrado utilizados en la busqueda.
	 * @return List<TiposFinalizacion> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(value = "/cargarCombo", method = RequestMethod.GET)
	public @ResponseBody List<TiposFinalizacion> cargarCombo(
			@ModelAttribute TiposFinalizacion filterTiposFinalizacion) {
		TiposFinalizacionController.logger
				.info("[GET - find_ALL] : Obtener Tipos de Finalización para cargar un combo");
		Procedimientos procedimiento = new Procedimientos();
		if (filterTiposFinalizacion.getIdDireccion() != null) {
			if (filterTiposFinalizacion.getIdDireccion() == Constantes.ID_TURISMO_DIRECCION) {
				procedimiento = this.procedimientosService.obtenerProcedimientos(Constantes.ID_TURISMO_DIRECCION);
				filterTiposFinalizacion.setProcedimiento(procedimiento);
			} else if (filterTiposFinalizacion.getIdDireccion() == Constantes.ID_COMERCIO_DIRECCION) {
				procedimiento = this.procedimientosService.obtenerProcedimientos(Constantes.ID_COMERCIO_DIRECCION);
				filterTiposFinalizacion.setProcedimiento(procedimiento);
			} else {
				return new ArrayList<TiposFinalizacion>();
			}
		}

		return this.tiposFinalizacionService.cargarCombo(filterTiposFinalizacion);
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idTipoFinaliacion
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return TiposFinalizacion Bean eliminado.
	 */
	@RequestMapping(value = "/{idTipoFinalizacion}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody TiposFinalizacion remove(@PathVariable Long idTipoFinalizacion,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		TiposFinalizacion tipoFinalizacion = new TiposFinalizacion();

		Calendar cal = Calendar.getInstance();
		tipoFinalizacion.setFechaUltmodificacion(cal.getTime());
		tipoFinalizacion.setUsuarioUltmodificacion(usuario.getUsuario());

		tipoFinalizacion.setIdTipoFinalizacion(idTipoFinalizacion);
		tipoFinalizacion.setBaja(Constantes.ESTADO_BAJA);

		this.tiposFinalizacionService.remove(tipoFinalizacion);
		TiposFinalizacionController.logger.info("[DELETE] : TiposFinalizacion borrado correctamente");
		return tipoFinalizacion;
	}
}
