package com.ejie.ab59.control.tablasMaestras;

import java.util.Calendar;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.tablasMaestras.Instructores;
import com.ejie.ab59.service.tablasMaestras.InstructoresService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/instructores")

public class InstructoresController {

	private static final Logger logger = LoggerFactory.getLogger(InstructoresController.class);

	@Autowired
	private InstructoresService instructoresService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idInstructor
	 *            Long
	 * @return Instructores Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idInstructor}", method = RequestMethod.GET)
	public @ResponseBody Instructores get(@PathVariable Long idInstructor) {
		Instructores instructor = new Instructores();
		instructor.setIdInstructor(idInstructor);
		instructor = this.instructoresService.find(instructor);
		InstructoresController.logger.info("[GET - findBy_PK] : Obtener Instructores por PK");
		return instructor;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterInstructores
	 *            Instructores Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Instructores> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Instructores> getAll(@ModelAttribute Instructores filterInstructores) {
		InstructoresController.logger.info("[GET - find_ALL] : Obtener Instructores por filtro");
		return this.instructoresService.findAll(filterInstructores, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param instructor
	 *            Instructores Bean que contiene la informacion a modificar.
	 * @return Instructores Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Instructores edit(@RequestBody Instructores instructor,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Calendar cal = Calendar.getInstance();
		instructor.setFechaUltmodificacion(cal.getTime());
		instructor.setUsuarioUltmodificacion(usuario.getUsuario());

		Instructores instructorAux = this.instructoresService.update(instructor);
		InstructoresController.logger.info("[PUT] : Instructor actualizado correctamente");
		return instructorAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param instructor
	 *            Instructores Bean que contiene la informacion con la que se va
	 *            a crear el nuevo registro.
	 * @return Instructores Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Instructores add(@RequestBody Instructores instructor,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Calendar cal = Calendar.getInstance();
		instructor.setFechaRegistro(cal.getTime());
		instructor.setUsuarioRegistro(usuario.getUsuario());

		instructor.setBaja(Constantes.ESTADO_NO_BAJA);

		Instructores instructorAux = this.instructoresService.add(instructor);
		InstructoresController.logger.info("[POST] : Instructor insertado correctamente");
		return instructorAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idInstructor
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return Instructores Bean eliminado.
	 */
	@RequestMapping(value = "/{idInstructor}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Instructores remove(@PathVariable Long idInstructor,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Instructores instructor = new Instructores();

		Calendar cal = Calendar.getInstance();
		instructor.setFechaUltmodificacion(cal.getTime());
		instructor.setUsuarioUltmodificacion(usuario.getUsuario());

		instructor.setIdInstructor(idInstructor);
		instructor.setBaja(Constantes.ESTADO_BAJA);

		this.instructoresService.remove(instructor);
		InstructoresController.logger.info("[DELETE] : Instructor borrado correctamente");
		return instructor;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		InstructoresController.logger.info("[GET - View] : instructores");
		return "instructores";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterInstructores
	 *            Instructores Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<Instructores> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<Instructores> filter(
			@RequestJsonBody(param = "filter") Instructores filterInstructores,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		InstructoresController.logger.info("[POST - filter] : Obtener Instructores");

		filterInstructores.setBaja(Constantes.ESTADO_NO_BAJA);
		return this.instructoresService.filter(filterInstructores, tableRequestDto);
	}

	/**
	 *
	 * @param filterInstructores
	 *            Instructores Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Instructores> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(value = "/cargarCombo", method = RequestMethod.GET)
	public @ResponseBody List<Instructores> cargarCombo(@ModelAttribute Instructores filterInstructores) {
		InstructoresController.logger.info("[GET - find_ALL] : Obtener Instructores para cargar un combo");
		return this.instructoresService.cargarCombo(filterInstructores);
	}
}
