package com.ejie.ab59.control.tablasMaestras;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab59.clientesWS.ab61WebService.DocumentoWS;
import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.propuestasSancion.DocProSan;
import com.ejie.ab59.service.expedientes.ExpedientesService;
import com.ejie.ab59.service.propuestasSancion.DocProSanService;
import com.ejie.ab59.webservice.adaptadores.PifAdapter;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/docprosan")

public class DocProSanController {

	private static final Logger logger = LoggerFactory.getLogger(DocProSanController.class);

	@Autowired
	private DocProSanService docProSanService;
	@Autowired
	private ExpedientesService expedientesService;
	@Autowired
	private PifAdapter pifAdapterService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */
	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterDocProSan
	 *            DocProSanSan Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<DocProSan> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/propuestaSancion/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<DocProSan> filterPropuestaSancion(
			@RequestJsonBody(param = "filter") DocProSan filterDocProSan,
			@RequestJsonBody TableRequestDto tableRequestDto) {

		DocProSanController.logger.info("[POST - filter] : Obtener Documentos de la propuesta de sanción");

		return this.docProSanService.filterByPropuestaSancion(filterDocProSan, tableRequestDto);
	}

	/**
	 * 
	 * @param httpRequestHttpServletRequest
	 * @param idDocumento
	 *            Integer
	 * @param oidPid
	 *            String
	 * @param idTipoPlantilla
	 *            Integer
	 * @param idSancion
	 *            Integer
	 * @param usuario
	 *            Usuario
	 * 
	 * @return String
	 * 
	 * @throws Ab61Exception
	 */
	@RequestMapping(value = "aportarDocumentoPid/{idDocumento}/{oidPid}/{idPlantilla}/{idSancion}", method = RequestMethod.GET)
	public @ResponseBody String aportarDocumentoPid(HttpServletRequest httpRequest, @PathVariable Integer idDocumento,
			@PathVariable String oidPid, @PathVariable Integer idPlantilla, @PathVariable Integer idSancion,
			@ModelAttribute("usuario") Usuario usuario) throws Ab61Exception {

		List<DocumentoWS> documentosWS = new ArrayList<DocumentoWS>();
		DocumentoWS documentoWS = new DocumentoWS();
		documentoWS.setOidPid(oidPid);
		documentoWS.setIdPlantilla(idPlantilla);
		documentosWS.add(documentoWS);

		Expedientes expedienteAux = this.expedientesService.findExpedienteSancion(idSancion);

		DocProSan docProSan = new DocProSan();
		docProSan.setIdDocumento(idDocumento);
		String respuesta = "ok";
		try {
			respuesta = this.docProSanService.aportarDocumentosPlatea(docProSan, documentosWS,
					expedienteAux.getFolderId(), expedienteAux.getProcedimiento().getCodProcedureId(), usuario);
		} catch (Ab61Exception e) {
			String idioma = LocaleContextHolder.getLocale().getLanguage();
			if ("es".equalsIgnoreCase(idioma)) {
				respuesta = e.getFaultInfo().getMensajeCastellano();
			} else {
				respuesta = e.getFaultInfo().getMensajeEuskera();
			}
		}
		return respuesta;
	}

	@RequestMapping(value = "aportarDocumentoDokusi/{idDocumento}/{oidDokusi}/{idPlantilla}/{idSancion}", method = RequestMethod.GET)
	public @ResponseBody String aportarDocumentoDokusi(HttpServletRequest httpRequest,
			@PathVariable Integer idDocumento, @PathVariable String oidDokusi, @PathVariable Integer idPlantilla,
			@PathVariable Integer idSancion, @ModelAttribute("usuario") Usuario usuario) throws Ab61Exception {

		List<DocumentoWS> documentosWS = new ArrayList<DocumentoWS>();
		DocumentoWS documentoWS = new DocumentoWS();
		documentoWS.setOidDokusi(oidDokusi);
		documentoWS.setIdPlantilla(idPlantilla);
		documentosWS.add(documentoWS);

		Expedientes expedienteAux = this.expedientesService.findExpedienteSancion(idSancion);

		DocProSan docProSan = new DocProSan();
		docProSan.setIdDocumento(idDocumento);
		String respuesta = "ok";
		try {
			respuesta = this.docProSanService.aportarDocumentosPlatea(docProSan, documentosWS,
					expedienteAux.getFolderId(), expedienteAux.getProcedimiento().getCodProcedureId(), usuario);
		} catch (Ab61Exception e) {
			String idioma = LocaleContextHolder.getLocale().getLanguage();
			if ("es".equalsIgnoreCase(idioma)) {
				respuesta = e.getFaultInfo().getMensajeCastellano();
			} else {
				respuesta = e.getFaultInfo().getMensajeEuskera();
			}
		}
		return respuesta;
	}

	@RequestMapping(value = "/descargarDocumentoDokusi/{oidDokusi}/{nombreDocumento:.+}", method = RequestMethod.GET)
	public @ResponseBody void descargarDocumentoDokusi(@PathVariable String oidDokusi,
			@PathVariable String nombreDocumento, HttpServletResponse response) throws Ab61Exception, IOException {

		BufferedInputStream bIS = null;

		try {

			String pathDokusi = this.docProSanService.descargarDocumentoDokusi(oidDokusi, Constantes.CODIGO_APLICACION,
					null);

			if (!StringUtils.isEmpty(pathDokusi)) {
				response.setHeader("content-disposition", "attachment; filename=\"" + nombreDocumento + "\"");
				bIS = new BufferedInputStream(this.pifAdapterService.getFile(pathDokusi));
				IOUtils.copy(bIS, response.getOutputStream());
				response.flushBuffer();
			}
			DocProSanController.logger.info("descargarDocumentoDokusi : " + pathDokusi);
		} catch (Exception e) {
			DocProSanController.logger.error("descargarDocumentoDokusi - ERROR", e);
		} finally {
			if (bIS != null) {
				bIS.close();
			}
		}

	}

	@RequestMapping(value = "/descargarDocumentoPid/{oidPid}/{nombreDocumento:.+}", method = RequestMethod.GET)
	public @ResponseBody void descargarDocumentoPid(@PathVariable String oidPid, @PathVariable String nombreDocumento,
			HttpServletResponse response) throws Ab61Exception, IOException {

		BufferedInputStream bIS = null;

		try {

			String pathPIF = this.docProSanService.descargarDocumentoPid(oidPid, Constantes.CODIGO_APLICACION, null);

			if (!StringUtils.isEmpty(pathPIF)) {
				response.setHeader("content-disposition", "attachment; filename=\"" + nombreDocumento + "\"");
				bIS = new BufferedInputStream(this.pifAdapterService.getFile(pathPIF));
				IOUtils.copy(bIS, response.getOutputStream());
				response.flushBuffer();
			}
			DocProSanController.logger.info("descargarDocumentoPid : " + pathPIF);
		} catch (Exception e) {
			DocProSanController.logger.error("descargarDocumentoPid - ERROR", e);
		} finally {
			if (bIS != null) {
				bIS.close();
			}
		}
	}
}
