package com.ejie.ab59.control.tablasMaestras;

import java.util.Calendar;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.comun.SeguridadAplicacion;
import com.ejie.ab59.model.procedimientos.Aplicaciones;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.tablasMaestras.Derechos;
import com.ejie.ab59.model.tablasMaestras.RelInfDer;
import com.ejie.ab59.service.procedimientos.ProcedimientosService;
import com.ejie.ab59.service.tablasMaestras.DerechosService;
import com.ejie.ab59.service.tablasMaestras.RelInfDerService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/derechos")

public class DerechosController {

	private static final Logger logger = LoggerFactory.getLogger(DerechosController.class);

	@Autowired
	private DerechosService derechosService;

	@Autowired
	private RelInfDerService relInfDerService;

	@Autowired
	private ProcedimientosService procedimientosService;

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		DerechosController.logger.info("[GET - View] : Derechos");
		String idDireccion = SeguridadAplicacion.precargarDireccion();
		Procedimientos procedimiento = null;
		String idProcedimiento = "";

		if (!"".contentEquals(idDireccion)) {
			procedimiento = this.procedimientosService.obtenerProcedimientos(Integer.parseInt(idDireccion));
		}

		if (procedimiento != null) {
			idProcedimiento = String.valueOf(procedimiento.getIdProcedimiento());
		}

		model.addAttribute("procedimientoPrecargado", idProcedimiento);
		return "derechos";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterDerechos
	 *            Derechos Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<Derechos> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<Derechos> filter(@RequestJsonBody(param = "filter") Derechos filterDerechos,
			@RequestJsonBody TableRequestDto tableRequestDto) {

		DerechosController.logger.info("[POST - filter] : Obtener Derechos");
		Procedimientos procedimientoAux = new Procedimientos();

		if (filterDerechos.getProcedimiento() != null) {
			procedimientoAux = filterDerechos.getProcedimiento();
		}

		Aplicaciones aplicacion = new Aplicaciones();
		aplicacion.setCodigoAplicacion(Constantes.CODIGO_APLICACION.toUpperCase());
		procedimientoAux.setAplicacion(aplicacion);

		filterDerechos.setProcedimiento(procedimientoAux);
		filterDerechos.setBaja(Constantes.ESTADO_NO_BAJA);

		return this.derechosService.filter(filterDerechos, tableRequestDto);
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param derechos
	 *            Derechos Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Derechos Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Derechos add(@RequestBody Derechos derechos,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Calendar cal = Calendar.getInstance();
		derechos.setFechaRegistro(cal.getTime());
		derechos.setUsuarioRegistro(usuario.getUsuario());
		derechos.setBaja(Constantes.ESTADO_NO_BAJA);
		Derechos derechosAux = this.derechosService.add(derechos);
		DerechosController.logger.info("[POST] : Derecho insertado correctamente");

		// Guardar las relaciones de los derechos y las infracciones
		String[] listaIdsInfracciones = derechos.getIdsInfracciones().split(",");
		for (String idInfraccion : listaIdsInfracciones) {
			RelInfDer relInfDer = new RelInfDer();
			relInfDer.setIdDerecho(derechosAux.getIdDerecho());
			relInfDer.setIdInfraccion(Integer.parseInt(idInfraccion));
			relInfDer.setUsuarioRegistro(usuario.getUsuario());
			this.relInfDerService.add(relInfDer);
		}

		return derechosAux;
	}

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idDerecho
	 *            Integer
	 * @return Derechos Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idDerecho}", method = RequestMethod.GET)
	public @ResponseBody Derechos get(@PathVariable Integer idDerecho) {
		Derechos derechos = new Derechos();
		derechos.setIdDerecho(idDerecho);
		derechos = this.derechosService.find(derechos);
		DerechosController.logger.info("[GET - findBy_PK] : Obtener Derechos por PK");
		return derechos;
	}

	@RequestMapping(value = "descripciones/{idsDerechos}", method = RequestMethod.GET)
	public @ResponseBody List<Derechos> getDescripciones(@PathVariable List<Integer> idsDerechos) {
		String derechosString = idsDerechos.toString();
		if (derechosString != null) {
			derechosString = derechosString.substring(1, derechosString.length() - 1);
		}
		List<Derechos> derechos = this.derechosService.findDescripciones(derechosString);
		DerechosController.logger.info("[GET - findBy_PK] : Obtener Derechos por PK");
		return derechos;
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param derechos
	 *            Derechos Bean que contiene la informacion a modificar.
	 * @return Derechos Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Derechos edit(@RequestBody Derechos derechos,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Calendar cal = Calendar.getInstance();
		derechos.setFechaUltmodificacion(cal.getTime());
		derechos.setUsuarioUltmodificacion(usuario.getUsuario());

		this.relInfDerService.removeByIdDerecho(derechos);

		// Guardar las relaciones de los derechos y las infracciones
		String[] listaIdsInfracciones = derechos.getIdsInfracciones().split(",");
		for (String idInfraccion : listaIdsInfracciones) {
			RelInfDer relInfDer = new RelInfDer();
			relInfDer.setIdDerecho(derechos.getIdDerecho());
			relInfDer.setIdInfraccion(Integer.parseInt(idInfraccion));
			relInfDer.setUsuarioRegistro(usuario.getUsuario());
			this.relInfDerService.add(relInfDer);
		}

		Derechos derechosAux = this.derechosService.update(derechos);
		DerechosController.logger.info("[PUT] : Derecho actualizado correctamente");
		return derechosAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idDerecho
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return Derechos Bean eliminado.
	 */
	@RequestMapping(value = "/{idDerecho}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Derechos remove(@PathVariable Integer idDerecho,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Derechos derecho = new Derechos();

		Calendar cal = Calendar.getInstance();
		derecho.setFechaUltmodificacion(cal.getTime());
		derecho.setUsuarioUltmodificacion(usuario.getUsuario());

		derecho.setIdDerecho(idDerecho);
		derecho.setBaja(Constantes.ESTADO_BAJA);

		this.derechosService.remove(derecho);
		DerechosController.logger.info("[DELETE] : Derecho borrado correctamente");
		return derecho;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterDerechos
	 *            Derechos Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Infracciones> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(value = "/cargarCombo", method = RequestMethod.GET)
	public @ResponseBody List<Derechos> cargarCombo(@ModelAttribute Derechos filterDerechos) {
		DerechosController.logger.info("[GET - find_ALL] : Obtener Derechos por filtro");
		return this.derechosService.cargarCombo(filterDerechos);
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterInfracciones
	 *            Infracciones Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Infracciones> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(value = "/cargarComboDerechos", method = RequestMethod.GET)
	public @ResponseBody List<Derechos> cargarComboDerechos(@ModelAttribute Derechos filterDerechos) {
		DerechosController.logger.info("[POST - filter] : Obtener Derechos");
		Procedimientos procedimientoAux = new Procedimientos();

		if (filterDerechos.getProcedimiento() != null) {
			procedimientoAux = filterDerechos.getProcedimiento();
		}

		Aplicaciones aplicacion = new Aplicaciones();
		aplicacion.setCodigoAplicacion(Constantes.CODIGO_APLICACION.toUpperCase());
		procedimientoAux.setAplicacion(aplicacion);

		filterDerechos.setProcedimiento(procedimientoAux);
		filterDerechos.setBaja(Constantes.ESTADO_NO_BAJA);

		return this.derechosService.cargarComboDerechos(filterDerechos, new TableRequestDto());
	}
}
