package com.ejie.ab59.control.tablasMaestras;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.SeguridadAplicacion;
import com.ejie.ab59.model.configuracionInicioOficio.AlcancesResolucion;
import com.ejie.ab59.model.configuracionInicioOficio.RelIniOfiAlcRes;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.tablasMaestras.ConfIniOfi;
import com.ejie.ab59.service.configuracionInicioOficio.RelIniOfiAlcResService;
import com.ejie.ab59.service.procedimientos.ProcedimientosService;
import com.ejie.ab59.service.tablasMaestras.ConfIniOfiService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * ConfIniOfiController  
 * 
 *  
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/confIniOfi")

public class ConfIniOfiController {

	private static final Logger logger = LoggerFactory.getLogger(ConfIniOfiController.class);

	@Autowired
	private ConfIniOfiService confIniOfiService;

	@Autowired
	private RelIniOfiAlcResService relIniOfiAlcResService;

	@Autowired
	private ProcedimientosService procedimientosService;

	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		ConfIniOfiController.logger.info("[GET - View] : maint getFormEdit");
		String idDireccion = SeguridadAplicacion.precargarDireccion();
		Procedimientos procedimiento = null;
		String idProcedimiento = "";

		if (!"".contentEquals(idDireccion)) {
			procedimiento = this.procedimientosService.obtenerProcedimientos(Integer.parseInt(idDireccion));
		}

		if (procedimiento != null) {
			idProcedimiento = String.valueOf(procedimiento.getIdProcedimiento());
		}

		model.addAttribute("procedimientoPrecargado", idProcedimiento);
		return "confIniOfi";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterConfIniOfi
	 *            ConfIniOfi Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<ConfIniOfi> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<ConfIniOfi> filter(
			@RequestJsonBody(param = "filter") ConfIniOfi filterConfIniOfi,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		ConfIniOfiController.logger.info("[POST - filter] : Obtener Tipos de Finalización");
		return this.confIniOfiService.filter(filterConfIniOfi, tableRequestDto);
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param confIniOfi
	 *            ConfIniOfi Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return ConfIniOfi Bean resultante del proceso de creacion.
	 * @throws Exception
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody ConfIniOfi add(@RequestBody ConfIniOfi confIniOfi,
			@ModelAttribute(value = "usuario") Usuario usuario) throws Exception {

		List<ConfIniOfi> listaExisteRegistroProcedimiento = this.confIniOfiService
				.findAll(new ConfIniOfi(confIniOfi.getProcedimiento().getIdProcedimiento()), new TableRequestDto());

		ConfIniOfi confIniOfiAux = null;
		if (listaExisteRegistroProcedimiento.isEmpty()) {

			confIniOfi.setUsuarioRegistro(usuario.getUsuario());

			confIniOfiAux = this.confIniOfiService.add(confIniOfi);

			insertarRelIniOfiAlc(confIniOfi, confIniOfiAux);

		} else {

			throw new Exception("errorGuardadoProcedRepetido");

		}

		ConfIniOfiController.logger.info("[POST] : ConfIniOfi insertado correctamente");
		return confIniOfiAux;
	}

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idConfiguracion
	 *            Long
	 * @return ConfIniOfi Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idConfiguracion}", method = RequestMethod.GET)
	public @ResponseBody ConfIniOfi get(@PathVariable Long idConfiguracion, Model model) {

		ConfIniOfi confIniOfi = new ConfIniOfi();
		confIniOfi.setIdConfiguracion(idConfiguracion);
		confIniOfi = this.confIniOfiService.find(confIniOfi);

		RelIniOfiAlcRes relIniOfiAlcRes = new RelIniOfiAlcRes();
		relIniOfiAlcRes.setConfIniOfi(confIniOfi);

		List<RelIniOfiAlcRes> listaRelacion = this.relIniOfiAlcResService.findAll(relIniOfiAlcRes,
				new TableRequestDto());

		String idsAlcancesResolcuion = "";
		List<AlcancesResolucion> listaAlcancesResolucion = new ArrayList<AlcancesResolucion>();
		for (int i = 0; i < listaRelacion.size(); i++) {
			AlcancesResolucion alcancesResolucion = new AlcancesResolucion();
			alcancesResolucion
					.setIdAlcanceResolucion(listaRelacion.get(i).getAlcancesResolucion().getIdAlcanceResolucion());
			listaAlcancesResolucion.add(alcancesResolucion);

			idsAlcancesResolcuion += Long
					.toString(listaRelacion.get(i).getAlcancesResolucion().getIdAlcanceResolucion());
			if ((i + 1) != listaRelacion.size()) {
				idsAlcancesResolcuion += ",";
			}
		}

		confIniOfi.setIdsAlcancesResolcuion(idsAlcancesResolcuion);
		confIniOfi.setListaAlcancesResolucion(listaAlcancesResolucion);

		ConfIniOfiController.logger.info("[GET - findBy_PK] : Obtener Configuracion inicio oficio");
		return confIniOfi;
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param tipoFinalizacion
	 *            TiposFinalizacion Bean que contiene la informacion a
	 *            modificar.
	 * @return TiposFinalizacion Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody ConfIniOfi edit(@RequestBody ConfIniOfi confIniOfi,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		confIniOfi.setUsuarioUltmodificacion(usuario.getUsuario());
		ConfIniOfi confIniOfiAux = this.confIniOfiService.update(confIniOfi);

		eliminarRelIniOfiAlc(confIniOfi);
		insertarRelIniOfiAlc(confIniOfi, confIniOfiAux);

		ConfIniOfiController.logger.info("[PUT] : Configuracion inicio oficio actualizada correctamente");
		return confIniOfiAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idConfiguracion
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return TiposFinalizacion Bean eliminado.
	 */
	@RequestMapping(value = "/{idConfiguracion}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody ConfIniOfi remove(@PathVariable Long idConfiguracion,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		ConfIniOfi confIniOfi = new ConfIniOfi();
		confIniOfi.setIdConfiguracion(idConfiguracion);
		confIniOfi.setPublicarTablon(false);
		eliminarRelIniOfiAlc(confIniOfi);
		this.confIniOfiService.remove(confIniOfi);
		ConfIniOfiController.logger.info("[DELETE] : Configuracion inicio oficio borrado correctamente");
		return confIniOfi;
	}

	private void insertarRelIniOfiAlc(ConfIniOfi confIniOfi, ConfIniOfi confIniOfiAux) {

		if (confIniOfi.getListaAlcancesResolucion() != null && !confIniOfi.getListaAlcancesResolucion().isEmpty()) {

			for (int i = 0; i < confIniOfi.getListaAlcancesResolucion().size(); i++) {

				RelIniOfiAlcRes relIniOfiAlcRes = new RelIniOfiAlcRes();
				relIniOfiAlcRes.setConfIniOfi(confIniOfiAux);
				relIniOfiAlcRes.setAlcancesResolucion(confIniOfi.getListaAlcancesResolucion().get(i));
				relIniOfiAlcRes.setUsuarioRegistro(confIniOfiAux.getUsuarioRegistro() == null
						? confIniOfiAux.getUsuarioUltmodificacion() : confIniOfiAux.getUsuarioRegistro());
				this.relIniOfiAlcResService.add(relIniOfiAlcRes);

			}
		}
	}

	private void eliminarRelIniOfiAlc(ConfIniOfi confIniOfi) {
		this.relIniOfiAlcResService.removeByConfIniOfi(confIniOfi);
	}

}
