package com.ejie.ab59.control.tablasMaestras;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.comun.SeguridadAplicacion;
import com.ejie.ab59.model.procedimientos.Aplicaciones;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.tablasMaestras.Calificaciones;
import com.ejie.ab59.service.procedimientos.ProcedimientosService;
import com.ejie.ab59.service.tablasMaestras.CalificacionesService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * CalificacionesController  
 * 
 *  
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/calificaciones")

public class CalificacionesController {

	private static final Logger logger = LoggerFactory.getLogger(CalificacionesController.class);

	@Autowired
	private CalificacionesService calificacionesService;

	@Autowired
	private ProcedimientosService procedimientosService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idCalificacion
	 *            Long
	 * @return Calificaciones Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idCalificacion}", method = RequestMethod.GET)
	public @ResponseBody Calificaciones get(@PathVariable Long idCalificacion) {
		Calificaciones calificaciones = new Calificaciones();
		calificaciones.setIdCalificacion(idCalificacion);
		calificaciones = this.calificacionesService.find(calificaciones);
		CalificacionesController.logger.info("[GET - findBy_PK] : Obtener Calificaciones por PK");
		return calificaciones;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterCalificaciones
	 *            Calificaciones Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Calificaciones> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Calificaciones> getAll(@ModelAttribute Calificaciones filterCalificaciones) {
		CalificacionesController.logger.info("[GET - find_ALL] : Obtener Calificaciones por filtro");
		return this.calificacionesService.findAll(filterCalificaciones, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param calificaciones
	 *            Calificaciones Bean que contiene la informacion a modificar.
	 * @return Calificaciones Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Calificaciones edit(@RequestBody Calificaciones calificaciones,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		calificaciones.setUsuarioUltmodificacion(usuario.getUsuario());

		Calificaciones calificacionesAux = this.calificacionesService.update(calificaciones);
		CalificacionesController.logger.info("[PUT] : Calificaciones actualizado correctamente");
		return calificacionesAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param calificaciones
	 *            Calificaciones Bean que contiene la informacion con la que se
	 *            va a crear el nuevo registro.
	 * @return Calificaciones Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Calificaciones add(@RequestBody Calificaciones calificaciones,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		calificaciones.setUsuarioRegistro(usuario.getUsuario());

		Calificaciones calificacionesAux = this.calificacionesService.add(calificaciones);
		CalificacionesController.logger.info("[POST] : Calificaciones insertado correctamente");
		return calificacionesAux;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		CalificacionesController.logger.info("[GET - View] : calificaciones");
		String idDireccion = SeguridadAplicacion.precargarDireccion();
		Procedimientos procedimiento = null;
		String idProcedimiento = "";

		if (!"".contentEquals(idDireccion)) {
			procedimiento = this.procedimientosService.obtenerProcedimientos(Integer.parseInt(idDireccion));
		}

		if (procedimiento != null) {
			idProcedimiento = String.valueOf(procedimiento.getIdProcedimiento());
		}

		model.addAttribute("procedimientoPrecargado", idProcedimiento);

		return "calificaciones";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterCalificaciones
	 *            Calificaciones Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<Calificaciones> Dto que contiene el resultado
	 *         del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<Calificaciones> filter(
			@RequestJsonBody(param = "filter") Calificaciones filterCalificaciones,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		CalificacionesController.logger.info("[POST - filter] : Obtener Calificacioness");

		Procedimientos procedimientoAux = new Procedimientos();

		if (filterCalificaciones.getProcedimiento() != null) {
			procedimientoAux = filterCalificaciones.getProcedimiento();
		}

		Aplicaciones aplicacion = new Aplicaciones();
		aplicacion.setCodigoAplicacion(Constantes.CODIGO_APLICACION.toUpperCase());
		procedimientoAux.setAplicacion(aplicacion);
		filterCalificaciones.setProcedimiento(procedimientoAux);

		return this.calificacionesService.filter(filterCalificaciones, tableRequestDto);
	}

	/**
	 *
	 * @param filterCalificaciones
	 *            Calificaciones Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Calificaciones> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(value = "/cargarCombo", method = RequestMethod.GET)
	public @ResponseBody List<Calificaciones> cargarCombo(@ModelAttribute Calificaciones filterCalificaciones) {
		CalificacionesController.logger.info("[GET - find_ALL] : Obtener Calificaciones por filtro");
		return this.calificacionesService.cargarCombo(filterCalificaciones);
	}

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idInfraccion
	 *            Long
	 * @return Calificaciones Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/infracciones/{idInfraccion}", method = RequestMethod.GET)
	public @ResponseBody Calificaciones buscarCalificacionByInfraccion(@PathVariable Integer idInfraccion) {

		Calificaciones calificaciones = this.calificacionesService.findCalificacionByInfraccion(idInfraccion);

		CalificacionesController.logger.info("[GET - findBy_PK] : Obtener Calificaciones por infracción");
		return calificaciones;
	}
}
