package com.ejie.ab59.control.sanciones;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.expedientes.DatosTerceros;
import com.ejie.ab59.model.procedimientos.Direcciones;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.service.expedientes.DatosTercerosService;
import com.ejie.ab59.service.procedimientos.DireccionesService;
import com.ejie.ab59.service.sanciones.SancionesService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * SancionesController  
 * 
 *  
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/sanciones")

public class SancionesController {

	private static final Logger logger = LoggerFactory.getLogger(SancionesController.class);

	@Autowired
	private SancionesService sancionesService;

	@Autowired
	private DatosTercerosService datosTercerosService;

	@Autowired
	private DireccionesService direccionesService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idSancion
	 *            Integer
	 * @return Sanciones Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idSancion}", method = RequestMethod.GET)
	public @ResponseBody Sanciones get(@PathVariable Integer idSancion) {
		Sanciones sanciones = new Sanciones();
		sanciones.setIdSancion(idSancion);
		sanciones = this.sancionesService.find(sanciones);
		SancionesController.logger.info("[GET - findBy_PK] : Obtener Sanciones por PK");
		return sanciones;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterSanciones
	 *            Sanciones Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Sanciones> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Sanciones> getAll(@ModelAttribute Sanciones filterSanciones) {
		SancionesController.logger.info("[GET - find_ALL] : Obtener Sanciones por filtro");
		return this.sancionesService.findAll(filterSanciones, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param sanciones
	 *            Sanciones Bean que contiene la informacion a modificar.
	 * @param usuario
	 *            Usuario
	 * @return Sanciones Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Sanciones edit(@RequestBody Sanciones sanciones,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Calendar cal = Calendar.getInstance();
		sanciones.setFechaUltmodificacion(cal.getTime());
		sanciones.setUsuarioUltmodificacion(usuario.getUsuario());

		Sanciones sancionesAux = this.sancionesService.updateDatosSancion(sanciones);
		SancionesController.logger.info("[PUT] : Datos de Sanción actualizado correctamente");
		return sancionesAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param sanciones
	 *            Sanciones Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Sanciones Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Sanciones add(@RequestBody Sanciones sanciones) {
		Sanciones sancionesAux = this.sancionesService.add(sanciones);
		SancionesController.logger.info("[POST] : Sanciones insertado correctamente");
		return sancionesAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idSancion
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return Sanciones Bean eliminado.
	 */
	@RequestMapping(value = "/{idSancion}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Sanciones remove(@PathVariable Integer idSancion) {
		Sanciones sanciones = new Sanciones();
		sanciones.setIdSancion(idSancion);
		this.sancionesService.remove(sanciones);
		SancionesController.logger.info("[DELETE] : Sanciones borrado correctamente");
		return sanciones;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/* ************************* */
	/* *** FICHA DE LA SANCION *** */
	/* ************************* */
	/**
	 * Cargar los datos de sancion
	 * 
	 * @param model
	 *            Model
	 * @param idSancion
	 *            Integer
	 * @return String
	 */
	@RequestMapping(value = "/maint/{idSancion}", method = RequestMethod.GET)
	public String getFormEdit(Model model, @PathVariable Integer idSancion,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		/* Obtener los datos de la sanción */
		Sanciones sancion = new Sanciones();
		sancion.setIdSancion(idSancion);
		sancion = this.sancionesService.findDatosSancion(sancion);
		model.addAttribute("sancion", sancion);

		/**
		 * Llamada a la validacion de si el expediente sancionado es valido para el pago
		 */
		Sanciones sancionAux = new Sanciones(idSancion);
		sancionAux = this.sancionesService.findDatosSancion(sancionAux);
		
		boolean mostraMensajeExpedienteSancionadorValidoParaPago = this.sancionesService.validarExpedienteSancionadorListoParaElPago(sancionAux, model);
		model.addAttribute("mostraMensajeExpedienteSancionadorValidoParaPago", mostraMensajeExpedienteSancionadorValidoParaPago);
		
		return "datosSancion";

	}

	/**
	 * Cargar los datos de sancion
	 * 
	 * @param model
	 *            Model
	 * @param idSancion
	 *            Integer
	 * @return String
	 */
	@RequestMapping(value = "/maint/datos/{idSancion}", method = RequestMethod.GET)
	public @ResponseBody Sanciones getFormEditData(@PathVariable Integer idSancion) {

		/* Obtener los datos de la sanción */
		Sanciones sancion = new Sanciones();
		sancion.setIdSancion(idSancion);
		sancion = this.sancionesService.findDatosSancion(sancion);

		return sancion;

	}
	/* ************************* */
	/* *** FICHA DE LA SANCION *** */
	/* ************************* */

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterSanciones
	 *            Sanciones Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<Sanciones> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<Sanciones> filter(
			@RequestJsonBody(param = "filter") Sanciones filterSanciones,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		SancionesController.logger.info("[POST - filter] : Obtener Sancioness");
		return this.sancionesService.filter(filterSanciones, tableRequestDto);
	}

	@InitBinder
	private void dateBinder(WebDataBinder binder) {
		Locale locale = LocaleContextHolder.getLocale();
		// The date format to parse or output your dates
		SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
		if (locale.toString().equals(Constantes.CASTELLANO)) {
			dateFormat = new SimpleDateFormat("dd/MM/yyyy");
		} else if (locale.toString().equals(Constantes.EUSKERA)) {
			dateFormat = new SimpleDateFormat("yyyy/MM/dd");
		}
		// Create a new CustomDateEditor
		CustomDateEditor editor = new CustomDateEditor(dateFormat, true);
		// Register it as custom editor for the Date type
		binder.registerCustomEditor(Date.class, editor);
	}

	/**
	 * Método que genera una hoja de excel con los resultados de búsqueda de
	 * sanciones.
	 */
	@RequestMapping(value = { "/exportarExcel/{sidx}/{sord}" }, method = RequestMethod.POST)
	public void getExcel(@ModelAttribute Sanciones filterSanciones, @PathVariable String sidx,
			@PathVariable String sord, @ModelAttribute TableRequestDto tableRequestDto, HttpServletResponse response) {

		SancionesController.logger.error("[Exportar Excel] INICIO Exportación excel");

		try {
			List<Sanciones> listaSanciones = new ArrayList<Sanciones>();

			tableRequestDto.setSidx(sidx);
			tableRequestDto.setSord(sord);

			if (filterSanciones != null && filterSanciones.getExpediente() != null
					&& "".equals(filterSanciones.getExpediente().getFolderNumber())) {
				filterSanciones.getExpediente().setFolderNumber(null);
			}
			if (filterSanciones != null && filterSanciones.getExpediente() != null
					&& "".equals(filterSanciones.getExpediente().getTitulo())) {
				filterSanciones.getExpediente().setTitulo(null);
			}
			if (filterSanciones != null && filterSanciones.getExpediente() != null
					&& filterSanciones.getExpediente().getDatosDirecciones() != null) {
				if (filterSanciones.getExpediente().getDatosDirecciones().getProvincia() != null
						&& "".equals(filterSanciones.getExpediente().getDatosDirecciones().getProvincia().getId())) {
					filterSanciones.getExpediente().getDatosDirecciones().getProvincia().setId(null);
				}
				if (filterSanciones.getExpediente().getDatosDirecciones().getMunicipio() != null
						&& "".equals(filterSanciones.getExpediente().getDatosDirecciones().getMunicipio().getId())) {
					filterSanciones.getExpediente().getDatosDirecciones().getMunicipio().setId(null);
				}
				if (filterSanciones.getExpediente().getDatosDirecciones().getLocalidad() != null
						&& "".equals(filterSanciones.getExpediente().getDatosDirecciones().getLocalidad().getId())) {
					filterSanciones.getExpediente().getDatosDirecciones().getLocalidad().setId(null);
				}
				if ("".equals(filterSanciones.getExpediente().getDatosDirecciones().getDireccion())) {
					filterSanciones.getExpediente().getDatosDirecciones().setDireccion(null);
				}
				if ("".equals(filterSanciones.getExpediente().getDatosDirecciones().getNumero())) {
					filterSanciones.getExpediente().getDatosDirecciones().setNumero(null);
				}
				if ("".equals(filterSanciones.getExpediente().getDatosDirecciones().getEscalera())) {
					filterSanciones.getExpediente().getDatosDirecciones().setEscalera(null);
				}
				if ("".equals(filterSanciones.getExpediente().getDatosDirecciones().getPiso())) {
					filterSanciones.getExpediente().getDatosDirecciones().setPiso(null);
				}
				if ("".equals(filterSanciones.getExpediente().getDatosDirecciones().getLetra())) {
					filterSanciones.getExpediente().getDatosDirecciones().setLetra(null);
				}
				if ("".equals(filterSanciones.getExpediente().getDatosDirecciones().getCodigoPostal())) {
					filterSanciones.getExpediente().getDatosDirecciones().setCodigoPostal(null);
				}

			}

			if (filterSanciones != null && filterSanciones.getExpediente() != null
					&& filterSanciones.getExpediente().getDatosTerceros() != null) {
				if (filterSanciones.getExpediente().getDatosTerceros().getNombre() != null) {
					filterSanciones.getExpediente().getDatosTerceros().setNombre(null);
				}
				if (filterSanciones.getExpediente().getDatosTerceros().getApellido1() != null) {
					filterSanciones.getExpediente().getDatosTerceros().setApellido1(null);
				}
				if (filterSanciones.getExpediente().getDatosTerceros().getApellido2() != null) {
					filterSanciones.getExpediente().getDatosTerceros().setApellido2(null);
				}
				if (filterSanciones.getExpediente().getDatosTerceros().getDocumento() != null) {
					filterSanciones.getExpediente().getDatosTerceros().setDocumento(null);
				}
			}

			if (filterSanciones != null && "".equals(filterSanciones.getImporteSancionDesde())) {
				filterSanciones.setImporteSancionDesde(null);
			}
			if (filterSanciones != null && "".equals(filterSanciones.getImporteSancionHasta())) {
				filterSanciones.setImporteSancionHasta(null);
			}
			if (filterSanciones != null && "".equals(filterSanciones.getFechaAcuseAcuerdoIncoacionDesde())) {
				filterSanciones.setFechaAcuseAcuerdoIncoacionDesde(null);
			}
			if (filterSanciones != null && "".equals(filterSanciones.getFechaAcuseAcuerdoIncoacionHasta())) {
				filterSanciones.setFechaAcuseAcuerdoIncoacionHasta(null);
			}
			if (filterSanciones != null && "".equals(filterSanciones.getFechaSancionFirmeDesde())) {
				filterSanciones.setFechaSancionFirmeDesde(null);
			}
			if (filterSanciones != null && "".equals(filterSanciones.getFechaSancionFirmeHasta())) {
				filterSanciones.setFechaSancionFirmeHasta(null);
			}

			listaSanciones = this.sancionesService.findAll(filterSanciones, tableRequestDto);

			this.sancionesService.getExcel(listaSanciones, response);

		} catch (Exception e) {
			SancionesController.logger.error("[Exportar Excel] ERROR : ", e);
		}
	}

	@RequestMapping(value = "/findExpedientesPartesInculpadas/{idExpediente}", method = RequestMethod.GET)
	public @ResponseBody List<Sanciones> findExpedientesPartesInculpadas(@PathVariable Integer idExpediente) {

		List<DatosTerceros> listaTerceros = this.datosTercerosService.findDocumentosPartesInculpadas(idExpediente);
		if (!listaTerceros.isEmpty()) {
			List<String> documentos = new ArrayList<String>();
			for (DatosTerceros datosTerceros : listaTerceros) {
				documentos.add(datosTerceros.getDocumento());
			}

			Direcciones direccion = this.direccionesService.findByIdExpediente(idExpediente);

			List<Sanciones> listaSanciones = this.sancionesService.findExpedientesPartesInculpadas(documentos,
					idExpediente, direccion);

			if (!listaSanciones.isEmpty()) {
				return listaSanciones;
			} else {
				return null;
			}

		} else {
			return null;
		}
	}
	
	
	@RequestMapping(value = "/validarExpedienteSancionadorListoParaElPago/{idSancion}", method = RequestMethod.GET)
	public @ResponseBody Boolean validarExpedienteSancionadorListoParaElPago(Model model, @PathVariable Integer idSancion) {

		Sanciones sancionAux = new Sanciones(idSancion);
		sancionAux = this.sancionesService.findDatosSancion(sancionAux);
		
		return this.sancionesService.validarExpedienteSancionadorListoParaElPago(sancionAux, model);
	}
}
