package com.ejie.ab59.control.relIniOfiAlcRes;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.model.configuracionInicioOficio.AlcancesResolucion;
import com.ejie.ab59.service.configuracionInicioOficio.AlcancesResolucionService;
import com.ejie.x38.dto.TableRequestDto;

/**
 * AlcanceResolucionController  
 * 
 *  
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/alcanceResolucion")

public class AlcanceResolucionController {

	private static final Logger logger = LoggerFactory.getLogger(AlcanceResolucionController.class);

	@Autowired
	private AlcancesResolucionService alcancesResolucionService;

	@RequestMapping(value = "/cargarCombo", method = RequestMethod.GET)
	public @ResponseBody List<AlcancesResolucion> cargarCombo(
			@ModelAttribute AlcancesResolucion filterAlcancesReslucion) {
		AlcanceResolucionController.logger.info("[GET - find_ALL] : Obtener AlcanceResolucion por filtro");
		return this.alcancesResolucionService.findAll(filterAlcancesReslucion, new TableRequestDto());
	}
}
