package com.ejie.ab59.control.propuestassancion;

import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab59.clientesWS.ab61WebService.DatosInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.DatosLlamadaGenerarExpedienteInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.DatosRespuestaConsultaDatosInteresado;
import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.comun.UtilsConfig;
import com.ejie.ab59.model.expedientes.DatosTerceros;
import com.ejie.ab59.model.expedientes.RelExpTer;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.propuestasSancion.RelProSanSan;
import com.ejie.ab59.service.expedientes.RelExpTerService;
import com.ejie.ab59.service.procedimientos.ProcedimientosService;
import com.ejie.ab59.service.propuestasSancion.PropuestasSancionService;
import com.ejie.ab59.service.propuestasSancion.RelProSanSanService;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/propuestasSancion")

public class PropuestasSancionFichaController {

	private static final Logger logger = LoggerFactory.getLogger(PropuestasSancionFichaController.class);

	@Autowired
	private PropuestasSancionService propuestasSancionService;
	@Autowired
	private RelExpTerService relExpTerService;
	@Autowired
	private ProcedimientosService procedimientosService;
	@Autowired
	private RelProSanSanService relProSanSanService;

	@Resource
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idPropuestaSancion
	 *            Integer
	 * @return PropuestasSancion Objeto correspondiente al identificador
	 *         indicado.
	 */
	@RequestMapping(value = "/{idPropuestaSancion}", method = RequestMethod.GET)
	public @ResponseBody PropuestasSancion get(@PathVariable Integer idPropuestaSancion) {
		PropuestasSancion propuestaSancion = new PropuestasSancion();
		propuestaSancion.setIdPropuestaSancion(idPropuestaSancion);
		propuestaSancion = this.propuestasSancionService.find(propuestaSancion);
		PropuestasSancionFichaController.logger.info("[GET - findBy_PK] : Obtener Propuesta de Sanción por PK");
		return propuestaSancion;
	}

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idPropuestaSancion
	 *            Integer
	 * @return PropuestasSancion Objeto correspondiente al identificador
	 *         indicado.
	 */
	@RequestMapping(value = "/sinExpediente/{idPropuestaSancion}", method = RequestMethod.GET)
	public @ResponseBody PropuestasSancion getSinExpediente(@PathVariable Integer idPropuestaSancion) {
		PropuestasSancion propuestaSancion = new PropuestasSancion();
		propuestaSancion.setIdPropuestaSancion(idPropuestaSancion);
		propuestaSancion = this.propuestasSancionService.findSinExpediente(propuestaSancion);
		PropuestasSancionFichaController.logger
				.info("[GET - findBy_PK] : Obtener Propuesta de Sanción sin expediente por PK");
		return propuestaSancion;
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param propuestaSancion
	 *            PropuestasSancion Bean que contiene la informacion a
	 *            modificar.
	 * @return PropuestasSancion Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody PropuestasSancion edit(@RequestBody PropuestasSancion propuestaSancion,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		propuestaSancion.setUsuarioUltmodificacion(usuario.getUsuario());

		PropuestasSancion propuestaSancionAux = this.propuestasSancionService.update(propuestaSancion);
		PropuestasSancionFichaController.logger.info("[PUT] : Propuesta de Sanción actualizada correctamente");
		return propuestaSancionAux;
	}

	/* ************************* */
	/* *** FICHA DE LA SANCION *** */
	/* ************************* */
	/**
	 * Cargar las propuestas de sancion
	 * 
	 * @param model
	 *            Model
	 * @param idSancion
	 *            Integer
	 * @return String
	 */
	@RequestMapping(value = "/maint/{idPropuestaSancion}", method = RequestMethod.GET)
	public String getFormEdit(Model model, @PathVariable Integer idPropuestaSancion, Usuario usuario) {

		PropuestasSancionFichaController.logger.info("[GET - View] : Pestaña Propuestas de Sanción");

		/* Obtener los datos de la sanción */
		String idioma = LocaleContextHolder.getLocale().getLanguage();
		PropuestasSancion propuestaSancion = new PropuestasSancion();
		propuestaSancion.setIdPropuestaSancion(idPropuestaSancion);
		propuestaSancion = this.propuestasSancionService.find(propuestaSancion);

		model.addAttribute("idPropuestaSancion", idPropuestaSancion);
		if (propuestaSancion != null && propuestaSancion.getExpedienteOrigen() != null
				&& propuestaSancion.getExpedienteOrigen().getIdExpediente() != null) {
			model.addAttribute("idExpedienteOrigen", propuestaSancion.getExpedienteOrigen().getIdExpediente());

			// Primero obtengo la lista de participaciones de mi BBDD, ya
			// actualiza previamente desde el webService
			List<RelExpTer> listaParticipantesParticipacion = relExpTerService
					.findParticipaciones(propuestaSancion.getExpedienteOrigen().getIdExpediente(), model);
			PropuestasSancionFichaController.logger.info("[INICIO] Participantes ",
					listaParticipantesParticipacion.size(), " para el expediente : ",
					propuestaSancion.getExpedienteOrigen().getIdExpediente());

			List<Integer> listaIdTercerosTitular = new java.util.ArrayList<Integer>();
			StringBuilder listaTipoParticipacion = new StringBuilder();
			StringBuilder listaSubTipoParticipacion = new StringBuilder();
			for (RelExpTer participacion : listaParticipantesParticipacion) {
				for (DatosTerceros participante : participacion.getListaDatosTerceros()) {

					if (participante.getTipoParticipante() == Constantes.PARTICIPANTE_TITULAR) {
						if (participacion.getIdSubtipoParticipacion() == Constantes.PARTE_INCULPADA) {

							String nombreTitular = participante.getNombre() + " " + participante.getApellido1() + " "
									+ participante.getApellido2();
							model.addAttribute("nombreTitular", nombreTitular);
						}

						listaIdTercerosTitular.add(participante.getIdTercero());
						if (listaTipoParticipacion.length() == 0) {
							listaTipoParticipacion.append((participacion.getTipoParticipacionDecorator() != null
									? participacion.getTipoParticipacionDecorator() : "*"));
						} else {
							listaTipoParticipacion.append("," + (participacion.getTipoParticipacionDecorator() != null
									? participacion.getTipoParticipacionDecorator() : "*"));
						}
						if (listaSubTipoParticipacion.length() == 0) {
							listaSubTipoParticipacion.append((participacion.getSubTipoParticipacionDecorator() != null
									? participacion.getSubTipoParticipacionDecorator() : "*"));
						} else {
							listaSubTipoParticipacion
									.append("," + (participacion.getSubTipoParticipacionDecorator() != null
											? participacion.getSubTipoParticipacionDecorator() : "*"));
						}
					}
				}
			}

			Procedimientos procedimientoOrigen = this.procedimientosService.obtenerProcedimientos(
					propuestaSancion.getExpedienteOrigen().getProcedimiento().getDirecciones().getIdDireccion());

			model.addAttribute("idProcedimientoOrigen", procedimientoOrigen.getIdProcedimiento());
			model.addAttribute("codProcedreIdOrigen", procedimientoOrigen.getCodProcedureId());
			model.addAttribute("listaParticipantesParticipacion", listaParticipantesParticipacion);

			model.addAttribute("urlab61", UtilsConfig.getAppProperties().getProperty("URLAB61"));
			model.addAttribute("ab61_folderID", propuestaSancion.getExpedienteOrigen().getFolderId());

			model.addAttribute("listaIdTercerosTitular", listaIdTercerosTitular);
			model.addAttribute("listaTipoParticipacion", listaTipoParticipacion);
			model.addAttribute("listaSubTipoParticipacion", listaSubTipoParticipacion);
		}
		model.addAttribute("lenguaje", idioma);

		return "propuestasSancionFicha";

	}

	@RequestMapping(value = "/consultaDatosInteresado/{idProcedimiento}", method = RequestMethod.POST)
	public @ResponseBody List<DatosRespuestaConsultaDatosInteresado> consultaDatosInteresado(
			@PathVariable Integer idProcedimiento, @RequestBody List<Integer> listaTercerosId) throws Ab61Exception {

		List<DatosRespuestaConsultaDatosInteresado> listaTercerosExpedienteInicioOficio = propuestasSancionService
				.consultaDatosInteresado(idProcedimiento, listaTercerosId);
		return listaTercerosExpedienteInicioOficio;
	}

	@RequestMapping(value = "/generarExpedienteInicioOficioDatosInteresado/{idPropuestaSancion}/{idProcedimiento}", method = RequestMethod.POST)
	public @ResponseBody String generarExpedienteInicioOficio(@PathVariable Integer idPropuestaSancion,
			@PathVariable Integer idProcedimiento, @RequestBody DatosLlamadaGenerarExpedienteInicioOficio datosLlamada,
			@ModelAttribute("usuario") Usuario usuario) throws Ab61Exception {

		PropuestasSancionFichaController.logger.info("INICIO [generarExpedienteInicioOficioDatosInteresado]");

		String respuesta = "ok";
		DatosInicioOficio datosInicioOficio = new DatosInicioOficio();
		try {

			PropuestasSancionFichaController.logger.info(
					"[generarExpedienteInicioOficioDatosInteresado] :: Llamada a generar el expediente sancionador de inicio oficio");

			datosLlamada.setExpedienteInicioOficioSanciones(true);
			datosInicioOficio = propuestasSancionService.crearExpedienteSancionadorInicioOficio(idPropuestaSancion,
					idProcedimiento, usuario, datosLlamada);

			PropuestasSancion propuestaSancion = new PropuestasSancion();
			propuestaSancion.setIdPropuestaSancion(idPropuestaSancion);
			propuestaSancion.setFolderId(datosInicioOficio.getFolderID());

			RelProSanSan relProSanSan = new RelProSanSan();
			relProSanSan.setPropuestaSancion(propuestaSancion);

			Procedimientos procedimiento = this.procedimientosService.find(new Procedimientos(idProcedimiento));
			if (procedimiento.getDirecciones().getIdDireccion() == Constantes.ID_TURISMO_DIRECCION) {
				propuestaSancion.setEstado(Constantes.ESTADO_PROPUESTA_EXPEDIENTE_SANCIONADOR_TURISMO);
				relProSanSan.setEstado(Constantes.ESTADO_PROPUESTA_EXPEDIENTE_SANCIONADOR_TURISMO);
			} else if (procedimiento.getDirecciones().getIdDireccion() == Constantes.ID_COMERCIO_DIRECCION) {
				propuestaSancion.setEstado(Constantes.ESTADO_PROPUESTA_EXPEDIENTE_SANCIONADOR_COMERCIO);
				relProSanSan.setEstado(Constantes.ESTADO_PROPUESTA_EXPEDIENTE_SANCIONADOR_COMERCIO);
			}

			PropuestasSancionFichaController.logger
					.info("[generarExpedienteInicioOficioDatosInteresado] :: Actualizamos el FolderIdEstado");
			propuestaSancion.setUsuarioUltmodificacion(usuario.getUsuario());
			this.propuestasSancionService.updateFolderIdEstado(propuestaSancion);

			PropuestasSancionFichaController.logger
					.info("[generarExpedienteInicioOficioDatosInteresado] :: Actualizamos relProSanSan");
			relProSanSan.setUsuarioUltModificacion(usuario.getUsuario());
			this.relProSanSanService.updateByPropuestaSancion(relProSanSan);
		} catch (Ab61Exception e) {
			String idioma = LocaleContextHolder.getLocale().getLanguage();
			if ("es".equalsIgnoreCase(idioma)) {
				respuesta = e.getFaultInfo().getMensajeCastellano();
			} else {
				respuesta = e.getFaultInfo().getMensajeEuskera();
			}
		} catch (Exception ex) {
			PropuestasSancionFichaController.logger.error(ex.getMessage(), ex);

			Locale locale = LocaleContextHolder.getLocale();
			respuesta = appMessageSource.getMessage("error.expedienteInicioOficio", null, locale);
		}

		PropuestasSancionFichaController.logger.info("FIN [generarExpedienteInicioOficioDatosInteresado]");
		return respuesta;
	}

}
