package com.ejie.ab59.control.propuestassancion;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.expedientes.RelExpTer;
import com.ejie.ab59.model.propuestasSancion.EstadosProSan;
import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.propuestasSancion.RelArtInfProSan;
import com.ejie.ab59.model.propuestasSancion.RelProSanFec;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.service.expedientes.RelExpTerService;
import com.ejie.ab59.service.propuestasSancion.PropuestasSancionService;
import com.ejie.ab59.service.propuestasSancion.RelArtInfProSanService;
import com.ejie.ab59.service.propuestasSancion.RelProSanFecService;
import com.ejie.ab59.service.sanciones.SancionesService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/propuestassancion")

public class PropuestasSancionController {

	private static final Logger logger = LoggerFactory.getLogger(PropuestasSancionController.class);

	@Autowired
	private PropuestasSancionService propuestasSancionService;
	@Autowired
	private RelArtInfProSanService relArtInfProSanService;
	@Autowired
	private SancionesService sancionesService;
	@Autowired
	private RelExpTerService relExpTerService;
	@Autowired
	private RelProSanFecService relProSanFecService;

	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<PropuestasSancion> filter(
			@RequestJsonBody(param = "filter") PropuestasSancion filterPropuestasSancion,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		PropuestasSancionController.logger.info("[POST - filter] : Obtener Propuestas de Sanción");

		return this.propuestasSancionService.filter(filterPropuestasSancion, tableRequestDto);
	}

	@InitBinder
	private void dateBinder(WebDataBinder binder) {
		Locale locale = LocaleContextHolder.getLocale();
		// The date format to parse or output your dates
		SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
		if (locale.toString().equals(Constantes.CASTELLANO)) {
			dateFormat = new SimpleDateFormat("dd/MM/yyyy");
		} else if (locale.toString().equals(Constantes.EUSKERA)) {
			dateFormat = new SimpleDateFormat("yyyy/MM/dd");
		}
		// Create a new CustomDateEditor
		CustomDateEditor editor = new CustomDateEditor(dateFormat, true);
		// Register it as custom editor for the Date type
		binder.registerCustomEditor(Date.class, editor);
	}

	@RequestMapping(value = { "/exportarExcel/{sidx}/{sord}" }, method = RequestMethod.POST)
	public void getExcel(@ModelAttribute PropuestasSancion filterPropuestasSancion, @PathVariable String sidx,
			@PathVariable String sord, @ModelAttribute TableRequestDto tableRequestDto, HttpServletResponse response) {

		PropuestasSancionController.logger.error("[Exportar Excel] INICIO Exportación excel");

		try {
			List<PropuestasSancion> listaPropuestasSancion;

			tableRequestDto.setSidx(sidx);
			tableRequestDto.setSord(sord);

			if (filterPropuestasSancion != null && filterPropuestasSancion.getExpedienteOrigen() != null
					&& "".equals(filterPropuestasSancion.getExpedienteOrigen().getFolderNumber())) {
				filterPropuestasSancion.getExpedienteOrigen().setFolderNumber(null);
			}
			if (filterPropuestasSancion != null && filterPropuestasSancion.getExpedienteOrigen() != null
					&& "".equals(filterPropuestasSancion.getExpedienteOrigen().getTitulo())) {
				filterPropuestasSancion.getExpedienteOrigen().setTitulo(null);
			}
			if (filterPropuestasSancion != null && filterPropuestasSancion.getExpedienteOrigen() != null
					&& filterPropuestasSancion.getExpedienteOrigen().getDatosDirecciones() != null
					&& "".equals(filterPropuestasSancion.getExpedienteOrigen().getDatosDirecciones()
							.getUbicacionEstablecimiento())) {
				filterPropuestasSancion.getExpedienteOrigen().getDatosDirecciones().setUbicacionEstablecimiento(null);
			}
			if (filterPropuestasSancion != null && filterPropuestasSancion.getExpedienteOrigen() != null
					&& filterPropuestasSancion.getExpedienteOrigen().getDatosDirecciones() != null
					&& "".equals(filterPropuestasSancion.getExpedienteOrigen().getDatosDirecciones()
							.getMunicipioLocalidad())) {
				filterPropuestasSancion.getExpedienteOrigen().getDatosDirecciones().setMunicipioLocalidad(null);
			}
			if (filterPropuestasSancion != null && "".equals(filterPropuestasSancion.getNotasRespOfi())) {
				filterPropuestasSancion.setNotasRespOfi(null);
			}
			if (filterPropuestasSancion != null && "".equals(filterPropuestasSancion.getIdentificadorInspeccion())) {
				filterPropuestasSancion.setIdentificadorInspeccion(null);
			}
			if (filterPropuestasSancion != null && "".equals(filterPropuestasSancion.getIdentificadorProSan())) {
				filterPropuestasSancion.setIdentificadorProSan(null);
			}

			listaPropuestasSancion = this.propuestasSancionService.findAll(filterPropuestasSancion, tableRequestDto);

			this.propuestasSancionService.getExcel(listaPropuestasSancion, response);

		} catch (Exception e) {
			PropuestasSancionController.logger.error("[Exportar Excel] ERROR : ", e);
		}
	}

	@RequestMapping(value = "/{idPropuestaSancion}", method = RequestMethod.GET)
	public @ResponseBody PropuestasSancion get(@PathVariable Integer idPropuestaSancion) {
		PropuestasSancion propuestaSancion = new PropuestasSancion();
		propuestaSancion.setIdPropuestaSancion(idPropuestaSancion);
		propuestaSancion = this.propuestasSancionService.find(propuestaSancion);
		PropuestasSancionController.logger.info("[GET - findBy_PK] : Obtener Propuesta de Sanción por PK");
		return propuestaSancion;
	}

	@RequestMapping(value = "/sinExpediente/{idPropuestaSancion}", method = RequestMethod.GET)
	public @ResponseBody PropuestasSancion getSinExpediente(@PathVariable Integer idPropuestaSancion) {
		PropuestasSancion propuestaSancion = new PropuestasSancion();
		propuestaSancion.setIdPropuestaSancion(idPropuestaSancion);
		propuestaSancion = this.propuestasSancionService.findSinExpediente(propuestaSancion);
		PropuestasSancionController.logger
				.info("[GET - findBy_PK] : Obtener Propuesta de Sanción sin expediente por PK");
		return propuestaSancion;
	}

	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody PropuestasSancion edit(@RequestBody PropuestasSancion propuestaSancion,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		propuestaSancion.setUsuarioUltmodificacion(usuario.getUsuario());

		PropuestasSancion propuestaSancionAux = this.propuestasSancionService.update(propuestaSancion);
		PropuestasSancionController.logger.info("[PUT] : Propuesta de Sanción actualizada correctamente");
		return propuestaSancionAux;
	}

	@RequestMapping(value = "/maint/{idSancion}", method = RequestMethod.GET)
	public String getFormEdit(Model model, @PathVariable Integer idSancion, Usuario usuario) {

		PropuestasSancionController.logger.info("[GET - View] : Pestaña Propuestas de Sanción");

		/* Obtener los datos de la sanción */
		Sanciones sancion = new Sanciones();
		sancion.setIdSancion(idSancion);
		sancion = this.sancionesService.find(sancion);
		model.addAttribute("sancion", sancion);

		return "propuestasSancion";

	}

	@RequestMapping(value = "/controlFechas/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<RelArtInfProSan> filterControlFechas(
			@RequestJsonBody(param = "filter") RelArtInfProSan filterRelArtInfProSan,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		PropuestasSancionController.logger.info("[POST - filter] : Obtener las fechas de la Propuesta de Sanción");
		return this.relArtInfProSanService.filterControlFechas(filterRelArtInfProSan, tableRequestDto);
	}

	@RequestMapping(value = "/controlFechas/historial/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<RelProSanFec> filterHistorialFechas(
			@RequestJsonBody(param = "filter") RelProSanFec filterRelProSanFec,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		PropuestasSancionController.logger
				.info("[POST - filter] : Obtener el historial de fechas de la propuesta de sancin");
		return this.relProSanFecService.filterHistorialFechas(filterRelProSanFec, tableRequestDto);
	}

	@RequestMapping(value = "/relExpTer/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<RelExpTer> filter(
			@RequestJsonBody(param = "filter") RelExpTer filterRelExpTer,
			@RequestJsonBody TableRequestDto tableRequestDto) {

		PropuestasSancionController.logger.info("[POST - filter] : Obtener Titulares");

		if (filterRelExpTer.getExpediente() != null && filterRelExpTer.getExpediente().getIdExpediente() != null) {
			return this.relExpTerService.filterByExpediente(filterRelExpTer, tableRequestDto);
		} else {
			return this.relExpTerService.filterSinExpediente(filterRelExpTer, tableRequestDto);
		}
	}

	@RequestMapping(value = "/findPropuestasPendientesMismoTitular/{idPropuestaSancion}", method = RequestMethod.GET)
	public @ResponseBody List<PropuestasSancion> findPropuestasPendientesMismoTitular(
			@PathVariable Integer idPropuestaSancion) {

		SqlRowSet retorno = this.propuestasSancionService.findPropuestasPendientesMismoTitular(idPropuestaSancion);

		List<PropuestasSancion> devolver = null;
		PropuestasSancion elemento = null;
		Expedientes expe = null;
		EstadosProSan estado = null;
		while (retorno.next()) {

			elemento = new PropuestasSancion();
			elemento.setIdentificadorProSan(retorno.getString("IDENTIFICADOR_PRO_SAN"));

			expe = new Expedientes();
			expe.setFolderNumber(retorno.getString("FOLDER_NUMBER"));
			expe.setTitulo(retorno.getString("TITULO"));

			estado = new EstadosProSan();
			estado.setDescripcionCastellano(retorno.getString("DESCRIPCION_CASTELLANO"));
			estado.setDescripcionEuskera(retorno.getString("DESCRIPCION_EUSKERA"));

			elemento.setExpedienteOrigen(expe);
			elemento.setEstadoProSan(estado);

			if (devolver == null) {
				devolver = new ArrayList<PropuestasSancion>();
			}
			devolver.add(elemento);
		}

		return devolver;
	}

	@RequestMapping(value = "/findPropuestasPendientesMismoTitularBySancion/{idSancion}", method = RequestMethod.GET)
	public @ResponseBody List<PropuestasSancion> findPropuestasPendientesMismoTitularBySancion(
			@PathVariable Integer idSancion) {

		SqlRowSet retorno = this.propuestasSancionService.findPropuestasPendientesMismoTitularBySancion(idSancion);

		List<PropuestasSancion> devolver = null;
		PropuestasSancion elemento = null;
		Expedientes expe = null;
		EstadosProSan estado = null;
		while (retorno.next()) {

			elemento = new PropuestasSancion();
			elemento.setIdentificadorProSan(retorno.getString("IDENTIFICADOR_PRO_SAN"));

			expe = new Expedientes();
			expe.setFolderNumber(retorno.getString("FOLDER_NUMBER"));
			expe.setTitulo(retorno.getString("TITULO"));

			estado = new EstadosProSan();
			estado.setDescripcionCastellano(retorno.getString("DESCRIPCION_CASTELLANO"));
			estado.setDescripcionEuskera(retorno.getString("DESCRIPCION_EUSKERA"));

			elemento.setExpedienteOrigen(expe);
			elemento.setEstadoProSan(estado);

			if (devolver == null) {
				devolver = new ArrayList<PropuestasSancion>();
			}
			devolver.add(elemento);
		}

		return devolver;
	}
}
