package com.ejie.ab59.control.procedimientos;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.procedimientos.Aplicaciones;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.service.procedimientos.ProcedimientosService;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/procedimientos")

public class ProcedimientosController {

	private static final Logger logger = LoggerFactory.getLogger(ProcedimientosController.class);

	@Autowired
	private ProcedimientosService procedimientosService;

	@RequestMapping(value = "/cargarCombo", method = RequestMethod.GET)
	public @ResponseBody List<Procedimientos> cargarCombo(@ModelAttribute Procedimientos filterProcedimientos) {
		ProcedimientosController.logger.info("[GET - cargarCombo] : Obtener Procedimientos para cargar combo");

		Aplicaciones aplicacion = new Aplicaciones();
		aplicacion.setCodigoAplicacion(Constantes.CODIGO_APLICACION.toUpperCase());
		filterProcedimientos.setAplicacion(aplicacion);

		return this.procedimientosService.cargarComboProcedimientos(filterProcedimientos);
	}

	@RequestMapping(value = "/cargarComboInicioOficio", method = RequestMethod.GET)
	public @ResponseBody List<Procedimientos> cargarComboInicioOficio(
			@ModelAttribute Procedimientos filterProcedimientos) {
		ProcedimientosController.logger
				.info("[GET - cargarComboInicioOficio] : Obtener Procedimientos para cargar combo con inicio oficio");

		Aplicaciones aplicacion = new Aplicaciones();
		aplicacion.setCodigoAplicacion(Constantes.CODIGO_APLICACION.toUpperCase());
		filterProcedimientos.setAplicacion(aplicacion);
		filterProcedimientos.setInicioOficio(Constantes.PROCEDIMIENTO_INICIO_OFICIO);

		return this.procedimientosService.cargarComboProcedimientosInicioOficio(filterProcedimientos);
	}
}
