package com.ejie.ab59.control.plantillas;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.model.plantillas.RelExpPla;
import com.ejie.ab59.service.plantillas.RelExpPlaService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/relexppla")

public class RelExpPlaController {

	private static final Logger logger = LoggerFactory.getLogger(RelExpPlaController.class);

	@Autowired
	private RelExpPlaService relExpPlaService;

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterRelExpPla
	 *            RelExpPla Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * 
	 * @return JQGridResponseDto<RelExpPla> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<RelExpPla> filter(
			@RequestJsonBody(param = "filter") RelExpPla filterRelExpPla,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		RelExpPlaController.logger.info("[POST - filter] : Obtener RelExpPla");

		String identificador;

		if (filterRelExpPla.getExpediente() != null && filterRelExpPla.getExpediente().getFolderId() != null) {
			identificador = filterRelExpPla.getExpediente().getFolderId();
		} else {
			identificador = filterRelExpPla.getProcedimiento().getCodProcedureId();
		}

		filterRelExpPla.setIdentificador(identificador);

		return this.relExpPlaService.filter(filterRelExpPla, tableRequestDto);
	}

}
