package com.ejie.ab59.control.plantillas;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab59.clientesWS.ab61WebService.Origen;
import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.plantillas.ParametrosConfig;
import com.ejie.ab59.model.plantillas.Plantillas;
import com.ejie.ab59.service.plantillas.ParametrosConfigService;
import com.ejie.ab59.service.plantillas.PlantillasService;
import com.ejie.ab59.webservice.adaptadores.PifAdapter;
import com.ejie.ab59.webservice.adaptadores.ab61WebServiceAdaptador;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/plantillas")

public class PlantillasController {

	private static final Logger logger = LoggerFactory.getLogger(PlantillasController.class);

	@Autowired
	private ParametrosConfigService parametrosConfigService;
	@Autowired
	private ab61WebServiceAdaptador ab61WebServiceAdaptadorService;
	@Autowired
	private PifAdapter pifAdapterService;
	@Autowired
	private PlantillasService plantillasService;

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEditPlantilla(Model model) {
		PlantillasController.logger.info("[GET - View] : plantillas");

		/*
		 * Sacamos el valor ( 0 , 1 , 2 ) segun descripcion del parametro de
		 * configuracion
		 */

		ParametrosConfig parametrosConfig = new ParametrosConfig();
		parametrosConfig.setDescripcion(Constantes.CONFIGURACION_DOCUMENTOS);
		parametrosConfig = this.parametrosConfigService.find(parametrosConfig);

		model.addAttribute("parametroConfig", parametrosConfig.getValor());
		model.addAttribute("origen", Constantes.ORIGEN_EXPEDIENTE);

		model.addAttribute("plantilla", new Plantillas());
		return "plantillas";
	}

	/**
	 * 
	 * @param httpResponse
	 *            HttpServletResponse
	 * @param plantilla
	 *            Plantillas
	 * 
	 * @return String
	 * 
	 * @throws Exception
	 */
	@RequestMapping(value = "/descargar", method = RequestMethod.POST)
	public @ResponseBody String descargar(HttpServletResponse httpResponse, @ModelAttribute Plantillas plantilla)
			throws Exception {

		String rutaDocumento = plantilla.getRutaDocumento();
		BufferedInputStream contenidoXml = this.pifAdapterService
				.getFile("/" + Constantes.CODIGO_APLICACION + "/" + rutaDocumento);
		int numRead;
		final int bufferSize = 1024;
		byte[] buffer = new byte[bufferSize];
		ByteArrayOutputStream outString = new ByteArrayOutputStream();
		try {
			while ((numRead = contenidoXml.read(buffer)) != -1) {
				outString.write(buffer, 0, numRead);
			}
		} finally {
			contenidoXml.close();
		}
		byte[] strbase64Doc1 = outString.toByteArray();

		String nombreDocumento = rutaDocumento;
		httpResponse.setHeader("Content-Disposition", "attachment; filename=\"" + nombreDocumento + "\"");
		Cookie cookie = new Cookie("fileDownload", "true");
		cookie.setMaxAge(2);
		cookie.setPath("/");
		httpResponse.addCookie(cookie);
		httpResponse.setContentType("application/doc");

		httpResponse.setContentLength(strbase64Doc1.length);
		httpResponse.getOutputStream().write(strbase64Doc1);

		httpResponse.getOutputStream().flush();
		httpResponse.getOutputStream().close();
		return null;
	}

	/**
	 * Metodo para llamar al webservice de la AB61 y que me genere el documento
	 * rtf
	 * 
	 * @param procedureId
	 *            Integer
	 * @param folderId
	 *            String
	 * @param idPlantilla
	 *            Integer
	 * 
	 * @return String
	 * 
	 * @throws AB61Exception
	 */
	@RequestMapping(value = "/llamarWebService/descargarDocumento/{folderId}/{idPlantilla}", method = RequestMethod.GET)
	public @ResponseBody String descargarDocumento(@PathVariable String folderId, @PathVariable Integer idPlantilla)
			throws Ab61Exception {
		PlantillasController.logger.info("[GET - descargarDocumento] : descargarDocumento");
		String aplicacion = Constantes.CODIGO_APLICACION;

		return ab61WebServiceAdaptadorService.descargarDocumentoNegocio(idPlantilla, folderId, Origen.EXPEDIENTE,
				aplicacion, false);

	}

	/**
	 * Metodo para llamar al webservice de la AB61 y que me genere el documento
	 * rtf
	 * 
	 * @param model
	 *            Model
	 * 
	 * @return String
	 * 
	 * @throws AB61Exception
	 */
	@RequestMapping(value = "/llamarWebService/{folderId}/{idPlantilla}", method = RequestMethod.GET)
	public @ResponseBody String generarDocumento(@PathVariable String folderId, @PathVariable Integer idPlantilla,
			@ModelAttribute(value = "usuario") Usuario usuario) throws Ab61Exception {
		PlantillasController.logger.info("[GET - generarDocumento] : generarDocumento");
		return ab61WebServiceAdaptadorService.generarDocumentoNegocio(idPlantilla, folderId, Origen.EXPEDIENTE,
				usuario.getUsuario().toLowerCase());

	}

	/**
	 * Metodo para llamar al webservice de la AB61 y que me modifique el
	 * documento rtf
	 * 
	 * @param model
	 *            Model
	 * @return String
	 * @throws AB61Exception
	 */
	@RequestMapping(value = "/llamarWebService/modificarDocumento/{idPlantilla}/{folderId}", method = RequestMethod.GET)
	public @ResponseBody String modificarDocumento(@PathVariable String folderId, @PathVariable Integer idPlantilla,
			@ModelAttribute(value = "usuario") Usuario usuario) throws Ab61Exception {
		PlantillasController.logger.info("[GET - modificarDocumento] : modificarDocumento");
		String usuarioName = usuario.getUsuario();

		return ab61WebServiceAdaptadorService.modificarDocumentoNegocio(idPlantilla, folderId, usuarioName);
	}

	/**
	 * llama al webService que realiza la tarea indicada
	 * 
	 * @param idPlantilla
	 *            Integer
	 * @param procedureId
	 *            String
	 * @param folderId
	 *            String
	 * 
	 */
	@RequestMapping(value = "/llamarWebService/eliminarDocumento/{idPlantilla}/{folderId}", method = RequestMethod.GET)
	public @ResponseBody String eliminarDocumento(HttpServletRequest httpRequest, @PathVariable Integer idPlantilla,
			@PathVariable String folderId, @ModelAttribute(value = "usuario") Usuario usuario) throws Ab61Exception {

		PlantillasController.logger.info("Entrada a eliminarDocumento");
		return ab61WebServiceAdaptadorService.eliminarDocumentoNegocio(idPlantilla, folderId);

	}

	/**
	 * llama al webService que realiza la tarea indicada
	 * 
	 * @param idPlantilla
	 *            Integer
	 * @param procedureId
	 *            String
	 * @param folderId
	 *            String
	 * @param n38Login
	 *            String
	 * @return String
	 * @throws Ab61Exception
	 */
	@RequestMapping(value = "/aportarDocumento/{idPlantilla}/{procedureId}/{folderId}", method = RequestMethod.GET)
	public @ResponseBody String aportarDocumento(HttpServletRequest httpRequest, @PathVariable Integer idPlantilla,
			@PathVariable String procedureId, @PathVariable String folderId,
			@ModelAttribute(value = "usuario") Usuario usuario) throws Ab61Exception {

		PlantillasController.logger.info("Entrada a aportarDocumento");

		return this.plantillasService.aportarDocumentoPlatea(idPlantilla, procedureId, folderId, usuario);

	}

	/**
	 * Captura las excepciones AB61Exception.
	 *
	 */
	@ExceptionHandler(value = { Ab61Exception.class })
	public void handleSQLException(HttpServletRequest request, HttpServletResponse response, Exception ex)
			throws Exception {

		String mensajeError = "";

		if (LocaleContextHolder.getLocale().getLanguage().equalsIgnoreCase(Constantes.CASTELLANO))
			mensajeError = ((Ab61Exception) ex).getFaultInfo().getMensajeCastellano();
		else
			mensajeError = ((Ab61Exception) ex).getFaultInfo().getMensajeEuskera();

		// stated Content-Length
		response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
		response.setContentType("text/html;charset=UTF-8");
		response.getWriter().write(mensajeError);
		response.flushBuffer();
	}

}
