package com.ejie.ab59.control.nora;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab59.model.nora.T17Localidad;
import com.ejie.ab59.model.nora.T17Municipio;
import com.ejie.ab59.model.nora.T17Pais;
import com.ejie.ab59.model.nora.T17Provincia;
import com.ejie.ab59.service.nora.T17LocalidadService;
import com.ejie.ab59.service.nora.T17MunicipioService;
import com.ejie.ab59.service.nora.T17PaisService;
import com.ejie.ab59.service.nora.T17ProvinciaService;

@Controller()
@RequestMapping(value = "/nora")
public class NoraController {

	private static final Logger logger = LoggerFactory.getLogger(NoraController.class);

	@Autowired()
	private T17PaisService paisService;

	@Autowired()
	private T17ProvinciaService provinciaService;

	@Autowired()
	private T17MunicipioService municipioService;

	@Autowired()
	private T17LocalidadService localidadService;
	

	/********************************************************************************
	 * Paises
	 *******************************************************************************/
	@RequestMapping(value = "/paises", method = RequestMethod.GET)
	public @ResponseBody() List<T17Pais> getPaises() {
		NoraController.logger.debug("Cargar paises");
		T17Pais pais = new T17Pais();
		return this.paisService.findAll(pais, null);

	}

	/********************************************************************************
	 * Provincias
	 *******************************************************************************/
	@RequestMapping(value = "/provincias", method = RequestMethod.GET)
	public @ResponseBody() List<T17Provincia> getProvincias() {

		NoraController.logger.debug("Cargar provincias");
		return this.provinciaService.findAll(null, null);
	}

	
	/********************************************************************************
	 * Municipios
	 *******************************************************************************/
	@RequestMapping(value = "/municipios", method = RequestMethod.GET)
	public @ResponseBody() List<T17Municipio> getMunicipios(HttpServletRequest request) {

		String provinciaId = "";
		if (!"".equalsIgnoreCase((String) request.getParameter("expediente.datosDirecciones.provincia.id"))
				&& null != (String) request.getParameter("expediente.datosDirecciones.provincia.id")) {
			provinciaId = request.getParameter("expediente.datosDirecciones.provincia.id");
		} else if (!"".equalsIgnoreCase((String) request.getParameter("expedienteOrigen.datosDirecciones.idProvincia"))
				&& null != (String) request.getParameter("expedienteOrigen.datosDirecciones.idProvincia")) {
			provinciaId = request.getParameter("expedienteOrigen.datosDirecciones.idProvincia");
		} else if (!"".equalsIgnoreCase((String) request.getParameter("datosDirecciones.provincia.id"))
				&& null != (String) request.getParameter("datosDirecciones.provincia.id")) {
			provinciaId = request.getParameter("datosDirecciones.provincia.id");
		} else if (!"".equalsIgnoreCase((String) request.getParameter("idProvinciaDireccionPostal"))
				&& null != (String) request.getParameter("idProvinciaDireccionPostal")) {
			provinciaId = request.getParameter("idProvinciaDireccionPostal");
		}

		T17Municipio t17Municipio = new T17Municipio();
		t17Municipio.setProvinciaId(provinciaId);

		return this.municipioService.findAll(t17Municipio, null);
	}

	@RequestMapping(value = "/municipiosBusqueda", method = RequestMethod.GET)
	public @ResponseBody() List<T17Municipio> municipiosBusqueda(@ModelAttribute T17Municipio t17Municipio) {

		return this.municipioService.findAll(t17Municipio, null);
	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
		@RequestMapping(value = "/localidades", method = RequestMethod.GET)
	public @ResponseBody() List<T17Localidad> getLocalidades(HttpServletRequest request) {

		String provinciaId = "";
		String municipioId = "";
		if (!"".equalsIgnoreCase((String) request.getParameter("expediente.datosDirecciones.provincia.id"))
				&& null != (String) request.getParameter("expediente.datosDirecciones.provincia.id")) {
			provinciaId = request.getParameter("expediente.datosDirecciones.provincia.id");
		} else if (!"".equalsIgnoreCase((String) request.getParameter("expedienteOrigen.datosDirecciones.idProvincia"))
				&& null != (String) request.getParameter("expedienteOrigen.datosDirecciones.idProvincia")) {
			provinciaId = request.getParameter("expedienteOrigen.datosDirecciones.idProvincia");
		} else if (!"".equalsIgnoreCase((String) request.getParameter("datosDirecciones.provincia.id"))
				&& null != (String) request.getParameter("datosDirecciones.provincia.id")) {
			provinciaId = request.getParameter("datosDirecciones.provincia.id");
		} else if (!"".equalsIgnoreCase((String) request.getParameter("idProvinciaDireccionPostal"))
				&& null != (String) request.getParameter("idProvinciaDireccionPostal")) {
			provinciaId = request.getParameter("idProvinciaDireccionPostal");
		}

		if (!"".equalsIgnoreCase((String) request.getParameter("expediente.datosDirecciones.municipio.id"))
				&& null != (String) request.getParameter("expediente.datosDirecciones.municipio.id")) {
			municipioId = request.getParameter("expediente.datosDirecciones.municipio.id");
		} else if (!"".equalsIgnoreCase((String) request.getParameter("expedienteOrigen.datosDirecciones.idMunicipio"))
				&& null != (String) request.getParameter("expedienteOrigen.datosDirecciones.idMunicipio")) {
			municipioId = request.getParameter("expedienteOrigen.datosDirecciones.idMunicipio");
		} else if (!"".equalsIgnoreCase((String) request.getParameter("datosDirecciones.municipio.id"))
				&& null != (String) request.getParameter("datosDirecciones.municipio.id")) {
			municipioId = request.getParameter("datosDirecciones.municipio.id");
		} else if (!"".equalsIgnoreCase((String) request.getParameter("idMunicipioDireccionPostal"))
				&& null != (String) request.getParameter("idMunicipioDireccionPostal")) {
			municipioId = request.getParameter("idMunicipioDireccionPostal");
		}

		T17Localidad t17Localidad = new T17Localidad();
		t17Localidad.setProvinciaId(provinciaId);
		t17Localidad.setMunicipioId(municipioId);

		return this.localidadService.findAll(t17Localidad, null);
	}

	@RequestMapping(value = "/localidadesBusqueda", method = RequestMethod.GET)
	public @ResponseBody() List<T17Localidad> localidadesBusqueda(@ModelAttribute T17Localidad t17Localidad) {

		return this.localidadService.findAll(t17Localidad, null);
	}

}
