package com.ejie.ab59.control.listados;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.model.listados.RelLisPro;
import com.ejie.ab59.service.listados.RelLisProService;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/rellispro")

public class RelLisProController {

	private static final Logger logger = LoggerFactory.getLogger(RelLisProController.class);

	@Autowired
	private RelLisProService relLisProService;

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param relLisPro
	 *            Listados Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<RelLisPro> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(value = "/cargarCombo", method = RequestMethod.GET)
	public @ResponseBody List<RelLisPro> getAll(RelLisPro relLisPro) {
		RelLisProController.logger.info("[GET - find_ALL] : Obtener Listados por filtro");

		return this.relLisProService.cargarCombo(relLisPro);
	}
}
