package com.ejie.ab59.control.listados;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab59.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.comun.SeguridadAplicacion;
import com.ejie.ab59.comun.UtilsConfig;
import com.ejie.ab59.model.listados.Listados;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.service.listados.ListadosService;
import com.ejie.ab59.service.procedimientos.ProcedimientosService;
import com.ejie.ab59.service.sanciones.SancionesService;
import com.ejie.ab59.webservice.adaptadores.PifAdapter;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/listados")

public class ListadosController {

	private static final Logger logger = LoggerFactory.getLogger(ListadosController.class);

	@Autowired
	private SancionesService sancionesService;

	@Autowired
	private ListadosService listadosService;

	@Autowired
	private PifAdapter pifAdapterService;

	@Autowired
	private ProcedimientosService procedimientosService;

	@RequestMapping(value = "/maint/{idSancion}", method = RequestMethod.GET)
	public ModelAndView mostrar(HttpServletRequest httpRequest, Model model, Usuario usuario,
			@PathVariable Integer idSancion) {
		ListadosController.logger.info("[GET - View] : listados");
		model.addAttribute("usuario", usuario);

		Sanciones sancionesAux = this.sancionesService.obtenerCabeceraSancion(idSancion);
		String folderNumber = "";
		String titulo = "";
		String cabeceraSancionProcedimiento = "";
		if (sancionesAux != null && sancionesAux.getExpediente() != null) {
			if (sancionesAux.getExpediente().getFolderNumber() != null) {
				folderNumber = sancionesAux.getExpediente().getFolderNumber();
			}
			if (sancionesAux.getExpediente().getTitulo() != null) {
				titulo = sancionesAux.getExpediente().getTitulo();
			}

			String idioma = LocaleContextHolder.getLocale().getLanguage();
			if ("es".equalsIgnoreCase(idioma)) {
				if (sancionesAux.getExpediente().getProcedimiento() != null
						&& sancionesAux.getExpediente().getProcedimiento().getDescripcionEs() != null) {
					cabeceraSancionProcedimiento = sancionesAux.getExpediente().getProcedimiento().getDescripcionEs();
				}
			} else {
				if (sancionesAux.getExpediente().getProcedimiento() != null
						&& sancionesAux.getExpediente().getProcedimiento().getDescripcionEu() != null) {
					cabeceraSancionProcedimiento = sancionesAux.getExpediente().getProcedimiento().getDescripcionEu();
				}
			}
		}

		model.addAttribute("cabeceraSancionExpediente", folderNumber);
		model.addAttribute("cabeceraSancionTitulo", titulo);
		model.addAttribute("cabeceraSancionProcedimiento", cabeceraSancionProcedimiento);
		model.addAttribute("idSancion", idSancion);
		if (sancionesAux != null && sancionesAux.getExpediente() != null) {
			model.addAttribute("idExpediente", sancionesAux.getExpediente().getIdExpediente());
			model.addAttribute("folderId", sancionesAux.getExpediente().getFolderId());
			if (sancionesAux.getExpediente().getProcedimiento() != null) {
				model.addAttribute("idProcedimiento",
						sancionesAux.getExpediente().getProcedimiento().getIdProcedimiento());
				model.addAttribute("codProcedureId",
						sancionesAux.getExpediente().getProcedimiento().getCodProcedureId());
			}
		}

		String url = UtilsConfig.getAppProperties().getProperty("urlVerDocumento");
		url = url.replace("[folderID]", sancionesAux.getExpediente().getFolderId());
		model.addAttribute("urlVerDocumentos", url);

		String idDireccion = SeguridadAplicacion.precargarDireccion();
		Procedimientos procedimiento = null;
		String idProcedimiento = "";

		if (!"".contentEquals(idDireccion)) {
			procedimiento = this.procedimientosService.obtenerProcedimientos(Integer.parseInt(idDireccion));
		}

		if (procedimiento != null) {
			idProcedimiento = String.valueOf(procedimiento.getIdProcedimiento());
		}

		model.addAttribute("procedimientoPrecargado", idProcedimiento);

		return new ModelAndView("listados");
	}

	@RequestMapping(value = "/cargarPantallaSinIdSancion", method = RequestMethod.GET)
	public ModelAndView cargarPantallaSinIdSancion(HttpServletRequest httpRequest, Model model, Usuario usuario) {

		ListadosController.logger.info("[GET - View] : listados");
		model.addAttribute("usuario", usuario);

		String idDireccion = SeguridadAplicacion.precargarDireccion();
		Procedimientos procedimiento = null;
		String idProcedimiento = "";

		if (!"".contentEquals(idDireccion)) {
			procedimiento = this.procedimientosService.obtenerProcedimientos(Integer.parseInt(idDireccion));
		}

		if (procedimiento != null) {
			idProcedimiento = String.valueOf(procedimiento.getIdProcedimiento());
		}

		model.addAttribute("procedimientoPrecargado", idProcedimiento);

		return new ModelAndView("listados");
	}

	/**
	 * 
	 * @param httpResponse
	 *            HttpServletResponse
	 * @param listados
	 *            Listados
	 * 
	 * @return String
	 * 
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/llamarWebService/{idProcedimiento}", method = RequestMethod.POST)
	public @ResponseBody String get(HttpServletResponse httpResponse, @RequestBody() Listados listados,
			@PathVariable Integer idProcedimiento) throws Exception {

		return this.listadosService.gerenarXLS(listados, idProcedimiento);
	}
	
	/**
     * Captura las excepciones AB61Exception.
     *
     */
    @ExceptionHandler(value = { Ab61Exception.class })
    public void handleSQLException(HttpServletRequest request, HttpServletResponse response, Exception ex)
            throws Exception {

        String mensajeError = "";

        if (LocaleContextHolder.getLocale().getLanguage().equalsIgnoreCase(Constantes.CASTELLANO))
            mensajeError = ((Ab61Exception) ex).getFaultInfo().getMensajeCastellano();
        else
            mensajeError = ((Ab61Exception) ex).getFaultInfo().getMensajeEuskera();

        // stated Content-Length
        response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
        response.setContentType("text/html;charset=UTF-8");
        response.getWriter().write(mensajeError);
        response.flushBuffer();
    }

	/**
	 * 
	 * @param httpResponse
	 *            HttpServletResponse
	 * @param listado
	 *            Listados
	 * 
	 * @return String
	 * 
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/descargar", method = RequestMethod.POST)
	public @ResponseBody String descargar(HttpServletResponse httpResponse, @ModelAttribute Listados listado)
			throws Exception {

		String rutaPIF = listado.getRutaPIF();
		BufferedInputStream contenidoXml = this.pifAdapterService.getFile(rutaPIF);
		int numRead;
		final int bufferSize = 1024;
		byte[] buffer = new byte[bufferSize];
		ByteArrayOutputStream outString = new ByteArrayOutputStream();
		try {
			while ((numRead = contenidoXml.read(buffer)) != -1) {
				outString.write(buffer, 0, numRead);
			}
		} finally {
			contenidoXml.close();
		}
		byte[] strbase64Doc1 = outString.toByteArray();

		String nombreDocumento = rutaPIF.substring(rutaPIF.indexOf("/"));
		httpResponse.setHeader("Content-Disposition", "attachment; filename=\"" + nombreDocumento + "\"");
		Cookie cookie = new Cookie("fileDownload", "true");
		cookie.setMaxAge(2);
		cookie.setPath("/");
		httpResponse.addCookie(cookie);
		httpResponse.setContentType("application/rtf");

		httpResponse.setContentLength(strbase64Doc1.length);
		httpResponse.getOutputStream().write(strbase64Doc1);

		httpResponse.getOutputStream().flush();
		httpResponse.getOutputStream().close();
		return null;
	}
}
