package com.ejie.ab59.control.listados;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.model.listados.Busquedas;
import com.ejie.ab59.model.listados.Listados;
import com.ejie.ab59.service.listados.BusquedasService;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/busquedas")

public class BusquedasController {

	private static final Logger logger = LoggerFactory.getLogger(BusquedasController.class);

	@Autowired
	private BusquedasService busquedasService;

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterParametros
	 *            Busquedas Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Busquedas> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(value = "/{idListado}", method = RequestMethod.POST)
	public @ResponseBody List<Busquedas> getAll(@PathVariable Integer idListado) {
		BusquedasController.logger.info("[GET - find_ALL] : Obtener busquedas por filtro");

		Listados listadoAux = new Listados();
		listadoAux.setIdListado(idListado);

		Busquedas busqueda = new Busquedas();
		busqueda.setListado(listadoAux);

		return busquedasService.findByListado(busqueda);
	}
}
