package com.ejie.ab59.control.intervalos;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.comun.UtilDate;
import com.ejie.ab59.model.Intervalos;
import com.ejie.ab59.service.IntervalosService;

/**
 * SancionesController  
 * 
 *  
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/intervalos")

public class IntervalosController {

	private static final Logger logger = LoggerFactory.getLogger(IntervalosController.class);

	@Autowired
	private IntervalosService intervalosService;

	@RequestMapping(value = "/calcularFechaConIntervalo/{fechaInicio}/{fechaFin}", method = RequestMethod.GET)
	public @ResponseBody String calcularFechaConIntervalo(@PathVariable String fechaInicio,
			@PathVariable String fechaFin) {

		Date fechaInicioSeleccionado = UtilDate.convertirFechaEnDate(fechaInicio.replaceAll("-", "/"));
		Date fechaFinSeleccionado = UtilDate.convertirFechaEnDate(fechaFin.replaceAll("-", "/"));

		List<Intervalos> listaIntervalos = this.intervalosService
				.buscarIntervalosEntreFechaInicioYFin(fechaInicioSeleccionado, fechaFinSeleccionado);

		Calendar fechaFinRetorno = Calendar.getInstance();
		fechaFinRetorno.setTime(fechaFinSeleccionado);
		if (listaIntervalos != null && !listaIntervalos.isEmpty()) {

			Intervalos intervalo;
			for (int i = 0; i < listaIntervalos.size(); i++) {

				intervalo = listaIntervalos.get(i);
				fechaFinRetorno.add(Calendar.DATE,
						(intervalo != null && intervalo.getNumeroDias() != null ? intervalo.getNumeroDias() : 0));
			}

		}

		logger.info(" [calcularFechaConIntervalo - GET] Fecha calculada con los intervalos correspondientes");
		return UtilDate.convertirFechaEnString(fechaFinRetorno.getTime());
	}
}
