package com.ejie.ab59.control.inicio;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.UtilUsuario;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.service.sanciones.SancionesService;

/**
 * Acceso a la aplicacion
 * 
 *  
 */
@Controller()
@SessionAttributes("usuario")
@RequestMapping(value = "/inicio")
public class InitController {

	private static final Logger logger = LoggerFactory.getLogger(InitController.class);

	@Autowired
	private SancionesService sancionesService;

	/**
	 * Method 'initApp' metodo de entrada a la aplicacion
	 * 
	 * @param httpRequest
	 *            HttpServletRequest
	 * @param procedureId
	 *            String
	 * @param folderId
	 *            String
	 * @param folderNumber
	 *            String
	 * @param fechaSolicitud
	 *            String
	 * @param folderDescription
	 *            String
	 * @param dni
	 *            String
	 * @param tipoExpediente
	 *            String
	 * @param tramite
	 *            String
	 * @param tarea
	 *            String
	 * @param idioma
	 *            String
	 * @param model
	 *            Model
	 * 
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(method = RequestMethod.POST)
	public String postAccess(HttpServletRequest httpRequest, HttpServletResponse response,
			@RequestParam(value = "procedureId") String procedureId, @RequestParam(value = "folderId") String folderId,
			@RequestParam(value = "folderNumber") String folderNumber,
			@RequestParam(value = "fechaSolicitud") String fechaSolicitud,
			@RequestParam(value = "folderDescription") String folderDescription,
			@RequestParam(value = "dni") String dni, @RequestParam(value = "expConv") String tipoExpediente,
			@RequestParam(value = "tramite") String tramite, @RequestParam(value = "tarea") String tarea,
			@RequestParam(value = "idioma") String idioma, Model model) throws Exception {
		InitController.logger.info("[POST - INICIO] Acceso a la aplicacion por Init Con datos: ");
		InitController.logger.info("[procedureId = " + procedureId + ", folderId = " + folderId + ", folderNumber = "
				+ folderNumber + ", fechaSolicitud = " + fechaSolicitud + ", folderDescription = " + folderDescription
				+ ", dni = " + dni + ", tramite = " + tramite + ", tarea = " + tarea + ", tipoExpediente = "
				+ tipoExpediente + ", idioma = " + idioma);

		// Se cambia el idioma para que se entre en la aplicacion con el que
		// llega como parametro
		Locale locale = new Locale(idioma);
		LocaleContextHolder.setLocale(locale);
		// Sobreescribir cookie
		((CookieLocaleResolver) RequestContextUtils.getLocaleResolver(httpRequest)).setLocale(httpRequest, response,
				locale);

		Authentication aut = SecurityContextHolder.getContext().getAuthentication();
		InitController.logger.info("autotenticación:getAuthentication" + aut);

		Usuario usuario = UtilUsuario.getUsuario(aut, httpRequest);
		model.addAttribute("usuario", usuario);

		Expedientes expedienteAux = new Expedientes();
		expedienteAux.setFolderId(folderId);

		Sanciones sancion = new Sanciones();
		sancion.setExpediente(expedienteAux);

		sancion = this.sancionesService.findByFolderId(sancion);

		if (sancion != null) {

			return "redirect:/versancion/" + folderId;

		} else {
			model.addAttribute("folderNumber", folderNumber);
			return "folderNoExiste";
		}

	}

	@RequestMapping(method = RequestMethod.GET)
	public String postAccess(HttpServletRequest httpRequest, HttpServletResponse response) throws Exception {
		InitController.logger.error("[ERROR] Acceso a la aplicacion por postAccess metodo GET");

		return "getAccess";
	}

}
