package com.ejie.ab59.control.firmantes;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Firmantes;
import com.ejie.ab59.service.configuracionInicioOficio.FirmantesService;
import com.ejie.x38.dto.TableRequestDto;

/**
 * FirmantesController  
 * 
 *  
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/firmantes")

public class FirmantesController {

	private static final Logger logger = LoggerFactory.getLogger(FirmantesController.class);

	@Autowired
	private FirmantesService firmantesService;

	@RequestMapping(value = "/cargarCombo", method = RequestMethod.GET)
	public @ResponseBody List<Firmantes> cargarCombo(@ModelAttribute Firmantes filterFirmantes) {
		FirmantesController.logger.info("[GET - find_ALL] : Obtener Firmantes por filtro");
		return this.firmantesService.findAll(filterFirmantes, new TableRequestDto());
	}
}
