package com.ejie.ab59.control.fichaSancion;

import java.util.Calendar;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.sanciones.RelSanProSan;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.service.propuestasSancion.PropuestasSancionService;
import com.ejie.ab59.service.sanciones.RelSanProSanService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * RelSanProSanController  
 * 
 *  
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/relsanprosan")

public class RelSanProSanController {

	private static final Logger logger = LoggerFactory.getLogger(RelSanProSanController.class);

	@Autowired
	private RelSanProSanService relSanProSanService;

	@Autowired
	private PropuestasSancionService propuestasSancionService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param relSanProSan
	 *            RelSanProSan Bean que contiene la informacion con la que se va
	 *            a crear el nuevo registro.
	 * @return RelSanProSan Bean resultante del proceso de creacion.
	 */
	@RequestMapping(value = "/guardar/{idSancion}/{idPropuestaSancion}/{tratarUbicacion}", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody RelSanProSan add(@PathVariable Integer idSancion, @PathVariable Integer idPropuestaSancion,
			@ModelAttribute(value = "usuario") Usuario usuario, @PathVariable Integer tratarUbicacion) {

		RelSanProSan relSanProSan = new RelSanProSan();

		Sanciones sancionAux = new Sanciones();
		sancionAux.setIdSancion(idSancion);
		relSanProSan.setSancion(sancionAux);

		PropuestasSancion propuestaSancionAux = new PropuestasSancion();
		propuestaSancionAux.setIdPropuestaSancion(idPropuestaSancion);
		propuestaSancionAux.setEstado(Constantes.ESTADO_INCOADO_EXPEDIENTE_SANCIONADOR);
		propuestaSancionAux.setUsuarioUltmodificacion(usuario.getUsuario());
		relSanProSan.setPropuestaSancion(propuestaSancionAux);

		Calendar cal = Calendar.getInstance();
		relSanProSan.setFechaRegistro(cal.getTime());
		relSanProSan.setUsuarioRegistro(usuario.getUsuario());

		relSanProSan = this.relSanProSanService.add(relSanProSan, tratarUbicacion);
		RelSanProSanController.logger.info("[POST] : RelSanProSan insertado correctamente");
		return relSanProSan;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idRelSanProSan
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return RelSanProSan Bean eliminado.
	 */
	@RequestMapping(value = "eliminar/{idSancion}/{idRelSanProSan}/{idPropuestaSancion}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody RelSanProSan remove(@PathVariable Integer idSancion, @PathVariable Integer idRelSanProSan,
			@PathVariable Integer idPropuestaSancion, @ModelAttribute(value = "usuario") Usuario usuario) {
		RelSanProSan relSanProSan = new RelSanProSan();
		relSanProSan.setIdRelSanProSan(idRelSanProSan);
		Sanciones sancionAux = new Sanciones();
		sancionAux.setIdSancion(idSancion);
		relSanProSan.setSancion(sancionAux);
		PropuestasSancion propuestaSancionAux = new PropuestasSancion();
		propuestaSancionAux.setIdPropuestaSancion(idPropuestaSancion);
		propuestaSancionAux.setEstado(Constantes.ESTADO_VALIDADA_DIRECCION_TURISMO);
		propuestaSancionAux.setUsuarioUltmodificacion(usuario.getUsuario());
		relSanProSan.setPropuestaSancion(propuestaSancionAux);

		this.relSanProSanService.remove(relSanProSan);
		RelSanProSanController.logger.info("[DELETE] : RelSanProSan borrado correctamente");
		return relSanProSan;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterRelSanProSan
	 *            RelSanProSan Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<RelSanProSan> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<RelSanProSan> filter(
			@RequestJsonBody(param = "filter") RelSanProSan filterRelSanProSan,
			@RequestJsonBody TableRequestDto tableRequestDto) {

		RelSanProSanController.logger.info("[POST - filter] : Obtener RelSanProSans");

		return this.relSanProSanService.filter(filterRelSanProSan, tableRequestDto);
	}

	/**
	 * Metodo que comprueba si una propuesta de sanción tiene identidicador de
	 * establecimiento indicado.
	 *
	 * @param relSanProSan
	 *            RelSanProSan Bean que contiene la informacion con la que se va
	 *            a crear el nuevo registro.
	 * @return RelSanProSan Bean resultante del proceso de creacion.
	 */
	@RequestMapping(value = "/comprobarEstablecimientoPropuesta/{idSancion}/{idPropuestaSancion}", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody boolean comprobarEstablecimientoPropuesta(@PathVariable Integer idSancion,
			@PathVariable Integer idPropuestaSancion, @ModelAttribute(value = "usuario") Usuario usuario) {

		// Añado la propuesta
		PropuestasSancion propuestaSancionAux = new PropuestasSancion();
		propuestaSancionAux.setIdPropuestaSancion(idPropuestaSancion);

		boolean existeIdentificadorEstablecimiento = this.propuestasSancionService
				.comprobarEstablecimientoPropuesta(propuestaSancionAux);

		return existeIdentificadorEstablecimiento;
	}

}
