package com.ejie.ab59.control.fichaSancion;

import java.math.BigDecimal;
import java.util.Calendar;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.model.sanciones.RelArtInfSan;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.service.sanciones.RelArtInfSanService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/relartinfsan")

public class RelArtInfSanController {

	private static final Logger logger = LoggerFactory.getLogger(RelArtInfSanController.class);

	@Autowired
	private RelArtInfSanService relArtInfSanService;

	@RequestMapping(method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody RelArtInfSan add(@RequestBody RelArtInfSan relArtInfSan,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Calendar cal = Calendar.getInstance();
		relArtInfSan.setFechaRegistro(cal.getTime());
		relArtInfSan.setUsuarioRegistro(usuario.getUsuario());

		RelArtInfSan relArtInfSanAux = this.relArtInfSanService.add(relArtInfSan);
		RelArtInfSanController.logger.info("[POST] : RelArtInfSan insertado correctamente");
		return relArtInfSanAux;
	}

	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody RelArtInfSan edit(@RequestBody RelArtInfSan relArtInfSan,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Calendar cal = Calendar.getInstance();
		relArtInfSan.setFechaUltModificacion(cal.getTime());
		relArtInfSan.setUsuarioUltModificacion(usuario.getUsuario());

		RelArtInfSan relArtInfSanAux = this.relArtInfSanService.update(relArtInfSan);
		RelArtInfSanController.logger.info("[PUT] : RelArtInfSan actualizado correctamente");
		return relArtInfSanAux;
	}

	@RequestMapping(value = "/{idRelArtInfSan}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody RelArtInfSan remove(@PathVariable Integer idRelArtInfSan, @RequestBody Integer idSancion,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		RelArtInfSan relArtInfSan = new RelArtInfSan();

		relArtInfSan.setIdRelArtInfSan(idRelArtInfSan);
		relArtInfSan.setSancion(new Sanciones(idSancion));

		this.relArtInfSanService.remove(relArtInfSan);
		RelArtInfSanController.logger.info("[DELETE] : Infracción borrada correctamente");
		return relArtInfSan;
	}

	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<RelArtInfSan> filter(
			@RequestJsonBody(param = "filter") RelArtInfSan filterRelArtInfSan,
			@RequestJsonBody TableRequestDto tableRequestDto) {

		RelArtInfSanController.logger.info("[POST - filter] : Obtener RelArtInfSan");

		return this.relArtInfSanService.filter(filterRelArtInfSan, tableRequestDto);
	}

	@RequestMapping(value = "/{idRelArtInfSan}", method = RequestMethod.GET)
	public @ResponseBody RelArtInfSan get(@PathVariable Integer idRelArtInfSan) {
		RelArtInfSan relArtInfSan = new RelArtInfSan();
		relArtInfSan.setIdRelArtInfSan(idRelArtInfSan);
		relArtInfSan = this.relArtInfSanService.find(relArtInfSan);
		RelArtInfSanController.logger.info("[GET - findBy_PK] : Obtener RelArtInfSan por PK");
		return relArtInfSan;
	}

	@RequestMapping(value = "totales/{idSancion}", method = RequestMethod.GET)
	public @ResponseBody RelArtInfSan totales(@PathVariable Integer idSancion) {
		RelArtInfSan relArtInfSan = new RelArtInfSan();
		Sanciones sancionAux = new Sanciones();
		sancionAux.setIdSancion(idSancion);
		relArtInfSan.setSancion(sancionAux);
		relArtInfSan = this.relArtInfSanService.totales(relArtInfSan);
		RelArtInfSanController.logger
				.info("[GET - findBy_PK] : Obtener los totales de Sanción y de Resolución por Sanción");
		return relArtInfSan;
	}

	@RequestMapping(value = "/pagos", method = RequestMethod.POST)
	public @ResponseBody RelArtInfSan editPagos(@RequestBody RelArtInfSan relArtInfSan,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		relArtInfSan.setUsuarioUltModificacion(usuario.getUsuario());

		RelArtInfSan relArtInfSanAux = this.relArtInfSanService.updatePagos(relArtInfSan);

		RelArtInfSanController.logger.info("[PUT] : RelArtInfSan actualizado correctamente");
		return relArtInfSanAux;
	}

	@RequestMapping(value = "/calcularImporteResolucion/{idSancion}/{importeSancion}", method = RequestMethod.GET)
	public @ResponseBody RelArtInfSan calcularImporteResolucion(@PathVariable Integer idSancion,
			@PathVariable String importeSancion) {
		RelArtInfSan relArtInfSan = new RelArtInfSan();
		relArtInfSan.setSancion(new Sanciones(idSancion));

		BigDecimal importeSancionFormateado = null;
		if (importeSancion.indexOf(",") != -1) {
			importeSancionFormateado = new BigDecimal(importeSancion.replaceAll(",", "."));
		} else {
			importeSancionFormateado = new BigDecimal(importeSancion);
		}

		relArtInfSan.setImporteSancionArt(importeSancionFormateado);
		relArtInfSan = this.relArtInfSanService.calcularImporteResolucion(relArtInfSan);
		RelArtInfSanController.logger.info("[GET - calcularImporteResolucion] : Obtener el importe resolucion");
		return relArtInfSan;
	}
}
