package com.ejie.ab59.control.fichaSancion;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.pagos.PagoSan;
import com.ejie.ab59.model.pagos.SituacionExpediente;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.service.SituacionExpedienteService;
import com.ejie.ab59.service.pagos.PagoSanService;
import com.ejie.ab59.service.sanciones.RelArtInfSanService;
import com.ejie.ab59.service.sanciones.SancionesService;

@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/pagos")

public class PagosController {

	private static final Logger logger = LoggerFactory.getLogger(PagosController.class);

	@Autowired
	private PagoSanService pagoSanService;

	@Autowired
	private SancionesService sancionesService;

	@Autowired
	private RelArtInfSanService relArtInfSanService;

	@Autowired
	private SituacionExpedienteService situacionExpedienteService;
	
	@RequestMapping(value = "/maint/{idSancion}", method = RequestMethod.GET)
	public String getFormEdit(Model model, @PathVariable Integer idSancion,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		/**
		 * Llamada a la validacion de si el expediente sancionado es valido para el pago
		 */
		Sanciones sancionAux = new Sanciones(idSancion);
		sancionAux = this.sancionesService.findDatosSancion(sancionAux);
		
		boolean mostraMensajeExpedienteSancionadorValidoParaPago = this.sancionesService.validarExpedienteSancionadorListoParaElPago(sancionAux, model);
		model.addAttribute("mostraMensajeExpedienteSancionadorValidoParaPago", mostraMensajeExpedienteSancionadorValidoParaPago);
		
		return "pagos";
	}

	@RequestMapping(value = "/maint/datos/{idSancion}", method = RequestMethod.GET)
	public @ResponseBody PagoSan getFormData(@PathVariable Integer idSancion,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		PagoSan pagoSan = new PagoSan();
		Sanciones sancionAux = new Sanciones();
		sancionAux.setIdSancion(idSancion);
		pagoSan.setSancion(sancionAux);

		PagoSan pagoSanAux = this.pagoSanService.find(pagoSan);
		if (pagoSanAux != null) {
			pagoSan = pagoSanAux;
		} else {
			pagoSan.setIdPagoSan(Constantes.MAGIC_NUMBER_0);
		}

		return pagoSan;

	}

	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody PagoSan edit(@RequestBody PagoSan pagoSan,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		PagoSan pagoSanAux;

		/**
		 * Se procede a dar de alta o actualizar el pago
		 */
		if (pagoSan.getIdPagoSan() == null || pagoSan.getIdPagoSan() == Constantes.MAGIC_NUMBER_0) {

			pagoSan.setUsuarioRegistro(usuario.getUsuario());

			pagoSanAux = this.pagoSanService.add(pagoSan);
			PagosController.logger.info("[PUT] : Pago insertado correctamente");
		} else {

			pagoSan.setUsuarioUltModificacion(usuario.getUsuario());

			pagoSanAux = this.pagoSanService.update(pagoSan);
			PagosController.logger.info("[PUT] : Pago actualizado correctamente");
		}

		Sanciones sancionBusqueda = this.sancionesService.findDatosSancion(pagoSanAux.getSancion());
		SituacionExpediente situacionExpediente = new SituacionExpediente();
		situacionExpediente.setExpediente(sancionBusqueda.getExpediente());
		List<SituacionExpediente> listadoSituacionExpediente = this.situacionExpedienteService
				.findAllLike(situacionExpediente, null, false);

		/**
		 * Calcularemos el id de tipo liquidacion segun los check de la pantalla
		 */
		Integer tipoLiquidacion = 0;
		if (pagoSanAux.getReconocimientoVoluntario() != null
				&& pagoSanAux.getReconocimientoVoluntario().equals(Constantes.CHECKED)
				&& pagoSanAux.getPagoVoluntario() != null
				&& pagoSanAux.getPagoVoluntario().equals(Constantes.CHECKED)) {

			tipoLiquidacion = Constantes.TIPO_LIQUIDACION_DOS_DESCUENTOS;
		} else if ((pagoSanAux.getReconocimientoVoluntario() != null
				&& pagoSanAux.getReconocimientoVoluntario().equals(Constantes.CHECKED)
				&& (pagoSanAux.getPagoVoluntario() == null
						|| !pagoSanAux.getPagoVoluntario().equals(Constantes.CHECKED)))
				|| (pagoSanAux.getPagoVoluntario() != null && pagoSanAux.getPagoVoluntario().equals(Constantes.CHECKED)
						&& (pagoSanAux.getReconocimientoVoluntario() == null
								|| !pagoSanAux.getReconocimientoVoluntario().equals(Constantes.CHECKED)))) {

			tipoLiquidacion = Constantes.TIPO_LIQUIDACION_UN_DESCUENTO;
		} else {

			tipoLiquidacion = Constantes.TIPO_LIQUIDACION_NINGUN_DESCUENTO;
		}

		if (listadoSituacionExpediente != null && !listadoSituacionExpediente.isEmpty()) {
			/**
			 * Existe una situacion de expediente, se procede actualizar
			 */
			situacionExpediente = listadoSituacionExpediente.get(0);
			situacionExpediente.setIdTipoLiquidacion(tipoLiquidacion);
			situacionExpediente.setEnviarCartaPago(pagoSanAux.getEnvioCartaPago());
			situacionExpediente.setUsuarioUltmodificacion(usuario.getUsuario());
			situacionExpediente = this.situacionExpedienteService.update(situacionExpediente);
		} else {

			/**
			 * Nuevo registro
			 */
			situacionExpediente.setIdTipoLiquidacion(tipoLiquidacion);
			situacionExpediente.setEnviarCartaPago(pagoSanAux.getEnvioCartaPago());
			situacionExpediente.setUsuarioRegistro(usuario.getUsuario());
			situacionExpediente = this.situacionExpedienteService.add(situacionExpediente);
		}

		/**
		 * Actualizamos los importes de todas las infracciones ya que dependen
		 * de los check
		 */
		relArtInfSanService.actualizarImporteResolucionInfraccionesSancion(pagoSanAux.getSancion().getIdSancion());

		/**
		 * Actualizamos los importes de la sancion segun todas las infracciones
		 */
		pagoSanAux.setSancion(this.sancionesService.updateImportes(pagoSanAux.getSancion()));

		return pagoSanAux;
	}
}
