package com.ejie.ab59.control.fichaSancion;

import java.util.Calendar;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.model.sanciones.ControlFechas;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.service.sanciones.ControlFechasService;
import com.ejie.ab59.service.sanciones.SancionesService;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/controlfechas")

public class ControlFechasController {

	private static final Logger logger = LoggerFactory.getLogger(ControlFechasController.class);

	@Autowired
	private ControlFechasService controlFechasService;

	@Autowired
	private SancionesService sancionesService;
	
	/*
	 * Cargar las propuestas de sancion
	 * 
	 * @param model Model
	 * 
	 * @param idSancion Integer
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/maint/{idSancion}", method = RequestMethod.GET)
	public String getFormEdit(Model model, @PathVariable Integer idSancion, Usuario usuario) {

		ControlFechasController.logger.info("[GET - View] : Pestaña Control de Fechas");

		/**
		 * Llamada a la validacion de si el expediente sancionado es valido para el pago
		 */
		Sanciones sancionAux = new Sanciones(idSancion);
		sancionAux = this.sancionesService.findDatosSancion(sancionAux);
		
		boolean mostraMensajeExpedienteSancionadorValidoParaPago = this.sancionesService.validarExpedienteSancionadorListoParaElPago(sancionAux, model);
		model.addAttribute("mostraMensajeExpedienteSancionadorValidoParaPago", mostraMensajeExpedienteSancionadorValidoParaPago);
		
		return "controlFechas";

	}

	/**
	 * Cargar el control de fechas
	 * 
	 * @param model
	 *            Model
	 * @param idSancion
	 *            Integer
	 * @return String
	 */
	@RequestMapping(value = "/maint/datos/{idSancion}", method = RequestMethod.GET)
	public @ResponseBody ControlFechas getFormEditData(@PathVariable Integer idSancion) {

		return this.controlFechasService.find(idSancion);

	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param controlFechas
	 *            ControlFechas Bean que contiene la informacion a modificar.
	 * @param usuario
	 *            Usuario
	 * @return ControlFechas Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody ControlFechas edit(@RequestBody ControlFechas controlFechas,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Calendar cal = Calendar.getInstance();
		controlFechas.setFechaUltmodificacion(cal.getTime());
		controlFechas.setUsuarioUltmodificacion(usuario.getUsuario());

		ControlFechas controlFechasAux = this.controlFechasService.update(controlFechas);
		ControlFechasController.logger.info("[PUT] : Fechas actualizadascorrectamente");
		return controlFechasAux;
	}
}
