package com.ejie.ab59.control.fichaPropuestaSancion;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.model.sanciones.RelSanProSan;
import com.ejie.ab59.service.propuestasSancion.FichaPropuestaSancionService;
import com.ejie.ab59.service.propuestasSancion.PropuestasSancionService;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/fichapropuestasancion")

public class fichaPropuestaSancionController {

	private static final Logger logger = LoggerFactory.getLogger(fichaPropuestaSancionController.class);

	@Autowired
	private PropuestasSancionService propuestasSancionService;

	@Autowired
	private FichaPropuestaSancionService fichaPropuestaSancionService;

	/**
	 * Metodo de presentacion de las Tabs.
	 * 
	 * @param model
	 *            Model
	 * @param idSancion
	 *            Integer
	 * @return String
	 */
	@RequestMapping(value = "/maint/{idPropuestaSancion}", method = RequestMethod.GET)
	public String getFormEdit(HttpServletRequest httpRequest, Model model, @PathVariable Integer idPropuestaSancion) {
		fichaPropuestaSancionController.logger.info("[GET - View] : Tabs de datos basicos de sanción");

		RelSanProSan propuestaSancion = this.propuestasSancionService
				.obtenerCabeceraPropuestaSancion(idPropuestaSancion);

		return this.fichaPropuestaSancionService.fichaPropuestaSancionView(httpRequest, propuestaSancion, model);

	}
}
