package com.ejie.ab59.control.expedientes;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.model.expedientes.SubtipoTercero;
import com.ejie.ab59.service.expedientes.SubtipoTerceroService;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/subtipotercero")

public class SubtipoTerceroController {

	private static final Logger logger = LoggerFactory.getLogger(SubtipoTerceroController.class);

	@Autowired
	private SubtipoTerceroService subtipoTerceroService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 *
	 * @param filterSubtipoTercero
	 *            SubtipoTercero Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<SubtipoTercero> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(value = "/cargarCombo", method = RequestMethod.GET)
	public @ResponseBody List<SubtipoTercero> cargarCombo(@ModelAttribute SubtipoTercero filterSubtipoTercero) {
		SubtipoTerceroController.logger.info("[GET - find_ALL] : Obtener SubtipoTercero por filtro");
		return this.subtipoTerceroService.cargarCombo(filterSubtipoTercero);
	}

}
