package com.ejie.ab59.control.expedientes;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.RelExpDir;
import com.ejie.ab59.model.expedientes.TiposDireccion;
import com.ejie.ab59.service.expedientes.RelExpDirService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * RelSanProSanController  
 * 
 *  
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/relexpdir")

public class RelExpDirController {

	private static final Logger logger = LoggerFactory.getLogger(RelExpDirController.class);

	@Autowired
	private RelExpDirService relExpDirService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterRelSanProSan
	 *            RelSanProSan Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<RelSanProSan> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<RelExpDir> filter(
			@RequestJsonBody(param = "filter") RelExpDir filterRelExpDir,
			@RequestJsonBody TableRequestDto tableRequestDto) {

		RelExpDirController.logger.info("[POST - filter] : Obtener RelExpDir");
		DatosDirecciones datosDirecciones = new DatosDirecciones();
		TiposDireccion tipoDireccion = new TiposDireccion();
		tipoDireccion.setIdTipoDireccion(Constantes.UBICACION_ACTIVIDAD);
		datosDirecciones.setTipoDireccion(tipoDireccion);

		return this.relExpDirService.filter(filterRelExpDir, tableRequestDto);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param relExpDir
	 *            RelExpDir Bean que contiene la informacion a modificar.
	 * @return RelExpDir Bean resultante de la modificacion.
	 */
	// @RequestMapping(method = RequestMethod.PUT)
	// public @ResponseBody RelExpDir edit(@RequestBody RelExpDir relExpDir,
	// @ModelAttribute(value = "usuario") Usuario usuario) {
	//
	// Calendar cal = Calendar.getInstance();
	// relExpDir.setFechaRegistro(cal.getTime());
	// relExpDir.setUsuarioRegistro(usuario.getNombreUsuario());
	//
	// RelExpDir relExpDirAux = this.relExpDirService.update(relExpDir);
	// RelExpDirController.logger.info("[PUT] : RelExpDir actualizada
	// correctamente");
	// return relExpDirAux;
	// }

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idRelExpDir
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return RelExpDir Bean eliminado.
	 */
	@RequestMapping(value = "eliminar/{idRelExpDir}/{idDireccion}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody RelExpDir remove(@PathVariable Integer idRelExpDir, @PathVariable Integer idDireccion) {
		RelExpDir relExpDir = new RelExpDir();
		relExpDir.setIdRelExpDir(idRelExpDir);
		relExpDir.setIdDireccion(idDireccion);

		this.relExpDirService.remove(relExpDir);
		RelExpDirController.logger.info("[DELETE] : RelSanProSan borrado correctamente");
		return relExpDir;
	}

}
