package com.ejie.ab59.control.expedientes;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.UtilsConfig;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.expedientes.RelExpTer;
import com.ejie.ab59.model.expedientes.SubtipoTercero;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.service.expedientes.ExpedientesService;
import com.ejie.ab59.service.expedientes.RelExpTerService;
import com.ejie.ab59.service.sanciones.SancionesService;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/expedientes")

public class ExpedientesController {

	private static final Logger logger = LoggerFactory.getLogger(ExpedientesController.class);

	@Autowired
	private ExpedientesService expedientesService;
	@Autowired
	private RelExpTerService relExpTerService;
	@Autowired
	private SancionesService sancionesService;

	/**
	 * Cargar el expediente de la sanción
	 * 
	 * @param model
	 *            Model
	 * @param idSancion
	 *            Integer
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/maint/{idSancion}", method = RequestMethod.GET)
	public String getFormEdit(Model model, @PathVariable Integer idSancion,
			@ModelAttribute(value = "usuario") Usuario usuario) throws Exception {

		String idioma = LocaleContextHolder.getLocale().getLanguage();
		Expedientes expedienteAux = this.expedientesService.findExpedienteSancion(idSancion);
		try {
			boolean flagSearchFolder = this.expedientesService.actualizarParticipaciones(expedienteAux.getFolderId(),
					usuario.getUsuario());

			model.addAttribute("flagSearchFolder", flagSearchFolder);
		} catch (Exception e) {
			ExpedientesController.logger.error(e.getMessage(), e);
			model.addAttribute("flagSearchFolder", false);
		}

		// Primero obtengo la lista de participaciones de mi BBDD, ya
		// actualiza previamente desde el webService
		List<RelExpTer> listaParticipantesParticipacion = relExpTerService
				.findParticipaciones(expedienteAux.getIdExpediente(), model);
		ExpedientesController.logger.info("[INICIO] Participantes ", listaParticipantesParticipacion.size(),
				" para el expediente : ", expedienteAux.getIdExpediente());

		model.addAttribute("listaParticipantesParticipacion", listaParticipantesParticipacion);

		model.addAttribute("urlab61", UtilsConfig.getAppProperties().getProperty("URLAB61"));
		model.addAttribute("ab61_folderID", expedienteAux.getFolderId());
		model.addAttribute("idExpediente", expedienteAux.getIdExpediente());
		model.addAttribute("lenguaje", idioma);

		/**
		 * Llamada a la validacion de si el expediente sancionado es valido para el pago
		 */
		Sanciones sancionAux = new Sanciones(idSancion);
		sancionAux = this.sancionesService.findDatosSancion(sancionAux);
		
		boolean mostraMensajeExpedienteSancionadorValidoParaPago = this.sancionesService.validarExpedienteSancionadorListoParaElPago(sancionAux, model);
		model.addAttribute("mostraMensajeExpedienteSancionadorValidoParaPago", mostraMensajeExpedienteSancionadorValidoParaPago);
		
		return "expediente";

	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param relExpTer
	 *            RelExpTer Bean que contiene la informacion a modificar.
	 * @param usuario
	 *            Usuario
	 * @return RelExpTer Bean resultante de la modificacion.
	 */
	@RequestMapping(value = "/{idSancion}", method = RequestMethod.PUT)
	public @ResponseBody RelExpTer edit(@RequestBody RelExpTer relExpTer, @PathVariable Integer idSancion,
			@ModelAttribute(value = "usuario") Usuario usuario) throws Exception {
		for (int i = 0; i < relExpTer.getListIdSubtipoTercero().size(); i++) {
			RelExpTer relExpTerAux = new RelExpTer();
			relExpTerAux.setParticipantId(relExpTer.getListParticipantId().get(i));
			SubtipoTercero subtipoTerceroAux = new SubtipoTercero();
			Integer idSubtipoTercero = null;
			if (relExpTer.getListIdSubtipoTercero().get(i).intValue() != -1) {
				idSubtipoTercero = relExpTer.getListIdSubtipoTercero().get(i).intValue();
			}
			subtipoTerceroAux.setIdSubtipoTercero(idSubtipoTercero);
			relExpTerAux.setSubtipoTercero(subtipoTerceroAux);
			relExpTerAux.setUsuarioUltmodificacion(usuario.getUsuario());

			this.relExpTerService.updateSubtipo(relExpTerAux);
		}

		ExpedientesController.logger.info("[PUT] : Subtipos de tercero actualizados correctamente");

		return relExpTer;
	}

	@RequestMapping(value = "/findUrlFromFolderNumber/{folderId}", method = RequestMethod.GET)
	public @ResponseBody String findUrlFromFolderNumber(@PathVariable String folderId) {

		if (folderId.contains("barra")) {

			folderId = folderId.replace("barra", "/");

		}

		Expedientes retorno = this.expedientesService.findUrlFromFolderNumber(folderId);

		String url = "";

		if (retorno != null) {

			url = retorno.getProcedimiento().getAplicacion().getUrlAplicacion() + retorno.getFolderId();

		}

		return url;
	}

	@RequestMapping(value = "/expedienteCerrado/{idExpediente}", method = RequestMethod.GET)
	public @ResponseBody Boolean descargarDocumento(@PathVariable Integer idExpediente) throws Ab61Exception {

		return this.expedientesService.findExpedienteCerrado(new Expedientes(idExpediente));
	}
}
